/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.config.ssl.SSLConfig;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.ssl.optional.SSLSupportOptional;
import com.ibm.ws.transport.iiop.security.SecurityInitializer;
import com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.ws.transport.iiop.spi.ReadyListener;
import com.ibm.ws.transport.iiop.spi.SubsystemFactory;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.yoko.osgi.locator.LocalFactory;
import org.apache.yoko.osgi.locator.Register;
import org.apache.yoko.osgi.locator.ServiceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractCsiv2SubsystemFactory
extends SubsystemFactory {
    private static final TraceComponent tc = Tr.register(AbstractCsiv2SubsystemFactory.class);
    protected static final long TIMEOUT_SECONDS = 10L;
    private Register providerRegistry;
    private ServiceProvider securityInitializerClass;
    private ServiceProvider connectionHelperClass;
    private SSLSupport sslSupport;
    private ScheduledExecutorService executor;
    protected String defaultAlias;
    private Collection<String> sslRefs = Collections.emptyList();
    private final List<ReadyRegistration> regs = new ArrayList<ReadyRegistration>();
    static final long serialVersionUID = 3508561016452535242L;

    @Reference
    protected void setRegister(Register providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    @Reference
    protected void setSSLSupport(SSLSupportOptional sslSupport, Map<String, Object> props) {
        this.sslSupport = sslSupport;
        this.defaultAlias = (String)props.get("sslRef");
        String[] repertoireIds = (String[])props.get("repertoireIds");
        if (repertoireIds != null) {
            this.sslRefs = Arrays.asList(repertoireIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSSLSupport(SSLSupportOptional sslSupport, Map<String, Object> props) {
        String[] repertoireIds = (String[])props.get("repertoireIds");
        AbstractCsiv2SubsystemFactory abstractCsiv2SubsystemFactory = this;
        synchronized (abstractCsiv2SubsystemFactory) {
            this.sslRefs = repertoireIds != null ? Arrays.asList(repertoireIds) : Collections.emptyList();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Known ssl configurations: {0}", (Object[])new Object[]{this.sslRefs});
        }
        this.updateRegistered();
    }

    @Reference
    protected void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.securityInitializerClass = new ServiceProvider((LocalFactory)MyLocalFactory.INSTANCE, SecurityInitializer.class);
        this.connectionHelperClass = new ServiceProvider((LocalFactory)MyLocalFactory.INSTANCE, SocketFactory.class);
        this.providerRegistry.registerProvider(this.securityInitializerClass);
        this.providerRegistry.registerProvider(this.connectionHelperClass);
        SecurityServices.setupSSLConfig(new SSLConfig(this.sslSupport.getJSSEHelper()));
    }

    @Deactivate
    protected void deactivate() {
        this.providerRegistry.unregisterProvider(this.securityInitializerClass);
        this.providerRegistry.unregisterProvider(this.connectionHelperClass);
        SecurityServices.clean();
    }

    public String getInitializerClassName(boolean endpoint) {
        return SecurityInitializer.class.getName();
    }

    public void register(ReadyListener listener, Map<String, Object> properties, List<IIOPEndpoint> endpoints) {
        ReadyRegistration rr = new ReadyRegistration(this.extractSslRefs(properties, endpoints), listener);
        this.regs.add(rr);
        rr.check();
    }

    protected abstract Set<String> extractSslRefs(Map<String, Object> var1, List<IIOPEndpoint> var2);

    public void unregister(ReadyListener listener) {
        for (ReadyRegistration rr : this.regs) {
            if (rr.listener != listener) continue;
            this.regs.remove(rr);
            rr.cancelTimeout();
            break;
        }
    }

    protected void updateRegistered() {
        for (ReadyRegistration rr : this.regs) {
            rr.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeoutMessage(Set<String> requiredSslRefs, ReadyListener listener) {
        HashSet<String> missing = new HashSet<String>(requiredSslRefs);
        AbstractCsiv2SubsystemFactory abstractCsiv2SubsystemFactory = this;
        synchronized (abstractCsiv2SubsystemFactory) {
            missing.removeAll(this.sslRefs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Known ssl configurations: {0}", (Object[])new Object[]{this.sslRefs});
        }
        Tr.error((TraceComponent)tc, (String)"SSL_SERVICE_NOT_STARTED", (Object[])new Object[]{missing, listener.listenerId(), 10L});
    }

    protected boolean check(Collection<String> requiredSslRefs) {
        boolean containsAll = this.sslRefs.containsAll(requiredSslRefs);
        return containsAll;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ReadyRegistration {
        private final Set<String> requiredSslRefs;
        private final ReadyListener listener;
        private ScheduledFuture<?> future;
        static final long serialVersionUID = 7389573923149402488L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ReadyRegistration(Set<String> requiredSslRefs, ReadyListener listener) {
            this.requiredSslRefs = requiredSslRefs;
            this.listener = listener;
            this.scheduleTimeout();
        }

        protected void scheduleTimeout() {
            this.future = AbstractCsiv2SubsystemFactory.this.executor.schedule(new Runnable(){
                static final long serialVersionUID = 7102653253569141476L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    AbstractCsiv2SubsystemFactory.this.timeoutMessage(ReadyRegistration.this.requiredSslRefs, ReadyRegistration.this.listener);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }, 10L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void check() {
            boolean containsAll = AbstractCsiv2SubsystemFactory.this.check(this.requiredSslRefs);
            this.listener.readyChanged((SubsystemFactory)AbstractCsiv2SubsystemFactory.this, containsAll);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Check: Known ssl configurations: {0}, required: {1}, containsAll: {2} timeout exists: {3}", (Object[])new Object[]{AbstractCsiv2SubsystemFactory.this.sslRefs, this.requiredSslRefs, containsAll, this.future != null});
            }
            ReadyRegistration readyRegistration = this;
            synchronized (readyRegistration) {
                if (containsAll) {
                    this.cancelTimeout();
                } else if (this.future == null) {
                    this.scheduleTimeout();
                }
            }
        }

        public void cancelTimeout() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReadyRegistration.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class MyLocalFactory
    extends Enum<MyLocalFactory>
    implements LocalFactory {
        public static final /* enum */ MyLocalFactory INSTANCE;
        private static final /* synthetic */ MyLocalFactory[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static MyLocalFactory[] values() {
            return (MyLocalFactory[])$VALUES.clone();
        }

        public static MyLocalFactory valueOf(String name) {
            return Enum.valueOf(MyLocalFactory.class, name);
        }

        public Class<?> forName(String clsName) throws ClassNotFoundException {
            return Class.forName(clsName);
        }

        public Object newInstance(Class cls) throws InstantiationException, IllegalAccessException {
            return cls.newInstance();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MyLocalFactory.class);
            INSTANCE = new MyLocalFactory();
            $VALUES = new MyLocalFactory[]{INSTANCE};
        }
    }
}

