/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import java.io.Serializable;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.omg.CSI.EstablishContext;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSCompoundSecMechConfig
implements Serializable {
    private static final TraceComponent tc = Tr.register(TSSCompoundSecMechConfig.class);
    private TSSTransportMechConfig transport_mech;
    private TSSASMechConfig as_mech;
    private TSSSASMechConfig sas_mech;
    static final long serialVersionUID = -7249505069185758982L;

    public TSSTransportMechConfig getTransport_mech() {
        return this.transport_mech;
    }

    public void setTransport_mech(TSSTransportMechConfig transport_mech) {
        this.transport_mech = transport_mech;
    }

    public TSSASMechConfig getAs_mech() {
        return this.as_mech;
    }

    public void setAs_mech(TSSASMechConfig as_mech) {
        this.as_mech = as_mech;
    }

    public TSSSASMechConfig getSas_mech() {
        return this.sas_mech;
    }

    public void setSas_mech(TSSSASMechConfig sas_mech) {
        this.sas_mech = sas_mech;
    }

    public short getSupports() {
        short result = 0;
        if (this.transport_mech != null) {
            result = (short)(result | this.transport_mech.getSupports());
        }
        if (this.as_mech != null) {
            result = (short)(result | this.as_mech.getSupports());
        }
        if (this.sas_mech != null) {
            result = (short)(result | this.sas_mech.getSupports());
        }
        return result;
    }

    public short getRequires() {
        short result = 0;
        if (this.transport_mech != null) {
            result = (short)(result | this.transport_mech.getRequires());
        }
        if (this.as_mech != null) {
            result = (short)(result | this.as_mech.getRequires());
        }
        if (this.sas_mech != null) {
            result = (short)(result | this.sas_mech.getRequires());
        }
        return result;
    }

    public CompoundSecMech encodeIOR(Codec codec) throws Exception {
        CompoundSecMech result = new CompoundSecMech();
        result.target_requires = 0;
        result.transport_mech = this.transport_mech.encodeIOR(codec);
        result.target_requires = (short)(result.target_requires | this.transport_mech.getRequires());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("transport adds supported: " + ConfigUtil.flags(this.transport_mech.getSupports())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("transport adds required: " + ConfigUtil.flags(this.transport_mech.getRequires())), (Object[])new Object[0]);
        }
        result.as_context_mech = this.as_mech.encodeIOR(codec);
        result.target_requires = (short)(result.target_requires | this.as_mech.getRequires());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AS adds supported: " + ConfigUtil.flags(this.as_mech.getSupports())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("AS adds required: " + ConfigUtil.flags(this.as_mech.getRequires())), (Object[])new Object[0]);
        }
        result.sas_context_mech = this.sas_mech.encodeIOR(codec);
        result.target_requires = (short)(result.target_requires | this.sas_mech.getRequires());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SAS adds supported: " + ConfigUtil.flags(this.sas_mech.getSupports())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("SAS adds required: " + ConfigUtil.flags(this.sas_mech.getRequires())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("REQUIRES: " + ConfigUtil.flags(result.target_requires)), (Object[])new Object[0]);
        }
        return result;
    }

    public static TSSCompoundSecMechConfig decodeIOR(Codec codec, CompoundSecMech compoundSecMech) throws Exception {
        TSSCompoundSecMechConfig result = new TSSCompoundSecMechConfig();
        result.setTransport_mech(TSSTransportMechConfig.decodeIOR(codec, compoundSecMech.transport_mech));
        result.setAs_mech(TSSASMechConfig.decodeIOR(compoundSecMech.as_context_mech));
        result.setSas_mech(new TSSSASMechConfig(compoundSecMech.sas_context_mech));
        return result;
    }

    public Subject check(SSLSession session, EstablishContext msg, Codec codec) throws SASException {
        Subject transportSubject = null;
        Subject authenticationLayerSubject = null;
        Subject attributeLayerSubject = null;
        if (this.isAssertingAnonymous(msg)) {
            attributeLayerSubject = this.sas_mech.check(this, session, msg, codec);
        } else {
            transportSubject = this.transport_mech.check(session);
            authenticationLayerSubject = this.as_mech.check(msg, codec);
            attributeLayerSubject = this.sas_mech.check(this, session, msg, codec);
        }
        if (attributeLayerSubject != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The attribute layer subject was selected.", (Object[])new Object[0]);
            }
            return attributeLayerSubject;
        }
        if (authenticationLayerSubject != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The authentication layer subject was selected.", (Object[])new Object[0]);
            }
            return authenticationLayerSubject;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The transport subject was selected.", (Object[])new Object[0]);
        }
        return transportSubject;
    }

    private boolean isAssertingAnonymous(EstablishContext msg) {
        return msg != null && msg.identity_token != null && msg.identity_token.discriminator() == 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSCompoundSecMechConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS (aggregate): ").append(ConfigUtil.flags(this.getSupports())).append("\n");
        buf.append(moreSpaces).append("REQUIRES (aggregate): ").append(ConfigUtil.flags(this.getRequires())).append("\n");
        if (this.transport_mech != null) {
            this.transport_mech.toString(moreSpaces, buf);
        }
        if (this.as_mech != null) {
            this.as_mech.toString(moreSpaces, buf);
        }
        if (this.sas_mech != null) {
            this.sas_mech.toString(moreSpaces, buf);
        }
        buf.append(spaces).append("]\n");
    }
}

