/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTPrincipalNameGSSUP;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.config.tss.TSSServiceConfigurationConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSSASMechConfig
implements Serializable {
    public static final String TYPE_ITTAnonymous = "ITTAnonymous";
    public static final String TYPE_ITTPrincipalName = "ITTPrincipalName";
    public static final String TYPE_ITTX509CertChain = "ITTX509CertChain";
    public static final String TYPE_ITTDistinguishedName = "ITTDistinguishedName";
    private short supports;
    private short requires;
    private int supportedIdentityTypes;
    private boolean required;
    private final ArrayList<TSSServiceConfigurationConfig> privilegeAuthorities = new ArrayList();
    private final Map<Short, TSSSASIdentityToken> idTokens = new HashMap<Short, TSSSASIdentityToken>();
    private transient TrustedIDEvaluator trustedIDEvaluator;
    static final long serialVersionUID = 7773202148556350667L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSSASMechConfig() {
    }

    public TSSSASMechConfig(TrustedIDEvaluator trustedIDEvaluator) {
        this.trustedIDEvaluator = trustedIDEvaluator;
    }

    public TSSSASMechConfig(SAS_ContextSec context) throws Exception {
        this.supports = context.target_supports;
        this.requires = context.target_requires;
        ServiceConfiguration[] c = context.privilege_authorities;
        for (int i = 0; i < c.length; ++i) {
            this.privilegeAuthorities.add(TSSServiceConfigurationConfig.decodeIOR(c[i]));
        }
        byte[][] n = context.supported_naming_mechanisms;
        for (int i = 0; i < n.length; ++i) {
            String oid = Util.decodeOID(n[i]);
            if (!TSSITTPrincipalNameGSSUP.OID.equals(oid)) continue;
            this.addIdentityToken(new TSSITTPrincipalNameGSSUP(null, null, null));
        }
        this.supports = context.target_supports;
        this.requires = context.target_requires;
        this.supportedIdentityTypes = context.supported_identity_types;
    }

    public void addServiceConfigurationConfig(TSSServiceConfigurationConfig config) {
        this.privilegeAuthorities.add(config);
        this.supports = (short)(this.supports | 0x800);
        if (this.required) {
            this.requires = (short)2048;
        }
    }

    public TSSServiceConfigurationConfig serviceConfigurationAt(int i) {
        return this.privilegeAuthorities.get(i);
    }

    public int paSize() {
        return this.privilegeAuthorities.size();
    }

    public void addIdentityToken(TSSSASIdentityToken token) {
        short type = token.getType();
        this.idTokens.put(type, token);
        this.supportedIdentityTypes |= type;
        if (token.getType() > 0) {
            this.supports = (short)(this.supports | 0x400);
        }
    }

    public short getSupports() {
        return this.supports;
    }

    public short getRequires() {
        return this.requires;
    }

    public int getSupportedIdentityTypes() {
        return this.supportedIdentityTypes;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
        if (required) {
            this.requires = (short)(this.requires | (short)(this.supports & 0x800));
        }
    }

    public SAS_ContextSec encodeIOR(Codec codec) throws Exception {
        SAS_ContextSec result = new SAS_ContextSec();
        int i = 0;
        result.privilege_authorities = new ServiceConfiguration[this.privilegeAuthorities.size()];
        Iterator<TSSServiceConfigurationConfig> iter = this.privilegeAuthorities.iterator();
        while (iter.hasNext()) {
            result.privilege_authorities[i++] = iter.next().generateServiceConfiguration();
        }
        ArrayList<TSSSASIdentityToken> list = new ArrayList<TSSSASIdentityToken>();
        for (TSSSASIdentityToken token : this.idTokens.values()) {
            if (token.getType() != 2) continue;
            list.add(token);
        }
        i = 0;
        result.supported_naming_mechanisms = new byte[list.size()][];
        for (TSSSASIdentityToken token : list) {
            result.supported_naming_mechanisms[i++] = Util.encodeOID(token.getOID());
        }
        result.target_supports = this.supports;
        result.target_requires = this.requires;
        result.supported_identity_types = this.supportedIdentityTypes;
        return result;
    }

    public Subject check(TSSCompoundSecMechConfig compoundSecMech, SSLSession session, EstablishContext msg, Codec codec) throws SASException {
        if (msg != null && msg.identity_token != null) {
            IdentityToken identityToken = msg.identity_token;
            int discriminator = identityToken.discriminator();
            TSSSASIdentityToken tssIdentityToken = this.idTokens.get((short)discriminator);
            if (tssIdentityToken == null) {
                throw new SASInvalidEvidenceException("Unsupported identity token type: " + discriminator, 1229079308);
            }
            if (this.isTokenTypeAlwaysAllowed(discriminator) || this.isPresumedTrust() || compoundSecMech.getAs_mech().isTrusted(this.trustedIDEvaluator, msg, codec) || compoundSecMech.getTransport_mech().isTrusted(this.trustedIDEvaluator, session)) {
                return tssIdentityToken.check(identityToken, codec);
            }
            throw new SASInvalidEvidenceException("Authentication failed. Could not validate Client Authentication Token and/or Client Certificates during Identity Assertion", 1229079309);
        }
        return null;
    }

    private boolean isTokenTypeAlwaysAllowed(int discriminator) {
        return discriminator == 0 || discriminator == 1;
    }

    private boolean isPresumedTrust() {
        return this.trustedIDEvaluator.isTrusted("*");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append(this.getName()).append(": [\n");
        buf.append(moreSpaces).append("required: ").append(this.required).append("\n");
        buf.append(moreSpaces).append("SUPPORTS: ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES: ").append(ConfigUtil.flags(this.requires)).append("\n");
        for (TSSServiceConfigurationConfig tssServiceConfigurationConfig : this.privilegeAuthorities) {
            tssServiceConfigurationConfig.toString(moreSpaces, buf);
        }
        buf.append("\n");
        for (TSSSASIdentityToken identityToken : this.idTokens.values()) {
            identityToken.toString(moreSpaces, buf);
        }
        buf.append(spaces).append("]\n");
    }

    protected String getName() {
        return "TSSSASMechConfig";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSSASMechConfig.class);
    }
}

