/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.connector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleHandlerBase;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.jca.metadata.ConnectorModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleHandler.class}, property={"service.vendor=IBM", "type:String=connector"})
public class ConnectorModuleHandlerImpl
extends ModuleHandlerBase {
    private static final TraceComponent tc = Tr.register(ConnectorModuleHandlerImpl.class);
    static final long serialVersionUID = -6753591388573849049L;

    @Reference(target="(type=connector)")
    protected void setConnectorContainer(ModuleRuntimeContainer connectorContainer) {
        super.setModuleRuntimeContainer(connectorContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> deployModule(DeployedModuleInfo deployedMod, DeployedAppInfo deployedApp) {
        Future future;
        long startTime = System.nanoTime();
        try {
            future = super.deployModule(deployedMod, deployedApp);
        }
        catch (Throwable throwable) {
            ConnectorModuleMetaData metadata = (ConnectorModuleMetaData)deployedMod.getModuleInfo().getMetaData();
            if (metadata != null && metadata.isEmbedded()) {
                if (super.getFirstFailure() == null) {
                    Tr.audit((TraceComponent)tc, (String)"J2CA7001.adapter.install.successful", (Object[])new Object[]{metadata.getIdentifier(), (double)(System.nanoTime() - startTime) / 1.0E9});
                } else {
                    Tr.error((TraceComponent)tc, (String)"J2CA7002.adapter.install.failed", (Object[])new Object[]{metadata.getIdentifier(), super.getFirstFailure().toString()});
                }
            }
            throw throwable;
        }
        ConnectorModuleMetaData metadata = (ConnectorModuleMetaData)deployedMod.getModuleInfo().getMetaData();
        if (metadata != null && metadata.isEmbedded()) {
            if (super.getFirstFailure() == null) {
                Tr.audit((TraceComponent)tc, (String)"J2CA7001.adapter.install.successful", (Object[])new Object[]{metadata.getIdentifier(), (double)(System.nanoTime() - startTime) / 1.0E9});
            } else {
                Tr.error((TraceComponent)tc, (String)"J2CA7002.adapter.install.failed", (Object[])new Object[]{metadata.getIdentifier(), super.getFirstFailure().toString()});
            }
        }
        return future;
    }

    public boolean undeployModule(DeployedModuleInfo deployedModule) {
        boolean success = super.undeployModule(deployedModule);
        ConnectorModuleMetaData metadata = (ConnectorModuleMetaData)deployedModule.getModuleInfo().getMetaData();
        if (metadata != null && metadata.isEmbedded()) {
            if (success) {
                Tr.audit((TraceComponent)tc, (String)"J2CA7009.adapter.uninstalled", (Object[])new Object[]{metadata.getIdentifier()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"J2CA7010.adapter.uninstall.failed", (Object[])new Object[]{metadata.getIdentifier()});
            }
        }
        return success;
    }
}

