/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.repository.download.RepositoryDownloadUtil;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.cert.CertPathBuilderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractor;

public class ExceptionUtils {
    public static boolean isCertPathBuilderException(Throwable cause) {
        if (cause == null) {
            return false;
        }
        if (cause instanceof CertPathBuilderException) {
            return true;
        }
        return ExceptionUtils.isCertPathBuilderException(cause.getCause());
    }

    public static InstallException createByKey(Exception e, String msgKey, Object ... args) {
        return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgKey, args), e);
    }

    static InstallException createByKey(String msgKey, Object ... args) {
        return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgKey, args));
    }

    static InstallException create(String msg) {
        return ExceptionUtils.create(msg, 21);
    }

    static InstallException createByKey(int rc, String msgKey, Object ... args) {
        return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgKey, args), rc);
    }

    static InstallException create(String msg, int rc) {
        return new InstallException(msg, rc);
    }

    static InstallException create(String msg, Exception e) {
        return ExceptionUtils.create(msg, e, 21);
    }

    static InstallException createByKey(int rc, Exception e, String msgKey, Object ... args) {
        return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(msgKey, args), e, rc);
    }

    public static InstallException createFailedToDownload(RepositoryResource installResource, Exception e, File toDir) {
        String target;
        String string = target = toDir == null ? System.getProperty("java.io.tmpdir") : toDir.getAbsolutePath();
        if (e instanceof IOException) {
            return ExceptionUtils.createByKey(25, e, "ERROR_FAILED_DOWNLOAD_ASSETS_TO_TEMP", InstallUtils.getResourceId(installResource), InstallUtils.getResourceName(installResource), target);
        }
        if (e instanceof RepositoryBackendException) {
            RepositoryConnection failingConnection = ((RepositoryBackendException)e).getFailingConnection();
            String repositoryLocation = failingConnection.getRepositoryLocation();
            boolean isDefaultRepo = repositoryLocation.startsWith("https://asset-websphere.ibm.com/ma/v1");
            if (ExceptionUtils.isCertPathBuilderException(e.getCause())) {
                return ExceptionUtils.createByKey(e, isDefaultRepo ? "ERROR_FAILED_TO_CONNECT_CAUSED_BY_CERT" : "ERROR_FAILED_TO_CONNECT_REPO_CAUSED_BY_CERT", repositoryLocation);
            }
            return ExceptionUtils.createByKey(e, isDefaultRepo ? "ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_DEFAULT_REPO" : "ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", InstallUtils.getResourceId(installResource), InstallUtils.getResourceName(installResource), repositoryLocation);
        }
        if (e instanceof RepositoryResourceException) {
            return ExceptionUtils.createByKey(e, "ERROR_FAILED_TO_DOWNLOAD_ASSETS", InstallUtils.getResourceId(installResource), InstallUtils.getResourceName(installResource));
        }
        if (installResource.getType().equals((Object)ResourceType.FEATURE)) {
            return ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", installResource.getName(), target);
        }
        if (installResource.getType().equals((Object)ResourceType.IFIX)) {
            return ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_IFIX", installResource.getName(), target);
        }
        if (installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE)) {
            return ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_SAMPLE", installResource.getName(), target);
        }
        if (installResource.getType().equals((Object)ResourceType.OPENSOURCE)) {
            return ExceptionUtils.createByKey(25, e, "ERROR_FAILED_TO_DOWNLOAD_OPENSOURCE", installResource.getName(), target);
        }
        return ExceptionUtils.createByKey(e, "ERROR_UNSUPPORTED", new Object[0]);
    }

    static InstallException create(Exception e) {
        if (e instanceof ProductInfoParseException) {
            ProductInfoParseException pipe = (ProductInfoParseException)((Object)e);
            String missingKey = pipe.getMissingKey();
            if (missingKey != null) {
                return ExceptionUtils.create(InstallLogUtils.Messages.UTILITY_MESSAGES.getLogMessage("version.missing.key", missingKey, pipe.getFile().getAbsoluteFile()));
            }
            return ExceptionUtils.create(InstallLogUtils.Messages.UTILITY_MESSAGES.getLogMessage("ERROR_UNABLE_READ_FILE", pipe.getFile().getAbsoluteFile(), pipe.getCause().getMessage()));
        }
        if (e instanceof DuplicateProductInfoException) {
            DuplicateProductInfoException dpie = (DuplicateProductInfoException)((Object)e);
            return ExceptionUtils.create(InstallLogUtils.Messages.UTILITY_MESSAGES.getLogMessage("version.duplicated.productId", "com.ibm.websphere.productId", dpie.getProductInfo1().getFile().getAbsoluteFile(), dpie.getProductInfo2().getFile().getAbsoluteFile()));
        }
        if (e instanceof ProductInfoReplaceException) {
            ProductInfoReplaceException pire = (ProductInfoReplaceException)((Object)e);
            ProductInfo productInfo = pire.getProductInfo();
            String replacesId = productInfo.getReplacesId();
            if (replacesId.equals(productInfo.getId())) {
                return ExceptionUtils.create(InstallLogUtils.Messages.UTILITY_MESSAGES.getLogMessage("version.replaced.product.can.not.itself", productInfo.getFile().getAbsoluteFile()));
            }
            return ExceptionUtils.create(InstallLogUtils.Messages.UTILITY_MESSAGES.getLogMessage("version.replaced.product.not.exist", replacesId, productInfo.getFile().getAbsoluteFile()));
        }
        if (e instanceof RepositoryBackendIOException) {
            return ExceptionUtils.create((RepositoryException)((Object)e), new Throwable(e), null, true);
        }
        return ExceptionUtils.create(e.getMessage(), e, 21);
    }

    static InstallException create(RepositoryException e, Throwable cause, RestRepositoryConnectionProxy proxy, boolean defaultRepo) {
        if (proxy != null && cause instanceof UnknownHostException) {
            return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_UNKNOWN_PROXY_HOST", proxy.getProxyURL().getHost()), (Exception)((Object)e));
        }
        if (cause instanceof ConnectException && cause.getMessage() != null && cause.getMessage().contains("Connection refused") && proxy != null) {
            return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INCORRECT_PROXY_PORT", String.valueOf(proxy.getProxyURL().getPort())), (Exception)((Object)e));
        }
        if (ExceptionUtils.isCertPathBuilderException(cause)) {
            return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(defaultRepo ? "ERROR_FAILED_TO_CONNECT_CAUSED_BY_CERT" : "ERROR_FAILED_TO_CONNECT_REPOS_CAUSED_BY_CERT", new Object[0]), (Exception)((Object)e), 21);
        }
        return ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(defaultRepo ? "ERROR_FAILED_TO_CONNECT" : "ERROR_FAILED_TO_CONNECT_REPOS", new Object[0]), (Exception)((Object)e), 21);
    }

    static InstallException create(RepositoryException e, Collection<String> featureNames, boolean installingAsset, RestRepositoryConnectionProxy proxy, boolean defaultRepo, boolean isOpenLiberty) {
        Throwable cause = e;
        Throwable rootCause = e;
        while ((rootCause = cause.getCause()) != null && cause != rootCause) {
            if (rootCause instanceof UnknownHostException || rootCause instanceof FileNotFoundException || rootCause instanceof ConnectException) {
                return ExceptionUtils.create(e, rootCause, proxy, defaultRepo);
            }
            cause = rootCause;
        }
        if (featureNames != null) {
            if (ExceptionUtils.isCertPathBuilderException(cause)) {
                return ExceptionUtils.createByKey(33, (Exception)((Object)e), defaultRepo ? "ERROR_FAILED_TO_CONNECT_CAUSED_BY_CERT" : "ERROR_FAILED_TO_CONNECT_REPOS_CAUSED_BY_CERT", new Object[0]);
            }
            String featuresListStr = InstallUtils.getFeatureListOutput(featureNames);
            InstallException ie = isOpenLiberty ? ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_FAILED_TO_RESOLVE_ASSETS" : "ERROR_FAILED_TO_RESOLVE_FEATURES_FOR_OPEN_LIBERTY", featuresListStr), (Exception)((Object)e)) : ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_FAILED_TO_RESOLVE_ASSETS" : "ERROR_FAILED_TO_RESOLVE_FEATURES", featuresListStr), (Exception)((Object)e));
            ie.setData(featuresListStr);
            return ie;
        }
        return ExceptionUtils.create((Exception)((Object)e));
    }

    static InstallException create(RepositoryResolutionException e, Collection<String> assetNames, File installDir, boolean installingAsset, boolean isOpenLiberty) {
        String missingRequirement;
        Collection allRequirementsNotFound = e.getAllRequirementsResourcesNotFound();
        ArrayList<RepositoryResolutionException.MissingRequirement> dependants = new ArrayList<RepositoryResolutionException.MissingRequirement>(allRequirementsNotFound.size());
        for (RepositoryResolutionException.MissingRequirement f : allRequirementsNotFound) {
            if (assetNames.contains(f.getRequirementName())) continue;
            dependants.add(f);
        }
        RepositoryResolutionException.MissingRequirement missingRequirementWithMaxVersion = null;
        String newestVersion = null;
        for (RepositoryResolutionException.MissingRequirement mr : allRequirementsNotFound) {
            String r;
            if (missingRequirementWithMaxVersion == null) {
                missingRequirementWithMaxVersion = mr;
            }
            if (!(r = mr.getRequirementName()).contains("productInstallType") && !r.contains("productEdition") && !r.contains("productVersion")) continue;
            Pattern validNumericVersionOrRange = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");
            Matcher matcher = validNumericVersionOrRange.matcher(r);
            String version = null;
            if (matcher.find()) {
                version = matcher.group();
            }
            List productMatchers = SelfExtractor.parseAppliesTo((String)mr.getRequirementName());
            ReturnCode validInstallRC = SelfExtractor.validateProductMatches((File)installDir, (List)productMatchers);
            String currentEdition = "";
            if (validInstallRC.getMessageKey().equals("invalidVersion") || validInstallRC.getMessageKey().equals("invalidEdition")) {
                int productEdition = 2;
                if (validInstallRC.getMessageKey().equals("invalidEdition")) {
                    productEdition = 0;
                }
                currentEdition = (String)validInstallRC.getParameters()[productEdition];
            }
            if (!currentEdition.equals("Liberty Early Access")) {
                if (!ExceptionUtils.isNewerVersion(version, newestVersion, false)) continue;
                missingRequirementWithMaxVersion = mr;
                newestVersion = version;
                continue;
            }
            if (!ExceptionUtils.isNewerVersion(version, newestVersion, true)) continue;
            missingRequirementWithMaxVersion = mr;
            newestVersion = version;
        }
        if (!(dependants.size() <= 0 || (missingRequirement = missingRequirementWithMaxVersion.getRequirementName()).contains(";") || missingRequirement.contains("productInstallType") || missingRequirement.contains("productEdition") || missingRequirement.contains("productVersion"))) {
            String assetsStr = "";
            String feature = missingRequirement;
            InstallException ie = null;
            if (assetNames.size() == 1) {
                assetsStr = assetNames.iterator().next();
                ie = ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_MISSING_DEPENDENT" : "ERROR_MISSING_DEPENDENT", assetsStr, feature), (Exception)e);
            } else if (assetNames.size() > 1) {
                assetsStr = assetNames.toString();
                ie = ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_MISSING_MULTIPLE_DEPENDENT" : "ERROR_MISSING_MULTIPLE_DEPENDENT", assetsStr, feature), (Exception)e);
            }
            ie.setData(assetsStr, feature);
            return ie;
        }
        if (missingRequirementWithMaxVersion.getRequirementName().contains("productInstallType") || missingRequirementWithMaxVersion.getRequirementName().contains("productEdition") || missingRequirementWithMaxVersion.getRequirementName().contains("productVersion")) {
            List productMatchers = SelfExtractor.parseAppliesTo((String)missingRequirementWithMaxVersion.getRequirementName());
            String feature = RepositoryDownloadUtil.getAssetNameFromMassiveResource(missingRequirementWithMaxVersion.getOwningResource());
            String errMsg = "";
            if (InstallUtils.containsIgnoreCase(assetNames, feature)) {
                errMsg = ExceptionUtils.validateProductMatches(feature, productMatchers, installDir, installingAsset);
            } else {
                String assetsStr = assetNames.size() == 1 ? assetNames.iterator().next() : InstallUtils.getFeatureListOutput(assetNames);
                errMsg = ExceptionUtils.validateProductMatches(assetsStr, feature, productMatchers, installDir, installingAsset);
            }
            if (!errMsg.isEmpty()) {
                return ExceptionUtils.create(errMsg, (Exception)e, 29);
            }
        }
        InstallException ie = isOpenLiberty ? ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_FAILED_TO_RESOLVE_ASSETS" : "ERROR_FAILED_TO_RESOLVE_FEATURES_FOR_OPEN_LIBERTY", InstallUtils.getFeatureListOutput(assetNames)), (Exception)e) : ExceptionUtils.create(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_FAILED_TO_RESOLVE_ASSETS" : "ERROR_FAILED_TO_RESOLVE_FEATURES", InstallUtils.getFeatureListOutput(assetNames)), (Exception)e);
        ie.setData(assetNames);
        return ie;
    }

    static boolean isNewerVersion(String version, String newestVersion, boolean isEarlyAccess) {
        if (version == null) {
            return false;
        }
        String[] versionAry = version.split("\\.");
        if (!isEarlyAccess && versionAry[0].length() == 4) {
            return false;
        }
        if (isEarlyAccess && versionAry[0].length() != 4) {
            return false;
        }
        if (newestVersion == null) {
            return true;
        }
        String[] newestVersionAry = newestVersion.split("\\.");
        for (int i = 0; i < versionAry.length; ++i) {
            if (Integer.parseInt(versionAry[i]) > Integer.parseInt(newestVersionAry[i])) {
                return true;
            }
            if (Integer.parseInt(versionAry[i]) >= Integer.parseInt(newestVersionAry[i])) continue;
            return false;
        }
        return false;
    }

    static String validateProductMatches(String feature, List productMatchers, File installDir, boolean installingAsset) {
        return ExceptionUtils.validateProductMatches(feature, null, productMatchers, installDir, installingAsset);
    }

    static String validateProductMatches(String feature, String dependency, List productMatchers, File installDir, boolean installingAsset) {
        ReturnCode validInstallRC = SelfExtractor.validateProductMatches((File)installDir, (List)productMatchers);
        String errMsg = "";
        if (validInstallRC != ReturnCode.OK) {
            String productName = "IBM WebSphere Application Server Liberty";
            Object[] params = validInstallRC.getParameters();
            if (validInstallRC.getMessageKey().equals("invalidVersion") || validInstallRC.getMessageKey().equals("invalidEdition")) {
                int productVersion = 0;
                int matchVersion = 1;
                int productEdition = 2;
                int matchEdition = 3;
                if (validInstallRC.getMessageKey().equals("invalidEdition")) {
                    productVersion = 2;
                    matchVersion = 3;
                    productEdition = 0;
                    matchEdition = 1;
                }
                String version = (String)params[productVersion];
                String appliesToVersion = (String)params[matchVersion];
                if (appliesToVersion == null || version.equals(appliesToVersion)) {
                    appliesToVersion = "";
                }
                List<String> editions = (List<String>)params[matchEdition];
                String edition = InstallUtils.getEditionName((String)params[productEdition]);
                StringBuilder applicableProducts = new StringBuilder();
                applicableProducts.append(InstallUtils.NEWLINE);
                if (editions == null || editions.size() == 0) {
                    editions = InstallUtils.ALL_EDITIONS;
                }
                if (((String)params[productEdition]).equalsIgnoreCase("Liberty Early Access")) {
                    editions = new ArrayList<String>();
                    editions.add("Early Access");
                }
                Collections.sort(editions);
                HashMap<String, String> productMap = new HashMap<String, String>();
                applicableProducts.append(InstallUtils.NEWLINE);
                for (String e : editions) {
                    String editionName = "";
                    editionName = InstallUtils.getEditionName(e);
                    if (productMap.containsKey(editionName)) continue;
                    String product = "- " + productName + (editionName.isEmpty() ? "" : " ") + editionName + " " + appliesToVersion;
                    productMap.put(editionName, product);
                    applicableProducts.append(product);
                    applicableProducts.append(InstallUtils.NEWLINE);
                }
                applicableProducts.append(InstallUtils.NEWLINE);
                errMsg = dependency == null || dependency.isEmpty() ? (appliesToVersion.equals("") ? (((String)params[productEdition]).equalsIgnoreCase("Open_Web") && productName.equalsIgnoreCase("IBM WebSphere Application Server Liberty") ? InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_INVALID_PRODUCT_EDITION" : "ERROR_INVALID_PRODUCT_EDITION_FOR_OPEN_LIBERTY_FEATURE", feature) : InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_INVALID_PRODUCT_EDITION" : "ERROR_INVALID_PRODUCT_EDITION", feature, productName, edition, applicableProducts.toString(), productName, edition)) : InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_INVALID_PRODUCT_EDITION_VERSION" : "ERROR_INVALID_PRODUCT_EDITION_VERSION", feature, productName, edition, version, applicableProducts.toString())) : InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_DEPENDENT_INVALID_VERSION_EDITION" : "ERROR_DEPENDENT_INVALID_VERSION_EDITION", feature, dependency, productName, edition, version, applicableProducts.toString());
            } else if (validInstallRC.getMessageKey().equals("invalidInstallType")) {
                errMsg = InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_INVALID_PRODUCT_INSTALLTYPE" : "ERROR_INVALID_PRODUCT_INSTALLTYPE", feature, params[0], params[1]);
            }
            if (errMsg.isEmpty()) {
                errMsg = InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(installingAsset ? "ERROR_ASSET_NOT_APPLICABLE" : "ERROR_FEATURE_NOT_APPLICABLE", feature, installDir.getAbsolutePath(), validInstallRC.getErrorMessage());
            }
        }
        return errMsg;
    }

    private static InstallException create(String msg, Exception e, int rc) {
        InstallException ie = new InstallException(msg, e, rc);
        return ie;
    }

    static String stacktraceToString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        return stackTrace;
    }
}

