/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.SingleFileRepositoryConnection;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.RepositoryResolver;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class InstallKernelMap
implements Map {
    private static final String MAP_BASED_INSTALL_KERNEL = "mapBasedInstallKernel";
    private static final String RUNTIME_INSTALL_DIR = "runtime.install.dir";
    private static final String LICENSE_ACCEPT = "license.accept";
    private static final String REPOSITORIES_PROPERTIES = "repositories.properties";
    private static final String DOWLOAD_EXTERNAL_DEPS = "dowload.external.deps";
    private static final String INSTALL_LOCAL_ESA = "install.local.esa";
    private static final String LOCAL_ESA_DOWNLOAD_DIR = "local.esa.download.dir";
    private static final String USER_AGENT = "user.agent";
    private static final String PROGRESS_MONITOR_MESSAGE = "progress.monitor.message";
    private static final String PROGRESS_MONITOR_CANCELLED = "progress.monitor.cancelled";
    private static final String PROGRESS_MONITOR_SIZE = "progress.monitor.size";
    private static final String TARGET_USER_DIRECTORY = "target.user.directory";
    private static final String INSTALL_KERNEL_INIT_CODE = "install.kernel.init.code";
    private static final String INSTALL_KERNEL_INIT_ERROR_MESSAGE = "install.kernel.init.error.message";
    private static final String UNINSTALL_USER_FEATURES = "uninstall.user.features";
    private static final String FORCE_UNINSTALL = "force.uninstall";
    private static final String ACTION_INSTALL = "action.install";
    private static final String ACTION_INSTALL_RESULT = "action.install.result";
    private static final String ACTION_UNINSTALL = "action.uninstall";
    private static final String ACTION_RESULT = "action.result";
    private static final String ACTION_ERROR_MESSAGE = "action.error.message";
    private static final String ACTION_EXCEPTION_STACKTRACE = "action.exception.stacktrace";
    private static final String TO_EXTENSION = "to.extension";
    private static final String DIRECTORY_BASED_REPOSITORY = "directory.based.repository";
    private static final String FEATURES_TO_RESOLVE = "features.to.resolve";
    private static final String SINGLE_JSON_FILE = "single.json.file";
    private static final String MESSAGE_LOCALE = "message.locale";
    private static final Integer OK = 0;
    private static final Integer CANCELLED = -1;
    private static final Integer ERROR = 1;
    private final Map data = new HashMap();
    private InstallKernelInteractive installKernel;
    private InstallEventListener ielistener;
    private ActionType actionType = null;

    public InstallKernelMap() {
        this.data.put(LICENSE_ACCEPT, Boolean.FALSE);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (INSTALL_KERNEL_INIT_CODE.equals(key)) {
            return this.initKernel();
        }
        if (ACTION_RESULT.equals(key)) {
            if (this.actionType.equals((Object)ActionType.install)) {
                Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.install();
                }
                return this.localESAInstall();
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return this.uninstall();
            }
            if (this.actionType.equals((Object)ActionType.resolve)) {
                Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.data.get(ACTION_RESULT);
                }
                return this.singleFileResolve();
            }
        } else if (PROGRESS_MONITOR_SIZE.equals(key)) {
            return this.getMonitorSize();
        }
        return this.data.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        if (LICENSE_ACCEPT.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(LICENSE_ACCEPT, value);
            return this.data.get(key);
        } else if (RUNTIME_INSTALL_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(RUNTIME_INSTALL_DIR, value);
            return this.data.get(key);
        } else if (LOCAL_ESA_DOWNLOAD_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(LOCAL_ESA_DOWNLOAD_DIR, value);
            return this.data.get(key);
        } else if (REPOSITORIES_PROPERTIES.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(REPOSITORIES_PROPERTIES, value);
            System.setProperty("WLP_REPOSITORIES_PROPS", ((File)value).getAbsolutePath());
            try {
                Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
                if (repoProperties == null) return this.data.get(key);
                this.installKernel.setRepositoryProperties(repoProperties);
                return this.data.get(key);
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                throw new RuntimeException(e);
            }
        } else if (DOWLOAD_EXTERNAL_DEPS.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(DOWLOAD_EXTERNAL_DEPS, value);
            return this.data.get(key);
        } else if (INSTALL_LOCAL_ESA.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(INSTALL_LOCAL_ESA, value);
            return this.data.get(key);
        } else if (USER_AGENT.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(USER_AGENT, value);
            if (this.installKernel == null) return this.data.get(key);
            this.installKernel.setUserAgent((String)value);
            return this.data.get(key);
        } else if (TO_EXTENSION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(TO_EXTENSION, value);
            return this.data.get(key);
        } else if (TARGET_USER_DIRECTORY.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(TARGET_USER_DIRECTORY, value);
            Utils.setUserDir((File)((File)value));
            return this.data.get(key);
        } else if (MESSAGE_LOCALE.equals(key)) {
            if (!(value instanceof Locale)) throw new IllegalArgumentException();
            this.data.put(MESSAGE_LOCALE, value);
            InstallLogUtils.Messages.setLocale((Locale)value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_MESSAGE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_MESSAGE, value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_CANCELLED.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_CANCELLED, value);
            return this.data.get(key);
        } else if (ACTION_INSTALL.equals(key)) {
            if (!(value instanceof List) && !(value instanceof File)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) {
                this.resolve(value);
                return this.data.get(key);
            } else {
                this.data.put(ACTION_INSTALL, value);
            }
            return this.data.get(key);
        } else if (UNINSTALL_USER_FEATURES.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(UNINSTALL_USER_FEATURES, value);
            return this.data.get(key);
        } else if (FORCE_UNINSTALL.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(FORCE_UNINSTALL, value);
            return this.data.get(key);
        } else if (ACTION_UNINSTALL.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(ACTION_UNINSTALL, value);
            this.actionType = ActionType.uninstall;
            return this.data.get(key);
        } else if (FEATURES_TO_RESOLVE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            if ((List)this.data.get(SINGLE_JSON_FILE) == null) throw new IllegalArgumentException();
            this.actionType = ActionType.resolve;
            this.data.put(FEATURES_TO_RESOLVE, value);
            return this.data.get(key);
        } else if (SINGLE_JSON_FILE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            this.data.put(SINGLE_JSON_FILE, value);
            return this.data.get(key);
        } else if (DIRECTORY_BASED_REPOSITORY.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(DIRECTORY_BASED_REPOSITORY, value);
            return this.data.get(key);
        } else {
            if (!key.equals("debug")) return this.data.get(key);
            if (!(value instanceof Level)) throw new IllegalArgumentException();
            this.data.put("debug", value);
            ((InstallKernelImpl)this.installKernel).enableConsoleLog((Level)value);
        }
        return this.data.get(key);
    }

    private InstallEventListener getListener() {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){

                @Override
                public void handleInstallEvent(InstallProgressEvent event) throws Exception {
                    if (InstallKernelMap.this.actionType != null) {
                        List messages;
                        if (InstallKernelMap.this.actionType.equals((Object)ActionType.install)) {
                            List messages2 = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE);
                            if (messages2 != null) {
                                messages2.add(event.message);
                                List cancelledList = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_CANCELLED);
                                if (((Boolean)cancelledList.get(0)).booleanValue()) {
                                    throw new CancelException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_CANCEL_INSTALL", new Object[0]), CANCELLED);
                                }
                            }
                        } else if (InstallKernelMap.this.actionType.equals((Object)ActionType.uninstall) && event.state == 255 && (messages = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE)) != null) {
                            messages.add(event.message);
                        }
                    }
                }
            };
        }
        return this.ielistener;
    }

    private Integer initKernel() {
        File installDir = (File)this.data.get(RUNTIME_INSTALL_DIR);
        Utils.setInstallDir((File)installDir);
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        String userAgent = (String)this.data.get(USER_AGENT);
        this.installKernel.setUserAgent(userAgent != null && !userAgent.isEmpty() ? userAgent : MAP_BASED_INSTALL_KERNEL);
        this.installKernel.setFirePublicAssetOnly(false);
        this.installKernel.addListener(this.getListener(), "PROGRESS");
        this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, null);
        return OK;
    }

    private void resolve(Object installObject) {
        this.data.put(ACTION_INSTALL, null);
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        this.actionType = ActionType.resolve;
        if (installObject instanceof List) {
            List assets = (List)installObject;
            try {
                this.installKernel.resolve(assets, false);
                this.checkLicense();
                this.actionType = ActionType.install;
                this.data.put(ACTION_INSTALL, installObject);
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            }
        } else if (installObject instanceof File) {
            File esaFile = (File)installObject;
            boolean isESA = ArchiveUtils.ArchiveFileType.ESA.isType(esaFile.getName());
            if (isESA) {
                try {
                    String feature = InstallUtils.getFeatureName(esaFile);
                    this.installKernel.resolve(feature, esaFile, "usr");
                    this.checkLicense();
                    this.actionType = ActionType.install;
                    this.data.put(ACTION_INSTALL, installObject);
                }
                catch (InstallException e) {
                    this.data.put(ACTION_RESULT, ERROR);
                    this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                    this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                }
            } else {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MAPBASED_ERROR_UNSUPPORTED_FILE", esaFile.getAbsoluteFile()));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static boolean containsIgnoreCase(Collection<String> featureToInstall, String existingFeature) {
        for (String current : featureToInstall) {
            if (!current.equalsIgnoreCase(existingFeature)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> singleFileResolve() {
        this.data.put(ACTION_INSTALL, null);
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        HashSet<ProductInfoProductDefinition> productDefinitions = new HashSet<ProductInfoProductDefinition>();
        Collection resolveResult = null;
        RepositoryResolver resolver = null;
        Collection<String> featuresResolved = new ArrayList<String>();
        boolean isOpenLiberty = false;
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
            RepositoryConnectionList repoList = new RepositoryConnectionList();
            List singleJsonRepos = (List)this.data.get(SINGLE_JSON_FILE);
            File directoryBasedRepo = (File)this.data.get(DIRECTORY_BASED_REPOSITORY);
            if (directoryBasedRepo != null) {
                DirectoryRepositoryConnection directRepo = new DirectoryRepositoryConnection(directoryBasedRepo);
                repoList.add((RepositoryConnection)directRepo);
            }
            for (File jsonRepo : singleJsonRepos) {
                SingleFileRepositoryConnection repo = new SingleFileRepositoryConnection(jsonRepo);
                repoList.add((RepositoryConnection)repo);
            }
            ManifestFileProcessor m_ManifestFileProcessor = new ManifestFileProcessor();
            Collection installedFeatures = m_ManifestFileProcessor.getFeatureDefinitions().values();
            int alreadyInstalled = 0;
            Collection featureToInstall = (Collection)this.data.get(FEATURES_TO_RESOLVE);
            ArrayList<String> featuresAlreadyPresent = new ArrayList<String>();
            for (ProvisioningFeatureDefinition feature : installedFeatures) {
                if (!InstallKernelMap.containsIgnoreCase(featureToInstall, feature.getIbmShortName()) && !featureToInstall.contains(feature.getFeatureName())) continue;
                ++alreadyInstalled;
                if (feature.getIbmShortName() == null) {
                    featuresAlreadyPresent.add(feature.getFeatureName());
                    continue;
                }
                featuresAlreadyPresent.add(feature.getIbmShortName());
            }
            if (alreadyInstalled == featureToInstall.size()) {
                throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", featuresAlreadyPresent);
            }
            resolver = new RepositoryResolver(productDefinitions, installedFeatures, Collections.emptySet(), repoList);
            resolveResult = resolver.resolve((Collection)this.data.get(FEATURES_TO_RESOLVE));
            Boolean accepted = (Boolean)this.data.get(LICENSE_ACCEPT);
            if (accepted == null || !accepted.booleanValue()) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
            }
            for (List item : resolveResult) {
                for (RepositoryResource repoResrc : item) {
                    if (repoResrc.getRepositoryConnection() instanceof DirectoryRepositoryConnection) {
                        featuresResolved.add(repoResrc.getId());
                        continue;
                    }
                    featuresResolved.add(repoResrc.getMavenCoordinates());
                }
            }
            this.actionType = ActionType.install;
            featuresResolved = InstallKernelMap.keepFirstInstance(featuresResolved);
            return featuresResolved;
        }
        catch (ProductInfoParseException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (DuplicateProductInfoException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (ProductInfoReplaceException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (RepositoryResolutionException e) {
            this.data.put(ACTION_RESULT, ERROR);
            InstallException ie = ExceptionUtils.create(e, (Collection)this.data.get(FEATURES_TO_RESOLVE), (File)this.data.get(RUNTIME_INSTALL_DIR), false, isOpenLiberty);
            this.data.put(ACTION_ERROR_MESSAGE, ie.toString());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(ie));
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
        }
        catch (RepositoryException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (Exception e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
        }
        this.actionType = ActionType.install;
        return featuresResolved;
    }

    private static Collection<String> keepFirstInstance(Collection<String> dupStrCollection) {
        ArrayList<String> uniqueStrCollection = new ArrayList<String>();
        for (String str : dupStrCollection) {
            if (uniqueStrCollection.contains(str)) continue;
            uniqueStrCollection.add(str);
        }
        return uniqueStrCollection;
    }

    private void checkLicense() throws InstallException {
        Boolean accepted;
        Set<InstallLicense> licenses = this.installKernel.getFeatureLicense(Locale.getDefault());
        if (!(licenses.isEmpty() || (accepted = (Boolean)this.data.get(LICENSE_ACCEPT)) != null && accepted.booleanValue())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
        }
    }

    private Integer getMonitorSize() {
        if (this.actionType != null) {
            if (this.actionType.equals((Object)ActionType.install)) {
                int numInstallResources = this.installKernel.getInstallResourcesSize();
                int numInstallAssets = this.installKernel.getLocalInstallAssetsSize();
                return numInstallResources * 2 + numInstallAssets + 1;
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return 1;
            }
        }
        return 0;
    }

    public Integer install() {
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        try {
            this.installKernel.checkResources();
            Boolean agreedToDownloadDependencies = (Boolean)this.data.get(DOWLOAD_EXTERNAL_DEPS);
            if (agreedToDownloadDependencies == null) {
                agreedToDownloadDependencies = Boolean.TRUE;
            }
            Map<String, Collection<String>> installedAssets = this.installKernel.install("usr", true, agreedToDownloadDependencies);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (CancelException e) {
            this.data.put(ACTION_RESULT, CANCELLED);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return CANCELLED;
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    public Integer localESAInstall() {
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        try {
            InstallKernelImpl installKernel = (InstallKernelImpl)this.installKernel;
            File esaFile = (File)this.data.get(ACTION_INSTALL);
            String toExtension = (String)this.data.get(TO_EXTENSION);
            if (toExtension == null) {
                toExtension = "usr";
            }
            Collection<String> installedAssets = installKernel.installLocalFeatureNoResolve(esaFile.getAbsolutePath(), toExtension, true, InstallConstants.ExistsAction.replace);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    private Integer uninstall() {
        ArrayList<String> uninstallFeatures = this.data.containsKey(ACTION_UNINSTALL) ? new ArrayList<String>((Collection)this.data.get(ACTION_UNINSTALL)) : new ArrayList();
        this.data.put(ACTION_ERROR_MESSAGE, null);
        try {
            Boolean allowUninstallUserFeatures;
            InstallKernel installKernel = (InstallKernel)((Object)this.installKernel);
            Boolean forceUninstall = this.data.containsKey(FORCE_UNINSTALL) ? (Boolean)this.data.get(FORCE_UNINSTALL) : Boolean.FALSE;
            Boolean bl = allowUninstallUserFeatures = this.data.containsKey(UNINSTALL_USER_FEATURES) ? (Boolean)this.data.get(UNINSTALL_USER_FEATURES) : Boolean.FALSE;
            if (forceUninstall.booleanValue()) {
                if (uninstallFeatures.size() > 1) {
                    this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
                    return ERROR;
                }
                installKernel.uninstallFeaturePrereqChecking((String)uninstallFeatures.get(0), allowUninstallUserFeatures, forceUninstall);
                installKernel.uninstallFeature((String)uninstallFeatures.get(0), forceUninstall);
            } else {
                if (allowUninstallUserFeatures != null && allowUninstallUserFeatures.booleanValue()) {
                    installKernel.uninstallFeaturePrereqChecking(uninstallFeatures);
                } else {
                    installKernel.uninstallCoreFeaturePrereqChecking(uninstallFeatures);
                }
                installKernel.uninstallFeature(uninstallFeatures);
            }
        }
        catch (InstallException e) {
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    private static enum ActionType {
        install,
        uninstall,
        resolve;

    }
}

