/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.utility.tasks;

import com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil;
import com.ibm.ws.springboot.utility.IFileUtility;
import com.ibm.ws.springboot.utility.SpringBootUtilityReturnCodes;
import com.ibm.ws.springboot.utility.tasks.BaseCommandTask;
import com.ibm.ws.springboot.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ThinAppTask
extends BaseCommandTask {
    static final String SLASH = String.valueOf(File.separatorChar);
    static final String ARG_SOURCE_APP = "--sourceAppPath";
    static final String ARG_DEST_THIN_APP = "--targetThinAppPath";
    static final String ARG_DEST_LIB_CACHE = "--targetLibCachePath";
    static final String ARG_PARENT_LIB_CACHE = "--parentLibCachePath";
    static final Set<String> knownArguments = new HashSet<String>(Arrays.asList("--sourceAppPath", "--targetThinAppPath", "--targetLibCachePath", "--parentLibCachePath"));
    private final IFileUtility fileUtility;
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;

    public ThinAppTask(IFileUtility fileUtility, String scriptName) {
        super(scriptName);
        this.fileUtility = fileUtility;
    }

    @Override
    public String getTaskName() {
        return "thin";
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("thin.desc", true, new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("thin.desc", "thin.usage.options", "thin.required-key.", "thin.required-desc.", "thin.optional-key.", "thin.optional-desc.", this.scriptName);
    }

    @Override
    public SpringBootUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args);
        String sourceAppPath = this.getArgumentValue(ARG_SOURCE_APP, args);
        String destThinAppPath = this.getArgumentValue(ARG_DEST_THIN_APP, args);
        String destLibCachePath = this.getArgumentValue(ARG_DEST_LIB_CACHE, args);
        String parentLibCachePath = this.getArgumentValue(ARG_PARENT_LIB_CACHE, args);
        if (!this.fileUtility.isFile(sourceAppPath)) {
            stdout.println(this.getMessage("thin.abort", new Object[0]));
            stdout.println(this.getMessage("thin.appNotFound", sourceAppPath));
            return SpringBootUtilityReturnCodes.ERR_APP_NOT_FOUND;
        }
        File sourceAppFile = new File(sourceAppPath).getAbsoluteFile();
        if (destThinAppPath == null) {
            String appName = sourceAppFile.getName();
            int lastDot = appName.lastIndexOf(46);
            appName = lastDot > 0 ? appName.substring(0, lastDot + 1) + "spring" : appName + ".spring";
            destThinAppPath = (sourceAppFile.getParent() == null ? "" : sourceAppFile.getParent()) + File.separator + appName;
        }
        if (this.fileUtility.isDirectory(destThinAppPath)) {
            stdout.println(this.getMessage("thin.abort", new Object[0]));
            stdout.println(this.getMessage("thin.appTargetIsDirectory", destThinAppPath));
            return SpringBootUtilityReturnCodes.ERR_APP_DEST_IS_DIR;
        }
        File thinAppFile = new File(destThinAppPath).getAbsoluteFile();
        if (!this.fileUtility.mkDirs(thinAppFile.getParentFile(), stdout)) {
            return SpringBootUtilityReturnCodes.ERR_MAKE_DIR;
        }
        if (destLibCachePath == null) {
            destLibCachePath = (sourceAppFile.getParent() == null ? "" : sourceAppFile.getParent()) + File.separator + "lib.index.cache";
        }
        if (this.fileUtility.isFile(destLibCachePath)) {
            stdout.println(this.getMessage("thin.abort", new Object[0]));
            stdout.println(this.getMessage("thin.libCacheIsFile", destLibCachePath));
            return SpringBootUtilityReturnCodes.ERR_LIB_DEST_IS_FILE;
        }
        File libCache = new File(destLibCachePath).getAbsoluteFile();
        if (!this.fileUtility.mkDirs(libCache, stdout)) {
            return SpringBootUtilityReturnCodes.ERR_MAKE_DIR;
        }
        File parentLibCache = null;
        if (parentLibCachePath != null && !this.fileUtility.mkDirs(parentLibCache = new File(parentLibCachePath).getAbsoluteFile(), stdout)) {
            return SpringBootUtilityReturnCodes.ERR_MAKE_DIR;
        }
        this.performThinTask(sourceAppFile, thinAppFile, libCache, parentLibCache);
        return SpringBootUtilityReturnCodes.OK;
    }

    private void performThinTask(File applicationFile, File thinAppFile, File libCache, File parentLibCache) throws IOException, NoSuchAlgorithmException {
        this.stdout.println(this.getMessage("thin.creating", applicationFile.getAbsolutePath()));
        SpringBootThinUtil thinUtil = new SpringBootThinUtil(applicationFile, thinAppFile, libCache, parentLibCache);
        thinUtil.execute();
        this.stdout.println(this.getMessage("thin.libraryCache", libCache));
        this.stdout.println(this.getMessage("thin.applicationLoc", thinAppFile.getAbsolutePath()));
    }

    @Override
    boolean isKnownArgument(String arg) {
        return knownArguments.contains(arg);
    }

    @Override
    void checkRequiredArguments(String[] args) {
        String message = "";
        if (args.length < 2) {
            message = this.getMessage("insufficientArgs", new Object[0]);
        }
        boolean sourceAppFound = false;
        for (String arg : args) {
            if (!arg.startsWith(ARG_SOURCE_APP)) continue;
            sourceAppFound = true;
        }
        if (!sourceAppFound) {
            message = message + " " + this.getMessage("missingArg", ARG_SOURCE_APP);
        }
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private String getArgumentValue(String arg, String[] args) {
        return this.getArgumentValue(arg, args, this.stdin, this.stdout);
    }
}

