/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.internal.BundleLifecycleStatus;
import com.ibm.ws.kernel.feature.internal.ShutdownHookManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class StartLevelFrameworkListener
implements FrameworkListener,
ShutdownHookManager.ShutdownHookListener {
    private final ShutdownHookManager shutdownHook;
    private final BundleLifecycleStatus status;
    private final AtomicBoolean levelReached = new AtomicBoolean(false);
    static final long serialVersionUID = 7818032148182241240L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public StartLevelFrameworkListener(ShutdownHookManager shutdownHook) {
        this.shutdownHook = shutdownHook;
        this.status = new BundleLifecycleStatus();
        shutdownHook.addListener(this);
    }

    @Override
    public void shutdownHookInvoked() {
        this.levelReached(true);
    }

    public void frameworkEvent(FrameworkEvent event) {
        switch (event.getType()) {
            case 2: {
                this.status.addStartException(event.getBundle(), event.getThrowable());
                break;
            }
            case 8: 
            case 64: 
            case 128: 
            case 256: {
                this.levelReached(false);
                break;
            }
        }
    }

    @FFDCIgnore(value={InterruptedException.class})
    public synchronized void waitForLevel() {
        while (!this.levelReached.get() && !this.shutdownHook.vmShutdown()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void levelReached(boolean inShutdownHook) {
        if (this.levelReached.compareAndSet(false, true)) {
            if (inShutdownHook) {
                this.status.markContextInvalid();
            } else {
                this.shutdownHook.removeListener(this);
            }
        }
        StartLevelFrameworkListener startLevelFrameworkListener = this;
        synchronized (startLevelFrameworkListener) {
            this.notifyAll();
        }
    }

    public BundleLifecycleStatus getStatus() {
        return this.status;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(StartLevelFrameworkListener.class);
    }
}

