/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.cmdline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class APIType
extends Enum<APIType> {
    public static final /* enum */ APIType API;
    public static final /* enum */ APIType SPI;
    public final String prefix;
    public final String attribute;
    private static final /* synthetic */ APIType[] $VALUES;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static APIType[] values() {
        return (APIType[])$VALUES.clone();
    }

    public static APIType valueOf(String name) {
        return Enum.valueOf(APIType.class, name);
    }

    private APIType(String prefix, String attribute) {
        this.prefix = prefix;
        this.attribute = attribute;
    }

    public boolean matches(FeatureResource resource) {
        String attrValue = resource.getAttributes().get(this.attribute);
        return attrValue == null || Boolean.parseBoolean(attrValue);
    }

    public String getElementName() {
        return this.attribute;
    }

    public static APIType getAPIType(FeatureResource resource) {
        String location = resource.getLocation();
        if (location != null) {
            location = location.trim();
            for (APIType apiType : APIType.values()) {
                if (!location.startsWith(apiType.prefix)) continue;
                return apiType.matches(resource) ? apiType : null;
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(APIType.class);
        API = new APIType("dev/api", "apiJar");
        SPI = new APIType("dev/spi", "spiJar");
        $VALUES = new APIType[]{API, SPI};
    }
}

