/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.schema.MetaTypeInformationSpecification;
import com.ibm.ws.config.xml.internal.schema.ObjectClassDefinitionSpecification;
import com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.cmdline.APIType;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListWriter;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FeatureList {
    private final FeatureListOptions options;
    private final Map<String, ProvisioningFeatureDefinition> features;
    private final Map<String, ProvisioningFeatureDefinition> coreFeatures;
    private final Map<String, List<Map<String, Object>>> cachedJavaVersionsByFeature = new HashMap<String, List<Map<String, Object>>>();
    private final Map<File, List<Map<String, Object>>> cachedJavaVersionsByBundle = new HashMap<File, List<Map<String, Object>>>();
    private final FeatureListUtils featureListUtils;
    private static final boolean writingJavaVersion;
    private static final List<Map<String, Object>> possibleJavaVersions;
    private static final Map<String, Collection<ManifestHeaderProcessor.GenericMetadata>> eeToCapability;
    static final long serialVersionUID = 1157940428931733491L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FeatureList(FeatureListOptions options, Map<String, ProvisioningFeatureDefinition> fds, Map<String, ProvisioningFeatureDefinition> coreFDs, FeatureListUtils utils) {
        this.options = options;
        this.features = fds;
        this.coreFeatures = coreFDs;
        this.featureListUtils = utils;
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
    }

    private static void addJVM(List<Map<String, Object>> possibleJavaVersions, String version, String ... versions) {
        ArrayList<Version> versionsList = new ArrayList<Version>();
        Version v = new Version(version);
        versionsList.add(v);
        for (String aVersion : versions) {
            versionsList.add(new Version(aVersion));
        }
        HashMap<String, Object> supportedJVM = new HashMap<String, Object>();
        supportedJVM.put("osgi.ee", "JavaSE");
        supportedJVM.put("version", versionsList);
        supportedJVM.put("bree", "JavaSE-" + v.getMajor() + "." + v.getMinor());
        possibleJavaVersions.add(supportedJVM);
    }

    /*
     * WARNING - void declaration
     */
    public void writeFeatureList(ManifestFileProcessor mfp) {
        try {
            File installDir = Utils.getInstallDir();
            try {
                String productName = this.options.getProductName();
                FeatureListWriter writer = new FeatureListWriter(this.featureListUtils);
                for (Map.Entry<String, ProvisioningFeatureDefinition> entry : this.features.entrySet()) {
                    this.writeFeature(writer, mfp, installDir, entry.getValue(), productName);
                }
            }
            catch (XMLStreamException productName) {
                void e;
                FFDCFilter.processException((Throwable)productName, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"149", (Object)this, (Object[])new Object[]{mfp});
                throw new IOException("Error generating feature list", (Throwable)e);
            }
        }
        catch (IOException installDir) {
            void ex;
            FFDCFilter.processException((Throwable)installDir, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"152", (Object)this, (Object[])new Object[]{mfp});
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException((Throwable)ex);
        }
    }

    private void writeFeature(FeatureListWriter writer, ManifestFileProcessor mfp, File installDir, ProvisioningFeatureDefinition fd, String productName) throws IOException, XMLStreamException {
        boolean publicFeature = false;
        boolean showExternals = true;
        boolean privateFeature = false;
        Collection<HeaderElementDefinition> autoFeature = fd.getHeaderElements("IBM-Provision-Capability");
        String apiPkgs = fd.getHeader("IBM-API-Package");
        String spiPkgs = fd.getHeader("IBM-SPI-Package");
        if (fd.getVisibility() == Visibility.PUBLIC) {
            String featureName = fd.getIbmShortName();
            if (featureName == null) {
                featureName = fd.getSymbolicName();
            }
            writer.startFeature("feature", featureName);
            publicFeature = true;
        } else if (fd.getVisibility() == Visibility.PROTECTED) {
            writer.startFeature("protectedFeature");
            showExternals = false;
        } else if (fd.isKernel()) {
            writer.startFeature("kernelFeature");
        } else if (!autoFeature.isEmpty()) {
            writer.startFeature("autoFeature");
        } else {
            writer.startFeature("privateFeature");
            showExternals = false;
            privateFeature = true;
        }
        writer.writeTextElement("symbolicName", fd.getSymbolicName());
        if (fd.isSingleton()) {
            writer.writeTextElement("singleton", "true");
        }
        if (FeatureDefinitionUtils.ALLOWED_ON_CLIENT_ONLY_FEATURES.contains(fd.getSymbolicName())) {
            writer.writeTextElement("processType", ProcessType.CLIENT.name());
        }
        if (!privateFeature) {
            String categories;
            String supersededBy;
            String name = fd.getHeader("Subsystem-Name", this.options.getLocale());
            String desc = fd.getHeader("Subsystem-Description", this.options.getLocale());
            if (name != null) {
                writer.writeTextElement("displayName", name);
            }
            if (fd.isSuperseded()) {
                writer.writeTextElement("superseded", "true");
            }
            if ((supersededBy = fd.getSupersededBy()) != null) {
                String[] supersededByList = supersededBy.split(",");
                for (String supersedByFeature : supersededByList) {
                    String supersedByFeatureTrim = supersedByFeature.trim();
                    if (supersedByFeatureTrim.equals("")) continue;
                    writer.writeTextElement("supersededBy", supersedByFeatureTrim);
                }
            }
            if (desc != null) {
                writer.writeTextElement("description", desc);
            }
            if (writingJavaVersion) {
                List<Map<String, Object>> javaVersions = this.getJavaVersion(mfp, fd);
                for (Map map : javaVersions) {
                    writer.writeTextElement("javaVersion", this.toJavaEE(map));
                }
            }
            if ((categories = fd.getHeader("Subsystem-Category")) != null) {
                for (String category : categories.split(",")) {
                    writer.writeTextElement("category", category);
                }
            }
        }
        for (HeaderElementDefinition element : autoFeature) {
            String filter = element.getDirectives().get("filter");
            writer.writeTextElement("autoProvision", filter);
        }
        if (!privateFeature) {
            ContentBasedLocalBundleRepository cbr = this.getBundleRepo(fd.getFeatureName(), mfp);
            TreeSet<File> bundles = new TreeSet<File>();
            TreeSet<File> apiJars = showExternals ? new TreeSet<File>() : null;
            TreeSet<File> spiJars = new TreeSet<File>();
            if (publicFeature) {
                TreeSet<String> enabledFeatureNames = new TreeSet<String>();
                this.searchContent(fd, cbr, enabledFeatureNames, bundles, apiJars, spiJars);
                for (String enabledFeatureName : enabledFeatureNames) {
                    writer.writeTextElement("enables", enabledFeatureName);
                }
            } else {
                this.searchJars(fd, cbr, bundles, apiJars, spiJars);
            }
            this.writeApiSpiJars(writer, installDir, apiJars, "apiJar");
            this.writeApiSpiJars(writer, installDir, spiJars, "spiJar");
            this.writeApiSpiPkgs(writer, apiPkgs, "apiPackage");
            this.writeApiSpiPkgs(writer, spiPkgs, "spiPackage");
            if (showExternals) {
                HashSet<String> elements = new HashSet<String>();
                if ("com.ibm.websphere.appserver.kernelCore-1.0".equals(fd.getSymbolicName())) {
                    elements.add("include");
                    elements.add("variable");
                }
                boolean bl = this.options.getIncludeInternals();
                SchemaMetaTypeParser parser = new SchemaMetaTypeParser(Locale.getDefault(), new ArrayList<File>(bundles), productName);
                List info = parser.getMetatypeInformation();
                for (MetaTypeInformationSpecification spec : info) {
                    for (ObjectClassDefinitionSpecification ocds : spec.getObjectClassSpecifications()) {
                        String alias;
                        Map attribs;
                        if (!bl && "internal".equals(ocds.getName()) || !ocds.getExtensionUris().contains("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0") || (attribs = ocds.getExtensionAttributes("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")) == null || (alias = (String)attribs.get("alias")) == null || attribs.containsKey("childAlias")) continue;
                        elements.add(alias);
                    }
                }
                for (String configElement : elements) {
                    writer.writeTextElement("configElement", configElement);
                }
            }
        }
        for (FeatureResource included : fd.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            String shortName = null;
            String symbolicName = included.getSymbolicName();
            ProvisioningFeatureDefinition other = this.features.get(symbolicName);
            if (other == null && this.coreFeatures != null) {
                other = this.coreFeatures.get(symbolicName);
            }
            if (other != null && other.getVisibility() == Visibility.PUBLIC) {
                shortName = other.getFeatureName();
            }
            writer.writeIncludeFeature(included.getSymbolicName(), included.getTolerates(), shortName);
        }
        writer.endFeature();
    }

    private String toJavaEE(Map<String, Object> version) {
        return (String)version.get("bree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<Map<String, Object>> getJavaVersion(ManifestFileProcessor mfp, ProvisioningFeatureDefinition fd) {
        result = this.cachedJavaVersionsByFeature.get(fd.getFeatureName());
        if (result == null) {
            result = new ArrayList<Map<String, Object>>(FeatureList.possibleJavaVersions);
            for (FeatureResource res : fd.getConstituents(SubsystemContentType.BUNDLE_TYPE)) {
                repo = mfp.getBundleRepository(fd.getBundleRepositoryType(), null);
                bundleFile = repo.selectBundle(res.getLocation(), res.getSymbolicName(), res.getVersionRange());
                bundleMatches = this.cachedJavaVersionsByBundle.get(bundleFile);
                if (bundleMatches == null) {
                    bundleMatches = new ArrayList<Map<String, Object>>();
                    jar = null;
                    try {
                        jar = new JarFile(bundleFile);
                        man = jar.getManifest();
                        a = man.getMainAttributes();
                        eeValue = a.getValue("Bundle-RequiredExecutionEnvironment");
                        if (eeValue != null) {
                            values = eeValue.split(",");
                            capabilityRequirements = this.toCapabilityRequirements(values);
                        } else {
                            rq = a.getValue("Require-Capability");
                            if (rq != null) {
                                capabilityRequirements = ManifestHeaderProcessor.parseCapabilityString((String)rq);
                            } else {
                                capabilityRequirements = Collections.emptyList();
                                bundleMatches = new ArrayList<Map<String, Object>>(FeatureList.possibleJavaVersions);
                            }
                        }
                        for (ManifestHeaderProcessor.GenericMetadata capability : capabilityRequirements) {
                            if (!"osgi.ee".equals(capability.getNamespace())) continue;
                            filterString = String.valueOf(capability.getDirectives().get("filter"));
                            try {
                                filter = FrameworkUtil.createFilter((String)filterString);
                                for (Map<String, Object> props : FeatureList.possibleJavaVersions) {
                                    if (!filter.matches(props)) continue;
                                    bundleMatches.add(props);
                                }
                            }
                            catch (InvalidSyntaxException var17_21) {
                                FFDCFilter.processException((Throwable)var17_21, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"385", (Object)this, (Object[])new Object[]{mfp, fd});
                            }
                        }
                        this.cachedJavaVersionsByBundle.put(bundleFile, bundleMatches);
                        ** if (jar == null) goto lbl-1000
                    }
                    catch (IOException var10_12) {
                        try {
                            FFDCFilter.processException((Throwable)var10_12, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"390", (Object)this, (Object[])new Object[]{mfp, fd});
                            ** if (jar == null) goto lbl-1000
                        }
                        catch (Throwable var20_24) {
                            if (jar != null) {
                                try {
                                    jar.close();
                                }
                                catch (IOException var21_25) {
                                    FFDCFilter.processException((Throwable)var21_25, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"396", (Object)this, (Object[])new Object[]{mfp, fd});
                                }
                            }
                            throw var20_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                jar.close();
                            }
                            catch (IOException var10_13) {
                                FFDCFilter.processException((Throwable)var10_13, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"396", (Object)this, (Object[])new Object[]{mfp, fd});
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            jar.close();
                        }
                        catch (IOException var10_11) {
                            FFDCFilter.processException((Throwable)var10_11, (String)"com.ibm.ws.kernel.feature.internal.generator.FeatureList", (String)"396", (Object)this, (Object[])new Object[]{mfp, fd});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                result.retainAll(bundleMatches);
            }
            for (FeatureResource res : fd.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
                otherFD = mfp.getFeatureDefinitions().get(res.getSymbolicName());
                if (otherFD == null) continue;
                featureSupportedVersion = this.getJavaVersion(mfp, otherFD);
                result.retainAll(featureSupportedVersion);
            }
            this.cachedJavaVersionsByFeature.put(fd.getFeatureName(), result);
        }
        return result.isEmpty() != false ? FeatureList.possibleJavaVersions : result;
    }

    private List<ManifestHeaderProcessor.GenericMetadata> toCapabilityRequirements(String[] values) {
        ArrayList<ManifestHeaderProcessor.GenericMetadata> metadata = new ArrayList<ManifestHeaderProcessor.GenericMetadata>();
        for (String val : values) {
            Collection<ManifestHeaderProcessor.GenericMetadata> data = eeToCapability.get(val);
            if (data == null) continue;
            metadata.addAll(data);
        }
        return metadata;
    }

    private void writeApiSpiJars(FeatureListWriter writer, File installDir, Set<File> jars, String elementName) throws IOException, XMLStreamException {
        if (jars != null) {
            for (File f : jars) {
                String nameToWrite;
                if (f.getAbsolutePath().startsWith(installDir.getAbsolutePath())) {
                    int installDirLen = installDir.getAbsolutePath().length() + 1;
                    nameToWrite = PathUtils.slashify((String)f.getAbsolutePath().substring(installDirLen));
                } else {
                    nameToWrite = PathUtils.slashify((String)f.getAbsolutePath());
                }
                writer.writeTextElement(elementName, nameToWrite);
            }
        }
    }

    private void writeApiSpiPkgs(FeatureListWriter writer, String pkgs, String pkgType) throws IOException, XMLStreamException {
        if (pkgs != null) {
            List pkgList = ManifestHeaderProcessor.parseExportString((String)pkgs);
            for (ManifestHeaderProcessor.NameValuePair pkg : pkgList) {
                Map attrs = pkg.getAttributes();
                if ("internal".equals(attrs.get("type"))) continue;
                writer.writeTextElementWithAttributes(pkgType, pkg.getName(), attrs);
            }
        }
    }

    private ContentBasedLocalBundleRepository getBundleRepo(String enabledFeatureName, ManifestFileProcessor mfp) {
        if (enabledFeatureName == null) {
            enabledFeatureName = "";
        }
        ContentBasedLocalBundleRepository cbr = enabledFeatureName.startsWith("usr:") ? BundleRepositoryRegistry.getUsrInstallBundleRepository() : (enabledFeatureName.contains(":") ? mfp.getBundleRepository(enabledFeatureName.substring(0, enabledFeatureName.indexOf(":")), null) : BundleRepositoryRegistry.getInstallBundleRepository());
        return cbr;
    }

    private void searchContent(ProvisioningFeatureDefinition feature, ContentBasedLocalBundleRepository cbr, Set<String> enabledFeatureNames, Set<File> bundles, Set<File> apiJars, Set<File> spiJars) {
        for (FeatureResource fr : feature.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            String symbolicName = fr.getSymbolicName();
            ProvisioningFeatureDefinition other = this.features.get(symbolicName);
            if (other == null && this.coreFeatures != null) {
                other = this.coreFeatures.get(symbolicName);
            }
            if (other == null) continue;
            if (other.getVisibility() == Visibility.PUBLIC) {
                if (enabledFeatureNames != null) {
                    enabledFeatureNames.add(other.getFeatureName());
                }
                this.searchContent(other, cbr, null, null, null, null);
                continue;
            }
            this.searchContent(other, cbr, enabledFeatureNames, bundles, apiJars != null && APIType.API.matches(fr) ? apiJars : null, spiJars != null && APIType.SPI.matches(fr) ? spiJars : null);
        }
        this.searchJars(feature, cbr, bundles, apiJars, spiJars);
    }

    private void searchJars(ProvisioningFeatureDefinition feature, ContentBasedLocalBundleRepository cbr, Set<File> bundles, Set<File> apiJars, Set<File> spiJars) {
        if (bundles != null || apiJars != null || spiJars != null) {
            this.searchJars(feature, cbr, SubsystemContentType.JAR_TYPE, null, apiJars, spiJars);
            this.searchJars(feature, cbr, SubsystemContentType.BUNDLE_TYPE, bundles, apiJars, spiJars);
        }
    }

    private void searchJars(ProvisioningFeatureDefinition feature, ContentBasedLocalBundleRepository cbr, SubsystemContentType contentType, Set<File> bundles, Set<File> apiJars, Set<File> spiJars) {
        for (FeatureResource fr : feature.getConstituents(contentType)) {
            APIType apiType;
            String location = fr.getLocation();
            File f = cbr.selectBundle(location, fr.getSymbolicName(), fr.getVersionRange());
            if (f == null) continue;
            if (bundles != null) {
                bundles.add(f);
            }
            if ((apiType = APIType.getAPIType(fr)) == APIType.API) {
                if (apiJars == null) continue;
                apiJars.add(f);
                continue;
            }
            if (apiType != APIType.SPI || spiJars == null) continue;
            spiJars.add(f);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FeatureList.class);
        writingJavaVersion = Boolean.getBoolean("ibm.javaVersion");
        possibleJavaVersions = new ArrayList<Map<String, Object>>();
        eeToCapability = new HashMap<String, Collection<ManifestHeaderProcessor.GenericMetadata>>();
        if (writingJavaVersion) {
            FeatureList.addJVM(possibleJavaVersions, "1.7", "1.6", "1.5", "1.4", "1.3", "1.2", "1.1");
            FeatureList.addJVM(possibleJavaVersions, "1.8", "1.7", "1.6", "1.5", "1.4", "1.3", "1.2", "1.1");
            List mostGeneralRange = ManifestHeaderProcessor.parseCapabilityString((String)"osgi.ee; filter:=\"(&(osgi.ee=JavaSE)(version=1.7))\"");
            eeToCapability.put("J2SE-1.2", mostGeneralRange);
            eeToCapability.put("J2SE-1.3", mostGeneralRange);
            eeToCapability.put("J2SE-1.4", mostGeneralRange);
            eeToCapability.put("JavaSE-1.5", mostGeneralRange);
            eeToCapability.put("JavaSE-1.6", mostGeneralRange);
            eeToCapability.put("JavaSE-1.7", mostGeneralRange);
            eeToCapability.put("JavaSE-1.8", ManifestHeaderProcessor.parseCapabilityString((String)"osgi.ee; filter:=\"(&(osgi.ee=JavaSE)(version=1.8))\""));
        }
    }
}

