/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class FeatureRepository
implements FeatureResolver.Repository {
    private static final TraceComponent tc = Tr.register(FeatureRepository.class);
    private boolean isDirty;
    private boolean cacheOk = true;
    private final WsResource cacheRes;
    private final BundleContext bundleContext;
    private volatile Set<String> installedFeatures = Collections.emptySet();
    private volatile Set<String> configuredFeatures = Collections.emptySet();
    private volatile boolean configurationError = true;
    private final Map<String, SubsystemFeatureDefinitionImpl> cachedFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
    private final Map<String, String> publicFeatureNameToSymbolicName = new HashMap<String, String>();
    private final ConcurrentMap<String, LibertyFeatureServiceFactory> featureServiceFactories = new ConcurrentHashMap<String, LibertyFeatureServiceFactory>();
    private ArrayList<SubsystemFeatureDefinitionImpl> autoFeatures;
    private Map<File, SubsystemFeatureDefinitionImpl> knownFeatures;
    private Map<File, BadFeature> knownBadFeatures;
    private static final String TOLERATE_PREFIX = "tolerates.";
    private static String FEATURE_SERVICE_NAME = "ibm.featureName";
    private static String FEATURE_SERVICE_SYMBOLIC_NAME = "osgi.symbolicName";
    private static String FEATURE_SERVICE_VERSION = "osgi.version";
    private static String FEATURE_SERVICE_CATEGORY = "osgi.category";
    static final long serialVersionUID = -1735717570458033311L;

    public FeatureRepository() {
        this.cacheRes = null;
        this.isDirty = true;
        this.bundleContext = null;
    }

    public FeatureRepository(WsResource res, BundleContext bundleContext) {
        this.cacheRes = res;
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.isDirty = false;
        boolean firstInit = this.cachedFeatures.isEmpty();
        this.autoFeatures = new ArrayList();
        this.knownFeatures = new HashMap<File, SubsystemFeatureDefinitionImpl>();
        this.knownBadFeatures = new HashMap<File, BadFeature>();
        this.readCache(firstInit);
        this.readFeatureManifests();
        if (this.isDirty && firstInit) {
            this.installedFeatures = Collections.emptySet();
            this.configuredFeatures = Collections.emptySet();
        }
    }

    public void dispose() {
        this.storeCache();
        this.autoFeatures = null;
        this.knownFeatures = null;
        this.knownBadFeatures = null;
        for (SubsystemFeatureDefinitionImpl def : this.cachedFeatures.values()) {
            def.setProvisioningDetails(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void readCache(boolean firstInit) {
        if (this.cacheOk && this.cacheRes != null && this.cacheRes.exists()) {
            String line = null;
            InputStream in = null;
            BufferedReader reader = null;
            SubsystemFeatureDefinitionImpl cachedEntry = null;
            try {
                in = this.cacheRes.get();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("@=")) {
                        if (!firstInit) continue;
                        this.installedFeatures = this.readFeatureNameList(line.substring(2));
                        continue;
                    }
                    if (line.startsWith("XX")) {
                        this.updateBadManifestCache(line.substring(2));
                        continue;
                    }
                    if (line.startsWith("-@")) {
                        if (!firstInit) continue;
                        this.configuredFeatures = this.readFeatureNameList(line.substring(2));
                        continue;
                    }
                    if (line.startsWith("-#")) {
                        if (line.length() <= 2) continue;
                        this.configurationError = line.charAt(2) == '1';
                        continue;
                    }
                    if (line.startsWith("-")) continue;
                    int index = line.indexOf(61);
                    String symbolicName = line.substring(0, index);
                    cachedEntry = this.cachedFeatures.get(symbolicName);
                    FeatureDefinitionUtils.ImmutableAttributes cachedAttr = cachedEntry == null ? null : cachedEntry.getImmutableAttributes();
                    FeatureDefinitionUtils.ImmutableAttributes newAttr = FeatureDefinitionUtils.loadAttributes(line, cachedAttr);
                    if (newAttr != null) {
                        FeatureDefinitionUtils.ProvisioningDetails details = new FeatureDefinitionUtils.ProvisioningDetails(reader, newAttr);
                        if (cachedAttr == newAttr) {
                            cachedEntry.setProvisioningDetails(details);
                        } else {
                            if (!firstInit) {
                                this.isDirty = true;
                            }
                            cachedEntry = new SubsystemFeatureDefinitionImpl(newAttr, details);
                        }
                    } else if (cachedAttr != null) {
                        this.isDirty = true;
                        this.cachedFeatures.remove(symbolicName);
                        cachedEntry = null;
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"cacheAttr and newAttr BOTH null while reading cache", (Object[])new Object[]{line});
                        }
                        this.isDirty = true;
                        cachedEntry = null;
                    }
                    this.updateMaps(cachedEntry);
                }
            }
            catch (IOException index) {
                try {
                    void ioe;
                    FFDCFilter.processException((Throwable)index, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"246", (Object)this, (Object[])new Object[]{firstInit});
                    this.cacheWarning((IOException)ioe);
                }
                catch (Throwable throwable) {
                    FileUtils.tryToClose(reader);
                    FileUtils.tryToClose((Closeable)in);
                    throw throwable;
                }
                FileUtils.tryToClose((Closeable)reader);
                FileUtils.tryToClose((Closeable)in);
            }
            FileUtils.tryToClose((Closeable)reader);
            FileUtils.tryToClose((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void storeCache() {
        if (this.cacheOk && this.cacheRes != null && this.isDirty) {
            OutputStream out = null;
            try {
                out = this.cacheRes.putStream();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
                for (SubsystemFeatureDefinitionImpl subsystemFeatureDefinitionImpl : this.cachedFeatures.values()) {
                    FeatureDefinitionUtils.ImmutableAttributes imAttrs = subsystemFeatureDefinitionImpl.getImmutableAttributes();
                    FeatureDefinitionUtils.ProvisioningDetails provDetails = subsystemFeatureDefinitionImpl.getProvisioningDetails();
                    if (imAttrs != null && provDetails != null) {
                        FeatureDefinitionUtils.writeAttributes(imAttrs, provDetails, writer);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Unable to write out " + subsystemFeatureDefinitionImpl.getFeatureName() + " to cache because the provisioning detail: " + provDetails + " or imAttrs: " + imAttrs + " is null"), (Object[])new Object[0]);
                }
                writer.write("@=");
                writer.write(FeatureRepository.toFeatureNameList(this.installedFeatures));
                writer.write("\r\n");
                writer.write("-@");
                writer.write(FeatureRepository.toFeatureNameList(this.configuredFeatures));
                writer.write("\r\n");
                writer.write("-#");
                writer.write(this.configurationError ? 49 : 48);
                writer.write("\r\n");
                for (Map.Entry entry : this.knownBadFeatures.entrySet()) {
                    writer.write("XX");
                    this.writeBadManifestEntry(writer, (File)entry.getKey(), (BadFeature)entry.getValue());
                    writer.write("\r\n");
                }
                writer.flush();
                writer.close();
                this.isDirty = false;
            }
            catch (IOException writer) {
                void e;
                FFDCFilter.processException((Throwable)writer, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"301", (Object)this, (Object[])new Object[0]);
                this.cacheWarning((IOException)e);
            }
            finally {
                FeatureDefinitionUtils.tryToClose(out);
            }
        }
    }

    private void updateBadManifestCache(String line) {
        String[] parts = FeatureDefinitionUtils.splitPattern.split(line);
        if (parts.length == 3) {
            File f = new File(parts[0]);
            long lastModified = FeatureDefinitionUtils.getLongValue(parts[1], -1L);
            long length = FeatureDefinitionUtils.getLongValue(parts[2], -1L);
            if (f.isFile()) {
                this.knownBadFeatures.put(f, new BadFeature(lastModified, length));
            }
        }
    }

    private void writeBadManifestEntry(PrintWriter writer, File f, BadFeature bf) {
        writer.write(f.getAbsolutePath());
        writer.write(";");
        writer.write(String.valueOf(bf.lastModified));
        writer.write(";");
        writer.write(String.valueOf(bf.length));
    }

    private Set<String> readFeatureNameList(String line) {
        String[] parts = FeatureDefinitionUtils.installedFeatureSplitPattern.split(line);
        return parts.length > 0 ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(parts))) : Collections.emptySet();
    }

    private void readFeatureManifests() {
        for (final BundleRepositoryRegistry.BundleRepositoryHolder holder : BundleRepositoryRegistry.holders()) {
            File libFeatureDir = new File(holder.getInstallDir(), "lib/features/");
            if (!libFeatureDir.isDirectory()) continue;
            libFeatureDir.listFiles(new FileFilter(){
                static final long serialVersionUID = 8518982116570981387L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean accept(File file) {
                    if (file == null || !file.isFile()) {
                        return false;
                    }
                    String name = file.getName();
                    int pos = name.lastIndexOf(46);
                    if (pos < 0) {
                        return false;
                    }
                    if (name.regionMatches(true, pos, ".mf", 0, 3)) {
                        BadFeature bad = (BadFeature)FeatureRepository.this.knownBadFeatures.get(file);
                        if (FeatureRepository.this.isFeatureStillBad(file, bad)) {
                            return false;
                        }
                        SubsystemFeatureDefinitionImpl def = (SubsystemFeatureDefinitionImpl)FeatureRepository.this.knownFeatures.get(file);
                        if (FeatureRepository.this.isCachedEntryValid(file, def)) {
                            return false;
                        }
                        FeatureRepository.this.isDirty = true;
                        try {
                            FeatureDefinitionUtils.ProvisioningDetails details = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
                            FeatureDefinitionUtils.ImmutableAttributes attr = FeatureDefinitionUtils.loadAttributes(holder.getFeatureType(), file, details);
                            if (!attr.isSupportedFeatureVersion()) {
                                FeatureRepository.this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                                return false;
                            }
                            def = new SubsystemFeatureDefinitionImpl(attr, details);
                            FeatureRepository.this.updateMaps(def);
                        }
                        catch (IOException details) {
                            FFDCFilter.processException((Throwable)details, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$1", (String)"425", (Object)this, (Object[])new Object[]{file});
                            if (tc.isDebugEnabled()) {
                                void e;
                                Tr.debug((TraceComponent)tc, (String)"An exception occurred while reading the feature manifest", (Object[])new Object[]{e.toString()});
                            }
                            FeatureRepository.this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                        }
                    }
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
    }

    private boolean isFeatureStillBad(File f, BadFeature bf) {
        return bf != null && f.lastModified() == bf.lastModified && f.length() == bf.length;
    }

    private boolean isCachedEntryValid(File f, SubsystemFeatureDefinitionImpl def) {
        if (def != null) {
            FeatureDefinitionUtils.ImmutableAttributes cachedAttr = def.getImmutableAttributes();
            if (cachedAttr.lastModified == f.lastModified() && cachedAttr.length == f.length()) {
                return true;
            }
            this.cachedFeatures.remove(cachedAttr.symbolicName);
            this.publicFeatureNameToSymbolicName.remove(FeatureRepository.lowerFeature(cachedAttr.featureName));
            if (cachedAttr.isAutoFeature) {
                this.autoFeatures.remove(def);
            }
        }
        return false;
    }

    private void updateMaps(SubsystemFeatureDefinitionImpl def) {
        if (def != null) {
            FeatureDefinitionUtils.ImmutableAttributes cachedAttr = def.getImmutableAttributes();
            SubsystemFeatureDefinitionImpl previousValue = this.cachedFeatures.put(cachedAttr.symbolicName, def);
            if (previousValue != null && !previousValue.equals(def)) {
                this.cachedFeatures.put(cachedAttr.symbolicName, previousValue);
                FeatureManifestException fme = new FeatureManifestException("Duplicate symbolic name: " + cachedAttr.symbolicName + ", " + def.getFeatureDefinitionFile().getAbsolutePath() + " will be ignored. The file " + previousValue.getFeatureDefinitionFile().getAbsolutePath() + " will be used instead.", (String)null);
                FFDCFilter.processException((Throwable)fme, (String)this.getClass().getName(), (String)"updateMaps", (Object)this, (Object[])new Object[]{previousValue, def});
                File file = cachedAttr.featureFile;
                this.knownBadFeatures.put(file, new BadFeature(file.lastModified(), file.length()));
                return;
            }
            this.knownFeatures.put(cachedAttr.featureFile, def);
            if (!cachedAttr.featureName.equals(cachedAttr.symbolicName)) {
                this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(cachedAttr.featureName), cachedAttr.symbolicName);
            }
            if (def.getVisibility() == Visibility.PUBLIC) {
                this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(cachedAttr.symbolicName), cachedAttr.symbolicName);
            }
            if (cachedAttr.isAutoFeature) {
                this.autoFeatures.add(def);
            }
        }
    }

    private void cacheWarning(IOException ioe) {
        if (this.cacheOk) {
            this.cacheOk = false;
            Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheRes.toExternalURI(), ioe.toString()});
        }
    }

    public void setInstalledFeatures(Set<String> newInstalledFeatures, Set<String> newConfiguredFeatures, boolean configurationError) {
        Set<String> current = this.installedFeatures;
        if (!current.equals(newInstalledFeatures)) {
            this.isDirty = true;
        }
        this.installedFeatures = newInstalledFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newInstalledFeatures));
        current = this.configuredFeatures;
        if (!current.equals(newConfiguredFeatures)) {
            this.isDirty = true;
        }
        this.configuredFeatures = newConfiguredFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newConfiguredFeatures));
        this.configurationError = configurationError;
    }

    public Set<String> getInstalledFeatures() {
        return this.installedFeatures;
    }

    public Set<String> getConfiguredFeatures() {
        return this.configuredFeatures;
    }

    public boolean hasConfigurationError() {
        return this.configurationError;
    }

    public void copyInstalledFeaturesTo(Set<String> features) {
        features.addAll(this.installedFeatures);
    }

    public boolean emptyFeatures() {
        return this.installedFeatures.isEmpty();
    }

    public boolean featureSetEquals(Set<String> newFeatureSet) {
        if (newFeatureSet == null) {
            return false;
        }
        return !this.isDirty && newFeatureSet.equals(this.installedFeatures);
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        if (this.autoFeatures == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.asProvisioningFeatureDefinitionCollection(Collections.unmodifiableCollection(this.autoFeatures));
    }

    private Collection<ProvisioningFeatureDefinition> asProvisioningFeatureDefinitionCollection(Collection<? extends ProvisioningFeatureDefinition> collection) {
        return collection;
    }

    @Trivial
    private static String toFeatureNameList(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String entry : collection) {
            builder.append(entry);
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public ProvisioningFeatureDefinition getFeature(String featureName) {
        SubsystemFeatureDefinitionImpl result = this.cachedFeatures.get(featureName);
        if (result == null) {
            String name = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            result = this.cachedFeatures.get(name);
        }
        return result;
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        if (this.bundleContext == null) {
            return Collections.emptyList();
        }
        String tolerates = this.bundleContext.getProperty(TOLERATE_PREFIX + baseSymbolicName);
        if (tolerates == null) {
            return Collections.emptyList();
        }
        String[] parts = tolerates.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String p : parts) {
            if ("".equals(p.trim())) continue;
            result.add(p.trim());
        }
        return result;
    }

    @Trivial
    public static String lowerFeature(String inFeature) {
        if (inFeature == null || inFeature.isEmpty()) {
            return inFeature;
        }
        int colonIndex = inFeature.indexOf(":");
        if (colonIndex > -1 && inFeature.length() > colonIndex) {
            return inFeature.substring(0, colonIndex).trim() + ':' + inFeature.substring(colonIndex + 1).trim().toLowerCase(Locale.ENGLISH);
        }
        return inFeature.toLowerCase(Locale.ENGLISH).trim();
    }

    public void updateServices() {
        if (this.bundleContext == null) {
            return;
        }
        HashSet<String> installedSymbolicNames = new HashSet<String>();
        for (String featureName : this.installedFeatures) {
            String symbolicName = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            if (symbolicName == null) continue;
            installedSymbolicNames.add(symbolicName);
        }
        HashSet removedFactories = new HashSet(this.featureServiceFactories.keySet());
        removedFactories.removeAll(installedSymbolicNames);
        for (String currentFactorySymbolicName : removedFactories) {
            LibertyFeatureServiceFactory factory = (LibertyFeatureServiceFactory)this.featureServiceFactories.remove(currentFactorySymbolicName);
            if (factory == null) continue;
            factory.unregisterService();
        }
        for (String currentFactorySymbolicName : installedSymbolicNames) {
            SubsystemFeatureDefinitionImpl featureDef = this.cachedFeatures.get(currentFactorySymbolicName);
            if (featureDef == null) continue;
            LibertyFeatureServiceFactory factory = new LibertyFeatureServiceFactory();
            LibertyFeatureServiceFactory previous = this.featureServiceFactories.putIfAbsent(currentFactorySymbolicName, factory);
            factory = previous != null ? previous : factory;
            factory.update(featureDef, this.bundleContext);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void removeInstalledFeature(String feature) {
        this.configurationError = true;
        HashSet<String> newInstalledFeatures = new HashSet<String>(this.installedFeatures);
        if (newInstalledFeatures.remove(feature)) {
            this.installedFeatures = newInstalledFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(newInstalledFeatures);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class LibertyFeatureServiceFactory
    implements ServiceFactory<LibertyFeature> {
        private final Hashtable<String, Object> serviceProps = new Hashtable();
        private ServiceRegistration<LibertyFeature> registration;
        private volatile SubsystemFeatureDefinitionImpl _featureDef;
        static final long serialVersionUID = -2842376468316705229L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LibertyFeatureServiceFactory() {
        }

        /*
         * WARNING - void declaration
         */
        public LibertyFeature getService(Bundle bundle, ServiceRegistration<LibertyFeature> registration) {
            FeatureDefinitionUtils.ProvisioningDetails details;
            SubsystemFeatureDefinitionImpl current;
            block3: {
                current = this._featureDef;
                details = current.getProvisioningDetails();
                if (details == null) {
                    try {
                        details = new FeatureDefinitionUtils.ProvisioningDetails(current.getImmutableAttributes().featureFile, null);
                    }
                    catch (IOException iOException) {
                        void e;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$LibertyFeatureServiceFactory", (String)"748", (Object)this, (Object[])new Object[]{bundle, registration});
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug((TraceComponent)tc, (String)"An exception occurred while reading the feature manifest", (Object[])new Object[]{e.toString()});
                    }
                }
            }
            current.setProvisioningDetails(details);
            return current;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<LibertyFeature> registration, LibertyFeature service) {
            this._featureDef.setProvisioningDetails(null);
        }

        void registerService(BundleContext bundleContext) {
            this.registration = bundleContext.registerService(LibertyFeature.class, (ServiceFactory)this, this.serviceProps);
        }

        void unregisterService() {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        void update(SubsystemFeatureDefinitionImpl featureDef, BundleContext bundleContext) {
            if (featureDef == this._featureDef) {
                return;
            }
            if (this.registration != null) {
                this.registration.unregister();
            }
            this._featureDef = featureDef;
            this.getServiceProps();
            this.registerService(bundleContext);
        }

        private void getServiceProps() {
            this.serviceProps.clear();
            this.serviceProps.put(FEATURE_SERVICE_NAME, this._featureDef.getFeatureName());
            this.serviceProps.put(FEATURE_SERVICE_SYMBOLIC_NAME, this._featureDef.getSymbolicName());
            this.serviceProps.put(FEATURE_SERVICE_VERSION, this._featureDef.getVersion());
            String category = this._featureDef.getHeader("Subsystem-Category");
            if (category != null) {
                this.serviceProps.put(FEATURE_SERVICE_CATEGORY, category.split("\\s*,\\s*"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LibertyFeatureServiceFactory.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class BadFeature {
        final long lastModified;
        final long length;
        static final long serialVersionUID = -4822730322691946046L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BadFeature(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BadFeature.class);
        }
    }
}

