/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.jwtsso.config.JwtSsoConfig;
import com.ibm.ws.security.jwtsso.utils.ConfigUtils;
import com.ibm.ws.security.jwtsso.utils.IssuerUtil;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JwtSsoConfig.class, MicroProfileJwtConfig.class, JwtConsumerConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.jwtsso"}, name="jwtSsoConfig", property={"service.vendor=IBM"})
public class JwtSsoComponent
implements JwtSsoConfig {
    private static final TraceComponent tc = Tr.register(JwtSsoComponent.class);
    private DynamicMBean httpsendpointInfoMBean;
    private DynamicMBean httpendpointInfoMBean;
    private ServerInfoMBean serverInfoMBean;
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    private final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    private boolean setCookiePathToWebAppContextPath;
    private boolean includeLtpaCookie;
    private boolean fallbackToLtpa;
    private boolean cookieSecureFlag;
    private String mpjwtConsumerRef;
    private String cookieName;
    private WebAppSecurityConfig webAppSecConfig;
    protected static final String KEY_UNIQUE_ID = "id";
    protected String uniqueId = null;
    private String signatureAlgorithm;
    ConsumerUtils consumerUtils = null;
    private IssuerUtil issuerUtil;
    static final long serialVersionUID = 1953177606215004894L;

    @Override
    public boolean isHttpOnlyCookies() {
        return WebConfigUtils.getWebAppSecurityConfig().getHttpOnlyCookies();
    }

    @Override
    public boolean isSsoUseDomainFromURL() {
        return WebConfigUtils.getWebAppSecurityConfig().getSSOUseDomainFromURL();
    }

    @Override
    public List<String> getSsoDomainNames() {
        return WebConfigUtils.getWebAppSecurityConfig().getSSODomainList();
    }

    @Override
    public boolean isSetCookiePathToWebAppContextPath() {
        return this.setCookiePathToWebAppContextPath;
    }

    @Override
    public boolean isIncludeLtpaCookie() {
        return this.includeLtpaCookie;
    }

    @Override
    public boolean isFallbackToLtpa() {
        return this.fallbackToLtpa;
    }

    @Override
    public boolean isCookieSecured() {
        return this.cookieSecureFlag;
    }

    @Override
    public String getJwtConsumerRef() {
        return this.mpjwtConsumerRef;
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpendpointInfoMBean == endpointInfoMBean) {
            this.httpendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.httpsendpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetHttpsEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.httpsendpointInfoMBean == endpointInfoMBean) {
            this.httpsendpointInfoMBean = null;
        }
    }

    @Reference(target="(jmx.objectname=WebSphere:feature=kernel,name=ServerInfo)", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        this.serverInfoMBean = serverInfoMBean;
    }

    protected void unsetServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        if (this.serverInfoMBean == serverInfoMBean) {
            this.serverInfoMBean = null;
        }
    }

    @Reference(service=KeyStoreService.class, name="keyStoreService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    @Reference(service=SSLSupport.class, name="sslSupport", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    @Activate
    protected void activate(Map<String, Object> properties, ComponentContext cc) {
        this.uniqueId = (String)properties.get(KEY_UNIQUE_ID);
        this.process(properties);
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        JwtUtils.setKeyStoreService(this.keyStoreServiceRef);
        JwtUtils.setSSLSupportService(this.sslSupportRef);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
        this.process(properties);
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        this.keyStoreServiceRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        JwtUtils.setKeyStoreService(null);
        JwtUtils.setSSLSupportService(null);
    }

    @ManualTrace
    private void process(Map<String, Object> props) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"process", (Object[])new Object[]{props});
        }
        if (props == null || props.isEmpty()) {
            return;
        }
        this.setCookiePathToWebAppContextPath = (Boolean)props.get("setCookiePathToWebAppContextRoot");
        this.includeLtpaCookie = (Boolean)props.get("includeLtpaCookie");
        this.fallbackToLtpa = (Boolean)props.get("useLtpaIfJwtAbsent");
        this.cookieSecureFlag = (Boolean)props.get("setCookieSecureFlag");
        this.mpjwtConsumerRef = JwtUtils.trimIt((String)((String)props.get("mpjwtConsumerRef")));
        this.cookieName = JwtUtils.trimIt((String)((String)props.get("cookieName")));
        this.cookieName = new ConfigUtils().validateCookieName(this.cookieName, true);
        if (this.mpjwtConsumerRef == null) {
            this.setJwtSsoConsumerDefaults();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"process");
        }
    }

    private void setJwtSsoConsumerDefaults() {
        this.mpjwtConsumerRef = this.getId();
        this.signatureAlgorithm = "RS256";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"consumer id = ", (Object[])new Object[]{this.mpjwtConsumerRef});
        }
        this.issuerUtil = new IssuerUtil();
    }

    public String getId() {
        return this.getUniqueId();
    }

    public List<String> getAudiences() {
        return null;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getSharedKey() {
        return null;
    }

    public String getTrustStoreRef() {
        return null;
    }

    public String getTrustedAlias() {
        return null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getUserNameAttribute() {
        return "upn";
    }

    public String getGroupNameAttribute() {
        return "groups";
    }

    public boolean ignoreApplicationAuthMethod() {
        return true;
    }

    public boolean getMapToUserRegistry() {
        return false;
    }

    public String getIssuer() {
        return this.issuerUtil.getResolvedHostAndPortUrl(this.httpsendpointInfoMBean, this.httpendpointInfoMBean, this.serverInfoMBean, this.uniqueId);
    }

    public long getClockSkew() {
        return 300000L;
    }

    public boolean getJwkEnabled() {
        return false;
    }

    public String getJwkEndpointUrl() {
        return null;
    }

    public ConsumerUtils getConsumerUtils() {
        if (this.consumerUtils == null) {
            this.consumerUtils = new ConsumerUtils(this.keyStoreServiceRef);
        }
        return this.consumerUtils;
    }

    public boolean isValidationRequired() {
        return true;
    }

    public boolean isHostNameVerificationEnabled() {
        return false;
    }

    public String getSslRef() {
        return null;
    }

    public JWKSet getJwkSet() {
        return null;
    }

    public boolean getTokenReuse() {
        return true;
    }

    @Override
    public String getCookieName() {
        return this.cookieName;
    }

    public String getAuthFilterRef() {
        return null;
    }
}

