/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.eclipselink.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jpa.container.eclipselink.logging.LogChannel;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.server.ServerLog;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EclipseLinkLogger
extends ServerLog {
    private static final String ECLIPSELINK_STRING = "eclipselink";
    private static final String EMPTY_CHANNEL = "eclipselink";
    private static final LogChannel EMPTY_LOG_CHANNEL = new LogChannel("eclipselink");
    private static final TraceComponent _tc = Tr.register(EclipseLinkLogger.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static final Map<String, LogChannel> _channels = new HashMap<String, LogChannel>();
    static final long serialVersionUID = 8804346880908496506L;

    @Trivial
    public void log(SessionLogEntry entry) {
        String category = entry.getNameSpace();
        int level = entry.getLevel();
        LogChannel channel = this.getLogChannel(category);
        if (channel.shouldLog(level)) {
            channel.log(entry, this.formatMessage(entry));
        }
    }

    @Trivial
    public boolean shouldLog(int level, String category) {
        return this.getLogChannel(category).shouldLog(level);
    }

    @Trivial
    private LogChannel getLogChannel(String category) {
        if (category == null) {
            return EMPTY_LOG_CHANNEL;
        }
        LogChannel channel = _channels.get(category);
        if (channel == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Found an unmapped logging channel (" + category + ") in log(...). Possibly something wrong in EclipseLink, remapping to base channel."), (Object[])new Object[0]);
            }
            channel = EMPTY_LOG_CHANNEL;
        }
        return channel;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        for (String category : SessionLog.loggerCatagories) {
            _channels.put(category, new LogChannel("eclipselink." + category));
        }
        _channels.put("eclipselink", EMPTY_LOG_CHANNEL);
    }
}

