/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.container;

import com.ibm.ws.app.manager.springboot.container.SpringBootConfig;
import java.io.File;
import java.security.AccessController;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;

public interface SpringBootConfigFactory {
    public SpringBootConfig createSpringBootConfig();

    public void addShutdownHook(Runnable var1);

    public void removeShutdownHook(Runnable var1);

    public void rootContextClosed();

    public File getServerDir();

    public static SpringBootConfigFactory findFactory(Object token) {
        ClassLoader cl;
        for (cl = AccessController.doPrivileged(() -> token.getClass().getClassLoader()); cl != null && !(cl instanceof BundleReference); cl = cl.getParent()) {
        }
        if (cl == null) {
            throw new IllegalStateException("Did not find a BundleReference class loader.");
        }
        Bundle b = ((BundleReference)cl).getBundle();
        SpringBootConfigFactory result = AccessController.doPrivileged(() -> {
            ServiceReference[] services = b.getRegisteredServices();
            if (services != null) {
                for (ServiceReference service : services) {
                    String[] objectClass;
                    for (String name : objectClass = (String[])service.getProperty("objectClass")) {
                        if (!SpringBootConfigFactory.class.getName().equals(name)) continue;
                        BundleContext context = b.getBundleContext();
                        try {
                            SpringBootConfigFactory springBootConfigFactory = (SpringBootConfigFactory)context.getService(service);
                            return springBootConfigFactory;
                        }
                        finally {
                            context.ungetService(service);
                        }
                    }
                }
            }
            return null;
        });
        if (result == null) {
            throw new IllegalStateException("No SpringBootConfigFactory service found for: " + b);
        }
        return result;
    }
}

