/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.springboot.util.SpringBootManifest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpringBootThinUtil {
    private final JarFile sourceFatJar;
    private final File targetThinJar;
    private final File libIndexCache;
    private final File libIndexCacheParent;
    private final String springBootLibPath;
    private final String springBootLibProvidedPath;
    private final List<String> libEntries = new ArrayList<String>();
    private final StarterFilter starterFilter;
    public static final String SPRING_LIB_INDEX_FILE = "META-INF/spring.lib.index";
    private static final String SPRING_BOOT_LOADER_CLASSPATH = "org/springframework/boot/loader/";
    private static String THE_UNKNOWN_STARTER;
    private static final Set<String> emptySet;
    static final long serialVersionUID = 8478551642048300184L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SpringBootThinUtil(File sourceFatJar, File targetThinJar, File libIndexCache) throws IOException {
        this(sourceFatJar, targetThinJar, libIndexCache, null);
    }

    public SpringBootThinUtil(File sourceFatJar, File targetThinJar, File libIndexCache, File libIndexCacheParent) throws IOException {
        this.sourceFatJar = new JarFile(sourceFatJar);
        this.targetThinJar = targetThinJar;
        this.libIndexCache = libIndexCache;
        this.libIndexCacheParent = libIndexCacheParent;
        SpringBootManifest sbmf = new SpringBootManifest(this.sourceFatJar.getManifest());
        String springBootLibPath = sbmf.getSpringBootLib();
        if (!springBootLibPath.endsWith("/")) {
            springBootLibPath = springBootLibPath + "/";
        }
        this.springBootLibPath = springBootLibPath;
        String springBootLibProvidedPath = sbmf.getSpringBootLibProvided();
        if (springBootLibProvidedPath != null && !springBootLibProvidedPath.endsWith("/")) {
            springBootLibProvidedPath = springBootLibProvidedPath + "/";
        }
        this.springBootLibProvidedPath = springBootLibProvidedPath;
        this.starterFilter = SpringBootThinUtil.getStarterFilter(this.sourceFatJar);
    }

    public void execute() throws IOException, NoSuchAlgorithmException {
        this.thin();
    }

    private void thin() throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        JarOutputStream thinJar = new JarOutputStream((OutputStream)new FileOutputStream(this.targetThinJar), this.sourceFatJar.getManifest());
        Throwable throwable = null;
        try {
            HashSet<String> entryNames = new HashSet<String>();
            Enumeration<JarEntry> entries = this.sourceFatJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entryNames.add(entry.getName()) || "META-INF/MANIFEST.MF".equals(entry.getName()) || entry.getName().startsWith(SPRING_BOOT_LOADER_CLASSPATH)) continue;
                this.storeEntry(thinJar, entry);
            }
            this.addLibIndexFileToThinJar(thinJar);
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"86", (Object)this, (Object[])new Object[0]);
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (thinJar != null) {
                if (throwable != null) {
                    try {
                        thinJar.close();
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"97", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    thinJar.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeEntry(JarOutputStream thinJar, JarEntry entry) throws IOException, NoSuchAlgorithmException {
        InputStream is;
        block11: {
            String path = entry.getName();
            boolean isLibPath = this.isFromLibPath(path);
            boolean isLibProvidedPath = this.isFromLibProvidedPath(path);
            if (isLibPath || isLibProvidedPath) {
                if (this.starterFilter.apply(entry.getName()) != false) return;
                if (isLibProvidedPath) {
                    if (!this.includeLibProvidedPaths()) return;
                }
                String hash = this.hash(this.sourceFatJar, entry);
                String hashPrefix = hash.substring(0, 2);
                String hashSuffix = hash.substring(2, hash.length());
                this.storeLibraryInDir(entry, hashPrefix, hashSuffix);
                String libLine = "/" + path + '=' + hash;
                this.libEntries.add(libLine);
                return;
            }
            is = this.sourceFatJar.getInputStream(entry);
            Throwable throwable = null;
            try {
                this.writeEntry(is, thinJar, path);
                if (is == null) return;
                if (throwable == null) break block11;
            }
            catch (Throwable throwable3) {
                try {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"117", (Object)this, (Object[])new Object[]{thinJar, entry});
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (is == null) throw throwable4;
                    if (throwable == null) {
                        is.close();
                        throw throwable4;
                    }
                    try {
                        is.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        FFDCFilter.processException((Throwable)throwable5, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"119", (Object)this, (Object[])new Object[]{thinJar, entry});
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                is.close();
                return;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"119", (Object)this, (Object[])new Object[]{thinJar, entry});
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        is.close();
    }

    private boolean includeLibProvidedPaths() {
        return false;
    }

    boolean isFromLibPath(String entryName) {
        return entryName.startsWith(this.springBootLibPath) && !entryName.endsWith("/");
    }

    boolean isFromLibProvidedPath(String entryName) {
        if (this.springBootLibProvidedPath != null) {
            return entryName.startsWith(this.springBootLibProvidedPath) && !entryName.endsWith("/");
        }
        return false;
    }

    protected String hash(JarFile jf, ZipEntry entry) throws IOException, NoSuchAlgorithmException {
        InputStream eis = jf.getInputStream(entry);
        MessageDigest digest = MessageDigest.getInstance("sha-256");
        byte[] buffer = new byte[4096];
        int read = -1;
        while ((read = eis.read(buffer)) != -1) {
            digest.update(buffer, 0, read);
        }
        byte[] digested = digest.digest();
        return SpringBootThinUtil.convertToHexString(digested);
    }

    private static String convertToHexString(byte[] digested) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < digested.length; ++i) {
            stringBuffer.append(Integer.toString((digested[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeLibraryInDir(JarEntry entry, String hashPrefix, String hashSuffix) throws IOException, NoSuchAlgorithmException {
        File libDir;
        File libFile;
        File libDirParent;
        File libFileParent;
        String hashPath = hashPrefix + '/' + hashSuffix;
        String libName = entry.getName();
        int lastSlash = libName.lastIndexOf(47);
        if (lastSlash >= 0) {
            libName = libName.substring(lastSlash + 1);
        }
        if (this.libIndexCacheParent != null && (libFileParent = new File(libDirParent = new File(this.libIndexCacheParent, hashPath), libName)).exists()) {
            return;
        }
        if (!this.libIndexCache.exists()) {
            this.libIndexCache.mkdirs();
        }
        if ((libFile = new File(libDir = new File(this.libIndexCache, hashPath), libName)).exists()) return;
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        try (InputStream is = this.sourceFatJar.getInputStream(entry);){
            FileOutputStream libJar;
            block16: {
                libJar = new FileOutputStream(libFile);
                Throwable throwable = null;
                try {
                    this.copyStream(is, libJar);
                    if (libJar == null) return;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"190", (Object)this, (Object[])new Object[]{entry, hashPrefix, hashSuffix});
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (libJar == null) throw throwable4;
                        if (throwable != null) {
                            try {
                                ((OutputStream)libJar).close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                FFDCFilter.processException((Throwable)throwable5, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"192", (Object)this, (Object[])new Object[]{entry, hashPrefix, hashSuffix});
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                        ((OutputStream)libJar).close();
                        throw throwable4;
                    }
                }
                try {
                    ((OutputStream)libJar).close();
                    return;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"192", (Object)this, (Object[])new Object[]{entry, hashPrefix, hashSuffix});
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            ((OutputStream)libJar).close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntry(InputStream is, ZipOutputStream zos, String entryName) throws IOException {
        try {
            zos.putNextEntry(new ZipEntry(entryName));
            this.copyStream(is, zos);
        }
        finally {
            zos.closeEntry();
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int read = -1;
        while ((read = is.read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibIndexFileToThinJar(JarOutputStream thinJar) throws IOException {
        thinJar.putNextEntry(new ZipEntry(SPRING_LIB_INDEX_FILE));
        try {
            for (String libEntry : this.libEntries) {
                thinJar.write(libEntry.getBytes(StandardCharsets.UTF_8));
                thinJar.write(10);
            }
        }
        finally {
            thinJar.closeEntry();
        }
    }

    public static StarterFilter getStarterFilter(JarFile jarFile) {
        return SpringBootThinUtil.getStarterFilter(SpringBootThinUtil.stringStream(jarFile));
    }

    public static Stream<String> stringStream(JarFile jarFile) {
        Stream<String> stream = StreamSupport.stream(jarFile.stream().spliterator(), false).map(entry -> entry.getName());
        return stream;
    }

    public static StarterFilter getStarterFilter(Stream<String> entries) {
        AtomicReference starterRef = new AtomicReference();
        entries.forEach(entry -> {
            if (starterRef.get() == null) {
                String path = entry;
                for (String starterJarNamePrefix : EmbeddedContainer.getSupportedStarters()) {
                    if (!path.contains(starterJarNamePrefix)) continue;
                    starterRef.set(starterJarNamePrefix);
                    break;
                }
            }
        });
        String springBootStarter = starterRef.get() != null ? (String)starterRef.get() : THE_UNKNOWN_STARTER;
        Set<String> starterArtifactIds = EmbeddedContainer.getStarterArtifactIds(springBootStarter);
        return new StarterFilter(springBootStarter, starterArtifactIds);
    }

    public static String getArtifactId(String jarName) {
        int idxEndAid;
        int idxBegAid = jarName.lastIndexOf(47) + 1;
        return idxBegAid <= (idxEndAid = jarName.lastIndexOf(45) - 1) && jarName.endsWith(".jar") ? jarName.substring(idxBegAid, idxEndAid + 1).toLowerCase() : "";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SpringBootThinUtil.class);
        THE_UNKNOWN_STARTER = "";
        emptySet = new HashSet<String>(0);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class EmbeddedContainer {
        private static final List<String> mvnSpringBoot15TomcatStarterDeps;
        private static final List<String> mvnSpringBoot20TomcatStarterDeps;
        private static final List<String> mvnSpringBoot15JettyStarterDeps;
        private static final List<String> mvnSpringBoot20JettyStarterDeps;
        private static final List<String> mvnSpringBoot15UndertowStarterDeps;
        private static final List<String> mvnSpringBoot20UndertowStarterDeps;
        private static final List<String> mvnSpringBoot20NettyStarterDeps;
        public static final String TOMCAT = "tomcat";
        public static final String JETTY = "jetty";
        public static final String UNDERTOW = "undertow";
        public static final String LIBERTY = "liberty";
        public static final String NETTY = "netty";
        public static final String SPRING_BOOT_STARTER = "spring-boot-starter";
        public static final String SPRING_BOOT_STARTER_REACTOR = "spring-boot-starter-reactor";
        private static final Map<String, Set<String>> startersToDependentArtifactIdsMap;
        static final long serialVersionUID = 594196147850258047L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EmbeddedContainer() {
        }

        public static Set<String> getSupportedStarters() {
            return EmbeddedContainer.getStartersToDependentArtifactIdsMap().keySet();
        }

        public static Set<String> getStarterArtifactIds(String starter) {
            Set starterArtifactIds = EmbeddedContainer.getStartersToDependentArtifactIdsMap().getOrDefault(starter, null);
            if (null == starterArtifactIds) {
                return emptySet;
            }
            return starterArtifactIds;
        }

        public static Map<String, Set<String>> getStartersToDependentArtifactIdsMap() {
            return startersToDependentArtifactIdsMap;
        }

        private static String starterJarNamePrefix(String embeddedContainer, String versionInfo) {
            if (NETTY.equals(embeddedContainer)) {
                return "spring-boot-starter-reactor-" + embeddedContainer + "-" + versionInfo;
            }
            return "spring-boot-starter-" + embeddedContainer + "-" + versionInfo;
        }

        public static Set<String> loadStarterMvnDeps(List<String> mvnStarterDeps) {
            HashSet starterArtifactIds = new HashSet();
            mvnStarterDeps.forEach(mvnDep -> starterArtifactIds.add(mvnDep.split(":")[1].toLowerCase()));
            return Collections.unmodifiableSet(starterArtifactIds);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EmbeddedContainer.class);
            mvnSpringBoot15TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:1.5.10.RELEASE:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:8.5.27:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:8.5.27:compile", "org.apache.tomcat:tomcat-annotations-api:jar:8.5.27:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:8.5.27:compile");
            mvnSpringBoot20TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.0.1.RELEASE:compile", "javax.annotation:javax.annotation-api:jar:1.3.2:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:8.5.29:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:8.5.29:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:8.5.29:compile");
            mvnSpringBoot15JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:1.5.10.RELEASE:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm-tree:jar:6.0:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-server:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-io:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-security:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.8.v20171121:compile", "javax.annotation:javax.annotation-api:jar:1.2:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-util:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm-commons:jar:6.0:compile", "javax.servlet:javax.servlet-api:jar:3.1.0:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-client:jar:9.4.8.v20171121:compile", "javax.websocket:javax.websocket-api:jar:1.0:compile", "org.mortbay.jasper:apache-el:jar:8.0.33:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-http:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm:jar:6.0:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.8.v20171121:compile");
            mvnSpringBoot20JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.0.1.RELEASE:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-http:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-util:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-io:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-security:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-server:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-client:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.9.v20180320:compile", "javax.servlet:javax.servlet-api:jar:3.1.0:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.9.v20180320:compile", "javax.annotation:javax.annotation-api:jar:1.3.2:compile", "org.ow2.asm:asm:jar:6.0:compile", "org.ow2.asm:asm-commons:jar:6.0:compile", "org.ow2.asm:asm-tree:jar:6.0:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.9.v20180320:compile", "javax.websocket:javax.websocket-api:jar:1.0:compile", "org.mortbay.jasper:apache-el:jar:8.5.24.2:compile");
            mvnSpringBoot15UndertowStarterDeps = Arrays.asList("org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.logging:jboss-logging:jar:3.3.1.Final:compile", "javax.servlet:javax.servlet-api:jar:3.1.0:compile", "org.springframework.boot:spring-boot-starter-undertow:jar:1.5.10.RELEASE:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.0.Final:compile", "io.undertow:undertow-websockets-jsr:jar:1.4.22.Final:compile", "org.glassfish:javax.el:jar:3.0.0:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.0.Final:compile", "io.undertow:undertow-core:jar:1.4.22.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:1.4.22.Final:compile");
            mvnSpringBoot20UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.0.1.RELEASE:compile", "io.undertow:undertow-core:jar:1.4.23.Final:compile", "org.jboss.logging:jboss-logging:jar:3.3.2.Final:compile", "org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:1.4.23.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.2.Final:compile", "io.undertow:undertow-websockets-jsr:jar:1.4.23.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.3.Final:compile", "javax.servlet:javax.servlet-api:jar:3.1.0:compile", "org.glassfish:javax.el:jar:3.0.0:compile");
            mvnSpringBoot20NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.0.1.RELEASE:compile");
            HashMap<String, Set<String>> theMap = new HashMap<String, Set<String>>(6);
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20NettyStarterDeps));
            startersToDependentArtifactIdsMap = Collections.unmodifiableMap(theMap);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class StarterFilter
    implements Function<String, Boolean> {
        final String starterName;
        final Set<String> starterArtifactIds;
        static final long serialVersionUID = -7572164932402214778L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StarterFilter(String starterName, Set<String> starterArtifactIds) {
            this.starterName = starterName;
            this.starterArtifactIds = starterArtifactIds;
        }

        @Override
        public Boolean apply(String jarName) {
            return this.starterArtifactIds.contains(SpringBootThinUtil.getArtifactId(jarName));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StarterFilter.class);
        }
    }
}

