/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.services.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.HealthCheckCDIBeanInvoker;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HealthCheckCDIBeanInvoker.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheckCDIBeanInvokerImpl
implements HealthCheckCDIBeanInvoker {
    private static final com.ibm.ejs.ras.TraceComponent tc = Tr.register(HealthCheckCDIBeanInvokerImpl.class);
    static final long serialVersionUID = -6904456700224442077L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public HealthCheckCDIBeanInvokerImpl() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<HealthCheckResponse> checkAllBeans() throws HealthCheckBeanCallException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", (Object)new Object[0]);
        }
        HashSet<HealthCheckResponse> retVal = new HashSet<HealthCheckResponse>();
        for (Object obj : this.getHealthCheckBeans()) {
            HealthCheck tempHCBean = (HealthCheck)obj;
            try {
                retVal.add(tempHCBean.call());
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.health.services.impl.HealthCheckCDIBeanInvokerImpl", (String)"58", (Object)this, (Object[])new Object[0]);
                HealthCheckBeanCallException hcbce = new HealthCheckBeanCallException((Throwable)e);
                hcbce.setBeanName(obj.getClass().toString());
                throw hcbce;
            }
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("HealthCheck beanClass: " + obj.getClass() + " called"));
        }
        HashSet<HealthCheckResponse> hashSet = retVal;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @FFDCIgnore(value={NameNotFoundException.class})
    private Set<Object> getHealthCheckBeans() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", (Object)new Object[0]);
        }
        BeanManager beanManager = null;
        HashSet<Object> healthCheckBeans = new HashSet<Object>();
        try {
            InitialContext context = new InitialContext();
            beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        }
        catch (NameNotFoundException e) {
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)"Catching NameNotFoundException looking up CDI java:comp/BeanManager.  Ignoring assuming the reason is because there are zero CDI managed beans");
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.health.services.impl.HealthCheckCDIBeanInvokerImpl", (String)"78", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        if (beanManager != null) {
            Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{new AnnotationLiteral<Health>(){
                static final long serialVersionUID = -6930944473618618190L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register(1.class);
                }
            }});
            for (Bean bean : beans) {
                Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Bean Found: HealthCheck beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", name = " + bean.getName()));
                healthCheckBeans.add(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean)));
            }
        }
        HashSet<Object> hashSet = healthCheckBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", hashSet);
        }
        return hashSet;
    }
}

