/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.cm.AbstractConnectionFactoryService;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.Connector;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConnectionFactoryService
extends AbstractConnectionFactoryService
implements ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(ConnectionFactoryService.class);
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final String CONNECTION_MANAGER = "connectionManager";
    private static final String CONFIG_PROPS_PREFIX = "properties.0.";
    private static final int CONFIG_PROPS_PREFIX_LENGTH = "properties.0.".length();
    public static final String FACTORY_PID = "com.ibm.ws.jca.connectionFactory.supertype";
    public static final String CONNECTION_FACTORY = "connectionFactory";
    private static final String REAUTHENTICATION_SUPPORT = "reauthentication-support";
    private static final String TRANSACTION_SUPPORT = "transaction-support";
    private final AtomicServiceReference<BootstrapContextImpl> bootstrapContextRef = new AtomicServiceReference("bootstrapContext");
    private ComponentContext componentContext;
    private String configElementName;
    private ServiceReference<ConnectionManagerService> connectionManagerRef;
    private String id;
    private String jndiName;
    private ManagedConnectionFactory mcf;
    private TransactionSupport.TransactionSupportLevel connectionFactoryTransactionSupport;
    private String mcfImplClassName;
    private boolean qmidenabled = true;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    static final long serialVersionUID = 7689845957975835245L;

    @Trivial
    @ManualTrace
    protected void activate(ComponentContext context) throws Exception {
        String sourcePID;
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.configElementName = (sourcePID = (String)props.get("ibm.extends.source.pid")) == null ? CONNECTION_FACTORY : sourcePID.substring(15, sourcePID.indexOf(95, 15));
        this.mcfImplClassName = (String)props.get("properties.0.managedconnectionfactory-class");
        this.jndiName = (String)props.get("jndiName");
        this.id = (String)props.get("config.displayId");
        this.componentContext = context;
        this.isServerDefined = true;
        if (props.get("transactionSupport") != null) {
            this.connectionFactoryTransactionSupport = TransactionSupport.TransactionSupportLevel.valueOf((String)((String)props.get("transactionSupport")));
        }
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String propName;
            String key = (String)keys.nextElement();
            if (key.length() <= CONFIG_PROPS_PREFIX_LENGTH || key.charAt(CONFIG_PROPS_PREFIX_LENGTH - 1) != '.' || !key.startsWith(CONFIG_PROPS_PREFIX) || (propName = key.substring(CONFIG_PROPS_PREFIX_LENGTH)).indexOf(46) >= 0 || propName.indexOf(45) >= 0) continue;
            this.properties.put(propName, props.get(key));
        }
        this.bootstrapContextRef.activate(context);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext context) {
        this.destroyConnectionFactories(true);
        this.bootstrapContextRef.deactivate(context);
    }

    public final ConnectorService getConnectorService() {
        return ((BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException()).getConnectorService();
    }

    public ApplicationRecycleContext getContext() {
        ApplicationRecycleContext context = (ApplicationRecycleContext)this.bootstrapContextRef.getService();
        if (context != null) {
            return context;
        }
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.appsToRecycle);
        this.appsToRecycle.removeAll(members);
        return members;
    }

    private void destroyConnectionFactories(boolean destroyImmediately) {
        this.lock.writeLock().lock();
        try {
            if (this.isInitialized.get()) {
                this.isInitialized.set(false);
                this.conMgrSvc.deleteObserver((Observer)((Object)this));
                this.conMgrSvc.destroyConnectionFactories();
                this.conMgrSvc = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Trivial
    public String getConfigElementName() {
        return this.configElementName;
    }

    @Trivial
    public String getID() {
        return this.id;
    }

    @Trivial
    public String getJNDIName() {
        return this.jndiName;
    }

    @Trivial
    public ManagedConnectionFactory getManagedConnectionFactory(String identifier) {
        return this.mcf;
    }

    @Trivial
    public boolean getReauthenticationSupport() {
        return Boolean.TRUE.equals(this.bootstrapContextRef.getReference().getProperty(REAUTHENTICATION_SUPPORT));
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchMethodException.class})
    public int[] getThreadIdentitySecurityAndRRSSupport(String identifier) {
        int rrsTransactional = 0;
        try {
            if (Boolean.TRUE.equals(this.mcf.getClass().getMethod("getRRSTransactional", new Class[0]).invoke((Object)this.mcf, new Object[0]))) {
                rrsTransactional = 1;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            void x;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jca.service.ConnectionFactoryService", (String)"330", (Object)((Object)this), (Object[])new Object[]{identifier});
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"327", (Object[])new Object[]{this.mcf.getClass()});
        }
        return new int[]{0, 0, rrsTransactional};
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        TransactionSupport.TransactionSupportLevel transactionSupport = this.mcf instanceof TransactionSupport ? ((TransactionSupport)this.mcf).getTransactionSupport() : null;
        String prop = (String)this.bootstrapContextRef.getReference().getProperty(TRANSACTION_SUPPORT);
        if (prop != null) {
            TransactionSupport.TransactionSupportLevel ddTransactionSupport = TransactionSupport.TransactionSupportLevel.valueOf((String)prop);
            if (transactionSupport == null) {
                transactionSupport = ddTransactionSupport;
            } else if (transactionSupport.ordinal() > ddTransactionSupport.ordinal()) {
                throw new IllegalArgumentException(ManagedConnectionFactory.class.getName() + ':' + transactionSupport + ", " + Connector.class.getName() + ':' + ddTransactionSupport);
            }
        }
        if (this.connectionFactoryTransactionSupport != null) {
            if (this.connectionFactoryTransactionSupport.ordinal() > transactionSupport.ordinal()) {
                throw new IllegalArgumentException(ManagedConnectionFactory.class.getName() + ':' + transactionSupport + ", " + Connector.class.getName() + ':' + this.connectionFactoryTransactionSupport);
            }
            transactionSupport = this.connectionFactoryTransactionSupport;
        }
        return transactionSupport == null ? TransactionSupport.TransactionSupportLevel.NoTransaction : transactionSupport;
    }

    public boolean getValidatingManagedConnectionFactorySupport() {
        return this.mcf instanceof ValidatingManagedConnectionFactory;
    }

    protected void init() throws Exception {
        BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"loading", (Object[])new Object[]{this.mcfImplClassName});
        }
        if (this.mcfImplClassName == null) {
            throw new IllegalArgumentException(Utils.getMessage("J2CA8504.incorrect.props.list", "properties", this.configElementName, this.id));
        }
        this.mcf = (ManagedConnectionFactory)bootstrapContext.loadClass(this.mcfImplClassName).newInstance();
        bootstrapContext.configure(this.mcf, this.jndiName, this.properties, null, null, null);
        this.conMgrSvc = this.connectionManagerRef == null ? ConnectionManagerService.createDefaultService((String)this.jndiName) : (ConnectionManagerService)priv.locateService(this.componentContext, CONNECTION_MANAGER);
        this.conMgrSvc.addObserver((Observer)((Object)this));
        this.isInitialized.set(true);
        this.conMgrSvc.addRaClassLoader(bootstrapContext.getRaClassLoader());
    }

    protected void setBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.setReference(ref);
    }

    protected void setConnectionManager(ServiceReference<ConnectionManagerService> ref) {
        this.connectionManagerRef = ref;
    }

    protected void setSslConfig(ServiceReference<?> ref) {
    }

    protected void unsetBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.unsetReference(ref);
    }

    protected void unsetConnectionManager(ServiceReference<ConnectionManagerService> ref) {
        this.connectionManagerRef = null;
    }

    protected void unsetSslConfig(ServiceReference<?> ref) {
    }

    public void update(Observable observable, Object data) {
        this.destroyConnectionFactories(true);
    }

    protected void checkAccess() throws ResourceException {
        BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
        ResourceAdapterMetaData metadata = bootstrapContext.getResourceAdapterMetaData();
        if (metadata != null && metadata.isEmbedded()) {
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            String currentApp = null;
            if (cData != null) {
                currentApp = cData.getJ2EEName().getApplication();
            }
            String adapterName = bootstrapContext.getResourceAdapterName();
            String embeddedApp = metadata.getJ2EEName().getApplication();
            Utils.checkAccessibility(this.jndiName, adapterName, embeddedApp, currentApp, false);
        }
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    public void setMQQueueManager(Serializable xaresinfo) throws Exception {
        if (this.qmidenabled) {
            Class<?> mcfImplClass = this.mcf.getClass();
            Object recoveryToken = null;
            try {
                Method mcfSetQmid = mcfImplClass.getMethod("setQmid", String.class);
                ArrayList byteList = (ArrayList)xaresinfo;
                byte[] bytes = new byte[byteList.size()];
                int i = 0;
                for (Byte b : byteList) {
                    bytes[i++] = b;
                }
                ResourceRefInfo resRefInfo = (ResourceRefInfo)ConnectorService.deserialize((byte[])bytes);
                Class<?> resRefInfoImplClass = resRefInfo.getClass();
                Method resRefGetQmid = resRefInfoImplClass.getMethod("getQmid", null);
                String qmid = (String)resRefGetQmid.invoke((Object)resRefInfo, (Object[])null);
                if (qmid != null) {
                    mcfSetQmid.invoke((Object)this.mcf, qmid);
                }
            }
            catch (NoSuchMethodException nsme) {
                this.qmidenabled = false;
            }
            catch (InvocationTargetException nsme) {
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ws.jca.service.ConnectionFactoryService", (String)"497", (Object)((Object)this), (Object[])new Object[]{xaresinfo});
                this.qmidenabled = false;
            }
            catch (IllegalAccessException ite) {
                FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ws.jca.service.ConnectionFactoryService", (String)"499", (Object)((Object)this), (Object[])new Object[]{xaresinfo});
                this.qmidenabled = false;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.service.ConnectionFactoryService", (String)"501", (Object)((Object)this), (Object[])new Object[]{xaresinfo});
                this.qmidenabled = false;
            }
        }
    }
}

