/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.internal.osgi.TrLogEntry;
import com.ibm.ws.logging.internal.osgi.TrLogImpl;
import java.util.EventObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class TrLogServiceImpl
implements LogService {
    public static final int LOG_EVENT = -5;
    private static final Object COULD_NOT_OBTAIN_LOCK_EXCEPTION = "Could not obtain lock";
    static boolean publishEvents = false;
    static boolean publishDebugEvents = false;
    protected final TrLogImpl logImpl;
    protected final Bundle bundle;
    protected final String ffdcMe;
    protected final OSGiTraceComponent tc;

    static void updatePublishEventConfig(String eventConfig) {
        if ("INFO".equals(eventConfig)) {
            publishEvents = true;
            publishDebugEvents = false;
        } else if ("ALL".equals(eventConfig)) {
            publishEvents = true;
            publishDebugEvents = true;
        } else {
            publishEvents = false;
            publishDebugEvents = false;
        }
    }

    TrLogServiceImpl(TrLogImpl logImpl, Bundle b) {
        String group;
        this.logImpl = logImpl;
        this.bundle = b;
        String symName = b.getSymbolicName();
        long id = b.getBundleId();
        if (symName != null) {
            this.ffdcMe = symName + "-" + b.getVersion();
        } else {
            symName = "osgi";
            this.ffdcMe = "osgi-bundle-" + id;
        }
        String logName = id + "-" + symName;
        this.tc = symName.startsWith("org.eclipse.equinox.metatype") ? new OSGiTraceComponent(logName, this.getClass(), new String[]{symName}) : ((group = (String)b.getHeaders("").get("WS-TraceGroup")) == null ? new OSGiTraceComponent(logName, this.getClass(), new String[]{symName, "logservice"}) : new OSGiTraceComponent(logName, this.getClass(), new String[]{symName, group, "logservice"}));
        TrConfigurator.registerTraceComponent((TraceComponent)this.tc);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.ffdcMe + "]";
    }

    public void log(int level, String message) {
        this.log(null, level, level, message, null, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log(null, level, level, message, exception, null);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, level, message, null, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        this.log(sr, level, level, message, t, null);
    }

    protected void log(ServiceReference<?> sr, int level, int trLevel, String msg, Throwable t, EventObject event) {
        boolean isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
        TrLogEntry logEntry = new TrLogEntry(this.logImpl, System.currentTimeMillis(), level, msg, this.bundle, sr, t, event);
        try {
            switch (trLevel) {
                default: {
                    if (isAnyTraceEnabled && this.tc.isDebugEnabled()) {
                        Tr.debug((Object)this.bundle, (TraceComponent)this.tc, (String)logEntry.getMessage(), (Object[])logEntry.getObjects(false));
                    }
                    break;
                }
                case 3: {
                    if (this.tc.isInfoEnabled()) {
                        Tr.info((TraceComponent)this.tc, (String)"OSGI_MSG001", (Object[])logEntry.getObjects(true));
                    }
                    break;
                }
                case 2: {
                    Tr.warning((TraceComponent)this.tc, (String)"OSGI_WARNING_MSG", (Object[])logEntry.getObjects(true));
                    break;
                }
                case 1: {
                    if (t instanceof BundleException && t.getMessage() != null && t.getCause() == null) {
                        Tr.error((TraceComponent)this.tc, (String)"OSGI_BUNDLE_EXCEPTION", (Object[])new Object[]{t.getMessage()});
                        break;
                    }
                    if (this.shouldBeLogged(t, logEntry)) {
                        Tr.error((TraceComponent)this.tc, (String)"OSGI_ERROR_MSG", (Object[])logEntry.getObjects(true));
                    }
                    break;
                }
                case -5: {
                    if (isAnyTraceEnabled && this.tc.isEventEnabled()) {
                        Tr.event((Object)this.bundle, (TraceComponent)this.tc, (String)logEntry.getMessage(), (Object[])logEntry.getObjects(false));
                    }
                    break;
                }
            }
        }
        catch (Throwable t2) {
            FFDCFilter.processException((Throwable)t2, (String)this.ffdcMe, (String)"log", (Object)logEntry);
        }
        if (publishEvents && (publishDebugEvents || level != 4)) {
            this.logImpl.publishLogEntry(logEntry);
        }
    }

    private boolean shouldBeLogged(Throwable t, TrLogEntry logEntry) {
        while (t != null) {
            if (t instanceof IllegalStateException && COULD_NOT_OBTAIN_LOCK_EXCEPTION.equals(t.getMessage())) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"DS could not obtain a lock. This is not an error, but may indicate high system load", (Object[])logEntry.getObjects(true));
                }
                return false;
            }
            t = t.getCause();
        }
        return true;
    }

    public Object getBundle() {
        return this.bundle;
    }

    static final class OSGiTraceComponent
    extends TraceComponent {
        protected OSGiTraceComponent(String logName, Class<?> aClass, String[] groups) {
            super("LogService-" + logName, aClass, groups, "com.ibm.ws.logging.internal.osgi.resources.OSGiMessages");
        }
    }
}

