/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventImpl;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventListener;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InboundSseEventProcessor {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE;
    private static final String COMMENT = ": ";
    private static final String EVENT = "event: ";
    private static final String ID = "id: ";
    private static final String RETRY = "retry: ";
    private static final String DATA = "data: ";
    private final Endpoint endpoint;
    private final InboundSseEventListener listener;
    private final ExecutorService executor;
    private volatile boolean closed;
    static final long serialVersionUID = 8385933904611815975L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected InboundSseEventProcessor(Endpoint endpoint, InboundSseEventListener listener) {
        this.endpoint = endpoint;
        this.listener = listener;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    void run(Response response) {
        if (this.closed) {
            throw new IllegalStateException("The SSE Event Processor is already closed");
        }
        InputStream is = (InputStream)response.readEntity(InputStream.class);
        ClientProviderFactory factory = ClientProviderFactory.getInstance((Endpoint)this.endpoint);
        Message message = null;
        if (response instanceof ResponseImpl) {
            message = ((ResponseImpl)response).getOutMessage();
        }
        this.executor.submit(this.process(response, is, factory, message));
    }

    private Callable<?> process(Response response, InputStream is, ClientProviderFactory factory, Message message) {
        return () -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                InboundSseEventImpl.Builder builder = null;
                while (line != null && !Thread.interrupted() && !this.closed) {
                    if (StringUtils.isEmpty((String)line) && builder != null) {
                        InboundSseEvent event = builder.build(factory, message);
                        builder = null;
                        this.listener.onNext(event);
                    } else if (line.startsWith(EVENT)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).name(line.substring(EVENT.length()));
                    } else if (line.startsWith(ID)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).id(line.substring(ID.length()));
                    } else if (line.startsWith(COMMENT)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).comment(line.substring(COMMENT.length()));
                    } else if (line.startsWith(RETRY)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).reconnectDelay(line.substring(RETRY.length()));
                    } else if (line.startsWith(DATA)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).data(line.substring(DATA.length()));
                    }
                    line = reader.readLine();
                }
                if (builder != null) {
                    this.listener.onNext(builder.build(factory, message));
                }
                this.listener.onComplete();
            }
            catch (Exception ex) {
                this.listener.onError(ex);
            }
            if (response != null) {
                response.close();
            }
            return null;
        };
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean close(long timeout, TimeUnit unit) {
        try {
            this.closed = true;
            if (this.executor.isShutdown()) {
                return true;
            }
            AccessController.doPrivileged(() -> {
                this.executor.shutdown();
                return null;
            });
            return this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", (String)"143", (Object)this, (Object[])new Object[]{timeout, unit});
            return false;
        }
    }

    private static InboundSseEventImpl.Builder getOrCreate(InboundSseEventImpl.Builder builder) {
        return builder == null ? new InboundSseEventImpl.Builder() : builder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(InboundSseEventProcessor.class);
        SERVER_SENT_EVENTS_TYPE = MediaType.valueOf((String)SERVER_SENT_EVENTS);
    }
}

