/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl;
import com.ibm.ws.artifact.zip.internal.SystemUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipCachingProperties {
    private static final TraceComponent tc = Tr.register(ZipFileHandleImpl.class);
    public static final String SOURCE_DEFAULTED = "defaulted";
    public static final String SOURCE_PROPERTY = "system property";
    public static final String ZIP_CACHE_HANDLE_MAX_PROPERTY_NAME = "zip.cache.handle.max";
    public static final int ZIP_CACHE_HANDLE_MAX_DEFAULT_VALUE = 255;
    public static final int ZIP_CACHE_HANDLE_MAX;
    public static final String ZIP_CACHE_ENTRY_LIMIT_PROPERTY_NAME = "zip.cache.entry.limit";
    public static final int ZIP_CACHE_ENTRY_LIMIT_DEFAULT_VALUE = 8192;
    public static final int ZIP_CACHE_ENTRY_LIMIT;
    public static final String ZIP_CACHE_ENTRY_MAX_PROPERTY_NAME = "zip.cache.entry.max";
    public static final int ZIP_CACHE_ENTRY_MAX_DEFAULT_VALUE = 16;
    public static final int ZIP_CACHE_ENTRY_MAX;
    public static final String ZIP_REAPDER_DEBUG_STATE_PROPERTY_NAME = "zip.reaper.debug.state";
    public static final boolean ZIP_REAPER_DEBUG_STATE_DEFAULT_VALUE = false;
    public static final boolean ZIP_REAPER_DEBUG_STATE;
    public static final String ZIP_REAPER_COLLECT_TIMINGS_PROPERTY_NAME = "zip.reaper.collect.timings";
    public static final boolean ZIP_REAPER_COLLECT_TIMINGS_DEFAULT_VALUE = false;
    public static final boolean ZIP_REAPER_COLLECT_TIMINGS;
    public static final String ZIP_CACHE_REAPER_MAX_PENDING_PROPERTY_NAME = "zip.reaper.max.pending";
    public static final int ZIP_CACHE_REAPER_MAX_PENDING_DEFAULT_VALUE = 255;
    public static final int ZIP_CACHE_REAPER_MAX_PENDING;
    public static final String ZIP_CACHE_REAPER_QUICK_PEND_MIN_PROPERTY_NAME = "zip.reaper.quick.pend.min";
    public static final long ZIP_CACHE_REAPER_QUICK_PEND_MIN_DEFAULT_VALUE = 10000000L;
    public static final long ZIP_CACHE_REAPER_QUICK_PEND_MIN;
    public static final String ZIP_CACHE_REAPER_QUICK_PEND_MAX_PROPERTY_NAME = "zip.reaper.quick.pend.max";
    public static final long ZIP_CACHE_REAPER_QUICK_PEND_MAX_DEFAULT_VALUE = 20000000L;
    public static final long ZIP_CACHE_REAPER_QUICK_PEND_MAX;
    public static final String ZIP_CACHE_REAPER_SLOW_PEND_MIN_PROPERTY_NAME = "zip.reaper.slow.pend.min";
    public static final long ZIP_CACHE_REAPER_SLOW_PEND_MIN_DEFAULT_VALUE = 100000000L;
    public static final long ZIP_CACHE_REAPER_SLOW_PEND_MIN;
    public static final String ZIP_CACHE_REAPER_SLOW_PEND_MAX_PROPERTY_NAME = "zip.reaper.slow.pend.max";
    public static final long ZIP_CACHE_REAPER_SLOW_PEND_MAX_DEFAULT_VALUE = 200000000L;
    public static final long ZIP_CACHE_REAPER_SLOW_PEND_MAX;
    private static final String PAD = "0000000000";
    private static final int PAD_LEN = 10;
    public static final long NANO_IN_ONE = 1000000000L;
    public static final long NANO_IN_MILLI = 1000000L;
    public static final long MILLI_IN_ONE = 1000L;
    public static final int NANO_IN_ONE_DIGITS = 9;
    public static final int NANO_IN_MILLI_DIGITS = 6;
    public static final int MILLI_IN_ONE_DIGITS = 3;
    public static final int PAD_LEFT = 6;
    public static final int PAD_RIGHT = 6;
    public static final String ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE_PROPERTY_NAME = "artifact.zip.use.extra.path.cache";
    public static final boolean ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE_DEFAULT_VALUE = true;
    public static final boolean ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE;
    public static final String ARTIFACT_ZIP_COLLECT_TIMINGS_PROPERTY_NAME = "artifact.zip.collect.timings";
    public static final boolean ARTIFACT_ZIP_COLLECT_TIMINGS_DEFAULT_VALUE = false;
    public static final boolean ARTIFACT_ZIP_COLLECT_TIMINGS;
    public static long initialTiming;
    static final long serialVersionUID = 6916401400431323875L;

    @Trivial
    public static boolean getProperty(String methodName, String propertyName, boolean propertyDefaultValue) {
        String propertyText = SystemUtils.getProperty(propertyName);
        boolean propertyDefaulted = propertyText == null;
        boolean propertyValue = propertyDefaulted ? propertyDefaultValue : Boolean.parseBoolean(propertyText);
        ZipCachingProperties.debugProperty(methodName, propertyName, propertyValue, propertyDefaulted);
        return propertyValue;
    }

    @Trivial
    public static int getProperty(String methodName, String propertyName, int propertyDefaultValue) {
        String propertyText = SystemUtils.getProperty(propertyName);
        boolean propertyDefaulted = propertyText == null;
        int propertyValue = propertyDefaulted ? propertyDefaultValue : Integer.parseInt(propertyText);
        ZipCachingProperties.debugProperty(methodName, propertyName, propertyValue, propertyDefaulted);
        return propertyValue;
    }

    @Trivial
    public static long getProperty(String methodName, String propertyName, long propertyDefaultValue) {
        String propertyText = SystemUtils.getProperty(propertyName);
        boolean propertyDefaulted = propertyText == null;
        long propertyValue = propertyDefaulted ? propertyDefaultValue : Long.parseLong(propertyText);
        ZipCachingProperties.debugProperty(methodName, propertyName, propertyValue, propertyDefaulted);
        return propertyValue;
    }

    @Trivial
    public static String getProperty(String methodName, String propertyName, String propertyDefaultValue) {
        String propertyText = SystemUtils.getProperty(propertyName);
        boolean propertyDefaulted = propertyText == null;
        String propertyValue = propertyDefaulted ? propertyDefaultValue : propertyText;
        ZipCachingProperties.debugProperty(methodName, propertyName, propertyValue, propertyDefaulted);
        return propertyValue;
    }

    @Trivial
    public static void debugProperty(String methodName, String propertyName, boolean propertyValue, boolean defaulted) {
        ZipCachingProperties.debugProperty(methodName, propertyName, (Object)propertyValue, defaulted);
    }

    @Trivial
    public static void debugProperty(String methodName, String propertyName, int propertyValue, boolean defaulted) {
        ZipCachingProperties.debugProperty(methodName, propertyName, (Object)propertyValue, defaulted);
    }

    @Trivial
    public static void debugProperty(String methodName, String propertyName, long propertyValue, boolean defaulted) {
        ZipCachingProperties.debugProperty(methodName, propertyName, (Object)propertyValue, defaulted);
    }

    @Trivial
    public static void debugProperty(String methodName, String propertyName, Object propertyValue, boolean defaulted) {
        if (tc.isDebugEnabled()) {
            String propertyText = "Property [ " + propertyName + " ] [ " + propertyValue + " ] (" + (defaulted ? SOURCE_DEFAULTED : SOURCE_PROPERTY) + ")";
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{propertyText});
        }
    }

    @Trivial
    public static String toCount(int count) {
        return ZipCachingProperties.toCount(count, 6);
    }

    @Trivial
    public static String toCount(int count, int pad) {
        String digits = Integer.toString(count);
        int numDigits = digits.length();
        if (numDigits >= pad) {
            return digits;
        }
        int missing = pad - numDigits;
        if (missing > 10) {
            missing = 10;
        }
        return PAD.substring(0, missing) + digits;
    }

    @Trivial
    public static String toRelSec(long baseNS, long actualNS) {
        return ZipCachingProperties.toAbsSec(actualNS - baseNS, 6);
    }

    @Trivial
    public static String toRelSec(long baseNS, long actualNS, int pad) {
        return ZipCachingProperties.toAbsSec(actualNS - baseNS, pad);
    }

    @Trivial
    public static String toAbsSec(long durationNS) {
        return ZipCachingProperties.toAbsSec(durationNS, 6);
    }

    @Trivial
    public static String toAbsSec(long nano, int padLeft) {
        if (nano < 0L) {
            return "-" + ZipCachingProperties.toAbsSec(-1L * nano, padLeft);
        }
        if (nano == 0L) {
            return PAD.substring(0, padLeft) + "." + PAD.substring(6);
        }
        String nanoText = Long.toString(nano);
        int nanoDigits = nanoText.length();
        if (nanoDigits > 9) {
            int secDigits = nanoDigits - 9;
            if (secDigits >= padLeft) {
                return nanoText.substring(0, secDigits) + "." + nanoText.substring(secDigits, secDigits + 6);
            }
            int padDigits = padLeft - secDigits;
            if (padDigits > 10) {
                padDigits = 10;
            }
            return PAD.substring(0, padDigits) + nanoText.substring(0, secDigits) + "." + nanoText.substring(secDigits, secDigits + 6);
        }
        if (nanoDigits > 3) {
            if (padLeft > 10) {
                padLeft = 10;
            }
            int missingDigits = 9 - nanoDigits;
            return PAD.substring(0, padLeft) + "." + PAD.substring(0, missingDigits) + nanoText.substring(0, 6 - missingDigits);
        }
        if (padLeft > 10) {
            padLeft = 10;
        }
        return PAD.substring(0, padLeft) + "." + PAD.substring(5) + "*";
    }

    @Trivial
    public static String toRelMilliSec(long baseNS, long actualNS, int pad) {
        return ZipCachingProperties.toAbsSec((actualNS - baseNS) * 1000L, pad);
    }

    @Trivial
    public static String toAbsMilliSec(long eventAt, int pad) {
        return ZipCachingProperties.toAbsSec(eventAt * 1000L, pad);
    }

    @Trivial
    public static String toRelMilliSec(long baseNS, long actualNS) {
        return ZipCachingProperties.toAbsSec((actualNS - baseNS) * 1000L);
    }

    @Trivial
    public static String toAbsMilliSec(long eventAt) {
        return ZipCachingProperties.toAbsSec(eventAt * 1000L);
    }

    @Trivial
    public static String dualTiming(long eventAt, long initialAt) {
        return " [ " + ZipCachingProperties.toAbsMilliSec(eventAt) + "ms ] [ " + ZipCachingProperties.toAbsMilliSec(eventAt - initialAt) + "ms ]";
    }

    @Trivial
    public static String dualTiming(long eventAt) {
        return " [ " + ZipCachingProperties.toAbsMilliSec(eventAt) + "ms ] [ " + ZipCachingProperties.toAbsMilliSec(eventAt - initialTiming) + "ms ]";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        String methodName = "<static init>";
        ZIP_CACHE_HANDLE_MAX = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_HANDLE_MAX_PROPERTY_NAME, 255);
        ZIP_CACHE_ENTRY_LIMIT = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_ENTRY_LIMIT_PROPERTY_NAME, 8192);
        ZIP_CACHE_ENTRY_MAX = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_ENTRY_MAX_PROPERTY_NAME, 16);
        methodName = "<static init>";
        ZIP_REAPER_COLLECT_TIMINGS = ZipCachingProperties.getProperty(methodName, ZIP_REAPER_COLLECT_TIMINGS_PROPERTY_NAME, false);
        ZIP_REAPER_DEBUG_STATE = ZipCachingProperties.getProperty(methodName, ZIP_REAPDER_DEBUG_STATE_PROPERTY_NAME, false);
        methodName = "<static init>";
        ZIP_CACHE_REAPER_MAX_PENDING = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_REAPER_MAX_PENDING_PROPERTY_NAME, 255);
        ZIP_CACHE_REAPER_QUICK_PEND_MIN = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_REAPER_QUICK_PEND_MIN_PROPERTY_NAME, 10000000L);
        ZIP_CACHE_REAPER_QUICK_PEND_MAX = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_REAPER_QUICK_PEND_MAX_PROPERTY_NAME, 20000000L);
        ZIP_CACHE_REAPER_SLOW_PEND_MIN = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_REAPER_SLOW_PEND_MIN_PROPERTY_NAME, 100000000L);
        ZIP_CACHE_REAPER_SLOW_PEND_MAX = ZipCachingProperties.getProperty(methodName, ZIP_CACHE_REAPER_SLOW_PEND_MAX_PROPERTY_NAME, 200000000L);
        methodName = "<static init>";
        ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE = ZipCachingProperties.getProperty(methodName, ARTIFACT_ZIP_USE_EXTRA_PATH_CACHE_PROPERTY_NAME, true);
        ARTIFACT_ZIP_COLLECT_TIMINGS = ZipCachingProperties.getProperty(methodName, ARTIFACT_ZIP_COLLECT_TIMINGS_PROPERTY_NAME, false);
        initialTiming = ZIP_REAPER_COLLECT_TIMINGS || ARTIFACT_ZIP_COLLECT_TIMINGS ? System.nanoTime() : -1L;
    }
}

