/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileData;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore;
import com.ibm.ws.artifact.zip.internal.SystemUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@Trivial
public class ZipFileReaper {
    static final TraceComponent tc = Tr.register(ZipFileReaper.class);
    public static final boolean DO_DEBUG_STATE = true;
    public static final boolean DO_NOT_DEBUG_STATE = false;
    private final String reaperName;
    private final boolean debugState;
    private final int maxCache;
    private final long quickPendMin;
    private final long quickPendMax;
    private final long slowPendMin;
    private final long slowPendMax;
    private boolean isActive;
    private final long initialAt;
    private long finalAt;
    private final Map<String, ZipFileData> storage;
    private final ZipFileDataStore pendingQuickStorage;
    private final ZipFileDataStore pendingSlowStorage;
    private final ZipFileDataStore completedStorage;
    private final ReaperShutdownRunnable reaperShutdown;
    private final Thread reaperShutdownThread;
    private final ReaperRunnable reaperRunnable;
    private final Thread reaperThread;
    private final ReaperLock reaperLock;
    private static final boolean IS_NOT_SHUTDOWN_REAP = false;
    private static final boolean IS_SHUTDOWN_REAP = true;
    private static final long REAP_DELAY_INDEFINITE = -1L;

    @Trivial
    private static String toCount(int count) {
        return ZipCachingProperties.toCount(count);
    }

    @Trivial
    private static String toRelSec(long baseNS, long actualNS) {
        return ZipCachingProperties.toRelSec(baseNS, actualNS);
    }

    @Trivial
    private static String toAbsSec(long durationNS) {
        return ZipCachingProperties.toAbsSec(durationNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public void validate() {
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            this.pendingQuickStorage.validate();
            this.pendingSlowStorage.validate();
            if (!this.debugState) {
                this.completedStorage.validate();
            }
        }
    }

    @Trivial
    public ZipFileReaper(String reaperName) {
        this(reaperName, SystemUtils.getNanoTime());
    }

    @Trivial
    public ZipFileReaper(String reaperName, long initialAt) {
        this(reaperName, ZipCachingProperties.ZIP_REAPER_DEBUG_STATE, ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX);
    }

    @Trivial
    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) {
        this(reaperName, debugState, maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax, SystemUtils.getNanoTime());
    }

    private static void validate(int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) throws IllegalArgumentException {
        if (maxCache == 0) {
            throw new IllegalArgumentException("Max cache cannot be zero.");
        }
        if (quickPendMin == 0L || quickPendMax == 0L) {
            if (quickPendMin != 0L || quickPendMax != 0L) {
                throw new IllegalArgumentException("If one quick pend duration is zero, the other must be zero.");
            }
        } else {
            if (quickPendMin < 0L) {
                throw new IllegalArgumentException("Minimum quick pend duration [ " + quickPendMin + " ] must be positive or zero");
            }
            if (quickPendMax < 0L) {
                throw new IllegalArgumentException("Maximum quick pend duration[ " + quickPendMax + " ] must be positive or zero");
            }
            if (quickPendMin >= quickPendMax) {
                throw new IllegalArgumentException("Both quick durations must be zero, or, the minimum quick pend duration [ " + quickPendMin + " ] must be less than maximum quick pend duration [ " + quickPendMax + " ]");
            }
        }
        if (slowPendMin <= 0L) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be positive");
        }
        if (slowPendMax <= 0L) {
            throw new IllegalArgumentException("Maximum slow pend duration [ " + slowPendMax + " ] must be positive");
        }
        if (slowPendMin >= slowPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be less than maximum slow pend duration [ " + slowPendMax + " ]");
        }
        if (slowPendMin <= quickPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be greater than maximum quick pend duration [ " + quickPendMax + " ]");
        }
    }

    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax, long initialAt) {
        ZipFileReaper.validate(maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax);
        this.reaperName = reaperName;
        this.debugState = debugState;
        this.maxCache = maxCache;
        this.quickPendMin = quickPendMin;
        this.quickPendMax = quickPendMax;
        this.slowPendMin = slowPendMin;
        this.slowPendMax = slowPendMax;
        this.storage = new HashMap<String, ZipFileData>();
        this.pendingQuickStorage = new ZipFileDataStore("pendingQuick");
        this.pendingSlowStorage = new ZipFileDataStore("pendingSlow");
        this.completedStorage = !debugState ? new ZipFileDataStore("completed") : null;
        this.reaperLock = new ReaperLock();
        this.reaperRunnable = new ReaperRunnable(this);
        this.reaperThread = new Thread((Runnable)this.reaperRunnable, "zip file reaper");
        this.reaperThread.setDaemon(true);
        if (this.debugState) {
            this.reaperShutdown = new ReaperShutdownRunnable(this.reaperThread);
            this.reaperShutdownThread = new Thread(this.reaperShutdown);
        } else {
            this.reaperShutdown = null;
            this.reaperShutdownThread = null;
        }
        this.initialAt = initialAt;
        this.finalAt = 0L;
        this.isActive = true;
        this.reaperThread.start();
        if (this.debugState) {
            SystemUtils.addShutdownHook(this.reaperShutdownThread);
        }
    }

    public void shutDown() {
        this.reaperThread.interrupt();
    }

    @Trivial
    public String getReaperName() {
        return this.reaperName;
    }

    @Trivial
    public boolean getDebugState() {
        return this.debugState;
    }

    @Trivial
    public int getMaxCache() {
        return this.maxCache;
    }

    @Trivial
    public long getQuickPendMin() {
        return this.quickPendMin;
    }

    @Trivial
    public long getQuickPendMax() {
        return this.quickPendMax;
    }

    @Trivial
    public long getSlowPendMin() {
        return this.slowPendMin;
    }

    @Trivial
    public long getSlowPendMax() {
        return this.slowPendMax;
    }

    @Trivial
    public boolean getIsActive() {
        return this.isActive;
    }

    @Trivial
    private void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Trivial
    public long getInitialAt() {
        return this.initialAt;
    }

    @Trivial
    public long getFinalAt() {
        return this.finalAt;
    }

    @Trivial
    private void setFinalAt(long finalAt) {
        this.finalAt = finalAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState getState(String path) {
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            ZipFileData data = this.storage.get(path);
            if (data == null && !this.debugState) {
                data = this.completedStorage.get(path);
            }
            return data == null ? null : data.zipFileState;
        }
    }

    protected ZipFileData getRipest() {
        ZipFileData ripest;
        if (this.pendingQuickStorage.isEmpty()) {
            ripest = this.pendingSlowStorage.getFirst();
        } else if (this.pendingSlowStorage.isEmpty()) {
            ripest = this.pendingQuickStorage.getFirst();
        } else {
            ZipFileData ripestQuick = this.pendingQuickStorage.getFirst();
            long expireAtQuick = ripestQuick.lastPendAt + this.quickPendMin;
            ZipFileData ripestSlow = this.pendingQuickStorage.getFirst();
            long expireAtSlow = ripestSlow.lastPendAt + this.slowPendMin;
            ripest = expireAtQuick <= expireAtSlow ? ripestQuick : ripestSlow;
        }
        return ripest;
    }

    protected void fullyClose(ZipFileData data, long fullCloseAt, boolean isShutdown) {
        String methodName = "fullyClose";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + data.path + " ] at [ " + ZipFileReaper.toRelSec(this.initialAt, fullCloseAt) + " (s) ]"), (Object[])new Object[0]);
        }
        data.closeZipFile();
        data.enactFullClose(fullCloseAt);
        if (!isShutdown && !this.debugState) {
            ZipFileData fullyClosedData = this.storage.remove(data.path);
            ZipFileData oldestCompletedClose = this.completedStorage.addLast(data, this.getMaxCache());
            if (tc.isDebugEnabled() && oldestCompletedClose != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Discard completed close [ " + oldestCompletedClose.path + " ]"), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private ReaperShutdownRunnable getReaperShutdown() {
        return this.reaperShutdown;
    }

    @Trivial
    private Thread getReaperShutdownThread() {
        return this.reaperShutdownThread;
    }

    @Trivial
    private ReaperRunnable getReaper() {
        return this.reaperRunnable;
    }

    @Trivial
    private Thread getReaperThread() {
        return this.reaperThread;
    }

    private long reap(long reapAt, boolean isShutdownReap) {
        long nextReapDelay;
        boolean useQuick;
        String methodName = "reap";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " At [ " + ZipFileReaper.toRelSec(this.initialAt, reapAt) + " (s) ] Force [ " + isShutdownReap + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " All [ " + this.storage.size() + " ] Pending Quick [ " + this.pendingQuickStorage.size() + " ] Pending Slow [ " + this.pendingSlowStorage.size() + " ]"), (Object[])new Object[0]);
        }
        long nextQuickReapDelay = -1L;
        Iterator<ZipFileData> pendingQuick = this.pendingQuickStorage.values();
        while (nextQuickReapDelay == -1L && pendingQuick.hasNext()) {
            ZipFileData nextPending = pendingQuick.next();
            long nextLastPendAt = nextPending.lastPendAt;
            long nextPendDuration = reapAt - nextLastPendAt;
            if (isShutdownReap) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Quick): Forced"), (Object[])new Object[0]);
                }
                pendingQuick.remove();
                this.fullyClose(nextPending, reapAt, true);
                continue;
            }
            if (nextPendDuration > this.quickPendMin) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Quick): Expired"), (Object[])new Object[0]);
                }
                pendingQuick.remove();
                this.fullyClose(nextPending, reapAt, false);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ]: Still Waiting"), (Object[])new Object[0]);
            }
            if (nextPendDuration < 0L) {
                nextPendDuration = 0L;
            }
            nextQuickReapDelay = this.quickPendMax - nextPendDuration;
        }
        long nextSlowReapDelay = -1L;
        Iterator<ZipFileData> pendingSlow = this.pendingSlowStorage.values();
        while (nextSlowReapDelay == -1L && pendingSlow.hasNext()) {
            ZipFileData nextPending = pendingSlow.next();
            long nextLastPendAt = nextPending.lastPendAt;
            long nextPendDuration = reapAt - nextLastPendAt;
            if (isShutdownReap) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Slow): Forced"), (Object[])new Object[0]);
                }
                pendingSlow.remove();
                this.fullyClose(nextPending, reapAt, true);
                continue;
            }
            if (nextPendDuration > this.slowPendMin) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Slow): Expired"), (Object[])new Object[0]);
                }
                pendingSlow.remove();
                this.fullyClose(nextPending, reapAt, false);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ]: Still Waiting"), (Object[])new Object[0]);
            }
            if (nextPendDuration < 0L) {
                nextPendDuration = 0L;
            }
            nextSlowReapDelay = this.slowPendMax - nextPendDuration;
        }
        if (isShutdownReap) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " De-activating reaper"), (Object[])new Object[0]);
            }
            this.setIsActive(false);
            this.setFinalAt(reapAt);
            for (ZipFileData mustBeOpenOrClosed : this.storage.values()) {
                String path = mustBeOpenOrClosed.path;
                if (mustBeOpenOrClosed.isFullyClosed()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Closed [ " + path + " ]: No shutdown action"), (Object[])new Object[0]);
                    continue;
                }
                if (mustBeOpenOrClosed.isPending()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Unexpected Pending [ " + path + " ]: Shutdown close"), (Object[])new Object[0]);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ] [ " + mustBeOpenOrClosed.getActiveOpens() + " ]: Shutdown pend and close"), (Object[])new Object[0]);
                    }
                    mustBeOpenOrClosed.enactClose(reapAt, true);
                }
                this.fullyClose(mustBeOpenOrClosed, reapAt, true);
            }
            for (ZipFileData mustBeClosed : this.storage.values()) {
                mustBeClosed.setFinal(reapAt);
                mustBeClosed.debugState();
            }
        }
        if (nextQuickReapDelay < 0L && nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = -1L;
        } else if (nextQuickReapDelay < 0L) {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        } else if (nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else if (nextQuickReapDelay < nextSlowReapDelay) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        }
        if (tc.isDebugEnabled()) {
            String delayText = nextReapDelay == -1L ? "Indefinite" : ZipFileReaper.toAbsSec(nextReapDelay);
            String speedText = useQuick ? "Quick" : "Slow";
            Tr.debug((TraceComponent)tc, (String)(methodName + " Next reap [ " + delayText + " (s) ] (" + speedText + ")"), (Object[])new Object[0]);
        }
        return nextReapDelay;
    }

    @Trivial
    public ZipFile open(String path) throws IOException, ZipException {
        return this.open(path, SystemUtils.getNanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public ZipFile open(String path, long openAt) throws IOException, ZipException {
        String methodName = "open";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] at [ " + ZipFileReaper.toRelSec(this.initialAt, openAt) + " (s) ]"), (Object[])new Object[0]);
        }
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            ZipFile zipFile;
            if (!this.getIsActive()) {
                Tr.warning((TraceComponent)tc, (String)(methodName + " Cannot open [ " + path + " ]: ZipFile cache [ " + this.reaperName + " ] is inactive"), (Object[])new Object[0]);
                throw new IOException("Cannot open [ " + path + " ]: ZipFile cache is inactive");
            }
            ZipFileData data = this.storage.get(path);
            if (data == null) {
                if (!this.debugState) {
                    data = this.completedStorage.remove(path);
                }
                if (data == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " New [ " + path + " ]"), (Object[])new Object[0]);
                    }
                    data = new ZipFileData(path, this.getInitialAt());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Recovered [ " + path + " ]"), (Object[])new Object[0]);
                }
                this.storage.put(path, data);
            }
            if (data.isFullyClosed()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ]"), (Object[])new Object[0]);
                }
                zipFile = data.openZipFile();
            } else if (data.isPending()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Unpend [ " + path + " ]"), (Object[])new Object[0]);
                }
                if (data.expireQuickly) {
                    ZipFileData zipFileData = this.pendingQuickStorage.remove(path);
                } else {
                    ZipFileData zipFileData = this.pendingSlowStorage.remove(path);
                }
                zipFile = data.reacquireZipFile();
            } else if (data.isOpen()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Already open [ " + path + " ]"), (Object[])new Object[0]);
                }
                zipFile = data.reacquireZipFile();
            } else {
                throw data.unknownState();
            }
            data.enactOpen(openAt);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] [ " + zipFile + " ]"), (Object[])new Object[0]);
            }
            return zipFile;
        }
    }

    public ZipFileData.ZipFileState close(String path) {
        return this.close(path, SystemUtils.getNanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState close(String path, long closeAt) {
        String methodName = "close";
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            if (!this.getIsActive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ]: Ignore: Inactive"), (Object[])new Object[0]);
                }
                return null;
            }
            ZipFileData data = this.storage.get(path);
            if (data == null) {
                Tr.warning((TraceComponent)tc, (String)(methodName + " Unregistered [ " + path + " ]: Ignore"), (Object[])new Object[0]);
            } else if (data.isFullyClosed()) {
                Tr.warning((TraceComponent)tc, (String)(methodName + " Fully closed [ " + path + " ]: Ignore"), (Object[])new Object[0]);
            } else if (data.isPending()) {
                Tr.warning((TraceComponent)tc, (String)(methodName + " Pending [ " + path + " ]: No active opens: Ignore"), (Object[])new Object[0]);
            } else if (data.isOpen()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Active opens [ " + path + " ] [ " + data.getActiveOpens() + " ]"), (Object[])new Object[0]);
                }
                if (data.enactClose(closeAt, false)) {
                    boolean expireQuickly = data.setExpireQuickly(this.slowPendMin);
                    if (expireQuickly && this.quickPendMin == 0L) {
                        this.fullyClose(data, closeAt, false);
                    } else {
                        boolean wasQuickEmpty = this.pendingQuickStorage.isEmpty();
                        boolean wasSlowEmpty = this.pendingSlowStorage.isEmpty();
                        ZipFileData ripestPending = expireQuickly ? this.pendingQuickStorage.addLast(data, this.getMaxCache()) : this.pendingSlowStorage.addLast(data, this.getMaxCache());
                        if (ripestPending != null) {
                            this.fullyClose(ripestPending, closeAt, false);
                        }
                        Object wakeReason = wasQuickEmpty && wasSlowEmpty ? "Added first pending" : (expireQuickly ? (!wasQuickEmpty ? null : "Added first quick while slow are present") : null);
                        if (wakeReason != null) {
                            this.reaperLock.notify(methodName, (String)wakeReason);
                        }
                    }
                }
            } else {
                throw data.unknownState();
            }
            return data == null ? null : data.zipFileState;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReaperLock {
        static final long serialVersionUID = 4710289982958822403L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ReaperLock() {
        }

        public void notify(String methodName, String text) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + text), (Object[])new Object[0]);
            }
            this.notify();
        }

        public void wait(String methodName, String text) throws InterruptedException {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting for [ " + text + " ]"), (Object[])new Object[0]);
            }
            this.wait();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        public void waitNS(long waitNs, String methodName, String text) throws InterruptedException {
            long waitMs = waitNs / 1000000L;
            int fracWaitNs = (int)(waitNs - waitMs * 1000000L);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
            if (waitMs == 0L && fracWaitNs == 0) {
                throw new IllegalArgumentException(methodName + ": Invalid zero wait request for [ " + text + " ]");
            }
            this.wait(waitMs, fracWaitNs);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReaperLock.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReaperShutdownRunnable
    implements Runnable {
        private final Thread reaperThread;
        static final long serialVersionUID = -4710337470754673672L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperShutdownRunnable(Thread reaperThread) {
            this.reaperThread = reaperThread;
        }

        @Trivial
        private Thread getReaperThread() {
            return this.reaperThread;
        }

        @Override
        public void run() {
            Thread reaperThread = this.getReaperThread();
            reaperThread.interrupt();
            try {
                reaperThread.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperShutdownRunnable", (String)"462", (Object)this, (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReaperShutdownRunnable.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReaperRunnable
    implements Runnable {
        private final ZipFileReaper reaper;
        static final long serialVersionUID = -8379467651535906822L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperRunnable(ZipFileReaper reaper) {
            this.reaper = reaper;
        }

        @Trivial
        public ZipFileReaper getReaper() {
            return this.reaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            String methodName = "run";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Start"), (Object[])new Object[0]);
            }
            ReaperLock reaperLock = this.reaper.reaperLock;
            synchronized (reaperLock) {
                long reapDelay = -1L;
                while (true) {
                    long pendMax;
                    try {
                        if (reapDelay < 0L) {
                            this.reaper.reaperLock.wait(methodName, "new pending close");
                        } else {
                            this.reaper.reaperLock.waitNS(reapDelay, methodName, "active pending close");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperRunnable", (String)"203", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Interrupted!"), (Object[])new Object[0]);
                        break;
                    }
                    ZipFileData ripestPending = this.reaper.getRipest();
                    if (ripestPending == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " No pending!"), (Object[])new Object[0]);
                        }
                        reapDelay = -1L;
                        continue;
                    }
                    long reapAt = SystemUtils.getNanoTime();
                    long lastPendAt = ripestPending.lastPendAt;
                    long consumedPend = reapAt - lastPendAt;
                    long l = pendMax = ripestPending.expireQuickly ? this.reaper.getQuickPendMin() : this.reaper.getSlowPendMax();
                    if (consumedPend < pendMax) {
                        reapDelay = pendMax - consumedPend;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec(consumedPend) + " (s) ] remaining [ " + ZipFileReaper.toAbsSec(reapDelay) + " (s) ]"), (Object[])new Object[0]);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec(consumedPend) + " (s) ]"), (Object[])new Object[0]);
                    }
                    reapDelay = this.reaper.reap(reapAt, false);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Shutting down"), (Object[])new Object[0]);
            }
            this.reaper.reap(SystemUtils.getNanoTime(), true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Stop"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReaperRunnable.class);
        }
    }
}

