/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileUtils {
    static final long serialVersionUID = -62238986655537482L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ZipFile openZipFile(String path) throws ZipException, IOException {
        return ZipFileUtils.openZipFile(new File(path));
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static ZipFile openZipFile(final File target) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            ZipFile zipFile = AccessController.doPrivileged(new PrivilegedExceptionAction<ZipFile>(){
                static final long serialVersionUID = 2992518483588960382L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ZipFile run() throws IOException {
                    return new ZipFile(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            return zipFile;
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException(e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static void closeZipFile(String path, final ZipFile zipFile) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = 6759013143901094848L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    zipFile.close();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof ZipException) {
                throw (ZipException)innerException;
            }
            if (innerException instanceof IOException) {
                throw (IOException)innerException;
            }
            if (innerException instanceof RuntimeException) {
                throw (RuntimeException)innerException;
            }
            throw new UndeclaredThrowableException(innerException);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipFileUtils.class);
    }
}

