/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileUtils {
    static final long serialVersionUID = -5627300283157105826L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean fileIsFile(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 346837481104866631L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.isFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileIsDirectory(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -6326485578432258624L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.isDirectory();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static synchronized boolean fileExists(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -198982929324016316L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fileLength(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                static final long serialVersionUID = -4298304409748501718L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Long run() {
                    return target.length();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
            return l;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static File[] listFiles(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            File[] fileArray = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
                static final long serialVersionUID = 594290122381729530L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() {
                    return target.listFiles();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class);
                }
            });
            return fileArray;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static String[] list(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
                static final long serialVersionUID = -2686093076581787582L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String[] run() {
                    return target.list();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class);
                }
            });
            return stringArray;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getInputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            InputStream inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){
                static final long serialVersionUID = 4070367448494335211L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(7.class);
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"126", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FileOutputStream getFileOutputStream(final File target) throws FileNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            FileOutputStream fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){
                static final long serialVersionUID = 6464525222289139774L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(target);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(8.class);
                }
            });
            return fileOutputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"147", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fileLastModified(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                static final long serialVersionUID = 4829281066557526193L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Long run() {
                    return target.lastModified();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(9.class);
                }
            });
            return l;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileSetLastModified(final File target, final long lastModified) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 1298666074283592674L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.setLastModified(lastModified);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(10.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileCanRead(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 6392202229265614712L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.canRead();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(11.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileCanWrite(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -7873141976832649555L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.canWrite();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(12.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static synchronized boolean fileMkDirs(final File target) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -7395902697158282723L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return target.mkdirs();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(13.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean fileDelete(final File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 2519667992542339760L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.delete();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(14.class);
                }
            });
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean ensureDirExists(File dir) {
        return FileUtils.fileMkDirs(dir) || FileUtils.fileExists(dir);
    }

    public static boolean tryToClose(Closeable closeable) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            if (closeable != null) {
                try {
                    closeable.close();
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"254", null, (Object[])new Object[]{closeable});
                }
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return false;
    }

    public static boolean setUserReadWriteOnly(File file) {
        return AccessController.doPrivileged(new SetFilePermsAction(file));
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean fileCreate(final File target) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Boolean bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -2192931555987623871L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IOException {
                    return target.createNewFile();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(15.class);
                }
            });
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.artifact.zip.internal.FileUtils", (String)"299", null, (Object[])new Object[]{target});
            Exception e2 = e.getException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new UndeclaredThrowableException((Throwable)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FileUtils.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class SetFilePermsAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = 7836076312388377282L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SetFilePermsAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            this.file.setReadable(false, false);
            this.file.setWritable(false, false);
            this.file.setExecutable(false, false);
            this.file.setReadable(true, true);
            this.file.setWritable(true, true);
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SetFilePermsAction.class);
        }
    }
}

