/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileContainerUtils;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileArtifactNotifier
implements ArtifactNotifier,
FileMonitor,
ArtifactNotifier.ArtifactListener {
    static final TraceComponent tc = Tr.register(ZipFileArtifactNotifier.class);
    private final ArtifactNotifier.ArtifactNotification emptyNotification;
    private final ZipFileContainer rootContainer;
    private final String a_exposedRootPath;
    private final ArtifactEntry entryInEnclosingContainer;
    private boolean monitorIsExplicit = false;
    private long monitorIntervalMilliSec = 5000L;
    private final Hashtable<String, Object> serviceProperties;
    private ServiceRegistration<FileMonitor> service;
    private boolean listenerRegistered;
    private final ListenersLock listenersLock;
    private final Map<String, Collection<ArtifactNotifier.ArtifactListener>> listeners;
    private final Set<String> coveringPaths;
    static final long serialVersionUID = 2336449739771515599L;

    public ZipFileArtifactNotifier(ZipFileContainer rootContainer, String a_rootPath) {
        this.emptyNotification = new DefaultArtifactNotification((ArtifactContainer)rootContainer, Collections.emptySet());
        this.rootContainer = rootContainer;
        this.a_exposedRootPath = a_rootPath;
        this.entryInEnclosingContainer = null;
        this.serviceProperties = new Hashtable();
        this.listenerRegistered = false;
        this.listenersLock = new ListenersLock();
        this.listeners = new HashMap<String, Collection<ArtifactNotifier.ArtifactListener>>();
        this.coveringPaths = new HashSet<String>();
    }

    public ZipFileArtifactNotifier(ZipFileContainer rootContainer, ArtifactEntry entryInEnclosingContainer) {
        this.emptyNotification = new DefaultArtifactNotification((ArtifactContainer)rootContainer, Collections.emptySet());
        this.rootContainer = rootContainer;
        this.a_exposedRootPath = null;
        this.entryInEnclosingContainer = entryInEnclosingContainer;
        this.serviceProperties = null;
        this.listenerRegistered = false;
        this.listenersLock = new ListenersLock();
        this.listeners = new HashMap<String, Collection<ArtifactNotifier.ArtifactListener>>();
        this.coveringPaths = new HashSet<String>();
    }

    @Trivial
    private boolean isExposedNotifier() {
        return this.a_exposedRootPath == null;
    }

    @Trivial
    private ContainerFactoryHolder getContainerFactoryHolder() {
        return this.rootContainer.getContainerFactoryHolder();
    }

    private void loadZipEntries() {
        ZipFileContainerUtils.ZipEntryData[] allZipEntries = this.rootContainer.getZipEntryData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNotificationOptions(long newMonitorIntervalMilliSec, boolean newMonitorIsExplicit) {
        ListenersLock listenersLock = this.listenersLock;
        synchronized (listenersLock) {
            if (this.isExposedNotifier()) {
                return false;
            }
            if (newMonitorIntervalMilliSec == this.monitorIntervalMilliSec && newMonitorIsExplicit == this.monitorIsExplicit) {
                return true;
            }
            this.monitorIsExplicit = newMonitorIsExplicit;
            this.monitorIntervalMilliSec = newMonitorIntervalMilliSec;
            this.updateMonitorService();
            return true;
        }
    }

    @Trivial
    private void updateMonitor() {
        if (!this.isExposedNotifier()) {
            this.updateMonitorService();
        } else {
            this.updateEnclosingMonitor();
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private void updateMonitorService() {
        if (!this.coveringPaths.isEmpty()) {
            if (this.service == null) {
                try {
                    BundleContext bundleContext = this.getContainerFactoryHolder().getBundleContext();
                    this.setServiceProperties();
                    this.service = bundleContext.registerService(FileMonitor.class, (Object)this, this.serviceProperties);
                    this.loadZipEntries();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        } else if (this.service != null) {
            try {
                this.service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.service = null;
        }
    }

    private void updateEnclosingMonitor() {
        if (!this.coveringPaths.isEmpty()) {
            if (!this.listenerRegistered) {
                ArtifactContainer enclosingRootContainer = this.entryInEnclosingContainer.getRoot();
                DefaultArtifactNotification enclosingNotification = new DefaultArtifactNotification(enclosingRootContainer, Collections.singleton(this.entryInEnclosingContainer.getPath()));
                ArtifactNotifier enclosingRootNotifier = enclosingRootContainer.getArtifactNotifier();
                this.listenerRegistered = enclosingRootNotifier.registerForNotifications((ArtifactNotifier.ArtifactNotification)enclosingNotification, (ArtifactNotifier.ArtifactListener)this);
                this.loadZipEntries();
            }
        } else if (this.listenerRegistered) {
            ArtifactContainer enclosingRootContainer = this.entryInEnclosingContainer.getRoot();
            ArtifactNotifier enclosingNotifier = enclosingRootContainer.getArtifactNotifier();
            enclosingNotifier.removeListener((ArtifactNotifier.ArtifactListener)this);
        }
    }

    private void setServiceProperties() {
        this.serviceProperties.put("service.vendor", "IBM");
        String notificationType = this.monitorIsExplicit ? "external" : "timed";
        this.serviceProperties.put("monitor.type", notificationType);
        this.serviceProperties.put("monitor.interval", Long.toString(this.monitorIntervalMilliSec) + "ms");
        this.serviceProperties.put("monitor.files", new String[]{this.a_exposedRootPath});
        this.serviceProperties.put("monitor.directories", new String[]{this.a_exposedRootPath});
        this.serviceProperties.put("monitor.recurse", Boolean.TRUE);
        this.serviceProperties.put("monitor.filter", ".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerForNotifications(ArtifactNotifier.ArtifactNotification newListenerPaths, ArtifactNotifier.ArtifactListener newListener) {
        if (newListenerPaths.getContainer().getRoot() != this.rootContainer) {
            throw new IllegalArgumentException();
        }
        ListenersLock listenersLock = this.listenersLock;
        synchronized (listenersLock) {
            boolean addedUncoveredPaths = false;
            for (String newListenerPath : newListenerPaths.getPaths()) {
                if (newListenerPath.startsWith("!")) {
                    newListenerPath = newListenerPath.substring(1);
                }
                if (!this.registerListener(newListenerPath, newListener)) continue;
                addedUncoveredPaths = true;
            }
            if (addedUncoveredPaths) {
                this.updateMonitor();
            }
        }
        return true;
    }

    private boolean registerListener(String newPath, ArtifactNotifier.ArtifactListener newListener) {
        boolean updatedCoveringPaths = this.addCoveringPath(newPath);
        Collection<ArtifactNotifier.ArtifactListener> listenersForPath = this.listeners.get(newPath);
        if (listenersForPath == null) {
            listenersForPath = new LinkedList<ArtifactNotifier.ArtifactListener>();
            this.listeners.put(newPath, listenersForPath);
        }
        listenersForPath.add(newListener);
        return updatedCoveringPaths;
    }

    private boolean addCoveringPath(String newPath) {
        int newLen = newPath.length();
        Iterator<String> useCoveringPaths = this.coveringPaths.iterator();
        boolean isCovered = false;
        boolean isCovering = false;
        while (!isCovered && useCoveringPaths.hasNext()) {
            String coveringPath = useCoveringPaths.next();
            int coveringLen = coveringPath.length();
            if (coveringLen < newLen) {
                if (isCovering || !newPath.regionMatches(0, coveringPath, 0, coveringLen) || newPath.charAt(coveringLen) != '/') continue;
                isCovered = true;
                break;
            }
            if (coveringLen == newLen) {
                if (isCovering || !newPath.regionMatches(0, coveringPath, 0, coveringLen)) continue;
                isCovered = true;
                break;
            }
            if (!newPath.regionMatches(0, coveringPath, 0, newLen) || coveringPath.charAt(newLen) != '/') continue;
            isCovering = true;
            useCoveringPaths.remove();
        }
        if (!isCovered) {
            this.coveringPaths.add(newPath);
        }
        return !isCovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ArtifactNotifier.ArtifactListener listenerToRemove) {
        ListenersLock listenersLock = this.listenersLock;
        synchronized (listenersLock) {
            ArrayList<String> pathsToRemove = new ArrayList<String>(1);
            block3: for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersEntry : this.listeners.entrySet()) {
                for (ArtifactNotifier.ArtifactListener listener : listenersEntry.getValue()) {
                    if (listener != listenerToRemove) continue;
                    pathsToRemove.add(listenersEntry.getKey());
                    continue block3;
                }
            }
            Iterator usePathsToRemove = pathsToRemove.iterator();
            while (usePathsToRemove.hasNext()) {
                String pathToRemove = (String)usePathsToRemove.next();
                Collection<ArtifactNotifier.ArtifactListener> listenersForPath = this.listeners.get(pathToRemove);
                if (listenersForPath.size() == 1) {
                    this.listeners.remove(pathToRemove);
                    continue;
                }
                listenersForPath.remove(listenerToRemove);
                usePathsToRemove.remove();
            }
            if (!pathsToRemove.isEmpty()) {
                this.coveringPaths.clear();
                for (String listenerPath : this.listeners.keySet()) {
                    boolean bl = this.addCoveringPath(listenerPath);
                }
                this.updateMonitor();
            }
            return !pathsToRemove.isEmpty();
        }
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void onChange(Collection<File> addedFiles, Collection<File> updatedFiles, Collection<File> removedFiles) {
        boolean isUpdate;
        boolean bl = isUpdate = !updatedFiles.isEmpty();
        if (addedFiles.isEmpty() && !isUpdate && removedFiles.isEmpty()) {
            return;
        }
        String validationMessage = this.validateNotification(addedFiles, updatedFiles, removedFiles);
        if (validationMessage != null) {
            Tr.debug((TraceComponent)tc, (String)("Unexpected notification on [ " + this.rootContainer + " ]: " + validationMessage), (Object[])new Object[0]);
        } else {
            this.notifyAllListeners(isUpdate);
        }
    }

    public void notifyEntryChange(ArtifactNotifier.ArtifactNotification addedNotification, ArtifactNotifier.ArtifactNotification removedNotification, ArtifactNotifier.ArtifactNotification updatedNotification) {
        boolean isUpdate;
        Collection addedPaths = addedNotification.getPaths();
        Collection removedPaths = removedNotification.getPaths();
        Collection updatedPaths = updatedNotification.getPaths();
        boolean bl = isUpdate = !updatedPaths.isEmpty();
        if (addedPaths.isEmpty() && !isUpdate && removedPaths.isEmpty()) {
            return;
        }
        String validationMessage = this.validateNotification(addedPaths, updatedPaths, removedPaths);
        if (validationMessage != null) {
            Tr.debug((TraceComponent)tc, (String)("Unexpected notification on [ " + this.rootContainer + " ]: " + validationMessage), (Object[])new Object[0]);
        } else {
            this.notifyAllListeners(isUpdate);
        }
    }

    @Trivial
    private String validateNotification(Collection<?> added, Collection<?> removed, Collection<?> updated) {
        boolean isUpdate;
        boolean isAddition = !added.isEmpty();
        boolean isRemoval = !removed.isEmpty();
        boolean bl = isUpdate = !updated.isEmpty();
        if (!(isAddition || isRemoval || isUpdate)) {
            return "null";
        }
        if (isAddition) {
            return "Addition of [ " + added.toString() + " ]";
        }
        if (isUpdate && isRemoval) {
            return "Update of [ " + updated.toString() + " ] with removal of [ " + removed.toString() + " ]";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(boolean isUpdate) {
        ListenersLock listenersLock = this.listenersLock;
        synchronized (listenersLock) {
            for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersEntry : this.listeners.entrySet()) {
                ArrayList<String> a_registeredPaths = new ArrayList<String>();
                this.collectRegisteredPaths(listenersEntry.getKey(), a_registeredPaths);
                if (a_registeredPaths.isEmpty()) continue;
                DefaultArtifactNotification registeredPaths = new DefaultArtifactNotification((ArtifactContainer)this.rootContainer, a_registeredPaths);
                for (ArtifactNotifier.ArtifactListener listener : listenersEntry.getValue()) {
                    if (isUpdate) {
                        listener.notifyEntryChange(this.emptyNotification, this.emptyNotification, (ArtifactNotifier.ArtifactNotification)registeredPaths);
                        continue;
                    }
                    listener.notifyEntryChange(this.emptyNotification, (ArtifactNotifier.ArtifactNotification)registeredPaths, this.emptyNotification);
                }
            }
        }
    }

    @Trivial
    private void collectRegisteredPaths(String a_path, List<String> a_paths) {
        ZipFileContainerUtils.ZipEntryData[] allEntryData = this.rootContainer.getZipEntryData();
        if (a_path.isEmpty() || a_path.length() == 1 && a_path.charAt(0) == '/') {
            for (ZipFileContainerUtils.ZipEntryData entry : allEntryData) {
                a_paths.add("/" + entry.r_getPath());
            }
            a_paths.add("/");
        } else {
            String r_nextPath;
            int r_nextPathLen;
            boolean isExact;
            String r_path = a_path.substring(1);
            int r_pathLen = r_path.length();
            int location = this.rootContainer.locatePath(r_path);
            if (location < 0) {
                location = (location + 1) * -1;
                isExact = false;
            } else {
                ++location;
                isExact = true;
            }
            while (location < allEntryData.length && (r_nextPathLen = (r_nextPath = allEntryData[location].r_getPath()).length()) > r_pathLen && r_nextPath.regionMatches(0, r_path, 0, r_pathLen) && r_nextPath.charAt(r_pathLen) == '/') {
                a_paths.add("/" + r_nextPath);
                ++location;
            }
            if (isExact) {
                a_paths.add("/" + r_path);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ListenersLock {
        static final long serialVersionUID = -8168842896811796283L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ListenersLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ListenersLock.class);
        }
    }
}

