/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.modelresolver.impl;

import com.ibm.jbatch.container.modelresolver.PropertyResolver;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Properties;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractPropertyResolver<B>
implements PropertyResolver<B> {
    protected boolean isPartitionedStep = false;
    public static final String UNRESOLVED_PROP_VALUE = "";
    static final long serialVersionUID = 8897440636436220682L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AbstractPropertyResolver(boolean isPartitionStep) {
        this.isPartitionedStep = isPartitionStep;
    }

    @Override
    public B substituteProperties(B b) {
        return this.substituteProperties(b, null, null);
    }

    @Override
    public B substituteProperties(B b, Properties submittedProps) {
        return this.substituteProperties(b, submittedProps, null);
    }

    protected Properties resolveElementProperties(List<Property> elementProperties, Properties submittedProps, Properties parentProps) {
        Properties currentXMLProperties = new Properties();
        currentXMLProperties = this.inheritProperties(parentProps, currentXMLProperties);
        for (Property prop : elementProperties) {
            String name = prop.getName();
            name = this.replaceAllProperties(name, submittedProps, currentXMLProperties);
            String value = prop.getValue();
            value = this.replaceAllProperties(value, submittedProps, currentXMLProperties);
            currentXMLProperties.setProperty(name, value);
            prop.setName(name);
            prop.setValue(value);
        }
        return currentXMLProperties;
    }

    protected String replaceAllProperties(String str, Properties submittedProps, Properties xmlProperties) {
        int startIndex = 0;
        NextProperty nextProp = this.findNextProperty(str, startIndex);
        while (nextProp != null) {
            startIndex = nextProp.endIndex;
            String nextPropValue = this.resolvePropertyValue(nextProp.propName, nextProp.propType, submittedProps, xmlProperties);
            if (nextPropValue.equals(UNRESOLVED_PROP_VALUE) && nextProp.defaultValueExpression != null) {
                nextPropValue = this.replaceAllProperties(nextProp.defaultValueExpression, submittedProps, xmlProperties);
            }
            int lengthDifference = 0;
            switch (nextProp.propType) {
                case JOB_PARAMETERS: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{jobParameters['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{jobParameters['" + nextProp.propName + "']}" + nextProp.getDefaultValExprWithDelimitersIfExists(), nextPropValue);
                    break;
                }
                case JOB_PROPERTIES: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{jobProperties['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{jobProperties['" + nextProp.propName + "']}" + nextProp.getDefaultValExprWithDelimitersIfExists(), nextPropValue);
                    break;
                }
                case SYSTEM_PROPERTIES: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{systemProperties['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{systemProperties['" + nextProp.propName + "']}" + nextProp.getDefaultValExprWithDelimitersIfExists(), nextPropValue);
                    break;
                }
                case PARTITION_PROPERTIES: {
                    lengthDifference = nextPropValue.length() - (nextProp.propName.length() + "#{partitionPlan['']}".length());
                    startIndex += lengthDifference;
                    str = str.replace("#{partitionPlan['" + nextProp.propName + "']}" + nextProp.getDefaultValExprWithDelimitersIfExists(), nextPropValue);
                }
            }
            nextProp = this.findNextProperty(str, startIndex);
        }
        return str;
    }

    private String resolvePropertyValue(String name, PROPERTY_TYPE propType, Properties submittedProperties, Properties xmlProperties) {
        String value = null;
        switch (propType) {
            case JOB_PARAMETERS: {
                if (submittedProperties != null) {
                    value = submittedProperties.getProperty(name);
                }
                if (value == null) break;
                return value;
            }
            case JOB_PROPERTIES: {
                if (xmlProperties != null) {
                    value = xmlProperties.getProperty(name);
                }
                if (value == null) break;
                return value;
            }
            case SYSTEM_PROPERTIES: {
                value = System.getProperty(name);
                if (value == null) break;
                return value;
            }
            case PARTITION_PROPERTIES: {
                if (submittedProperties != null) {
                    value = submittedProperties.getProperty(name);
                }
                if (value == null) break;
                return value;
            }
        }
        return UNRESOLVED_PROP_VALUE;
    }

    private Properties inheritProperties(Properties parentProps, Properties childProps) {
        if (parentProps == null) {
            return childProps;
        }
        if (childProps == null) {
            return parentProps;
        }
        for (String parentKey : parentProps.stringPropertyNames()) {
            if (childProps.containsKey(parentKey)) continue;
            childProps.setProperty(parentKey, parentProps.getProperty(parentKey));
        }
        return childProps;
    }

    private int getEndIndexOfNextProperty(String str, int startIndex) {
        if (str == null) {
            return -1;
        }
        int startPropIndex = str.indexOf("${", startIndex);
        if (startPropIndex == -1) {
            return -1;
        }
        int endPropIndex = str.indexOf("}", startPropIndex);
        if (endPropIndex > startPropIndex) {
            return endPropIndex;
        }
        return -1;
    }

    private NextProperty findNextProperty(String str, int startIndex) {
        if (str == null) {
            return null;
        }
        int startPropIndex = str.indexOf("#{", startIndex);
        if (startPropIndex == -1) {
            return null;
        }
        PROPERTY_TYPE type = null;
        if (str.startsWith("#{jobParameters['", startPropIndex)) {
            type = PROPERTY_TYPE.JOB_PARAMETERS;
        } else if (str.startsWith("#{systemProperties['", startPropIndex)) {
            type = PROPERTY_TYPE.SYSTEM_PROPERTIES;
        } else if (str.startsWith("#{jobProperties['", startPropIndex)) {
            type = PROPERTY_TYPE.JOB_PROPERTIES;
        } else if (this.isPartitionedStep && str.startsWith("#{partitionPlan['", startPropIndex)) {
            type = PROPERTY_TYPE.PARTITION_PROPERTIES;
        }
        if (type == null) {
            return null;
        }
        int endPropIndex = str.indexOf("']}");
        String propName = null;
        String defaultPropExpression = null;
        if (endPropIndex > startPropIndex) {
            if (str.startsWith("?:", endPropIndex + "']}".length())) {
                int tempEndPropIndex = str.indexOf(";", endPropIndex + "']}?:".length());
                if (tempEndPropIndex == -1) {
                    throw new IllegalArgumentException("The default property expression is not properly terminated with ';'");
                }
                defaultPropExpression = str.substring(endPropIndex + "]}?:".length() + 1, tempEndPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.JOB_PARAMETERS)) {
                propName = str.substring(startPropIndex + "#{jobParameters['".length(), endPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.JOB_PROPERTIES)) {
                propName = str.substring(startPropIndex + "#{jobProperties['".length(), endPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.SYSTEM_PROPERTIES)) {
                propName = str.substring(startPropIndex + "#{systemProperties['".length(), endPropIndex);
            }
            if (type.equals((Object)PROPERTY_TYPE.PARTITION_PROPERTIES)) {
                propName = str.substring(startPropIndex + "#{partitionPlan['".length(), endPropIndex);
            }
            return new NextProperty(propName, type, startPropIndex, endPropIndex, defaultPropExpression);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AbstractPropertyResolver.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class NextProperty {
        final String propName;
        final PROPERTY_TYPE propType;
        final int startIndex;
        final int endIndex;
        final String defaultValueExpression;
        static final long serialVersionUID = 5674893769790385967L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        NextProperty(String propName, PROPERTY_TYPE propType, int startIndex, int endIndex, String defaultValueExpression) {
            this.propName = propName;
            this.propType = propType;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.defaultValueExpression = defaultValueExpression;
        }

        String getDefaultValExprWithDelimitersIfExists() {
            if (this.defaultValueExpression != null) {
                return "?:" + this.defaultValueExpression + ";";
            }
            return AbstractPropertyResolver.UNRESOLVED_PROP_VALUE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NextProperty.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class PROPERTY_TYPE
    extends Enum<PROPERTY_TYPE> {
        public static final /* enum */ PROPERTY_TYPE JOB_PARAMETERS;
        public static final /* enum */ PROPERTY_TYPE SYSTEM_PROPERTIES;
        public static final /* enum */ PROPERTY_TYPE JOB_PROPERTIES;
        public static final /* enum */ PROPERTY_TYPE PARTITION_PROPERTIES;
        private static final /* synthetic */ PROPERTY_TYPE[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static PROPERTY_TYPE[] values() {
            return (PROPERTY_TYPE[])$VALUES.clone();
        }

        public static PROPERTY_TYPE valueOf(String name) {
            return Enum.valueOf(PROPERTY_TYPE.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PROPERTY_TYPE.class);
            JOB_PARAMETERS = new PROPERTY_TYPE();
            SYSTEM_PROPERTIES = new PROPERTY_TYPE();
            JOB_PROPERTIES = new PROPERTY_TYPE();
            PARTITION_PROPERTIES = new PROPERTY_TYPE();
            $VALUES = new PROPERTY_TYPE[]{JOB_PARAMETERS, SYSTEM_PROPERTIES, JOB_PROPERTIES, PARTITION_PROPERTIES};
        }
    }
}

