/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.module.ApplicationNestedConfigHelper;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.classloading.ClassLoaderConfigHelper;
import com.ibm.ws.classloading.ClassLoadingButler;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.permissions.PermissionsConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.java2sec.PermissionManager;
import com.ibm.ws.threadContext.ModuleMetaDataAccessorImpl;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DeployedAppInfoBase
extends SimpleDeployedAppInfoBase
implements ApplicationClassesContainerInfo,
AppClassLoaderFactory,
ModuleClassLoaderFactory {
    private static final TraceComponent _tc = Tr.register(DeployedAppInfoBase.class, (String)"app.manager", (String)"com.ibm.ws.app.manager.module.internal.resources.Messages");
    private static final String PERMISSION_XML = "permissions.xml";
    protected final ApplicationInformation<?> applicationInformation;
    public final String location;
    protected final ClassLoadingService classLoadingService;
    protected final Library globalSharedLibrary;
    protected final SharedLibDeploymentInfo sharedLibDeploymentInfo;
    private final FutureMonitor futureMonitor;
    private final ConfigurationAdmin configAdmin;
    private final ClassLoaderConfigHelper libraryConfigHelper;
    protected final boolean isDelegateLast;
    private final PermissionManager permissionManager;
    private final PermissionsConfig permissionsConfig;
    static final long serialVersionUID = -6908382869835671687L;

    /*
     * WARNING - void declaration
     */
    protected DeployedAppInfoBase(ApplicationInformation<?> applicationInformation, DeployedAppInfoFactoryBase factory) throws UnableToAdaptException {
        super(factory);
        this.applicationInformation = applicationInformation;
        this.location = applicationInformation.getLocation();
        this.classLoadingService = factory.getClassLoadingService();
        this.globalSharedLibrary = factory.getGlobalSharedLibrary();
        this.futureMonitor = factory.getFutureMonitor();
        this.configAdmin = factory.getConfigurationAdmin();
        this.libraryConfigHelper = new ClassLoaderConfigHelper(this.getConfigHelper(), this.configAdmin, this.classLoadingService);
        this.isDelegateLast = this.libraryConfigHelper.isDelegateLast();
        this.permissionManager = factory.getPermissionManager();
        try {
            this.permissionsConfig = (PermissionsConfig)this.getContainer().adapt(PermissionsConfig.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"304", (Object)this, (Object[])new Object[]{applicationInformation, factory});
            Tr.error((TraceComponent)_tc, (String)"error.application.parse.descriptor", (Object[])new Object[]{this.getName(), "META-INF/permissions.xml", e});
            throw e;
        }
        String parentPid = (String)applicationInformation.getConfigProperty("service.pid");
        String sourcePid = (String)applicationInformation.getConfigProperty("ibm.extends.source.pid");
        if (sourcePid != null) {
            parentPid = sourcePid;
        }
        this.sharedLibDeploymentInfo = new SharedLibDeploymentInfo(factory, parentPid);
    }

    @Trivial
    public String getName() {
        return this.applicationInformation.getName();
    }

    @Trivial
    public Container getContainer() {
        return this.applicationInformation.getContainer();
    }

    @Trivial
    public NestedConfigHelper getConfigHelper() {
        return new ApplicationNestedConfigHelper(this.applicationInformation);
    }

    protected abstract ExtendedApplicationInfo createApplicationInfo();

    public List<ContainerInfo> getLibraryClassesContainerInfo() {
        if (this.sharedLibDeploymentInfo.getClassesContainerInfo() != null) {
            return Collections.unmodifiableList(this.sharedLibDeploymentInfo.getClassesContainerInfo());
        }
        return Collections.emptyList();
    }

    public ClassLoader createAppClassLoader() {
        return null;
    }

    protected void registerApplicationMBean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean preDeployApp(Future<Boolean> result) {
        this.appInfo = this.createApplicationInfo();
        try {
            this.metaDataService.fireApplicationMetaDataCreated(this.appInfo.getMetaData(), this.appInfo.getContainer());
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"359", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        HashMap<URL, ModuleMetaData> mmds = new HashMap<URL, ModuleMetaData>();
        for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            try {
                ModuleMetaData mmd = modInfo.createModuleMetaData((ApplicationInfo)this.appInfo, this, this);
                URL location = (URL)modInfo.getContainer().getURLs().iterator().next();
                mmds.put(location, mmd);
            }
            catch (Throwable mmd) {
                void ex;
                FFDCFilter.processException((Throwable)mmd, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"371", (Object)this, (Object[])new Object[]{result});
                this.uninstallApp();
                this.futureMonitor.setResult(result, (Throwable)ex);
                return false;
            }
        }
        this.registerApplicationMBean();
        this.starting = true;
        try {
            ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().beginContext(mmds);
            this.stateChangeService.fireApplicationStarting((ApplicationInfo)this.appInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"384", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().endContext();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean postDeployApp(Future<Boolean> result) {
        this.started = true;
        try {
            this.stateChangeService.fireApplicationStarted((ApplicationInfo)this.appInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"398", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean deployApp(Future<Boolean> result) {
        if (this.moduleContainerInfos.isEmpty()) {
            throw new IllegalStateException();
        }
        if (!this.preDeployApp(result)) {
            return false;
        }
        if (!this.deployModules(result)) {
            return false;
        }
        return this.postDeployApp(result);
    }

    private boolean deployModules(Future<Boolean> result) {
        DeployModulesListener listener = new DeployModulesListener(result);
        for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            DeployedModuleInfoImpl deployedMod = (DeployedModuleInfoImpl)this.getDeployedModule(modInfo.moduleInfo);
            this.futureMonitor.onCompletion(deployedMod.installModule(this, this.futureMonitor, modInfo.getType()), (CompletionListener)listener);
            if (listener.isFailed()) {
                this.uninstallApp();
                return false;
            }
            if (modInfo.nestedModules == null) continue;
            for (DeployedModuleInfoImpl nestedMod : modInfo.nestedModules) {
                nestedMod.installModule(this, null, null);
            }
        }
        return true;
    }

    protected ClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration config) {
        ClassLoader classLoader = this.libraryConfigHelper.createTopLevelClassLoader(classPath, gwConfig, config, this.classLoadingService, this.globalSharedLibrary);
        this.associateClassLoaderWithApp(classLoader);
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean associateClassLoaderWithApp(ClassLoader loader) {
        boolean success;
        block2: {
            try {
                ClassLoadingButler butler = (ClassLoadingButler)this.appInfo.getContainer().adapt(ClassLoadingButler.class);
                butler.addClassLoader(loader);
                success = true;
            }
            catch (Exception butler) {
                void ex;
                FFDCFilter.processException((Throwable)butler, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase", (String)"485", (Object)this, (Object[])new Object[]{loader});
                success = false;
                if (!_tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)_tc, (String)"Failed to associate this app with a its loader via the ClassLoadingButler", (Object[])new Object[]{ex});
            }
        }
        return success;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    protected ProtectionDomain getProtectionDomain() {
        CodeSource codesource;
        Permissions perms;
        block6: {
            perms = new Permissions();
            if (!this.java2SecurityEnabled()) {
                ((PermissionCollection)perms).add(new AllPermission());
            } else {
                if (this.permissionsConfig != null) {
                    List configuredPermissions = this.permissionsConfig.getPermissions();
                    this.addPermissions(configuredPermissions);
                }
                ArrayList mergedPermissions = this.permissionManager.getEffectivePermissions(this.applicationInformation.getLocation());
                int count = mergedPermissions.size();
                for (int i = 0; i < count; ++i) {
                    ((PermissionCollection)perms).add((Permission)mergedPermissions.get(i));
                }
            }
            try {
                String loc = this.applicationInformation.getLocation();
                codesource = new CodeSource(new URL("file://" + (loc.startsWith("/") ? "" : "/") + loc), (Certificate[])null);
            }
            catch (MalformedURLException e) {
                codesource = null;
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)_tc, (String)"Code Source could not be set. Setting it to null.", (Object[])new Object[]{e});
            }
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(codesource, perms);
        return protectionDomain;
    }

    private void addPermissions(List<com.ibm.ws.javaee.dd.permissions.Permission> configuredPermissions) {
        Permission[] permissions = new Permission[configuredPermissions.size()];
        String codeBase = this.applicationInformation.getLocation();
        int count = 0;
        for (com.ibm.ws.javaee.dd.permissions.Permission permission : configuredPermissions) {
            Permission perm = this.permissionManager.createPermissionObject(permission.getClassName(), permission.getName(), permission.getActions(), null, null, null, PERMISSION_XML);
            if (perm == null) continue;
            permissions[count++] = perm;
            this.permissionManager.addPermissionsXMLPermission(codeBase, perm);
        }
    }

    private boolean java2SecurityEnabled() {
        SecurityManager sm = System.getSecurityManager();
        return sm != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class DeployModulesListener
    implements CompletionListener<Boolean> {
        private final Future<Boolean> aggregateResultFuture;
        private int remaining;
        private volatile boolean aggregateResult;
        static final long serialVersionUID = -6934804456392138684L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeployModulesListener(Future<Boolean> aggregateResultFuture) {
            this.remaining = DeployedAppInfoBase.this.moduleContainerInfos.size();
            this.aggregateResult = true;
            this.aggregateResultFuture = aggregateResultFuture;
        }

        public synchronized void successfulCompletion(Future<Boolean> future, Boolean result) {
            this.aggregateResult &= result.booleanValue();
            if (--this.remaining == 0) {
                DeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, (Object)this.aggregateResult);
            }
        }

        public synchronized void failedCompletion(Future<Boolean> future, Throwable t) {
            DeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, t);
            this.aggregateResult = false;
        }

        public boolean isFailed() {
            return !this.aggregateResult;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DeployModulesListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class SharedLibDeploymentInfo {
        private final BundleContext bundleContext;
        private final WsLocationAdmin locAdmin;
        private final ArtifactContainerFactory artifactFactory;
        private final AdaptableModuleFactory moduleFactory;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = -9033256786848720484L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SharedLibDeploymentInfo(DeployedAppInfoFactoryBase factory, String parentPid) {
            this.bundleContext = factory.getBundleContext();
            this.locAdmin = factory.getLocationAdmin();
            this.artifactFactory = factory.getArtifactFactory();
            this.moduleFactory = factory.getModuleFactory();
            try {
                StringBuilder classloaderFilter = new StringBuilder(200);
                classloaderFilter.append("(&");
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
                classloaderFilter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
                classloaderFilter.append(')');
                Configuration[] classloaderConfigs = factory.getConfigurationAdmin().listConfigurations(classloaderFilter.toString());
                if (classloaderConfigs != null && classloaderConfigs.length == 1) {
                    Configuration cfg = classloaderConfigs[0];
                    Dictionary props = cfg.getProperties();
                    if (props != null) {
                        String[] libraryPIDs = (String[])props.get("privateLibraryRef");
                        this.processLibraryPIDs(this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.PRIVATE_LIB);
                        libraryPIDs = (String[])props.get("commonLibraryRef");
                        this.processLibraryPIDs(this.classesContainerInfo, libraryPIDs, LibraryContainerInfo.LibraryType.COMMON_LIB);
                    } else {
                        cfg.delete();
                        return;
                    }
                }
                if (this.classesContainerInfo.isEmpty()) {
                    this.addLibraryContainers(this.classesContainerInfo, factory.getGlobalSharedLibraryPid(), LibraryContainerInfo.LibraryType.GLOBAL_LIB, factory.getGlobalSharedLibrary());
                }
            }
            catch (IOException classloaderFilter) {
                FFDCFilter.processException((Throwable)classloaderFilter, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"165", (Object)this, (Object[])new Object[]{factory, parentPid});
                return;
            }
            catch (InvalidSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase$SharedLibDeploymentInfo", (String)"168", (Object)this, (Object[])new Object[]{factory, parentPid});
                return;
            }
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        private void processLibraryPIDs(List<ContainerInfo> sharedLibContainers, String[] libraryPIDs, LibraryContainerInfo.LibraryType libType) throws InvalidSyntaxException {
            if (libraryPIDs != null) {
                for (String pid : libraryPIDs) {
                    String libraryFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)pid);
                    Collection libraryRefs = this.bundleContext.getServiceReferences(Library.class, libraryFilter);
                    for (ServiceReference libraryRef : libraryRefs) {
                        Library library = (Library)this.bundleContext.getService(libraryRef);
                        this.addLibraryContainers(sharedLibContainers, pid, libType, library);
                    }
                }
            }
        }

        private void addLibraryContainers(List<ContainerInfo> sharedLibContainers, String pid, LibraryContainerInfo.LibraryType libType, Library library) {
            if (library != null) {
                String libName = library.id();
                SharedLibClassesContainerInfo libClassesInfo = new SharedLibClassesContainerInfo(libType, library, "/" + libName);
                Collection files = library.getFiles();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, files);
                Collection folders = library.getFolders();
                this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, folders);
                Collection filesets = library.getFilesets();
                for (Fileset fileset : filesets) {
                    this.addContainers(libClassesInfo.getClassesContainerInfo(), pid, libName, fileset.getFileset());
                }
                if (!libClassesInfo.getClassesContainerInfo().isEmpty()) {
                    sharedLibContainers.add((ContainerInfo)libClassesInfo);
                }
            }
        }

        private void addContainers(List<ContainerInfo> sharedLibContainers, String pid, String libName, Collection<File> files) {
            if (files != null) {
                for (File file : files) {
                    final Container container = this.setupContainer(pid, file);
                    if (container == null) continue;
                    final String name = "/" + libName + "/" + file.getName();
                    sharedLibContainers.add(new ContainerInfo(){
                        static final long serialVersionUID = -6809503652722008649L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.SHARED_LIB;
                        }

                        public String getName() {
                            return name;
                        }

                        public Container getContainer() {
                            return container;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                }
            }
        }

        private Container setupContainer(String pid, File locationFile) {
            if (!FileUtils.fileExists((File)locationFile)) {
                return null;
            }
            File cacheDir = new File(this.getCacheDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDir)) {
                return null;
            }
            ArtifactContainer artifactContainer = this.artifactFactory.getContainer(cacheDir, (Object)locationFile);
            if (artifactContainer == null) {
                return null;
            }
            File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
                return null;
            }
            File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
                return null;
            }
            return this.moduleFactory.getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        }

        private File getCacheAdaptDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheAdapt");
        }

        private File getCacheOverlayDir() {
            return this.locAdmin.getBundleFile((Object)this, "cacheOverlay");
        }

        private File getCacheDir() {
            return this.locAdmin.getBundleFile((Object)this, "cache");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibDeploymentInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class SharedLibClassesContainerInfo
    implements LibraryClassesContainerInfo {
        private final LibraryContainerInfo.LibraryType libType;
        private final Library sharedLib;
        private final String libName;
        private final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 6112678435634051759L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SharedLibClassesContainerInfo(LibraryContainerInfo.LibraryType libType, Library sharedLib, String libName) {
            this.sharedLib = sharedLib;
            this.libName = libName;
            this.libType = libType;
        }

        public ContainerInfo.Type getType() {
            return ContainerInfo.Type.SHARED_LIB;
        }

        public String getName() {
            return this.libName;
        }

        public Container getContainer() {
            return null;
        }

        public LibraryContainerInfo.LibraryType getLibraryType() {
            return this.libType;
        }

        public ClassLoader getClassLoader() {
            return this.sharedLib.getClassLoader();
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SharedLibClassesContainerInfo.class);
        }
    }
}

