/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.principal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.context.SubjectManager;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Alternative
@Priority(value=100)
@RequestScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PrincipalBean
implements JsonWebToken {
    private static final TraceComponent tc = Tr.register(PrincipalBean.class);
    Principal principal = null;
    JsonWebToken jsonWebToken = null;
    private final PrivilegedExceptionAction getCallerSubjectAction = new PrivilegedExceptionAction(){
        static final long serialVersionUID = -725788710681712112L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Object run() throws Exception {
            return new SubjectManager().getCallerSubject();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = -2538428211128229945L;

    @ManualTrace
    public PrincipalBean() {
        Subject subject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PrincipalBean", (Object[])new Object[0]);
        }
        if ((subject = this.getCallerSubject()) != null) {
            Set<Principal> principals;
            Set<JsonWebToken> jsonWebTokens = subject.getPrincipals(JsonWebToken.class);
            if (!jsonWebTokens.isEmpty()) {
                this.jsonWebToken = jsonWebTokens.iterator().next();
                this.principal = this.jsonWebToken;
            }
            if (this.jsonWebToken == null && !(principals = subject.getPrincipals(Principal.class)).isEmpty()) {
                this.principal = principals.iterator().next();
            }
        }
        if (this.principal == null) {
            Tr.error((TraceComponent)tc, (String)"MPJWT_CDI_PRINCIPAL_UNAVAILABLE", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PrincipalBean", (Object)this.principal);
        }
    }

    public <T> Optional<T> claim(String claimName) {
        Object claim = this.getClaim(claimName);
        return Optional.ofNullable(claim);
    }

    public Object getClaim(String claimName) {
        if (this.jsonWebToken != null) {
            return this.jsonWebToken.getClaim(claimName);
        }
        return null;
    }

    public Set<String> getClaimNames() {
        if (this.jsonWebToken != null) {
            return this.jsonWebToken.getClaimNames();
        }
        return null;
    }

    public String getName() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return null;
    }

    public Set<String> getAudience() {
        if (this.jsonWebToken != null) {
            return this.jsonWebToken.getAudience();
        }
        return null;
    }

    public Set<String> getGroups() {
        if (this.jsonWebToken != null) {
            return this.jsonWebToken.getGroups();
        }
        return null;
    }

    public String toString() {
        if (this.jsonWebToken != null) {
            return this.jsonWebToken.toString();
        }
        if (this.principal != null) {
            return this.principal.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Subject getCallerSubject() {
        Subject s;
        block2: {
            s = null;
            try {
                s = (Subject)AccessController.doPrivileged(this.getCallerSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                void pae;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.mp.jwt.principal.PrincipalBean", (String)"137", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("getCallerSubject(PrivilegedAction) Exception caught: " + pae), (Object[])new Object[0]);
            }
        }
        return s;
    }
}

