/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.FrameWriteProcessor;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.WsocWriteCallback;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MessageWriter {
    WsByteBuffer[] messageBuffers = null;
    FrameWriteProcessor frameWriteProcessor = null;
    WsocWriteCallback callback = null;
    TCPWriteRequestContext tcpWriteContext = null;
    boolean shouldMaskData = false;
    static final long serialVersionUID = 4435975865031881370L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void initialize(TCPWriteRequestContext _wrc, WsocWriteCallback _cb, boolean _shouldMaskData) {
        this.tcpWriteContext = _wrc;
        this.callback = _cb;
        this.shouldMaskData = _shouldMaskData;
    }

    public void WriteMessage(@Sensitive WsByteBuffer buffer, OpcodeType opcode, int timeout, WRITE_TYPE type) throws IOException {
        WsByteBuffer[] buffers = null;
        if (buffer != null) {
            buffers = new WsByteBuffer[]{buffer};
        }
        this.WriteMessage(buffers, opcode, timeout, type);
    }

    @FFDCIgnore(value={IOException.class})
    public void WriteMessage(@Sensitive WsByteBuffer[] buffers, OpcodeType opcode, int timeout, WRITE_TYPE type) throws IOException {
        if (buffers == null && timeout != -2) {
            return;
        }
        if (this.frameWriteProcessor == null) {
            this.frameWriteProcessor = new FrameWriteProcessor();
        }
        this.messageBuffers = this.frameWriteProcessor.formatForFrameMessage(buffers, opcode, this.shouldMaskData);
        this.tcpWriteContext.setBuffers(this.messageBuffers);
        if (type == WRITE_TYPE.SYNC) {
            try {
                this.WriteMessageSync(timeout);
            }
            catch (IOException x) {
                this.frameCleanup();
                throw x;
            }
            this.frameCleanup();
        } else {
            this.WriteMessageASync(timeout);
        }
    }

    public void frameCleanup() {
        this.frameWriteProcessor.cleanup();
    }

    public void cancelMessageAsync() throws IOException {
        this.tcpWriteContext.write(0L, -2);
    }

    private void WriteMessageSync(int timeout) throws IOException {
        this.tcpWriteContext.write(-1L, timeout);
    }

    private void WriteMessageASync(int timeout) {
        if (this.callback == null) {
            this.callback = new WsocWriteCallback();
        }
        this.tcpWriteContext.write(-1L, (TCPWriteCompletedCallback)this.callback, true, timeout);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MessageWriter.class);
    }

    @Trivial
    public static enum WRITE_TYPE {
        SYNC,
        ASYNC;

    }
}

