/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.request;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.extended.IRequestExtended;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.util.IteratorEnumerator;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.SSLContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;

public class IRequestImpl
implements IRequestExtended {
    private static final TraceComponent tc = Tr.register(IRequestImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private HttpInboundConnection conn = null;
    protected HttpRequest request = null;
    private boolean startAsync;
    private ReentrantLock asyncLock;
    private String serverName = null;
    private int serverPort = -1;
    private boolean isHttpsIndicatorSecure;
    private boolean isHttpsIndicatorSecureSet;
    private String normalizedURI = null;
    private static boolean normalizeRequestURI = WCCustomProperties.NORMALIZE_REQUEST_URI;

    public IRequestImpl(HttpInboundConnection connection) {
        this.conn = connection;
        this.request = connection.getRequest();
    }

    @Override
    public void clearHeaders() {
    }

    @Override
    public List<String> getAllCookieValues(String cookieName) {
        List cookies = this.request.getCookies(cookieName);
        ArrayList<String> values = new ArrayList<String>(cookies.size());
        for (HttpCookie cookie : cookies) {
            values.add(cookie.getValue());
        }
        return values;
    }

    @Override
    public String getAuthType() {
        String type = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSAT.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("type=" + type), (Object[])new Object[0]);
        }
        return type;
    }

    @Override
    public String getCipherSuite() {
        if (this.conn.useTrustedHeaders()) {
            String csHdr = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSCS.getName());
            if (csHdr != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getCipherSuite isTrusted --> true suite --> " + csHdr), (Object[])new Object[0]);
                }
                return csHdr;
            }
            if (this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSRA.getName()) != null) {
                return null;
            }
        }
        return this.getConnectionCipherSuite();
    }

    public String getConnectionCipherSuite() {
        String suite = null;
        SSLContext ssl = this.conn.getSSLContext();
        if (null != ssl && ssl.getSession() != null) {
            suite = ssl.getSession().getCipherSuite();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getConnectionCipherSuite suite --> " + suite), (Object[])new Object[0]);
        }
        return suite;
    }

    public Boolean checkForDirectConnection() {
        boolean direct = true;
        if (this.request.getHeader(HttpHeaderKeys.HDR_$WSRA.getName()) != null) {
            direct = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkForDirectConnection return --> " + direct), (Object[])new Object[0]);
        }
        return direct;
    }

    @Override
    public int getContentLength() {
        long rc = this.request.getContentLength();
        if (rc > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)rc;
    }

    @Override
    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    @Override
    public byte[] getCookieValue(String cookieName) {
        HttpCookie cookie = this.request.getCookie(cookieName);
        if (null != cookie) {
            return cookie.getValue().getBytes();
        }
        return null;
    }

    @Override
    public Cookie[] getCookies() {
        List cookies;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCookies ENTRY", (Object[])new Object[0]);
        }
        if ((cookies = this.request.getCookies()).size() == 0) {
            return null;
        }
        Cookie[] rc = new Cookie[cookies.size()];
        int i = 0;
        int t = 0;
        for (HttpCookie cookie : cookies) {
            Cookie newCookie;
            try {
                newCookie = new Cookie(cookie.getName(), cookie.getValue());
            }
            catch (IllegalArgumentException iae) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid cookie name: " + cookie.getName()), (Object[])new Object[0]);
                }
                ++t;
                continue;
            }
            if (cookie.getDomain() != null && !cookie.getDomain().equals("")) {
                newCookie.setDomain(cookie.getDomain());
            }
            newCookie.setComment(cookie.getComment());
            newCookie.setHttpOnly(cookie.isHttpOnly());
            newCookie.setMaxAge(cookie.getMaxAge());
            newCookie.setPath(cookie.getPath());
            newCookie.setVersion(cookie.getVersion());
            newCookie.setSecure(cookie.isSecure());
            rc[i++] = newCookie;
        }
        if (t == 0) {
            return rc;
        }
        if (t == cookies.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No valid cookies", (Object[])new Object[0]);
            }
            return null;
        }
        Cookie[] ca = new Cookie[cookies.size() - t];
        System.arraycopy(rc, 0, ca, 0, ca.length);
        return ca;
    }

    @Override
    @FFDCIgnore(value={ParseException.class})
    public long getDateHeader(String name) {
        String value = this.request.getHeader(name);
        if (null != value) {
            try {
                Date rc = this.conn.getDateFormatter().parseTime(value);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(name + " " + rc.getTime()), (Object[])new Object[0]);
                }
                return rc.getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(value, e);
            }
        }
        return -1L;
    }

    @Override
    public String getHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    public Enumeration getHeaderNames() {
        List names = this.request.getHeaderNames();
        return new IteratorEnumerator(names.iterator());
    }

    @Override
    public Enumeration getHeaders(String headerName) {
        List values = this.request.getHeaders(headerName);
        return new IteratorEnumerator(values.iterator());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getBody();
    }

    @Override
    public int getIntHeader(String name) {
        int rc = -1;
        String value = this.request.getHeader(name);
        if (null != value) {
            rc = Integer.parseInt(value.trim());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(name + " " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public String getLocalAddr() {
        return this.conn.getLocalHostAddress();
    }

    @Override
    public String getLocalName() {
        return this.conn.getLocalHostName(true);
    }

    @Override
    public int getLocalPort() {
        return this.conn.getLocalPort();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    private java.security.cert.X509Certificate[] convertCertToChain(java.security.cert.X509Certificate rootCert) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertCertToChain", (Object[])new Object[]{""});
        }
        java.security.cert.X509Certificate[] chain = null;
        if (rootCert != null) {
            chain = new java.security.cert.X509Certificate[]{rootCert};
        }
        return chain;
    }

    private String armor(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----BEGIN CERTIFICATE-----\r\n");
        for (int begin = 0; begin < str.length(); begin += 76) {
            int end = Math.min(begin + 76, str.length());
            sb.append(str.substring(begin, end) + "\r\n");
        }
        sb.append("-----END CERTIFICATE-----\r\n");
        String buffer = sb.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"armor", (Object[])new Object[]{" " + buffer});
        }
        return buffer;
    }

    @Override
    @FFDCIgnore(value={SSLPeerUnverifiedException.class})
    public java.security.cert.X509Certificate[] getPeerCertificates() {
        try {
            java.security.cert.X509Certificate[] chain = null;
            if (this.conn.useTrustedHeaders()) {
                String clientCertificate = this.request.getHeader(HttpHeaderKeys.HDR_$WSCC.getName());
                if (clientCertificate != null) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream inStream = new ByteArrayInputStream(this.armor(clientCertificate).getBytes());
                    java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(inStream);
                    chain = this.convertCertToChain(cert);
                    return chain;
                }
                if (this.request.getHeader(HttpHeaderKeys.HDR_$WSRA.getName()) != null) {
                    return null;
                }
            }
            chain = this.getConnectionPeerCertificates();
            return chain;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)this.getClass().getName(), (String)"peercerts", (Object[])new Object[]{this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                TraceComponent tc_twas = Tr.register(IRequestImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
                Tr.error((TraceComponent)tc_twas, (String)"invalid.peer.certificate", (Object[])new Object[]{exc.toString()});
            }
            return null;
        }
    }

    public java.security.cert.X509Certificate[] getConnectionPeerCertificates() throws Exception {
        java.security.cert.X509Certificate[] rc;
        block7: {
            rc = null;
            SSLContext ssl = this.conn.getSSLContext();
            if (null != ssl && (ssl.getNeedClientAuth() || ssl.getWantClientAuth())) {
                try {
                    Object[] objs = ssl.getSession().getPeerCertificates();
                    if (objs != null) {
                        rc = (java.security.cert.X509Certificate[])objs;
                    } else {
                        objs = ssl.getSession().getPeerCertificateChain();
                        if (objs != null) {
                            rc = this.convertCertificateChain((X509Certificate[])objs);
                        }
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"No certificates in the SSLSession", (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"certs->", (Object[])rc);
        }
        return rc;
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] inChain) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertCertificateChain", (Object[])new Object[]{""});
        }
        java.security.cert.X509Certificate[] outChain = new java.security.cert.X509Certificate[inChain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int idx = 0; idx < inChain.length; ++idx) {
            outChain[idx] = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(inChain[idx].getEncoded()));
        }
        return outChain;
    }

    @Override
    public String getProtocol() {
        String protocol = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSPR.getName());
        if (protocol != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProtocol isTrusted --> true, protocol --> " + protocol), (Object[])new Object[0]);
            }
        } else {
            protocol = this.request.getVersion();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProtocol protocol --> " + protocol), (Object[])new Object[0]);
            }
        }
        return protocol;
    }

    @Override
    public String getQueryString() {
        return this.request.getQuery();
    }

    @Override
    public String getRemoteAddr() {
        return this.conn.getRemoteHostAddress();
    }

    @Override
    public String getRemoteHost() {
        return this.conn.getRemoteHostName(true);
    }

    @Override
    public int getRemotePort() {
        return this.conn.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        String user = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSRU.getName());
        return user;
    }

    @Override
    public String getRequestURI() {
        String uri = null;
        if (normalizeRequestURI) {
            if (this.normalizedURI != null) {
                uri = this.normalizedURI;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{"Use previously normalized request uri --> " + this.normalizedURI});
                }
            } else {
                uri = this.request.getURI();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{"normalize request uri --> ", uri});
                }
                this.normalizedURI = uri = WebApp.normalize(uri);
            }
        } else {
            uri = this.request.getURI();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{" uri --> " + uri});
        }
        return uri;
    }

    @Override
    public byte[] getSSLSessionID() {
        byte[] rc = null;
        String sslHdr = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSSI.getName());
        if (sslHdr != null) {
            rc = sslHdr.getBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSSLSessionID , trusted found " + sslHdr), (Object[])new Object[0]);
            }
            return rc;
        }
        SSLContext ssl = this.conn.getSSLContext();
        if (null != ssl) {
            rc = ssl.getSession().getId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSSLSessionID , trusted not found", (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public String getScheme() {
        if (this.conn.useTrustedHeaders()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getScheme: useTrustedHeaders is true", (Object[])new Object[0]);
            }
            if (this.isHttpsIndicatorSecure()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" isTrusted --> true, isHttpsIndicatorSecure --> true, scheme --> https", (Object[])new Object[0]);
                }
                return "https";
            }
            String WSSC_header = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSSC.getName());
            if (WSSC_header != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true, containsHeader --> $WSSC, scheme --> " + WSSC_header), (Object[])new Object[0]);
                }
                return WSSC_header;
            }
            String WSIS_header = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSIS.getName());
            if (WSIS_header != null) {
                if (WSIS_header.equalsIgnoreCase("true")) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" isTrusted --> true --> containsHeader --> $WSIS  --> scheme --> https", (Object[])new Object[0]);
                    }
                    return "https";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" isTrusted --> true --> containsHeader --> $WSIS  --> scheme --> http", (Object[])new Object[0]);
                }
                return "http";
            }
            String FORWARDED_PROTO_header = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_X_FORWARDED_PROTO.getName());
            if (FORWARDED_PROTO_header != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto  --> scheme --> " + FORWARDED_PROTO_header), (Object[])new Object[0]);
                }
                return FORWARDED_PROTO_header;
            }
        }
        String scheme = this.request.getScheme();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("scheme --> " + scheme), (Object[])new Object[0]);
        }
        return scheme;
    }

    @Override
    public String getServerName() {
        String name = this.serverName;
        if (null == name) {
            name = this.serverName = this.conn.getRequestedHost();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("name=" + name), (Object[])new Object[0]);
        }
        return name;
    }

    @Override
    public int getServerPort() {
        int port = this.serverPort;
        if (-1 == port) {
            port = this.serverPort = this.conn.getRequestedPort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("port=" + port), (Object[])new Object[0]);
        }
        return port;
    }

    private boolean isHttpsIndicatorSecure() {
        if (!this.isHttpsIndicatorSecureSet) {
            if (WCCustomProperties.HTTPS_INDICATOR_HEADER != null && this.getHeader(WCCustomProperties.HTTPS_INDICATOR_HEADER) != null) {
                this.isHttpsIndicatorSecure = true;
                String host = this.getHeader("Host");
                if (host != null) {
                    int idx = host.indexOf(58);
                    if (idx != -1) {
                        int len = host.length();
                        int sp = 0;
                        for (int i = idx + 1; i < len; ++i) {
                            sp = sp * 10 + host.charAt(i) - 48;
                        }
                        this.serverPort = sp;
                    } else {
                        this.serverPort = 443;
                    }
                }
            } else {
                this.isHttpsIndicatorSecure = false;
            }
            this.isHttpsIndicatorSecureSet = true;
        }
        return this.isHttpsIndicatorSecure;
    }

    @Override
    public String getSessionID() {
        return null;
    }

    @Override
    public boolean getShouldDestroy() {
        return false;
    }

    @Override
    public IResponse getWCCResponse() {
        return null;
    }

    @Override
    public boolean isProxied() {
        return false;
    }

    @Override
    public boolean isSSL() {
        boolean ssl = false;
        if (this.conn.useTrustedHeaders()) {
            if (this.isHttpsIndicatorSecure()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" isTrusted --> true, isHttpsIndicatorSecure --> true ssl --> true", (Object[])new Object[0]);
                }
                return true;
            }
            String WSIS_header = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_$WSIS.getName());
            if (WSIS_header != null) {
                ssl = WSIS_header.equalsIgnoreCase("true");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true ssl --> " + ssl), (Object[])new Object[0]);
                }
                return ssl;
            }
            String FORWARDED_PROTO_header = this.conn.getTrustedHeader(HttpHeaderKeys.HDR_X_FORWARDED_PROTO.getName());
            if (FORWARDED_PROTO_header != null && (FORWARDED_PROTO_header.equalsIgnoreCase("https") || FORWARDED_PROTO_header.equalsIgnoreCase("wss"))) {
                ssl = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto  --> " + FORWARDED_PROTO_header + " ssl --> " + ssl), (Object[])new Object[0]);
                }
                return ssl;
            }
        }
        boolean bl = ssl = null != this.conn.getSSLContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" ssl --> " + ssl), (Object[])new Object[0]);
        }
        return ssl;
    }

    @Override
    public boolean isStartAsync() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(this.startAsync), (Object[])new Object[0]);
        }
        return this.startAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        IRequestImpl iRequestImpl = this;
        synchronized (iRequestImpl) {
            if (this.asyncLock == null) {
                this.asyncLock = new ReentrantLock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lock asyncLock: " + this.asyncLock), (Object[])new Object[0]);
        }
        this.asyncLock.lock();
    }

    @Override
    public void removeHeader(String headerName) {
    }

    @Override
    public void setShouldClose(boolean flag) {
    }

    @Override
    public void setShouldDestroy(boolean shouldDestroy) {
    }

    @Override
    public void setShouldReuse(boolean flag) {
    }

    @Override
    public void startAsync() {
        this.startAsync = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(this.startAsync), (Object[])new Object[0]);
        }
    }

    @Override
    public void unlock() {
        if (this.asyncLock != null && this.asyncLock.isHeldByCurrentThread()) {
            this.asyncLock.unlock();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unlock asyncLock: " + this.asyncLock), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public ThreadPool getThreadPool() {
        return null;
    }

    @Override
    public HttpInboundConnection getHttpInboundConnection() {
        return this.conn;
    }
}

