/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.util.ExtDocRootFile;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileResource
implements ExtDocRootFile {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.ZipFileResource";
    private String entry;
    private File jarFile;
    private URL url;

    public ZipFileResource(File jarFile, String entry) {
        this.entry = entry;
        this.jarFile = jarFile;
    }

    public ZipFileResource(File jarFile, String entry, URL url) {
        this.entry = entry;
        this.jarFile = jarFile;
        this.url = url;
    }

    @Override
    public InputStream getIS() throws IOException {
        ZipFile zip = new ZipFile(this.jarFile);
        ZipEntry zEntry = zip.getEntry(this.entry);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIS", "return ZipFileResource inputstream zip -->" + this.jarFile + " entry -->" + this.entry);
        }
        return zip.getInputStream(zEntry);
    }

    public File getMatch() {
        return this.jarFile;
    }

    @Override
    public long getLastModified() {
        return this.jarFile.lastModified();
    }

    @Override
    public String getPath() {
        return this.jarFile.getAbsolutePath();
    }

    public ZipFile getZipFile() {
        try {
            return new ZipFile(this.jarFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ZipEntry getZipEntry() {
        try {
            return new ZipFile(this.jarFile).getEntry(this.entry);
        }
        catch (Exception e) {
            return null;
        }
    }

    public URL getURL() {
        return this.url;
    }
}

