/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.BaseConfiguration;
import com.ibm.ws.container.ErrorPage;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.common.DataSource;
import com.ibm.ws.javaee.dd.common.EJBRef;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.dd.common.MessageDestinationRef;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.javaee.dd.common.ResourceEnvRef;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.ws.javaee.dd.webext.Attribute;
import com.ibm.ws.javaee.dd.webext.MimeFilter;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.session.SessionCookieConfigImpl;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.util.MetaInfResourceFinder;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefBindingHelper;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.filter.IFilterMapping;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;

public abstract class WebAppConfiguration
extends BaseConfiguration
implements WebAppConfigExtended {
    private static final String CLASS_NAME = WebAppConfiguration.class.getName();
    private static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final TraceComponent tc = Tr.register(WebAppConfiguration.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS(WebAppConfiguration.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private int version;
    private String contextRoot;
    private boolean isDefaultContextRootUsed;
    private int sessionTimeout = 0;
    private boolean moduleSessionTimeoutSet = false;
    private boolean moduleSessionTrackingModeSet = false;
    private SessionCookieConfigImpl sessionCookieConfig;
    private boolean hasProgrammaticCookieConfig = false;
    private EnumSet<SessionTrackingMode> sessionDefaultTrackingModeSet;
    private SessionManagerConfig sessionManagerConfig;
    private String displayName;
    private String description;
    private int reloadInterval;
    private boolean distributable;
    private boolean denyUncoveredHttpMethods;
    private boolean reloadingEnabled;
    private Boolean serveServletsByClassnameEnabled;
    private String defaultErrorPage;
    private String additionalClassPath;
    private Boolean fileServingEnabled;
    private Boolean directoryBrowsingEnabled;
    private boolean autoRequestEncoding;
    private boolean autoResponseEncoding;
    private boolean autoLoadFilters;
    private Map requestListeners;
    private Map requestAttributeListeners;
    private Map sessionListeners;
    private HashMap localeMap;
    private String moduleName;
    private String j2eeModuleName;
    private String moduleId;
    private boolean isSyncToThreadEnabled;
    private boolean encodeDispatchedRequestURI;
    private boolean isSystemApp;
    private boolean ardEnabled;
    private String ardDispatchType;
    private ArrayList listeners = new ArrayList();
    private List<String> welcomeFileList = new ArrayList<String>();
    private Map<String, List<String>> servletMappings;
    private int lastIndexBeforeDeclaredFilters = 0;
    private List<IFilterMapping> filterMappings;
    private Map<String, IServletConfig> servletInfo;
    private Map<String, IFilterConfig> filterInfo;
    private Map<String, String> mimeMappings = new HashMap<String, String>();
    private HashMap mimeFilters;
    private boolean isMimeFilteringEnabled = false;
    public WebGroup theWebGroup;
    private Map<String, String> jspAttributes = null;
    private HashMap fileServingAttributes = new HashMap();
    private HashMap invokerAttributes = new HashMap();
    private HashMap contextParams = new HashMap();
    private String virtualHost;
    private HashMap exceptionErrorPages = new HashMap();
    private HashMap codeErrorPages = new HashMap();
    private List tagLibList;
    private boolean precompileJsps;
    protected WebApp webApp;
    private List<String> virtualHostList = Collections.emptyList();
    private int appStartupWeight;
    private int moduleStartupWeight;
    private boolean metaDataComplete;
    private List<Class<?>> classesToScan;
    private List<IFilterMapping> uriFilterMappingInfos;
    private List<IFilterMapping> servletFilterMappingInfos;
    private Map<String, ServletRegistration.Dynamic> dynamicServletRegistrationMap;
    private String applicationName;
    private List<String> libBinPathList;
    private Set<String> webXmlDefinedListeners = new HashSet<String>();
    private Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs = new EnumMap<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>>(JNDIEnvironmentRefType.class);
    private Map<JNDIEnvironmentRefType, Map<String, String>> allRefBindings = JNDIEnvironmentRefBindingHelper.createAllBindingsMap();
    private Map<String, String> envEntryValues;
    private ResourceRefConfigList resourceRefConfigList;
    private static String disallowAllFileServingProp;
    private static String disallowServeServletsByClassnameProp;
    private boolean disableStaticMappingCache = false;
    private Map jspCachedLocations = null;
    private String primedSTSHeader = null;
    private boolean enablemultireadofpostdata = false;
    private String requestEncoding = null;
    private String responseEncoding = null;
    private static final String NULLSERVLETNAME = "com.ibm.ws.webcontainer.NullServletName";

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public WebAppConfiguration(String id) {
        super(id);
        this.servletInfo = new ConcurrentHashMap<String, IServletConfig>();
        this.servletMappings = new HashMap<String, List<String>>();
        this.filterInfo = new HashMap<String, IFilterConfig>();
        this.filterMappings = new ArrayList<IFilterMapping>();
        this.classesToScan = new ArrayList();
    }

    public String getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    @Override
    public List getVirtualHostList() {
        return this.virtualHostList;
    }

    @Override
    public Iterator getServletNames() {
        return this.servletInfo.keySet().iterator();
    }

    @Override
    public void addServletInfo(String name, IServletConfig info) {
        if (name == null || name.isEmpty()) {
            Tr.debug((TraceComponent)tc, (String)"addServletInfo", (Object[])new Object[]{"servlet name is null/empty. Use internal servlet name com.ibm.ws.webcontainer.NullServletName"});
            name = NULLSERVLETNAME;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addServletInfo", "servlet name: " + name);
        }
        this.servletInfo.put(name, info);
    }

    public void removeServletInfo(String name) {
        if (name == null || name.isEmpty()) {
            Tr.debug((TraceComponent)tc, (String)"removeServletInfo", (Object[])new Object[]{"servlet name is null/empty. Use internal servlet name com.ibm.ws.webcontainer.NullServletName"});
            name = NULLSERVLETNAME;
        }
        this.servletInfo.remove(name);
    }

    @Override
    public Iterator<IServletConfig> getServletInfos() {
        return this.servletInfo.values().iterator();
    }

    @Override
    public Iterator<IFilterConfig> getFilterInfos() {
        return this.filterInfo.values().iterator();
    }

    public boolean isAutoRequestEncoding() {
        return this.autoRequestEncoding;
    }

    @Override
    public boolean isAutoResponseEncoding() {
        return this.autoResponseEncoding;
    }

    public String getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    public boolean isDirectoryBrowsingEnabled() {
        if (this.directoryBrowsingEnabled != null) {
            return this.directoryBrowsingEnabled;
        }
        this.directoryBrowsingEnabled = WCCustomProperties.DIRECTORY_BROWSING_ENABLED;
        return this.directoryBrowsingEnabled;
    }

    public boolean isFileServingEnabled() {
        disallowAllFileServingProp = WCCustomProperties.DISALLOW_ALL_FILE_SERVING;
        if (disallowAllFileServingProp != null && !this.getApplicationName().equalsIgnoreCase("isclite")) {
            try {
                if (Boolean.valueOf(disallowAllFileServingProp).booleanValue()) {
                    this.fileServingEnabled = Boolean.FALSE;
                }
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isFileServing", "PK54499: disallowAllFileServingProp set to " + disallowAllFileServingProp + " for application: " + this.getApplicationName());
                }
            }
            catch (Exception x) {
                logger.logp(Level.SEVERE, CLASS_NAME, "isFileServing", "Illegal value set for property com.ibm.ws.webcontainer.disallowallfileserving");
            }
        }
        if (this.fileServingEnabled != null) {
            return this.fileServingEnabled;
        }
        return WCCustomProperties.FILE_SERVING_ENABLED;
    }

    public Map getMimeMappings() {
        return this.mimeMappings;
    }

    public boolean isReloadingEnabled() {
        return this.reloadingEnabled;
    }

    public int getReloadInterval() {
        return this.reloadInterval;
    }

    public Map getRequestAttributeListeners() {
        return this.requestAttributeListeners;
    }

    public Map getRequestListeners() {
        return this.requestListeners;
    }

    public Map getSessionListeners() {
        return this.sessionListeners;
    }

    public void setAdditionalClassPath(String additionalClassPath) {
        this.additionalClassPath = additionalClassPath;
    }

    public void setAutoRequestEncoding(boolean autoRequestEncoding) {
        this.autoRequestEncoding = autoRequestEncoding;
    }

    public void setAutoResponseEncoding(boolean autoResponseEncoding) {
        this.autoResponseEncoding = autoResponseEncoding;
    }

    public void setDefaultErrorPage(String defaultErrorPage) {
        this.defaultErrorPage = defaultErrorPage;
    }

    public void setDirectoryBrowsingEnabled(Boolean directoryBrowsingEnabled) {
        this.directoryBrowsingEnabled = directoryBrowsingEnabled;
    }

    public void setFileServingEnabled(Boolean fileServingEnabled) {
        this.fileServingEnabled = fileServingEnabled;
    }

    public void setMimeMappings(HashMap mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public void setReloadingEnabled(boolean reloadingEnabled) {
        this.reloadingEnabled = reloadingEnabled;
    }

    public void setReloadInterval(int reloadInterval) {
        this.reloadInterval = reloadInterval;
    }

    public void setRequestAttributeListeners(Map requestAttributeListeners) {
        this.requestAttributeListeners = requestAttributeListeners;
    }

    public void setRequestListeners(Map requestListeners) {
        this.requestListeners = requestListeners;
    }

    public void setSessionListeners(Map sessionListeners) {
        this.sessionListeners = sessionListeners;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Map<String, String> getJspAttributes() {
        if (null == this.jspAttributes) {
            this.jspAttributes = new HashMap<String, String>();
        }
        return this.jspAttributes;
    }

    public void setJspAttributes(Map<String, String> jspAttributes) {
        this.jspAttributes = jspAttributes;
    }

    public String toString() {
        return this.displayName;
    }

    public HashMap getContextParams() {
        return this.contextParams;
    }

    public void setContextParams(HashMap contextParams) {
        this.contextParams = contextParams;
    }

    @Override
    public IServletConfig getServletInfo(String string) {
        if (string == null || string.isEmpty()) {
            Tr.debug((TraceComponent)tc, (String)"getServletInfo", (Object[])new Object[]{"servlet name is null/empty. Use internal servlet name com.ibm.ws.webcontainer.NullServletName"});
            string = NULLSERVLETNAME;
        }
        return this.servletInfo.get(string);
    }

    public HashMap getFileServingAttributes() {
        return this.fileServingAttributes;
    }

    public void setFileServingAttributes(HashMap fileServingAttributes) {
        this.fileServingAttributes = fileServingAttributes;
    }

    public boolean isServeServletsByClassnameEnabled() {
        disallowServeServletsByClassnameProp = WCCustomProperties.DISALLOW_SERVE_SERVLETS_BY_CLASSNAME_PROP;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isServeServletsByClassnameEnabled", "disallowServeServletsByClassnameProp = " + disallowServeServletsByClassnameProp);
        }
        if (disallowServeServletsByClassnameProp != null) {
            try {
                if (Boolean.valueOf(disallowServeServletsByClassnameProp).booleanValue()) {
                    this.serveServletsByClassnameEnabled = Boolean.FALSE;
                }
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isServeServletsByClassnameEnabled", "PK52059: disallowServeServletsByClassnameProp set to " + disallowServeServletsByClassnameProp + " for application: " + this.getApplicationName());
                }
            }
            catch (Exception x) {
                logger.logp(Level.SEVERE, CLASS_NAME, "isServeServletsByClassnameEnabled", "Illegal value set for property com.ibm.ws.webcontainer.disallowserveservletsbyclassname");
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isServeServletsByClassnameEnabled", "value = " + (this.serveServletsByClassnameEnabled != null ? this.serveServletsByClassnameEnabled : WCCustomProperties.SERVE_SERVLETS_BY_CLASSNAME_ENABLED));
        }
        if (this.serveServletsByClassnameEnabled != null) {
            return this.serveServletsByClassnameEnabled;
        }
        return WCCustomProperties.SERVE_SERVLETS_BY_CLASSNAME_ENABLED;
    }

    public void setServeServletsByClassnameEnabled(Boolean serveServletsByClassname) {
        this.serveServletsByClassnameEnabled = serveServletsByClassname;
    }

    public HashMap getInvokerAttributes() {
        return this.invokerAttributes;
    }

    public void setInvokerAttributes(HashMap invokerAttributes) {
        this.invokerAttributes = invokerAttributes;
    }

    @Override
    public int getLastIndexBeforeDeclaredFilters() {
        return this.lastIndexBeforeDeclaredFilters;
    }

    @Override
    public void setLastIndexBeforeDeclaredFilters(int lastIndexBeforeDeclaredFilters) {
        this.lastIndexBeforeDeclaredFilters = lastIndexBeforeDeclaredFilters;
    }

    public List getFilterMappings() {
        return this.filterMappings;
    }

    public void setFilterMappings(List<IFilterMapping> filterMappings) {
        this.filterMappings = filterMappings;
    }

    public IFilterConfig getFilterInfo(String filterName) {
        return this.filterInfo.get(filterName);
    }

    public void addFilterInfo(IFilterConfig config) {
        this.filterInfo.put(config.getFilterName(), config);
    }

    @Override
    public String getVirtualHostName() {
        return this.virtualHost;
    }

    @Override
    public Map<String, List<String>> getServletMappings() {
        return this.servletMappings;
    }

    public void setServletMappings(Map<String, List<String>> servletMappings) {
        this.servletMappings = servletMappings;
    }

    public List<String> getServletMappings(String servletName) {
        return this.servletMappings.get(servletName);
    }

    public HashMap getMimeFilters() {
        return this.mimeFilters;
    }

    public void setMimeFilters(HashMap mimeFilters) {
        if (mimeFilters != null && mimeFilters.size() > 0) {
            this.isMimeFilteringEnabled = true;
        }
        this.mimeFilters = mimeFilters;
    }

    public String getMimeType(String extension) {
        return this.mimeMappings.get(extension);
    }

    public ErrorPage getErrorPageTraverseRootCause(Throwable th) {
        Throwable rootCause;
        while (th != null && th instanceof ServletException && (rootCause = ((ServletException)th).getRootCause()) != null) {
            ErrorPage er = this.getErrorPageByExceptionType(th);
            if (er != null) {
                return er;
            }
            th = rootCause;
        }
        if (th != null) {
            return this.getErrorPageByExceptionType(th);
        }
        return null;
    }

    public ErrorPage getErrorPageByExceptionType(Throwable rootException) {
        String exceptionName = rootException.getClass().getName();
        Object obj = this.exceptionErrorPages.get(exceptionName);
        if (obj != null) {
            return (ErrorPage)obj;
        }
        Iterator i = this.exceptionErrorPages.values().iterator();
        ErrorPage curEP = null;
        ClassLoader warClassLoader = this.getWebApp().getClassLoader();
        while (i.hasNext()) {
            ErrorPage ep = (ErrorPage)i.next();
            Class exceptionClass = ep.getException(warClassLoader);
            if (exceptionClass == null || !exceptionClass.isInstance(rootException)) continue;
            if (curEP == null) {
                curEP = ep;
                continue;
            }
            if (!curEP.getException(warClassLoader).isAssignableFrom(exceptionClass)) continue;
            curEP = ep;
        }
        return curEP;
    }

    public ErrorPage getErrorPageByErrorCode(Integer code) {
        return (ErrorPage)this.codeErrorPages.get(code);
    }

    public List<String> getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public void setWelcomeFileList(List<String> list) {
        this.welcomeFileList = list;
    }

    @Override
    public List getTagLibs() {
        return this.tagLibList;
    }

    public void setTagLibs(List l) {
        this.tagLibList = l;
    }

    @Override
    public List getListeners() {
        return this.listeners;
    }

    @Override
    public void addListener(String listenerClass) {
        this.listeners.add(listenerClass);
    }

    public void setListeners(ArrayList listeners) {
        this.listeners = listeners;
    }

    public void setWebXmlDefinedListeners(Set<String> setOfWebXmlDefinedListeners) {
        this.webXmlDefinedListeners = setOfWebXmlDefinedListeners;
    }

    public Set<String> getWebXmlDefinedListeners() {
        return this.webXmlDefinedListeners;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public String getJ2EEModuleName() {
        return this.j2eeModuleName;
    }

    @Override
    public String getApplicationName() {
        if (this.applicationName != null) {
            return this.applicationName;
        }
        if (this.webApp != null) {
            return this.webApp.getApplicationName();
        }
        return null;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setJ2EEModuleName(String j2eeModuleName) {
        this.j2eeModuleName = j2eeModuleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
    }

    public boolean isDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    public void setCodeErrorPages(HashMap codeErrorPages) {
        this.codeErrorPages = codeErrorPages;
    }

    public void setExceptionErrorPages(HashMap exceptionErrorPages) {
        this.exceptionErrorPages = exceptionErrorPages;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isModuleSessionTimeoutSet() {
        return this.moduleSessionTimeoutSet;
    }

    public boolean isModuleSessionTrackingModeSet() {
        return this.moduleSessionTrackingModeSet;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setModuleSessionTimeoutSet(boolean b) {
        this.moduleSessionTimeoutSet = b;
    }

    public void setModuleSessionTrackingModeSet(boolean b) {
        this.moduleSessionTrackingModeSet = b;
    }

    public SessionManagerConfig getSessionManagerConfig() {
        return this.sessionManagerConfig;
    }

    public void setSessionManagerConfig(SessionManagerConfig smcBase) {
        this.sessionManagerConfig = smcBase;
    }

    public SessionCookieConfigImpl getSessionCookieConfig() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSessionCookieConfigurator", "scc = " + this.sessionCookieConfig + " for application: " + this.getApplicationName());
        }
        return this.sessionCookieConfig;
    }

    public void setSessionCookieConfig(SessionCookieConfigImpl scc) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSessionCookieConfig", "scc = " + scc + " for application: " + this.getApplicationName());
        }
        this.sessionCookieConfig = scc;
    }

    public void setSessionCookieConfigInitilialized() {
        if (this.sessionCookieConfig != null && WebContainer.getServletContainerSpecLevel() >= 31) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setSessionCookieConfigInitialized", "scc = " + this.sessionCookieConfig + " for application: " + this.getApplicationName());
            }
            this.sessionCookieConfig.setContextInitialized();
        }
    }

    public void setHasProgrammaticCookieConfig() {
        this.hasProgrammaticCookieConfig = true;
    }

    public boolean hasProgrammaticCookieConfig() {
        return this.hasProgrammaticCookieConfig;
    }

    public EnumSet<SessionTrackingMode> getSessionTrackingMode() {
        if (this.sessionManagerConfig == null) {
            return this.getDefaultSessionTrackingMode();
        }
        return EnumSet.copyOf(this.sessionManagerConfig.getSessionTrackingMode());
    }

    public EnumSet<SessionTrackingMode> getDefaultSessionTrackingMode() {
        if (this.sessionDefaultTrackingModeSet == null) {
            return EnumSet.noneOf(SessionTrackingMode.class);
        }
        return EnumSet.copyOf(this.sessionDefaultTrackingModeSet);
    }

    public EnumSet<SessionTrackingMode> getInternalDefaultSessionTrackingMode() {
        return this.sessionDefaultTrackingModeSet;
    }

    public void setSessionTrackingMode(Set<SessionTrackingMode> stm) {
        this.sessionManagerConfig.setEffectiveTrackingModes(EnumSet.copyOf(stm));
    }

    public void setDefaultSessionTrackingMode(EnumSet<SessionTrackingMode> stm) {
        this.sessionDefaultTrackingModeSet = stm;
    }

    public void setServletInfos(Map<String, IServletConfig> sInfos) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setServletInfos", "servletInfo --> " + sInfos);
        }
        this.servletInfo = sInfos;
    }

    public void setAppStartupWeight(int appStartupWeight) {
        this.appStartupWeight = appStartupWeight;
    }

    @Override
    public int getAppStartupWeight() {
        return this.appStartupWeight;
    }

    public void setFilterInfos(Map<String, IFilterConfig> fInfos) {
        this.filterInfo = fInfos;
    }

    @Override
    @FFDCIgnore(value={NullPointerException.class})
    public void addServletMapping(String servletName, String urlPattern) {
        List<String> mappings;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addServletMapping", "adding servletName->" + servletName + ", urlPattern->" + urlPattern);
        }
        if ((mappings = this.servletMappings.get(servletName)) == null) {
            IServletConfig scon = this.getServletInfo(servletName);
            mappings = new ArrayList<String>();
            mappings.add(urlPattern);
            this.servletMappings.put(servletName, mappings);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addServletMapping", "servletInfo --> " + this.servletInfo + " servletName --> " + servletName);
            }
            if (scon == null) {
                Object[] objectArray = new Object[]{servletName, urlPattern, this.getModuleName(), this.getApplicationName()};
                logger.logp(Level.SEVERE, CLASS_NAME, "addServletMapping", "servlet.name.for.servlet.mapping.not.found", objectArray);
                String msg = nls.getFormattedMessage("servlet.name.for.servlet.mapping.not.found", objectArray, "Servlet name not found adding servlet mapping; servlet name=" + servletName + "; URL pattern=" + urlPattern + "; module=" + this.getModuleName() + "; application=" + this.getApplicationName());
                throw new RuntimeException(new MetaDataException(msg));
            }
            scon.setMappings(mappings);
        } else {
            boolean found = false;
            for (String curPattern : mappings) {
                if (!urlPattern.equals(curPattern)) continue;
                found = true;
                break;
            }
            if (!found) {
                mappings.add(urlPattern);
            }
        }
    }

    public void setVirtualHostName(String string) {
        this.virtualHost = string;
    }

    public void setPrecompileJSPs(boolean b) {
        this.precompileJsps = b;
    }

    public boolean getPreCompileJSPs() {
        return this.precompileJsps;
    }

    public boolean isAutoLoadFilters() {
        return this.autoLoadFilters;
    }

    public void setAutoLoadFilters(boolean autoLoadFilters) {
        this.autoLoadFilters = autoLoadFilters;
    }

    public String getLocaleEncoding(Locale locale) {
        if (this.localeMap == null) {
            return null;
        }
        String encoding = (String)this.localeMap.get(locale.toString());
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale);
        }
        if (encoding == null) {
            encoding = (String)this.localeMap.get(locale.getLanguage() + "_" + locale.getCountry());
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale + ", language->" + locale.getLanguage() + ", country->" + locale.getCountry());
            }
            if (encoding == null) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "locale->" + locale + ", language->" + locale.getLanguage());
                }
                encoding = (String)this.localeMap.get(locale.getLanguage());
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocaleEncoding", "encoding->" + encoding);
        }
        return encoding;
    }

    public void addLocaleEncodingMap(String locale, String encoding) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addLocaleEncodingMap", "locale->" + locale + ", encoding->" + encoding);
        }
        if (this.localeMap == null) {
            this.localeMap = new HashMap();
        }
        this.localeMap.put(locale, encoding);
    }

    public boolean isMimeFilteringEnabled() {
        return this.isMimeFilteringEnabled;
    }

    @Override
    public boolean isServlet2_4() {
        return this.version == 24;
    }

    @Override
    public boolean isServlet2_5() {
        return this.version == 25;
    }

    @Override
    public boolean isServlet2_4OrHigher() {
        return this.version >= 24;
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    public void setWebApp(WebApp app) {
        this.webApp = app;
    }

    public void removeServletMappings(String servletName) {
        this.servletMappings.remove(servletName);
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @Override
    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setDefaultContextRootUsed(boolean isDefaultContextRootUsed) {
        this.isDefaultContextRootUsed = isDefaultContextRootUsed;
    }

    public boolean isDefaultContextRootUsed() {
        return this.isDefaultContextRootUsed;
    }

    public void setVersion(int i) {
        this.version = i;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isSyncToThreadEnabled() {
        return this.isSyncToThreadEnabled;
    }

    public void setSyncToThreadEnabled(boolean b) {
        this.isSyncToThreadEnabled = b;
    }

    @Override
    public int getModuleStartupWeight() {
        return this.moduleStartupWeight;
    }

    public void setModuleStartupWeight(int moduleStartupWeight) {
        this.moduleStartupWeight = moduleStartupWeight;
    }

    public HashMap getCodeErrorPages() {
        return this.codeErrorPages;
    }

    public HashMap getExceptionErrorPages() {
        return this.exceptionErrorPages;
    }

    @Override
    public String getArdDispatchType() {
        return this.ardDispatchType;
    }

    @Override
    public void setArdDispatchType(String ardDispatchType) {
        this.ardDispatchType = ardDispatchType;
        if (this.ardDispatchType.equals("CLIENT_SIDE") || this.ardDispatchType.equals("SERVER_SIDE")) {
            this.ardEnabled = true;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setArdDispatchType", " type --> " + ardDispatchType);
        }
    }

    @Override
    public boolean isArdEnabled() {
        return this.ardEnabled;
    }

    @Override
    public void setMetadataComplete(boolean b) {
        this.metaDataComplete = b;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metaDataComplete;
    }

    @Override
    public void addClassesToScan(List<Class<?>> list) {
        this.classesToScan.addAll(list);
    }

    @Override
    public List<Class<?>> getClassesToScan() {
        return this.classesToScan;
    }

    @Override
    public boolean isSystemApp() {
        return this.isSystemApp;
    }

    public void setSystemApp(boolean b) {
        this.isSystemApp = b;
    }

    @Override
    public void addUriMappedFilterInfo(IFilterMapping fmInfo) {
        if (this.uriFilterMappingInfos == null) {
            this.uriFilterMappingInfos = new ArrayList<IFilterMapping>();
        }
        this.uriFilterMappingInfos.add(fmInfo);
    }

    @Override
    public void addServletMappedFilterInfo(IFilterMapping fmInfo) {
        if (this.servletFilterMappingInfos == null) {
            this.servletFilterMappingInfos = new ArrayList<IFilterMapping>();
        }
        this.servletFilterMappingInfos.add(fmInfo);
    }

    public List<IFilterMapping> getUriFilterMappings() {
        return this.uriFilterMappingInfos;
    }

    public List<IFilterMapping> getServletFilterMappings() {
        return this.servletFilterMappingInfos;
    }

    public Map<String, ? extends ServletRegistration> getServletInfoMap() {
        return this.servletInfo;
    }

    public Map<String, ? extends FilterRegistration> getFilterInfoMap() {
        return this.filterInfo;
    }

    public void addDynamicServletRegistration(String servletName, ServletRegistration.Dynamic dynamicServletRegistration) {
        if (this.dynamicServletRegistrationMap == null) {
            this.dynamicServletRegistrationMap = new HashMap<String, ServletRegistration.Dynamic>();
        }
        this.dynamicServletRegistrationMap.put(servletName, dynamicServletRegistration);
    }

    public Map<String, ? extends ServletRegistration.Dynamic> getDynamicServletRegistrations() {
        return this.dynamicServletRegistrationMap;
    }

    public void setLibBinPathList(List<String> libBinPathList) {
        this.libBinPathList = libBinPathList;
    }

    @Override
    public List<String> getLibBinPathList() {
        if (this.libBinPathList == null) {
            this.libBinPathList = new ArrayList<String>();
            if (this.webApp != null) {
                MetaInfResourceFinder metaInfRes = this.webApp.getMetaInfResourceFinder();
                for (URL url : metaInfRes.getJarResourceURLs()) {
                    String path;
                    if ("jar".equals(url.getProtocol())) {
                        path = url.getFile().substring("file:".length(), url.getFile().indexOf("!/"));
                    } else {
                        if (!"file".equals(url.getProtocol())) continue;
                        path = url.getPath();
                    }
                    this.libBinPathList.add(path);
                }
            }
        }
        return this.libBinPathList;
    }

    @Override
    public boolean isJCDIEnabled() {
        return false;
    }

    @Override
    public void setJCDIEnabled(boolean b) {
    }

    public Map<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> getAllRefs() {
        return this.allRefs;
    }

    private <T> List<T> getRefs(JNDIEnvironmentRefType refType, Class<T> type) {
        if (type != refType.getType()) {
            throw new IllegalArgumentException();
        }
        List<? extends JNDIEnvironmentRef> refs = this.allRefs.get(refType);
        return refs == null ? Collections.emptyList() : refs;
    }

    public List<ServiceRef> getServiceRefs() {
        return this.getRefs(JNDIEnvironmentRefType.ServiceRef, ServiceRef.class);
    }

    public List<ResourceRef> getResourceRefs() {
        return this.getRefs(JNDIEnvironmentRefType.ResourceRef, ResourceRef.class);
    }

    public List<ResourceEnvRef> getResourceEnvRefs() {
        return this.getRefs(JNDIEnvironmentRefType.ResourceEnvRef, ResourceEnvRef.class);
    }

    public List<MessageDestinationRef> getMessageDestinationRefs() {
        return this.getRefs(JNDIEnvironmentRefType.MessageDestinationRef, MessageDestinationRef.class);
    }

    public List<EnvEntry> getEnvEntries() {
        return this.getRefs(JNDIEnvironmentRefType.EnvEntry, EnvEntry.class);
    }

    public List<DataSource> getDataSources() {
        return this.getRefs(JNDIEnvironmentRefType.DataSource, DataSource.class);
    }

    public Map<JNDIEnvironmentRefType, Map<String, String>> getAllRefBindings() {
        return this.allRefBindings;
    }

    public Map<String, String> getEnvEntryValues() {
        if (this.envEntryValues == null) {
            this.envEntryValues = new HashMap<String, String>();
        }
        return this.envEntryValues;
    }

    public ResourceRefConfigList getResourceRefConfigList(ResourceRefConfigFactory resourceRefConfigFactory) {
        if (this.resourceRefConfigList == null && resourceRefConfigFactory != null) {
            this.resourceRefConfigList = resourceRefConfigFactory.createResourceRefConfigList();
        }
        return this.resourceRefConfigList;
    }

    public List<? extends PersistenceContextRef> getPersistenceContextRefs() {
        return this.getRefs(JNDIEnvironmentRefType.PersistenceContextRef, PersistenceContextRef.class);
    }

    public List<? extends PersistenceUnitRef> getPersistenceUnitRefs() {
        return this.getRefs(JNDIEnvironmentRefType.PersistenceUnitRef, PersistenceUnitRef.class);
    }

    public List<? extends EJBRef> getEJBRefs() {
        return this.getRefs(JNDIEnvironmentRefType.EJBRef, EJBRef.class);
    }

    public void setInitializeWebExtProps(WebExt ext) {
        List invokerAttributes;
        List jspAttributes;
        List fileServingAttributes;
        String extPage;
        String methodName = "setInitializeWebExtProps";
        if (ext.isSetAutoEncodeRequests()) {
            this.setAutoRequestEncoding(ext.isAutoEncodeRequests());
        }
        if (ext.isSetAutoEncodeResponses()) {
            this.setAutoResponseEncoding(ext.isAutoEncodeResponses());
        }
        if (ext.isSetAutoloadFilters()) {
            this.setAutoLoadFilters(ext.isAutoloadFilters());
        }
        if (ext.isSetEnableDirectoryBrowsing()) {
            this.setDirectoryBrowsingEnabled(ext.isEnableDirectoryBrowsing());
        }
        if (ext.isSetEnableFileServing()) {
            this.setFileServingEnabled(ext.isEnableFileServing());
        }
        if (ext.isSetEnableReloading()) {
            this.setReloadingEnabled(ext.isEnableReloading());
        }
        if (ext.isSetEnableServingServletsByClassName()) {
            this.setServeServletsByClassnameEnabled(ext.isEnableServingServletsByClassName());
        }
        if (ext.isSetPreCompileJsps()) {
            this.setPrecompileJSPs(ext.isPreCompileJsps());
        }
        if (ext.isSetReloadInterval()) {
            this.setReloadInterval(ext.getReloadInterval());
        }
        if ((extPage = ext.getDefaultErrorPage()) != null && extPage.length() > 0) {
            String currentPage = this.getDefaultErrorPage();
            if (!extPage.equals(currentPage)) {
                if (currentPage != null && currentPage.length() != 0) {
                    if (WebContainer.getServletContainerSpecLevel() >= 31) {
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, methodName, "Servlet 3.1: Descriptor default error page " + currentPage + " overrides extension default error page " + extPage + ".");
                        }
                    } else {
                        this.setDefaultErrorPage(extPage);
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, methodName, "Servlet 3.0: Descriptor default error page " + currentPage + " overridden by extension default error page " + extPage + ".");
                        }
                    }
                } else {
                    this.setDefaultErrorPage(extPage);
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "Assigning ibm-web-ext.xml default error page " + extPage + ".");
                    }
                }
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "ibm-web-ext.xml default error page page same as descriptor default error page " + extPage + ".");
            }
        }
        if ((fileServingAttributes = ext.getFileServingAttributes()) != null && fileServingAttributes.size() > 0) {
            HashMap fileServingHashMap = this.convertAttributeListToMap(fileServingAttributes);
            this.setFileServingAttributes(fileServingHashMap);
        }
        if ((jspAttributes = ext.getJspAttributes()) != null && jspAttributes.size() > 0) {
            HashMap jspServingHashMap = this.convertAttributeListToMap(jspAttributes);
            this.setJspAttributes(jspServingHashMap);
        }
        if ((invokerAttributes = ext.getInvokerAttributes()) != null && invokerAttributes.size() > 0) {
            HashMap invokerHashMap = this.convertAttributeListToMap(invokerAttributes);
            this.setInvokerAttributes(invokerHashMap);
        }
        List mimeFilters = ext.getMimeFilters();
        if (fileServingAttributes != null && fileServingAttributes.size() > 0) {
            HashMap mimeFiltersHashMap = this.convertMimeFiltersToMap(mimeFilters);
            this.setMimeFilters(mimeFiltersHashMap);
        }
    }

    private HashMap convertAttributeListToMap(List<Attribute> attributeList) {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (Attribute a : attributeList) {
            String name = a.getName();
            String value = a.getValue();
            if (name != null && name.equals("extendedDocumentRoot")) {
                try {
                    WsLocationAdmin locationService = WebContainer.getLocationService();
                    value = locationService.resolveString(value);
                }
                catch (Exception e) {
                    logger.logp(Level.FINE, CLASS_NAME, "convertAttributeListToMap", "varaible expansion failed for " + name, e);
                }
            }
            hm.put(name, value);
        }
        return hm;
    }

    private HashMap convertMimeFiltersToMap(List<MimeFilter> mimeFilters) {
        HashMap<String, com.ibm.ws.container.MimeFilter> hm = new HashMap<String, com.ibm.ws.container.MimeFilter>();
        for (MimeFilter mf : mimeFilters) {
            com.ibm.ws.container.MimeFilter wmf = new com.ibm.ws.container.MimeFilter(mf.getMimeType(), mf.getTarget());
            hm.put(mf.getMimeType(), wmf);
        }
        return hm;
    }

    @Override
    public boolean isErrorPagePresent() {
        int codeErrorPageLen = null != this.getCodeErrorPages() ? this.getCodeErrorPages().size() : 0;
        int exceptionErrorPageLen = null != this.getExceptionErrorPages() ? this.getExceptionErrorPages().size() : 0;
        return codeErrorPageLen > 0 || exceptionErrorPageLen > 0;
    }

    public void setDisableStaticMappingCache() {
        String value;
        if (this.contextParams != null && (value = (String)this.contextParams.get("com.ibm.ws.webcontainer.DISABLE_STATIC_MAPPING_CACHE")) != null) {
            if (value.equalsIgnoreCase("true")) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setDisableStaticMappingCache", "cxtParam disable static mapping cache for application -> " + this.applicationName);
                }
                this.setDisableStaticMappingCache(true);
            }
            return;
        }
        if (WCCustomProperties.DISABLE_STATIC_MAPPING_CACHE != null) {
            String[] parsedStr;
            String disableStaticMappingCacheApp = WCCustomProperties.DISABLE_STATIC_MAPPING_CACHE;
            if (disableStaticMappingCacheApp.equals("*")) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setDisableStaticMappingCache", "disable static mapping cache for all apps.");
                }
                this.setDisableStaticMappingCache(true);
                return;
            }
            for (String toCheckStr : parsedStr = disableStaticMappingCacheApp.split(",")) {
                toCheckStr = toCheckStr.trim();
                if (this.applicationName == null || !this.applicationName.equalsIgnoreCase(toCheckStr)) continue;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setDisableStaticMappingCache", "disable static mapping cache for application -> " + this.applicationName);
                }
                this.setDisableStaticMappingCache(true);
                return;
            }
        }
    }

    public void setDisableStaticMappingCache(boolean b) {
        this.disableStaticMappingCache = b;
    }

    public boolean isDisableStaticMappingCache() {
        return this.disableStaticMappingCache;
    }

    public void setJspCachedLocations(Map jspCachedLocations) {
        this.jspCachedLocations = jspCachedLocations;
    }

    public Map getJspCachedLocations() {
        return this.jspCachedLocations;
    }

    public void setSTSHeaderValue() {
        String STSHeader = null;
        if (this.contextParams != null && (STSHeader = (String)this.contextParams.get("com.ibm.ws.webcontainer.ADD_STS_HEADER_WEBAPP")) != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setSTSHeaderValue", "cxtParam provided for STS_HEADER in web application -> " + this.applicationName);
            }
            this.primedSTSHeader = this.generateSTSHeader(STSHeader);
        }
        if (STSHeader == null) {
            STSHeader = WCCustomProperties.ADD_STRICT_TRANSPORT_SECURITY_HEADER;
            this.primedSTSHeader = this.generateSTSHeader(STSHeader);
        }
        if (STSHeader == null || this.primedSTSHeader == null) {
            this.primedSTSHeader = "NoValue";
        }
    }

    public String getSTSHeaderValue() {
        return this.primedSTSHeader;
    }

    private String generateSTSHeader(String value) {
        if (value != null) {
            String[] tokens = value.split(";");
            int size = tokens.length;
            int maxAgeToken = -1;
            int number = -1;
            boolean quotes = false;
            try {
                for (int i = 0; i < size; ++i) {
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "size -->" + size + " token [" + i + "] -->" + tokens[i]);
                    }
                    if (!tokens[i].toLowerCase().contains("max-age")) continue;
                    maxAgeToken = i;
                    String[] tok = tokens[i].split("=");
                    if (tok.length == 2) {
                        tok[1] = tok[1].trim();
                        if (tok[1].startsWith("\"") && tok[1].endsWith("\"")) {
                            quotes = true;
                            tok[1] = tok[1].replace("\"", "");
                        }
                        if ((number = Integer.parseInt(tok[1].trim())) < 0) {
                            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "max-age value must be 0 or greater " + number);
                            }
                            return null;
                        }
                        break;
                    }
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "max-age value must be provided");
                    }
                    return null;
                }
            }
            catch (NumberFormatException e) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "max-age value must be number");
                }
                return null;
            }
            String generatedHeaderValue = null;
            if (maxAgeToken >= 0) {
                generatedHeaderValue = quotes ? "max-age=\"" + number + "\"" : "max-age=" + number;
            } else {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "max-age is mandatory token");
                }
                return null;
            }
            if (size > 1) {
                int i;
                int includeSubDomainsToken = -1;
                int preloadToken = -1;
                for (i = 0; i < size; ++i) {
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", "includeSubDomains , size -->" + size + " token [" + i + "] -->" + tokens[i]);
                    }
                    if (!tokens[i].toLowerCase().contains("includesubdomains")) continue;
                    includeSubDomainsToken = i;
                    break;
                }
                if (includeSubDomainsToken >= 0) {
                    generatedHeaderValue = generatedHeaderValue + "; includeSubDomains";
                }
                for (i = 0; i < size; ++i) {
                    if (!tokens[i].toLowerCase().contains("preload")) continue;
                    preloadToken = i;
                    break;
                }
                if (preloadToken >= 0) {
                    generatedHeaderValue = generatedHeaderValue + "; preload";
                }
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "generateSTSHeader", " property -->" + value + " , response value-->" + generatedHeaderValue);
            }
            return generatedHeaderValue;
        }
        return null;
    }

    public void setEncodeDispatchedRequestURI() {
        String value;
        if (this.contextParams != null && (value = (String)this.contextParams.get("com.ibm.ws.webcontainer.ENCODE_DISPATCHED_REQUEST_URI")) != null) {
            if (value.equalsIgnoreCase("true")) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setEncodeDispatchedRequestURI", "Encode dispatched request URI for application -> " + this.applicationName);
                }
                this.encodeDispatchedRequestURI = true;
                return;
            }
            if (value.equalsIgnoreCase("false")) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setEncodeDispatchedRequestURI", "Do not encode dispatched request URI for application -> " + this.applicationName);
                }
                this.encodeDispatchedRequestURI = false;
                return;
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setEncodeDispatchedRequestURI", "Invalid value set for context param [com.ibm.ws.webcontainer.ENCODE_DISPATCHED_REQUEST_URI] in application -> " + this.applicationName);
            }
        }
        if (WCCustomProperties.ENCODE_DISPATCHED_REQUEST_URI) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setEncodeDispatchedRequestURI", "Encode dispatched request URI per custom property for application -> " + this.applicationName);
            }
            this.encodeDispatchedRequestURI = true;
        }
    }

    public boolean isEncodeDispatchedRequestURI() {
        return this.encodeDispatchedRequestURI;
    }

    public boolean isEnablemultireadofpostdata() {
        return this.enablemultireadofpostdata;
    }

    public void setMultiReadOfPostDataValue() {
        String multiRead = null;
        if (this.contextParams != null && (multiRead = (String)this.contextParams.get("com.ibm.ws.webcontainer.SET_MULTI_READ_WEBAPP")) != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setMultiReadOfPostDataValue", "cxtParam provided for MULTI_READ: " + multiRead + " in web application -> " + this.applicationName);
            }
            if (multiRead.equalsIgnoreCase("true")) {
                this.setEnablemultireadofpostdata(true);
            } else if (multiRead.equalsIgnoreCase("false")) {
                this.setEnablemultireadofpostdata(false);
            }
            return;
        }
        if (multiRead == null) {
            this.setEnablemultireadofpostdata(WCCustomProperties.ENABLE_MULTI_READ_OF_POST_DATA);
        }
    }

    private void setEnablemultireadofpostdata(boolean enablemultireadofpostdata) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setEnablemultireadofpostdata", "set enablemultireadofpostdata: " + enablemultireadofpostdata);
        }
        this.enablemultireadofpostdata = enablemultireadofpostdata;
    }

    public String getModuleRequestEncoding() {
        return this.requestEncoding;
    }

    public void setModuleRequestEncoding(String encoding) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setModuleRequestEncoding", " request encoding [" + encoding + "]");
        }
        this.requestEncoding = encoding;
    }

    public String getModuleResponseEncoding() {
        return this.responseEncoding;
    }

    public void setModuleResponseEncoding(String encoding) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setModuleResponseEncoding", " response encoding [" + encoding + "]");
        }
        this.responseEncoding = encoding;
    }
}

