/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.RequestUtils";
    private static TraceNLS nls = TraceNLS.getTraceNLS(RequestUtils.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static final String SHORT_ENGLISH = "8859_1";
    private static boolean ignoreInvalidQueryString = WCCustomProperties.IGNORE_INVALID_QUERY_STRING;
    private static boolean allowQueryParamWithNoEqual = WCCustomProperties.ALLOW_QUERY_PARAM_WITH_NO_EQUAL;
    private static final String EMPTY_STRING = "";
    private static int maxParamPerRequest = WCCustomProperties.MAX_PARAM_PER_REQUEST;
    private static final int maxDuplicateHashKeyParams = WCCustomProperties.MAX_DUPLICATE_HASHKEY_PARAMS;
    private static boolean decodeParamViaReqEncoding = WCCustomProperties.DECODE_PARAM_VIA_REQ_ENCODING;
    private static final boolean printbyteValueandcharParamdata = WCCustomProperties.PRINT_BYTEVALUE_AND_CHARPARAMDATA;
    private static String lastShortEnglishEncoding = null;

    public static Hashtable parseQueryString(String s) {
        return RequestUtils.parseQueryString(s.toCharArray(), SHORT_ENGLISH);
    }

    public static Hashtable parseQueryString(String s, String encoding) {
        return RequestUtils.parseQueryString(s.toCharArray(), encoding);
    }

    private static boolean isShortEnglishEncoding(String encoding) {
        if (encoding == lastShortEnglishEncoding || encoding == SHORT_ENGLISH || encoding == "ISO-8859-1") {
            return true;
        }
        if (encoding.endsWith(SHORT_ENGLISH) || encoding.endsWith("8859-1") || encoding.indexOf("8859-1-Windows") != -1) {
            lastShortEnglishEncoding = encoding;
            return true;
        }
        return false;
    }

    private static Hashtable parseQueryString(char[] ch, String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseQueryString( char[] , encoding --> [" + encoding + "])");
        }
        int totalSize = 0;
        int dupSize = 0;
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        HashSet<Integer> key_hset = new HashSet<Integer>();
        boolean encoding_is_ShortEnglish = RequestUtils.isShortEnglishEncoding(encoding);
        int pair_start = 0;
        int equalSign = -1;
        int lgth = ch.length;
        for (int i = 0; i <= lgth; ++i) {
            if (i == lgth || ch[i] == '&') {
                if (equalSign < pair_start) {
                    equalSign = i;
                }
            } else {
                if (ch[i] != '=' || equalSign >= pair_start) continue;
                equalSign = i;
                continue;
            }
            if (equalSign < i || allowQueryParamWithNoEqual && equalSign == i) {
                String[] valArray;
                String[] oldVals;
                String key = null;
                String value = null;
                if (decodeParamViaReqEncoding && !encoding_is_ShortEnglish) {
                    key = RequestUtils.parse_decode_Parameter(ch, pair_start, equalSign - pair_start, encoding, "paramKey");
                    if (equalSign == i) {
                        value = key != null ? EMPTY_STRING : null;
                    } else {
                        int valueStart = equalSign + 1;
                        int valueLen = i - valueStart;
                        value = RequestUtils.parse_decode_Parameter(ch, valueStart, valueLen, encoding, "paramValue");
                    }
                    if (ignoreInvalidQueryString && (value == null || key == null)) {
                        pair_start = i + 1;
                        equalSign = i;
                        continue;
                    }
                } else {
                    key = RequestUtils.parseName(ch, pair_start, equalSign);
                    value = equalSign == i ? (key != null ? EMPTY_STRING : null) : RequestUtils.parseName(ch, equalSign + 1, i);
                    if (ignoreInvalidQueryString && (value == null || key == null)) {
                        pair_start = i + 1;
                        equalSign = i;
                        continue;
                    }
                    if (!encoding_is_ShortEnglish) {
                        try {
                            key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                            value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                        }
                        catch (UnsupportedEncodingException uee) {
                            logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                            throw new IllegalArgumentException();
                        }
                    }
                }
                if ((oldVals = ht.put(key, valArray = new String[]{value})) != null) {
                    valArray = new String[oldVals.length + 1];
                    System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                    valArray[oldVals.length] = value;
                    ht.put(key, valArray);
                } else if (!key_hset.add(key.hashCode())) {
                    ++dupSize;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "duplicate hashCode generated by key --> " + key);
                    }
                    if (dupSize > maxDuplicateHashKeyParams) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.hash.collisions"), maxDuplicateHashKeyParams));
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (maxParamPerRequest != -1 && ++totalSize >= maxParamPerRequest) {
                logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, totalSize));
                throw new IllegalArgumentException();
            }
            pair_start = i + 1;
            equalSign = i;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "parseQueryString(char[], String)");
        }
        return ht;
    }

    public static Hashtable parseQueryString(char[][] cha, String encoding) {
        String[] oldVals;
        char[] valueChars;
        int valueLen;
        int valueStart;
        int nameLen;
        int nameStart;
        boolean equalFound;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseQueryString( query , encoding --> [" + encoding + "])");
        }
        if (cha == null || cha.length == 0) {
            throw new IllegalArgumentException("query string or post data is null");
        }
        if (cha.length == 1) {
            return RequestUtils.parseQueryString(cha[0], encoding);
        }
        String[] valArray = null;
        int totalSize = 0;
        int dupSize = 0;
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        HashSet<Integer> key_hset = new HashSet<Integer>();
        boolean encoding_is_ShortEnglish = RequestUtils.isShortEnglishEncoding(encoding);
        int pair_start = 0;
        int pair_start_index = 0;
        int pair_end = 0;
        int pair_end_index = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        int equalSign = 0;
        int equalSign_index = 0;
        for (k = 0; k < cha.length; ++k) {
            int lgth = cha[k].length;
            for (i = 0; i < lgth; ++i) {
                if (cha[k][i] == '&') {
                    equalFound = false;
                    for (int count = pair_start_index; count <= k; ++count) {
                        int start = 0;
                        int end = cha[k].length;
                        equalSign_index = count;
                        if (count == pair_start_index) {
                            start = pair_start;
                        }
                        if (count == k) {
                            end = i;
                        }
                        for (equalSign = start; equalSign < end; ++equalSign) {
                            if (cha[count][equalSign] != '=') continue;
                            equalFound = true;
                            break;
                        }
                        if (equalFound) break;
                    }
                    if (equalSign < i || equalSign_index < k || allowQueryParamWithNoEqual && equalSign == i && equalSign_index == k) {
                        char[] nameChars;
                        String key = null;
                        String value = null;
                        nameStart = 0;
                        nameLen = 0;
                        valueStart = 0;
                        valueLen = 0;
                        if (pair_start_index != equalSign_index) {
                            nameChars = RequestUtils.getSingleBuffer(cha, pair_start, pair_start_index, equalSign, equalSign_index);
                            nameStart = 0;
                            nameLen = nameChars.length;
                        } else {
                            nameChars = cha[pair_start_index];
                            nameStart = pair_start;
                            nameLen = equalSign - pair_start;
                        }
                        if (equalSign_index != k) {
                            valueChars = RequestUtils.getSingleBuffer(cha, equalSign + 1, equalSign_index, i, k);
                            valueStart = 0;
                            valueLen = valueChars.length;
                        } else {
                            valueChars = cha[k];
                            valueStart = equalSign + 1;
                            valueLen = i - valueStart;
                        }
                        if (decodeParamViaReqEncoding && !encoding_is_ShortEnglish) {
                            key = RequestUtils.parse_decode_Parameter(nameChars, nameStart, nameLen, encoding, "paramKey");
                            value = equalSign == i && equalSign_index == k ? (key != null ? EMPTY_STRING : null) : RequestUtils.parse_decode_Parameter(valueChars, valueStart, valueLen, encoding, "paramValue");
                            valueChars = null;
                            nameChars = null;
                            if (ignoreInvalidQueryString && (value == null || key == null)) {
                                pair_start = i + 1;
                                pair_start_index = k;
                                continue;
                            }
                        } else {
                            key = RequestUtils.parseName(nameChars, nameStart, nameStart + nameLen);
                            value = equalSign == i && equalSign_index == k ? (key != null ? EMPTY_STRING : null) : RequestUtils.parseName(valueChars, valueStart, valueStart + valueLen);
                            valueChars = null;
                            nameChars = null;
                            if (ignoreInvalidQueryString && (value == null || key == null)) {
                                pair_start = i + 1;
                                pair_start_index = k;
                                continue;
                            }
                            if (!encoding_is_ShortEnglish) {
                                try {
                                    key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                                    value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                                }
                                catch (UnsupportedEncodingException uee) {
                                    logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                                    throw new IllegalArgumentException();
                                }
                            }
                        }
                        if (ht.containsKey(key)) {
                            oldVals = (String[])ht.get(key);
                            valArray = new String[oldVals.length + 1];
                            for (j = 0; j < oldVals.length; ++j) {
                                valArray[j] = oldVals[j];
                            }
                            valArray[oldVals.length] = value;
                        } else {
                            if (!key_hset.add(key.hashCode())) {
                                ++dupSize;
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "duplicate hashCode generated by key --> " + key);
                                }
                                if (dupSize > maxDuplicateHashKeyParams) {
                                    logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.hash.collisions"), maxDuplicateHashKeyParams));
                                    throw new IllegalArgumentException();
                                }
                            }
                            valArray = new String[]{value};
                        }
                        if (maxParamPerRequest == -1 || ++totalSize < maxParamPerRequest) {
                            ht.put(key, valArray);
                        } else {
                            logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, totalSize));
                            throw new IllegalArgumentException();
                        }
                    }
                    pair_start = i + 1;
                    pair_start_index = k;
                }
                pair_end = i;
                pair_end_index = k;
            }
        }
        equalFound = false;
        for (int count = pair_start_index; count < cha.length; ++count) {
            int start = 0;
            int end = cha[count].length;
            if (count == pair_start_index) {
                start = pair_start;
            }
            equalSign_index = count;
            for (equalSign = start; equalSign < end; ++equalSign) {
                if (cha[count][equalSign] != '=') continue;
                equalSign_index = count;
                equalFound = true;
                break;
            }
            if (equalFound) break;
        }
        if ((pair_start < equalSign || pair_start_index < equalSign_index) && (equalSign <= pair_end || equalSign_index < pair_end_index || allowQueryParamWithNoEqual && equalSign > pair_end && equalSign_index == pair_end_index)) {
            char[] nameChars;
            String key = null;
            String value = null;
            nameStart = 0;
            nameLen = 0;
            valueStart = 0;
            valueLen = 0;
            if (pair_start_index != equalSign_index) {
                nameChars = RequestUtils.getSingleBuffer(cha, pair_start, pair_start_index, equalSign, equalSign_index);
                nameStart = 0;
                nameLen = nameChars.length;
            } else {
                nameChars = cha[pair_start_index];
                nameStart = pair_start;
                nameLen = equalSign - pair_start;
            }
            if (equalSign_index != pair_end_index) {
                valueChars = RequestUtils.getSingleBuffer(cha, equalSign + 1, equalSign_index, pair_end + 1, pair_end_index);
                valueStart = 0;
                valueLen = valueChars.length;
            } else {
                valueChars = cha[pair_end_index];
                valueStart = equalSign + 1;
                valueLen = pair_end - equalSign;
            }
            if (decodeParamViaReqEncoding && !encoding_is_ShortEnglish) {
                key = RequestUtils.parse_decode_Parameter(nameChars, nameStart, nameLen, encoding, "paramKey");
                value = equalSign > pair_end && equalSign_index == pair_end_index ? (key != null ? EMPTY_STRING : null) : RequestUtils.parse_decode_Parameter(valueChars, valueStart, valueLen, encoding, "paramValue");
                valueChars = null;
                nameChars = null;
                if (ignoreInvalidQueryString && (value == null || key == null)) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.exiting(CLASS_NAME, "parseQueryString(String, String)");
                    }
                    return ht;
                }
            } else {
                key = RequestUtils.parseName(nameChars, nameStart, nameStart + nameLen);
                value = equalSign > pair_end && equalSign_index == pair_end_index ? (key != null ? EMPTY_STRING : null) : RequestUtils.parseName(valueChars, valueStart, valueStart + valueLen);
                valueChars = null;
                nameChars = null;
                if (ignoreInvalidQueryString && (value == null || key == null)) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.exiting(CLASS_NAME, "parseQueryString(String, String)");
                    }
                    return ht;
                }
                if (!encoding_is_ShortEnglish) {
                    try {
                        key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                        value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (ht.containsKey(key)) {
                oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (j = 0; j < oldVals.length; ++j) {
                    valArray[j] = oldVals[j];
                }
                valArray[oldVals.length] = value;
            } else {
                if (!key_hset.add(key.hashCode())) {
                    ++dupSize;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "duplicate hashCode generated by key --> " + key);
                    }
                    if (dupSize > maxDuplicateHashKeyParams) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.hash.collisions"), maxDuplicateHashKeyParams));
                        throw new IllegalArgumentException();
                    }
                }
                valArray = new String[]{value};
            }
            if (maxParamPerRequest == -1 || ++totalSize < maxParamPerRequest) {
                ht.put(key, valArray);
            } else {
                logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, totalSize));
                throw new IllegalArgumentException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "parseQueryString(String, String)");
        }
        return ht;
    }

    private static String parseName(char[] ch, int startOffset, int endOffset) {
        String returnValue;
        int j = 0;
        char[] c = null;
        block4: for (int i = startOffset; i < endOffset; ++i) {
            switch (ch[i]) {
                case '+': {
                    if (c == null) {
                        c = new char[endOffset - startOffset];
                        j = i - startOffset;
                        if (j != 0) {
                            System.arraycopy(ch, startOffset, c, 0, j);
                        }
                    }
                    c[j++] = 32;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < endOffset) {
                        if (c == null) {
                            c = new char[endOffset - startOffset];
                            j = i - startOffset;
                            if (j != 0) {
                                System.arraycopy(ch, startOffset, c, 0, j);
                            }
                        }
                        int num1 = Character.digit(ch[++i], 16);
                        int num2 = Character.digit(ch[++i], 16);
                        if (num1 == -1 || num2 == -1) {
                            if (ignoreInvalidQueryString) {
                                logger.logp(Level.WARNING, CLASS_NAME, "parseName", "invalid.query.string");
                                return null;
                            }
                            throw new IllegalArgumentException();
                        }
                        c[j++] = (char)(num1 << 4 | num2);
                        continue block4;
                    }
                    if (c != null) {
                        while (i < endOffset) {
                            c[j++] = ch[i];
                            ++i;
                        }
                        continue block4;
                    }
                    i = endOffset;
                    continue block4;
                }
                default: {
                    if (c == null) continue block4;
                    c[j++] = ch[i];
                }
            }
        }
        String string = returnValue = c != null ? new String(c, 0, j) : new String(ch, startOffset, endOffset - startOffset);
        if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            RequestUtils.printValues(returnValue, "parseNameOUT");
        }
        return returnValue;
    }

    public static String getURIForCurrentDispatch(HttpServletRequest req) {
        String includeURI = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (includeURI == null) {
            return req.getRequestURI();
        }
        return includeURI;
    }

    private static String parse_decode_Parameter(char[] data, int start, int length, String encoding, String val) {
        String paramData = null;
        paramData = new String(data, start, length);
        if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            RequestUtils.printValues(paramData, "parsed " + val);
        }
        try {
            paramData = URLDecoder.decode(paramData, encoding);
            if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                RequestUtils.printValues(paramData, "decoded " + val);
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.logp(Level.SEVERE, CLASS_NAME, "parse_decode_Parameter", "unsupported exception--> ", uee);
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException ie) {
            if (ignoreInvalidQueryString) {
                logger.logp(Level.WARNING, CLASS_NAME, "parse_decode_Parameter", "invalid.query.string");
                return null;
            }
            throw ie;
        }
        return paramData;
    }

    private static void printValues(String value, String loc) {
        char[] buffervalue = value.toCharArray();
        byte[] bytevalue = new byte[buffervalue.length];
        for (int ivalue = 0; ivalue < bytevalue.length; ++ivalue) {
            bytevalue[ivalue] = (byte)buffervalue[ivalue];
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "printValues", EMPTY_STRING + loc + " byteValue-->" + bytevalue[ivalue] + " ,charValue-->" + buffervalue[ivalue]);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "printValues", EMPTY_STRING + loc + " -->[" + value + "]");
        }
    }

    private static char[] getSingleBuffer(char[][] buffers, int start_pos, int start_index, int end_pos, int end_index) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getSingleBuffer", "start_pos=" + start_pos + ", start_index=" + start_index + ", end_pos=" + end_pos + ", end_index=" + end_index);
        }
        long bufflen = buffers[start_index].length - start_pos;
        if (start_index != end_index) {
            for (int i = start_index + 1; i <= end_index; ++i) {
                if (i == end_index) {
                    bufflen += (long)end_pos;
                    continue;
                }
                bufflen += (long)buffers[i].length;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "calculated required buffer length =" + bufflen);
        }
        if (bufflen >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        char[] buff = new char[(int)bufflen];
        if (start_index != end_index) {
            int bufferPos = 0;
            for (int count = start_index; count <= end_index; ++count) {
                long len;
                if (count == start_index) {
                    if (start_pos < buffers[start_index].length) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + (buffers[start_index].length - start_pos) + " bytes from buffer " + count);
                        }
                        System.arraycopy(buffers[start_index], start_pos, buff, bufferPos, buffers[start_index].length - start_pos);
                    }
                    bufferPos = buffers[start_index].length - start_pos;
                    buffers[count] = null;
                    continue;
                }
                if (count == end_index) {
                    len = bufferPos + end_pos;
                    if (len > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + end_pos + " bytes from buffer " + count);
                    }
                    System.arraycopy(buffers[count], 0, buff, bufferPos, end_pos);
                    continue;
                }
                len = bufferPos + buffers[count].length;
                if (len > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + buffers[count].length + " bytes from buffer " + count);
                }
                System.arraycopy(buffers[count], 0, buff, bufferPos, buffers[count].length);
                bufferPos += buffers[count].length;
                buffers[count] = null;
            }
        } else {
            System.arraycopy(buffers[start_index], start_pos, buff, 0, buffers[start_index].length - start_pos);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getSingleBuffer");
        }
        return buff;
    }
}

