/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWKProvider {
    private static final TraceComponent tc = Tr.register(JWKProvider.class, (String)"SecurityCommonJWK", (String)"com.ibm.ws.security.common.jwk.internal.resources.JWKCommonMessages");
    protected List<JWK> jwks = Collections.synchronizedList(new ArrayList());
    public static final String RSA = "RSA";
    public static final String RS256 = "RS256";
    public static final String HS256 = "HS256";
    private final int JWKS_TO_GENERATE = 1;
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final long DEFAULT_ROTATION_TIME = 43200000L;
    protected String alg = null;
    protected String use = null;
    protected int size = 2048;
    protected Timer timer;
    protected long rotationTimeInMilliseconds = 43200000L;
    protected PublicKey publicKey = null;
    protected PrivateKey privateKey = null;
    static final long serialVersionUID = -8671861658452312146L;

    protected JWKProvider() {
        this(2048, RS256, 43200000L);
    }

    public JWKProvider(int keySize, String alg, long rotationTimeMs) {
        if (keySize < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Specified key size " + keySize + " < 0. Setting key size to the default (" + 2048 + ") instead"), (Object[])new Object[0]);
            }
            keySize = 2048;
        }
        this.size = keySize;
        this.alg = alg;
        if (rotationTimeMs <= 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Specified rotation time " + rotationTimeMs + " <= 0. Setting rotation time to the default (" + 43200000L + " ms) instead"), (Object[])new Object[0]);
            }
            rotationTimeMs = 43200000L;
        }
        this.rotationTimeInMilliseconds = rotationTimeMs;
        this.scheduleRotationTask();
    }

    public JWKProvider(int keySize, String alg, long rotationTimeMs, PublicKey publicKey, PrivateKey privateKey) {
        if (keySize < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Specified key size " + keySize + " < 0. Setting key size to the default (" + 2048 + ") instead"), (Object[])new Object[0]);
            }
            keySize = 2048;
        }
        this.size = keySize;
        this.alg = alg;
        if (rotationTimeMs <= 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Specified rotation time " + rotationTimeMs + " <= 0. Setting rotation time to the default (" + 43200000L + " ms) instead"), (Object[])new Object[0]);
            }
            rotationTimeMs = 43200000L;
        }
        this.rotationTimeInMilliseconds = rotationTimeMs;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public JSONWebKey getJWK() {
        JWK jwk = null;
        while (this.jwks.size() < 1) {
            this.generateJWKs();
        }
        jwk = this.jwks.get(0);
        return jwk;
    }

    protected void generateJWKs() {
        JWK jwk = null;
        while (this.jwks.size() < 1) {
            jwk = this.generateJWK(this.alg, this.size);
            this.jwks.add(jwk);
        }
    }

    protected JWK generateJWK(String alg, int size) {
        JWK jwk = null;
        if (RS256.equals(alg)) {
            if (this.publicKey != null && this.privateKey != null) {
                jwk = Jose4jRsaJWK.getInstance(alg, this.use, this.publicKey, this.privateKey);
                jwk.generateKey();
            } else {
                jwk = this.generateRsaJWK(alg, size);
            }
        }
        return jwk;
    }

    protected JWK generateRsaJWK(String alg, int size) {
        Jose4jRsaJWK jwk = Jose4jRsaJWK.getInstance(size, alg, null, RSA);
        jwk.generateKey();
        return jwk;
    }

    public String getJwkSetString() {
        if (this.jwks.size() < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Generate JWKs:" + this.jwks.size()), (Object[])new Object[0]);
            }
            this.generateJWKs();
        }
        JWKS obj = new JWKS();
        return obj.toString();
    }

    protected void scheduleRotationTask() {
        RotationTask rotationTask = new RotationTask();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)rotationTask, this.rotationTimeInMilliseconds, this.rotationTimeInMilliseconds);
    }

    protected void rotateKeys() {
        while (this.jwks.size() < 2) {
            JWK jwk = this.generateJWK(this.alg, this.size);
            this.jwks.add(jwk);
        }
        if (this.jwks.size() > 1) {
            this.jwks.remove(0);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class JWKS {
        private List<JSONObject> keys = new ArrayList<JSONObject>();
        static final long serialVersionUID = -5530968906191619526L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected JWKS() {
            for (JWK jwk : JWKProvider.this.jwks) {
                JSONObject jsonKey = jwk != null ? jwk.getJsonObject() : (JSONObject)null;
                this.keys.add(jsonKey);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{\"keys\":[");
            sb.append(this.getKeysString());
            sb.append("]}");
            return sb.toString();
        }

        private String getKeysString() {
            if (this.keys == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<JSONObject> iter = this.keys.iterator();
            while (iter.hasNext()) {
                JSONObject entry = iter.next();
                if (entry == null) {
                    sb.append("null");
                } else {
                    sb.append(entry.toString());
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JWKS.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class RotationTask
    extends TimerTask {
        static final long serialVersionUID = 2899992666302690713L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected RotationTask() {
        }

        @Override
        public void run() {
            JWKProvider.this.rotateKeys();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RotationTask.class);
        }
    }
}

