/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWKSet {
    protected List<JWK> jwks = Collections.synchronizedList(new ArrayList());
    private Map<String, Set<JWK>> jwksBySetId = Collections.synchronizedMap(new HashMap());
    private final long Stale = 600000L;
    JWK theOnePEMJwk = null;
    static final long serialVersionUID = 5478839081425400507L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public List<JWK> getJWKs() {
        return null;
    }

    public synchronized void addJWK(JWK jwk) {
        long current = new Date().getTime();
        ArrayList<JWK> jwksToBeRemoved = new ArrayList<JWK>();
        for (JWK oldJwk : this.jwks) {
            if (current - oldJwk.getCreated() <= 600000L) continue;
            jwksToBeRemoved.add(oldJwk);
        }
        for (JSONWebKey jSONWebKey : jwksToBeRemoved) {
            this.jwks.remove(jSONWebKey);
        }
        this.jwks.add(0, jwk);
    }

    public JSONWebKey getJWKByKid(String id) {
        if (id == null) {
            if (this.jwks.size() == 1) {
                return this.jwks.get(0);
            }
            return null;
        }
        Iterator<JWK> it = this.jwks.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!id.equals(jwk.getKeyID())) continue;
            return jwk;
        }
        return this.getPEMKey();
    }

    private JSONWebKey getJWKByKidInCollection(String kid, Collection<JWK> jwkCollection) {
        if (kid == null) {
            if (jwkCollection.size() == 1) {
                return (JSONWebKey)jwkCollection.toArray()[0];
            }
            return null;
        }
        Iterator<JWK> it = jwkCollection.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!kid.equals(jwk.getKeyID())) continue;
            return jwk;
        }
        if (jwkCollection.size() == 1) {
            return (JSONWebKey)jwkCollection.toArray()[0];
        }
        return null;
    }

    private JSONWebKey getJWKByx5tInCollection(String x5t, Collection<JWK> jwkCollection) {
        Iterator<JWK> it = jwkCollection.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!x5t.equals(jwk.getKeyX5t())) continue;
            return jwk;
        }
        return null;
    }

    public PublicKey getPublicKeyByKid(String id) {
        JSONWebKey jwk = this.getJWKByKid(id);
        if (jwk != null) {
            return jwk.getPublicKey();
        }
        return null;
    }

    public JSONWebKey getJWKByx5t(String id) {
        for (JSONWebKey jSONWebKey : this.jwks) {
            if (!id.equals(jSONWebKey.getKeyX5t())) continue;
            return jSONWebKey;
        }
        return null;
    }

    public PublicKey getPublicKeyByx5t(String id) {
        JSONWebKey jwk = this.getJWKByx5t(id);
        if (jwk != null) {
            return jwk.getPublicKey();
        }
        return null;
    }

    public PublicKey getPublicKeyBySetId(String setId) {
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && jwks.size() == 1) {
            JSONWebKey jwk = jwks.iterator().next();
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndKid(String setId, String kid) {
        JSONWebKey jwk;
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && (jwk = this.getJWKByKidInCollection(kid, jwks)) != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndx5t(String setId, String x5t) {
        JSONWebKey jwk;
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && (jwk = this.getJWKByx5tInCollection(x5t, jwks)) != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public void remove(JSONWebKey jwk) {
        this.jwks.remove(jwk);
    }

    public void remove(int i) {
        this.jwks.remove(i);
    }

    public void add(JWK jwk) {
        this.jwks.add(jwk);
    }

    public void add(int i, JWK jwk) {
        this.jwks.add(i, jwk);
    }

    public void add(String setId, JWK jwk) {
        if (!this.jwksBySetId.containsKey(setId)) {
            this.jwksBySetId.put(setId, Collections.synchronizedSet(new HashSet()));
        }
        this.jwksBySetId.get(setId).add(jwk);
    }

    public void add(JWK jwk, boolean isFromPEM) {
        this.jwks.add(jwk);
        if (isFromPEM) {
            this.theOnePEMJwk = jwk;
        }
    }

    protected JWK getPEMKey() {
        if (this.theOnePEMJwk != null) {
            return this.theOnePEMJwk;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JWKSet.class);
    }
}

