/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config13.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.sources.DynamicConfigSource;
import com.ibm.ws.microprofile.config.sources.InternalConfigSource;
import com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AppPropertyConfigSource
extends InternalConfigSource
implements DynamicConfigSource {
    private static final TraceComponent tc = Tr.register(AppPropertyConfigSource.class);
    private BundleContext bundleContext;
    private String applicationName;
    static final long serialVersionUID = -1514291017088997571L;

    public AppPropertyConfigSource() {
        super(600, Tr.formatMessage((TraceComponent)tc, (String)"server.xml.appproperties.config.source", (Object[])new Object[0]));
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        SortedSet<Configuration> osgiConfigs = this.getOSGiConfigurations();
        for (Configuration osgiConfig : osgiConfigs) {
            Dictionary dict = osgiConfig.getProperties();
            Enumeration keys = dict.keys();
            Object myKey = null;
            Object myValue = null;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.equals("name")) {
                    myKey = dict.get(key);
                }
                if (key.equals("value")) {
                    myValue = dict.get(key);
                }
                if (myKey == null || myValue == null) continue;
                props.put(myKey.toString(), myValue.toString());
            }
        }
        return props;
    }

    private SortedSet<Configuration> getOSGiConfigurations() {
        PrivilegedAction<SortedSet> configAction = () -> {
            if (this.bundleContext == null) {
                this.bundleContext = OSGiConfigUtils.getBundleContext(this.getClass());
            }
            if (this.applicationName == null) {
                this.applicationName = OSGiConfigUtils.getApplicationName(this.bundleContext);
            }
            SortedSet<Configuration> osgiConfigs = OSGiConfigUtils.getConfigurations(this.bundleContext, this.applicationName);
            return osgiConfigs;
        };
        SortedSet osgiConfigs = AccessController.doPrivileged(configAction);
        return osgiConfigs;
    }
}

