/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config13.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.interfaces.ConfigStartException;
import com.ibm.ws.microprofile.config13.interfaces.Config13Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.Application;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OSGiConfigUtils {
    private static final TraceComponent tc = Tr.register(OSGiConfigUtils.class);
    public static final String CFG_SERVICE_FACTORY_PID = "service.factoryPid";
    public static final String CFG_APP_PROPERTIES = "com.ibm.ws.appconfig.appProperties";
    public static final String CFG_CONFIG_PARENT_PID = "config.parentPID";
    public static final String CFG_APP_PROPERTIES_PROPERTY = "com.ibm.ws.appconfig.appProperties.property";
    static final long serialVersionUID = 2652527315834098484L;

    public static String getApplicationName(BundleContext bundleContext) {
        String applicationName = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        applicationName = cmd == null ? OSGiConfigUtils.getCDIAppName(bundleContext) : cmd.getJ2EEName().getApplication();
        if (applicationName == null) {
            if (cmd == null) {
                throw new ConfigStartException(Tr.formatMessage((TraceComponent)tc, (String)"no.application.name.CWMCG0201E", (Object[])new Object[0]));
            }
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"no.application.name.CWMCG0201E", (Object[])new Object[0]));
        }
        return applicationName;
    }

    public static BundleContext getBundleContext(Class<?> clazz) {
        return FrameworkUtil.getBundle(clazz).getBundleContext();
    }

    public static ConfigurationAdmin getConfigurationAdmin(BundleContext bundleContext) {
        return OSGiConfigUtils.getService(bundleContext, ConfigurationAdmin.class);
    }

    public static CDIService getCDIService(BundleContext bundleContext) {
        return OSGiConfigUtils.getService(bundleContext, CDIService.class);
    }

    public static ConfigVariables getConfigVariables(BundleContext bundleContext) {
        return OSGiConfigUtils.getService(bundleContext, ConfigVariables.class);
    }

    public static <T> T getService(BundleContext bundleContext, Class<T> serviceClass) {
        ServiceReference ref = bundleContext.getServiceReference(serviceClass);
        Object service = null;
        if (ref != null) {
            service = bundleContext.getService(ref);
        }
        return (T)service;
    }

    /*
     * WARNING - void declaration
     */
    public static ServiceReference<Application> getApplicationServiceRef(BundleContext bundleContext, String applicationName) {
        Collection appRefs;
        try {
            appRefs = bundleContext.getServiceReferences(Application.class, FilterUtils.createPropertyFilter((String)"name", (String)applicationName));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils", (String)"153", null, (Object[])new Object[]{bundleContext, applicationName});
            throw new ConfigException((Throwable)e);
        }
        ServiceReference appRef = null;
        if (appRefs != null && appRefs.size() > 0) {
            if (appRefs.size() > 1) {
                throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"duplicate.application.name.CWMCG0202E", (Object[])new Object[]{applicationName}));
            }
            appRef = (ServiceReference)appRefs.iterator().next();
        }
        return appRef;
    }

    public static String getApplicationPID(BundleContext bundleContext, String applicationName) {
        String applicationPID = null;
        ServiceReference<Application> appRef = OSGiConfigUtils.getApplicationServiceRef(bundleContext, applicationName);
        if (appRef != null) {
            applicationPID = (String)appRef.getProperty("service.pid");
            String sourcePid = (String)appRef.getProperty("ibm.extends.source.pid");
            if (sourcePid != null) {
                applicationPID = sourcePid;
            }
        }
        return applicationPID;
    }

    public static String getCDIAppName(BundleContext bundleContext) {
        String appName = null;
        CDIService cdiService = OSGiConfigUtils.getCDIService(bundleContext);
        if (cdiService != null) {
            appName = cdiService.getCurrentApplicationContextID();
        }
        return appName;
    }

    public static String getApplicationPropertiesConfigFilter(String applicationPid) {
        String applicationConfigFilter = null;
        StringBuilder applicationFilter = new StringBuilder(200);
        applicationFilter.append("(&");
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_SERVICE_FACTORY_PID, (String)CFG_APP_PROPERTIES));
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_CONFIG_PARENT_PID, (String)applicationPid));
        applicationFilter.append(')');
        applicationConfigFilter = applicationFilter.toString();
        return applicationConfigFilter;
    }

    public static String getApplicationPropertiesPropertyConfigFilter(String applicationPropertyPid) {
        String applicationConfigFilter = null;
        StringBuilder applicationFilter = new StringBuilder(200);
        applicationFilter.append("(&");
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_SERVICE_FACTORY_PID, (String)CFG_APP_PROPERTIES_PROPERTY));
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_CONFIG_PARENT_PID, (String)applicationPropertyPid));
        applicationFilter.append(')');
        applicationConfigFilter = applicationFilter.toString();
        return applicationConfigFilter;
    }

    /*
     * WARNING - void declaration
     */
    public static SortedSet<Configuration> getConfigurations(BundleContext bundleContext, String applicationName) {
        TreeSet<Configuration> configSet = new TreeSet<Configuration>((o1, o2) -> o1.getPid().compareTo(o2.getPid()));
        try {
            String applicationPID = OSGiConfigUtils.getApplicationPID(bundleContext, applicationName);
            String applicationPropertiesPid = null;
            ConfigurationAdmin admin = OSGiConfigUtils.getConfigurationAdmin(bundleContext);
            if (applicationPID != null && admin != null) {
                String appPropertiesPropertyFilter;
                Configuration[] appPropertiesPropertyOsgiConfigs;
                String appPropertiesFilter = OSGiConfigUtils.getApplicationPropertiesConfigFilter(applicationPID);
                Configuration[] appPropertiesOsgiConfigs = admin.listConfigurations(appPropertiesFilter);
                if (appPropertiesOsgiConfigs != null) {
                    for (Configuration cfg : appPropertiesOsgiConfigs) {
                        applicationPropertiesPid = cfg.getPid();
                    }
                }
                if (applicationPropertiesPid != null && (appPropertiesPropertyOsgiConfigs = admin.listConfigurations(appPropertiesPropertyFilter = OSGiConfigUtils.getApplicationPropertiesPropertyConfigFilter(applicationPropertiesPid))) != null) {
                    for (Configuration cfg : appPropertiesPropertyOsgiConfigs) {
                        configSet.add(cfg);
                    }
                }
            }
        }
        catch (IOException | InvalidSyntaxException applicationPID) {
            void e;
            FFDCFilter.processException((Throwable)applicationPID, (String)"com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils", (String)"283", null, (Object[])new Object[]{bundleContext, applicationName});
            throw new ConfigException((Throwable)e);
        }
        return configSet;
    }

    public static Map<String, String> getVariableFromServerXML(BundleContext bundleContext) {
        ConfigVariables configVars = OSGiConfigUtils.getConfigVariables(bundleContext);
        Map theMap = configVars.getUserDefinedVariables();
        return theMap;
    }

    public static boolean isSystemKey(String key) {
        for (String prefix : Config13Constants.SYSTEM_PREFIXES) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

