/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config13.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.sources.DynamicConfigSource;
import com.ibm.ws.microprofile.config.sources.InternalConfigSource;
import com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerXMLVariableConfigSource
extends InternalConfigSource
implements DynamicConfigSource {
    private static final TraceComponent tc = Tr.register(ServerXMLVariableConfigSource.class);
    private BundleContext bundleContext;
    static final long serialVersionUID = 4036698666202618613L;

    public ServerXMLVariableConfigSource() {
        super(500, Tr.formatMessage((TraceComponent)tc, (String)"server.xml.variable.config.source", (Object[])new Object[0]));
    }

    public Map<String, String> getProperties() {
        PrivilegedAction<Map> configAction = () -> {
            if (this.bundleContext == null) {
                this.bundleContext = OSGiConfigUtils.getBundleContext(this.getClass());
            }
            Map<String, String> osgiConfigs = OSGiConfigUtils.getVariableFromServerXML(this.bundleContext);
            return osgiConfigs;
        };
        Map props = AccessController.doPrivileged(configAction);
        return props;
    }
}

