/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.support.web.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.app.manager.springboot.container.config.SpringConfiguration;
import com.ibm.ws.app.manager.springboot.container.config.SpringErrorPageData;
import com.ibm.ws.app.manager.springboot.support.ContainerInstanceFactory;
import com.ibm.ws.app.manager.springboot.support.SpringBootApplication;
import com.ibm.ws.container.ErrorPage;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.TagLibContainerInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.springboot.support.web.server.initializer.WebInitializer;
import com.ibm.ws.springboot.support.web.server.internal.WebInstanceFactory;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebInstance
implements ContainerInstanceFactory.Instance {
    private static final String APP_NAME_KEY = "com.ibm.websphere.servlet.enterprise.application.name";
    private final WebInstanceFactory instanceFactory;
    private final SpringBootApplication app;
    private final AtomicReference<DeployedModuleInfo> deployed = new AtomicReference();
    private final ServiceTracker<VirtualHost, VirtualHost> tracker;
    static final long serialVersionUID = 3182332933752264139L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebInstance(WebInstanceFactory instanceFactory, SpringBootApplication app, String id, String virtualHostId, WebInitializer initializer, ServiceTracker<VirtualHost, VirtualHost> tracker, SpringConfiguration additionalConfig) throws IOException, UnableToAdaptException, MetaDataException {
        this.instanceFactory = instanceFactory;
        this.app = app;
        this.tracker = tracker;
        this.installIntoWebContainer(id, virtualHostId, initializer, additionalConfig);
    }

    private void installIntoWebContainer(String id, String virtualHostId, WebInitializer initializer, SpringConfiguration cfg) throws IOException, UnableToAdaptException, MetaDataException {
        String contextPath = initializer.getContextPath();
        if (contextPath == null) {
            contextPath = "/";
        } else if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        Container appContainer = this.app.createContainerFor(virtualHostId);
        WebModuleClassesInfo classesInfo = new WebModuleClassesInfo(){
            static final long serialVersionUID = 826867941009874650L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public List<ContainerInfo> getClassesContainers() {
                return Collections.emptyList();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        NonPersistentCache npc = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
        npc.addToCache(WebModuleClassesInfo.class, (Object)classesInfo);
        TagLibContainerInfo tagLibInfo = new TagLibContainerInfo(){
            static final long serialVersionUID = -7411801367201443171L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public List<ContainerInfo> getTagLibContainers() {
                return WebInstance.this.app.getSpringClassesContainerInfo().getClassesContainerInfo();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        npc.addToCache(TagLibContainerInfo.class, (Object)tagLibInfo);
        ExtendedApplicationInfo appInfo = this.app.createApplicationInfo(id, appContainer);
        final InstanceDeployedAppInfo deployedApp = new InstanceDeployedAppInfo(initializer, this.instanceFactory.getDeployedAppFactory(), appInfo);
        DeployedModuleInfo deployedModule = deployedApp.createDeployedModule(appContainer, id, this.app, cfg);
        this.deployed.set(deployedModule);
        deployedApp.registerServletContainerListener(this.instanceFactory.getContext());
        Future appFuture = this.instanceFactory.getModuleHandler().deployModule(deployedModule, (DeployedAppInfo)deployedApp);
        this.instanceFactory.getFutureMonitor().onCompletion(appFuture, (CompletionListener)new CompletionListener<Boolean>(){
            static final long serialVersionUID = 6779063790488840103L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void successfulCompletion(Future<Boolean> future, Boolean result) {
            }

            public void failedCompletion(Future<Boolean> future, Throwable t) {
                deployedApp.unregisterServletContainerListener();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        this.tracker.open();
        try {
            VirtualHost v = (VirtualHost)this.tracker.waitForService(30000L);
            if (v == null) {
                throw new IllegalStateException("Virtual host not configured.");
            }
        }
        catch (InterruptedException v) {
            void e;
            FFDCFilter.processException((Throwable)v, (String)"com.ibm.ws.springboot.support.web.server.internal.WebInstance", (String)"214", (Object)this, (Object[])new Object[0]);
            Thread.currentThread().interrupt();
            throw new RuntimeException((Throwable)e);
        }
        finally {
            this.tracker.close();
        }
    }

    public void stop() {
        DeployedModuleInfo deployedModule = this.deployed.getAndSet(null);
        if (deployedModule != null) {
            this.instanceFactory.getModuleHandler().undeployModule(deployedModule);
            deployedModule.getModuleInfo().getApplicationInfo();
            this.app.destroyApplicationInfo((ExtendedApplicationInfo)deployedModule.getModuleInfo().getApplicationInfo());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebInstance.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class InstanceDeployedAppInfo
    extends SimpleDeployedAppInfoBase
    implements ServletContainerInitializer {
        private final WebInitializer initializer;
        private final AtomicReference<ServiceRegistration<ServletContainerInitializer>> sciRegistration;
        private final AtomicReference<String> appName;
        static final long serialVersionUID = 5021926516952147600L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        InstanceDeployedAppInfo(WebInitializer initializer, DeployedAppInfoFactoryBase factory, ExtendedApplicationInfo appInfo) throws UnableToAdaptException {
            super(factory);
            this.sciRegistration = new AtomicReference();
            this.appName = new AtomicReference();
            this.appInfo = appInfo;
            this.initializer = initializer;
        }

        DeployedModuleInfo createDeployedModule(Container appContainer, String id, SpringBootApplication app, SpringConfiguration additionalConfig) throws UnableToAdaptException, MetaDataException {
            String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)id);
            SimpleDeployedAppInfoBase.WebModuleContainerInfo mci = new SimpleDeployedAppInfoBase.WebModuleContainerInfo(WebInstance.this.instanceFactory.getModuleHandler(), (List)WebInstance.this.instanceFactory.getDeployedAppFactory().getModuleMetaDataExtenders().get("web"), (List)WebInstance.this.instanceFactory.getDeployedAppFactory().getNestedModuleMetaDataFactories().get("web"), appContainer, null, moduleURI, this.moduleClassesInfo, this.initializer.getContextPath());
            this.moduleContainerInfos.add(mci);
            WebModuleMetaData mmd = (WebModuleMetaData)mci.createModuleMetaData((ApplicationInfo)this.appInfo, (SimpleDeployedAppInfoBase)this, (m, c) -> app.getClassLoader());
            this.addSpringConfigToModuleMetadata(mmd, additionalConfig);
            this.appName.set(mmd.getJ2EEName().getApplication());
            return this.getDeployedModule(mci.moduleInfo);
        }

        private void addSpringConfigToModuleMetadata(WebModuleMetaData mmd, SpringConfiguration additionalConfig) {
            WebAppConfiguration wac = (WebAppConfiguration)mmd.getConfiguration();
            HashMap code_errorPage_hm = wac.getCodeErrorPages();
            wac.setMimeMappings(additionalConfig.getMimeMappings());
            HashMap exception_errorPage_hm = wac.getExceptionErrorPages();
            for (SpringErrorPageData spr_ep : additionalConfig.getErrorPages()) {
                if (spr_ep.isGlobal()) {
                    wac.setDefaultErrorPage(spr_ep.getLocation());
                    continue;
                }
                ErrorPage container_ep = new ErrorPage(spr_ep.getLocation());
                if (spr_ep.getErrorCode() != null) {
                    container_ep.setErrorParam(spr_ep.getErrorCode().toString());
                    code_errorPage_hm.put(Integer.valueOf(spr_ep.getErrorCode()), container_ep);
                    continue;
                }
                if (spr_ep.getExceptionType() == null) continue;
                container_ep.setErrorParam(spr_ep.getExceptionType());
                exception_errorPage_hm.put(spr_ep.getExceptionType().toString(), container_ep);
            }
        }

        public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
            String expectedName = this.appName.get();
            if (expectedName == null) {
                expectedName = this.appInfo.getName();
            }
            if (expectedName.equals(context.getAttribute(WebInstance.APP_NAME_KEY))) {
                this.initializer.getContextInitializer().apply(context);
                this.unregisterServletContainerListener();
            }
        }

        public void registerServletContainerListener(BundleContext context) {
            this.sciRegistration.set((ServiceRegistration<ServletContainerInitializer>)context.registerService(ServletContainerInitializer.class, (Object)this, null));
        }

        public void unregisterServletContainerListener() {
            this.sciRegistration.getAndUpdate(r -> {
                if (r != null) {
                    r.unregister();
                }
                return null;
            });
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InstanceDeployedAppInfo.class);
        }
    }
}

