/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.osgi.framework.Version;

public class BootstrapManifest {
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String JAR_PROTOCOL = "jar";
    static final String SYSTEM_PKG_PREFIX = "OSGI-OPT/websphere/system-packages_";
    static final String SYSTEM_PKG_SUFFIX = ".properties";
    static final String MANIFEST_EXPORT_PACKAGE = "Export-Package";
    private static BootstrapManifest instance = null;
    private final Attributes manifestAttributes;
    private final boolean libertyBoot;

    public static BootstrapManifest readBootstrapManifest(boolean libertyBoot) throws IOException {
        BootstrapManifest manifest = instance;
        if (manifest == null) {
            manifest = instance = new BootstrapManifest(libertyBoot);
        }
        return manifest;
    }

    public static void dispose() {
        instance = null;
    }

    protected BootstrapManifest() throws IOException {
        this(false);
    }

    protected BootstrapManifest(boolean libertyBoot) throws IOException {
        this.libertyBoot = libertyBoot;
        this.manifestAttributes = libertyBoot ? BootstrapManifest.getLibertyBootAttributes() : BootstrapManifest.getAttributesFromBootstrapJar();
    }

    private static Attributes getAttributesFromBootstrapJar() throws IOException {
        Attributes attributes;
        JarFile jf = null;
        try {
            jf = new JarFile(KernelUtils.getBootstrapJar());
            Manifest mf = jf.getManifest();
            attributes = mf.getMainAttributes();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Utils.tryToClose(jf);
                throw throwable;
            }
        }
        Utils.tryToClose(jf);
        return attributes;
    }

    private static Attributes getLibertyBootAttributes() {
        JarFile jf = BootstrapManifest.getLibertBootJarFile();
        try {
            Manifest mf = jf.getManifest();
            Attributes attributes = mf.getMainAttributes();
            return attributes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Utils.tryToClose(jf);
        }
    }

    private static JarFile getLibertBootJarFile() {
        return BootstrapManifest.getJarFile(BootstrapManifest.class.getResource(BootstrapManifest.class.getSimpleName() + ".class"));
    }

    private static JarFile getJarFile(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof JarURLConnection) {
                    return ((JarURLConnection)conn).getJarFile();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("No jar file found: " + url, e);
            }
        }
        throw new IllegalArgumentException("Not a jar URL: " + url);
    }

    private JarFile getBootJar() throws IOException {
        return this.libertyBoot ? BootstrapManifest.getLibertBootJarFile() : new JarFile(KernelUtils.getBootstrapJar());
    }

    public String getBundleVersion() {
        return this.manifestAttributes.getValue(BUNDLE_VERSION);
    }

    public void prepSystemPackages(BootstrapConfig bootProps) {
        String packages = bootProps.get("org.osgi.framework.system.packages.extra");
        String syspackages = bootProps.get("org.osgi.framework.system.packages");
        String mPackages = this.manifestAttributes.getValue(MANIFEST_EXPORT_PACKAGE);
        if (mPackages != null) {
            String string = packages = packages == null ? mPackages : packages + "," + mPackages;
            if (packages != null) {
                bootProps.put("org.osgi.framework.system.packages.extra", packages);
            }
        }
        if (syspackages == null) {
            String javaVersion = System.getProperty("java.version", "1.6.0");
            int index = javaVersion.indexOf(95);
            index = index == -1 ? javaVersion.indexOf(45) : index;
            javaVersion = index == -1 ? javaVersion : javaVersion.substring(0, index);
            String pkgListFileName = SYSTEM_PKG_PREFIX + javaVersion + SYSTEM_PKG_SUFFIX;
            JarFile jarFile = null;
            try {
                jarFile = this.getBootJar();
                List<String> systemPackageFileNames = new ArrayList<String>();
                Enumeration<JarEntry> bootstrapJarEntries = jarFile.entries();
                while (bootstrapJarEntries.hasMoreElements()) {
                    JarEntry entry = bootstrapJarEntries.nextElement();
                    if (entry == null || !entry.getName().startsWith(SYSTEM_PKG_PREFIX) || !entry.getName().endsWith(SYSTEM_PKG_SUFFIX)) continue;
                    systemPackageFileNames.add(entry.getName());
                }
                Collections.sort(systemPackageFileNames, new Comparator<String>(){

                    @Override
                    public int compare(String name1, String name2) {
                        Version oneVersion = this.getVersion(name1);
                        Version twoVersion = this.getVersion(name2);
                        return twoVersion.compareTo(oneVersion);
                    }

                    private Version getVersion(String name) {
                        String version = name.substring(BootstrapManifest.SYSTEM_PKG_PREFIX.length(), name.length());
                        version = version.substring(0, version.indexOf(BootstrapManifest.SYSTEM_PKG_SUFFIX, 0));
                        return new Version(version);
                    }
                });
                if (!systemPackageFileNames.isEmpty()) {
                    int indexOfPackageFileToUse = systemPackageFileNames.indexOf(pkgListFileName);
                    if (indexOfPackageFileToUse < 0) {
                        indexOfPackageFileToUse = 0;
                    }
                    systemPackageFileNames = systemPackageFileNames.subList(indexOfPackageFileToUse, systemPackageFileNames.size());
                } else {
                    systemPackageFileNames = Arrays.asList(pkgListFileName);
                }
                syspackages = this.getMergedSystemProperties(jarFile, systemPackageFileNames);
                if (syspackages != null) {
                    bootProps.put("org.osgi.framework.system.packages", syspackages);
                }
            }
            catch (IOException ioe) {
                throw new LaunchException("Unable to find or read specified properties file; " + pkgListFileName, MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), ioe.toString()), ioe);
            }
            finally {
                Utils.tryToClose(jarFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMergedSystemProperties(JarFile jarFile, List<String> pkgListFileNames) throws IOException {
        String packages = null;
        boolean inheritSystemPackages = true;
        for (String pkgListFileName : pkgListFileNames) {
            if (!inheritSystemPackages) continue;
            ZipEntry propFile = jarFile.getEntry(pkgListFileName);
            if (propFile != null) {
                Properties properties = new Properties();
                InputStream is = jarFile.getInputStream(propFile);
                try {
                    properties.load(is);
                    String loadedPackages = properties.getProperty("org.osgi.framework.system.packages");
                    if (loadedPackages != null) {
                        packages = packages == null ? loadedPackages : packages + "," + loadedPackages;
                    }
                    inheritSystemPackages &= Boolean.parseBoolean(properties.getProperty("websphere.inherit.system.packages", "true"));
                    continue;
                }
                finally {
                    Utils.tryToClose(is);
                    continue;
                }
            }
            throw new IOException("Unable to find specified properties file; " + pkgListFileName);
        }
        return packages;
    }
}

