/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UserRegistryWrapper
implements com.ibm.websphere.security.UserRegistry {
    private final UserRegistry wrappedUr;
    static final long serialVersionUID = 1875918962556666600L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UserRegistryWrapper(UserRegistry wrappedUr) {
        this.wrappedUr = wrappedUr;
    }

    public void initialize(Properties props) throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    public String checkPassword(String userSecurityName, @Sensitive String password) throws PasswordCheckFailedException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            String ret = this.wrappedUr.checkPassword(userSecurityName, password);
            if (ret == null) {
                throw new PasswordCheckFailedException("Unable to authenticate given specified username and password combination");
            }
            return ret;
        }
        catch (RegistryException ret) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = userSecurityName;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)ret, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"60", (Object)this, (Object[])objectArray);
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new PasswordCheckFailedException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={CertificateMapFailedException.class})
    public String mapCertificate(X509Certificate[] chain) throws com.ibm.websphere.security.CertificateMapNotSupportedException, com.ibm.websphere.security.CertificateMapFailedException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.mapCertificate(chain);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"73", (Object)this, (Object[])new Object[]{chain});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (CertificateMapNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"75", (Object)this, (Object[])new Object[]{chain});
            throw new com.ibm.websphere.security.CertificateMapNotSupportedException(e.getMessage(), (Throwable)e);
        }
        catch (CertificateMapFailedException e) {
            throw new com.ibm.websphere.security.CertificateMapFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public String getRealm() throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
        return this.wrappedUr.getRealm();
    }

    /*
     * WARNING - void declaration
     */
    public Result getUsers(String pattern, int limit) throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            SearchResult ret = this.wrappedUr.getUsers(pattern, limit);
            Result result = new Result();
            result.setList(ret.getList());
            if (ret.hasMore()) {
                result.setHasMore();
            }
            return result;
        }
        catch (RegistryException ret) {
            void e;
            FFDCFilter.processException((Throwable)ret, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"100", (Object)this, (Object[])new Object[]{pattern, limit});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUserDisplayName(String userSecurityName) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getUserDisplayName(userSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"111", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUniqueUserId(String userSecurityName) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getUniqueUserId(userSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"124", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUserSecurityName(String uniqueUserId) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getUserSecurityName(uniqueUserId);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"137", (Object)this, (Object[])new Object[]{uniqueUserId});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    public boolean isValidUser(String userSecurityName) throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.isValidUser(userSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"150", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Result getGroups(String pattern, int limit) throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            SearchResult ret = this.wrappedUr.getGroups(pattern, limit);
            Result result = new Result();
            result.setList(ret.getList());
            if (ret.hasMore()) {
                result.setHasMore();
            }
            return result;
        }
        catch (RegistryException ret) {
            void e;
            FFDCFilter.processException((Throwable)ret, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"169", (Object)this, (Object[])new Object[]{pattern, limit});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getGroupDisplayName(String groupSecurityName) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getGroupDisplayName(groupSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"180", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUniqueGroupId(String groupSecurityName) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getUniqueGroupId(groupSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"193", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public List<String> getUniqueGroupIds(String uniqueUserId) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getUniqueGroupIdsForUser(uniqueUserId);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"206", (Object)this, (Object[])new Object[]{uniqueUserId});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getGroupSecurityName(String uniqueGroupId) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getGroupSecurityName(uniqueGroupId);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"219", (Object)this, (Object[])new Object[]{uniqueGroupId});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    public boolean isValidGroup(String groupSecurityName) throws com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.isValidGroup(groupSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"232", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntryNotFoundException.class})
    public List<String> getGroupsForUser(String userSecurityName) throws com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            return this.wrappedUr.getGroupsForUser(userSecurityName);
        }
        catch (RegistryException registryException) {
            void e;
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"245", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (EntryNotFoundException e) {
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public Result getUsersForGroup(String groupSecurityName, int limit) throws com.ibm.websphere.security.NotImplementedException, com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        try {
            SearchResult ret = this.wrappedUr.getUsersForGroup(groupSecurityName, limit);
            Result result = new Result();
            if (ret != null) {
                result.setList(ret.getList());
                if (ret.hasMore()) {
                    result.setHasMore();
                }
            }
            return result;
        }
        catch (NotImplementedException ret) {
            FFDCFilter.processException((Throwable)ret, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"270", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new com.ibm.websphere.security.NotImplementedException("The getUsersForGroup API is not implemented");
        }
        catch (EntryNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"272", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new com.ibm.websphere.security.EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (CustomRegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"274", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.UserRegistryWrapper", (String)"276", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new com.ibm.websphere.security.CustomRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public WSCredential createCredential(String userSecurityName) throws com.ibm.websphere.security.NotImplementedException, com.ibm.websphere.security.EntryNotFoundException, com.ibm.websphere.security.CustomRegistryException, RemoteException {
        throw new com.ibm.websphere.security.NotImplementedException("The createCredential method is not available");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UserRegistryWrapper.class);
    }
}

