/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class URLHandler {
    private static final TraceComponent tc = Tr.register(URLHandler.class);
    protected final WebAppSecurityConfig webAppSecConfig;
    static final long serialVersionUID = -230891797278230214L;

    public URLHandler(WebAppSecurityConfig webAppSecConfig) {
        this.webAppSecConfig = webAppSecConfig;
    }

    @Sensitive
    protected String encodeURL(@Sensitive String url) {
        url = url.replaceAll("%", "%25");
        url = url.replaceAll(";", "%3B");
        url = url.replaceAll(",", "%2C");
        return url;
    }

    @Sensitive
    protected String decodeURL(@Sensitive String url) {
        url = url.replaceAll("%2C", ",");
        url = url.replaceAll("%3B", ";");
        url = url.replaceAll("%25", "%");
        return url;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    protected String removeHostNameFromURL(@Sensitive String url) {
        block3: {
            try {
                int doubleSlash = url.indexOf("//");
                int firstSingleSlash = url.indexOf("/", doubleSlash + 2);
                URL originalURL = new URL(url);
                StringBuffer workURL = new StringBuffer();
                workURL.append(originalURL.getProtocol());
                workURL.append("://");
                int port = originalURL.getPort();
                if (port != -1) {
                    workURL.append(":");
                    workURL.append(port);
                }
                url = workURL.append(url.substring(firstSingleSlash)).toString();
            }
            catch (MalformedURLException doubleSlash) {
                void e;
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)doubleSlash, (String)"com.ibm.ws.webcontainer.security.internal.URLHandler", (String)"102", (Object)this, (Object[])objectArray);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"removeHostNameFromURL", (Object[])new Object[]{e});
            }
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    protected String restoreHostNameToURL(@Sensitive String referrerURL, String url) {
        block5: {
            if (referrerURL.startsWith("/") || referrerURL.length() == 0) {
                int doubleSlash = url.indexOf("//");
                int firstSingleSlash = url.indexOf("/", doubleSlash + 2);
                referrerURL = url.substring(0, firstSingleSlash) + referrerURL;
            } else {
                try {
                    URL referrer = new URL(referrerURL);
                    String referrerHost = referrer.getHost();
                    if (referrerHost == null || referrerHost.length() == 0) {
                        URL currentURL = new URL(url);
                        String currentHost = currentURL.getHost();
                        int doubleSlash = referrerURL.indexOf("//");
                        StringBuffer newURLBuf = new StringBuffer(referrerURL);
                        newURLBuf.insert(doubleSlash + 2, currentHost);
                        referrerURL = newURLBuf.toString();
                    }
                }
                catch (MalformedURLException referrer) {
                    void e;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = "<sensitive java.lang.String>";
                    objectArray[1] = url;
                    FFDCFilter.processException((Throwable)referrer, (String)"com.ibm.ws.webcontainer.security.internal.URLHandler", (String)"143", (Object)this, (Object[])objectArray);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"restoreHostNameToURL", (Object[])new Object[]{e});
                }
            }
        }
        return referrerURL;
    }

    public String getServletURI(HttpServletRequest req) {
        int sindex;
        String uriName = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            uriName = uriName.concat(pathInfo);
        }
        if (uriName == null || uriName.length() == 0) {
            uriName = "/";
        }
        if ((sindex = (uriName = WSUtil.resolveURI((String)uriName)).indexOf(";")) != -1) {
            uriName = uriName.substring(0, sindex);
        }
        if (uriName.indexOf(":") >= 0) {
            uriName = uriName.replaceAll(":", "%3A");
        }
        return uriName;
    }
}

