/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.pacing;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;

public abstract class MessagePacingControlFactory {
    private static String CLASS_NAME = MessagePacingControlFactory.class.getName();
    private static final TraceComponent tc = SibTr.register(MessagePacingControlFactory.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static MessagePacingControl singleton = null;

    public static final synchronized MessagePacingControl getInstance() {
        if (!RasHelper.isServer()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"MessagePacingControl not available in a client process");
            }
            return null;
        }
        if (singleton == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.wsspi.sib.pacing.impl.MessagePacingControlImpl");
                singleton = (MessagePacingControl)cls.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"MessagePacingControl not available within application server");
                }
                return null;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                throw new RuntimeException(e);
            }
        }
        return singleton;
    }
}

