/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.Batcher;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRebalanceListener;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AckTracker
implements ConsumerRebalanceListener {
    private static final TraceComponent tc = Tr.register(AckTracker.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final Map<TopicPartition, PartitionAckTracker> partitionTrackers;
    private final ScheduledExecutorService executor;
    private final int ackThreshold;
    private final AtomicInteger outstandingAcks;
    private CommitAction commitAction = (p, o) -> CompletableFuture.completedFuture(null);
    private CompletableFuture<Void> ackThresholdStage = CompletableFuture.completedFuture(null);
    private final KafkaAdapterFactory kafkaAdapterFactory;
    static final long serialVersionUID = 5797060897036150652L;

    public AckTracker(KafkaAdapterFactory kafkaAdapterFactory, ScheduledExecutorService executor, int ackThreshold) {
        this.kafkaAdapterFactory = kafkaAdapterFactory;
        this.executor = executor;
        this.ackThreshold = ackThreshold;
        this.partitionTrackers = Collections.synchronizedMap(new HashMap());
        this.outstandingAcks = new AtomicInteger(0);
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(partitions.size() + " removed partitions"), (Object[])new Object[]{partitions});
        }
        for (TopicPartition partition : partitions) {
            PartitionAckTracker tracker = this.partitionTrackers.remove(partition);
            if (tracker == null) continue;
            tracker.close();
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(partitions.size() + " new partitions"), (Object[])new Object[]{partitions});
        }
        for (TopicPartition partition : partitions) {
            if (this.partitionTrackers.get(partition) != null) continue;
            this.partitionTrackers.put(partition, new PartitionAckTracker(partition));
        }
    }

    public Supplier<CompletionStage<Void>> trackRecord(ConsumerRecord<?, ?> record) {
        TopicPartition partition = this.kafkaAdapterFactory.newTopicPartition(record.topic(), record.partition());
        PartitionAckTracker partitionTracker = this.partitionTrackers.get(partition);
        if (partitionTracker == null) {
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(this.kafkaAdapterFactory.newCommitFailedException());
            return () -> failedFuture;
        }
        MessageAckData ackData = partitionTracker.recordSent(record);
        return () -> partitionTracker.recordAck(ackData);
    }

    public void setCommitAction(CommitAction commitAction) {
        this.commitAction = commitAction;
    }

    public CompletionStage<Void> waitForAckThreshold() {
        return this.ackThresholdStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<TopicPartition, PartitionAckTracker> map = this.partitionTrackers;
        synchronized (map) {
            Iterator<PartitionAckTracker> i = this.partitionTrackers.values().iterator();
            while (i.hasNext()) {
                PartitionAckTracker tracker = i.next();
                i.remove();
                try {
                    tracker.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.AckTracker", (String)"147", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementOutstandingAcks() {
        AtomicInteger atomicInteger = this.outstandingAcks;
        synchronized (atomicInteger) {
            int outstanding = this.outstandingAcks.incrementAndGet();
            if (outstanding == this.ackThreshold) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Too many outstanding unacked messages, stopping polling kafka. Current count: " + outstanding), (Object[])new Object[0]);
                }
                this.ackThresholdStage = new CompletableFuture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementOutstandingAcks() {
        CompletableFuture<Void> thresholdStage;
        int outstanding;
        AtomicInteger atomicInteger = this.outstandingAcks;
        synchronized (atomicInteger) {
            outstanding = this.outstandingAcks.getAndDecrement();
            thresholdStage = this.ackThresholdStage;
        }
        if (outstanding == this.ackThreshold) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Outstanding unacked message count dropped below threshold, resuming polling kafka. Current count: " + outstanding), (Object[])new Object[0]);
            }
            thresholdStage.complete(null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MessageAckData {
        private final long offset;
        private CompletableFuture<Void> completion;
        private final Optional<Integer> leaderEpoch;
        static final long serialVersionUID = -3157412437713254902L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MessageAckData(long offset, Optional<Integer> leaderEpoch) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.completion = null;
        }

        public void setCompletion(CompletableFuture<Void> completion) {
            this.completion = completion;
        }

        public CompletableFuture<Void> getCompletion() {
            return this.completion;
        }

        public Optional<Integer> getLeaderEpoch() {
            return this.leaderEpoch;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.AckTracker$MessageAckData", MessageAckData.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class PartitionAckTracker {
        private final List<MessageAckData> unackedMessages;
        private final Batcher<MessageAckData> messageBatcher;
        private final TopicPartition partition;
        static final long serialVersionUID = 8789116834583355532L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PartitionAckTracker(TopicPartition partition) {
            this.messageBatcher = Batcher.create(MessageAckData.class).withMaxBatchSize(2000).withMaxBatchTime(Duration.ofMillis(500L)).withProcessBatchAction(this::commitAckBatch).withExecutor(AckTracker.this.executor).build();
            this.partition = partition;
            this.unackedMessages = new LinkedList<MessageAckData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageAckData recordSent(ConsumerRecord<?, ?> record) {
            MessageAckData ackCompletion = new MessageAckData(record.offset(), record.leaderEpoch());
            List<MessageAckData> list = this.unackedMessages;
            synchronized (list) {
                this.unackedMessages.add(ackCompletion);
            }
            AckTracker.this.incrementOutstandingAcks();
            return ackCompletion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public CompletionStage<Void> recordAck(MessageAckData messageAckData) {
            block6: {
                CompletableFuture<Void> result = new CompletableFuture<Void>();
                try {
                    if (AckTracker.this.partitionTrackers.get(this.partition) == null) {
                        result.completeExceptionally(AckTracker.this.kafkaAdapterFactory.newCommitFailedException());
                        break block6;
                    }
                    List<MessageAckData> list = this.unackedMessages;
                    synchronized (list) {
                        messageAckData.setCompletion(result);
                        this.batchPendingAcks();
                    }
                    AckTracker.this.decrementOutstandingAcks();
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.AckTracker$PartitionAckTracker", (String)"237", (Object)this, (Object[])new Object[]{messageAckData});
                    result.completeExceptionally((Throwable)t);
                    throw t;
                }
            }
            return CompletableFuture.completedFuture(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void batchPendingAcks() {
            List<MessageAckData> list = this.unackedMessages;
            synchronized (list) {
                MessageAckData ackData;
                Iterator<MessageAckData> i = this.unackedMessages.iterator();
                while (i.hasNext() && (ackData = i.next()).getCompletion() != null) {
                    this.messageBatcher.addToBatch(ackData);
                    i.remove();
                }
            }
        }

        private void commitAckBatch(List<MessageAckData> toCommit) {
            if (toCommit.isEmpty()) {
                return;
            }
            MessageAckData lastAcked = toCommit.get(toCommit.size() - 1);
            long commitOffset = lastAcked.offset + 1L;
            OffsetAndMetadata offset = AckTracker.this.kafkaAdapterFactory.newOffsetAndMetadata(commitOffset, lastAcked.getLeaderEpoch(), null);
            CompletionStage<Void> commitResult = AckTracker.this.commitAction.doCommit(this.partition, offset);
            commitResult.handleAsync((r, t) -> {
                if (t == null) {
                    for (MessageAckData ackData : toCommit) {
                        ackData.getCompletion().complete(null);
                    }
                } else {
                    for (MessageAckData ackData : toCommit) {
                        ackData.getCompletion().completeExceptionally((Throwable)t);
                    }
                }
                return null;
            }, AckTracker.this.executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            this.messageBatcher.close();
            List<MessageAckData> list = this.unackedMessages;
            synchronized (list) {
                for (MessageAckData ackData : this.unackedMessages) {
                    if (ackData.getCompletion() == null) continue;
                    ackData.getCompletion().completeExceptionally(AckTracker.this.kafkaAdapterFactory.newCommitFailedException());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.AckTracker$PartitionAckTracker", PartitionAckTracker.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }

    @FunctionalInterface
    public static interface CommitAction {
        public CompletionStage<Void> doCommit(TopicPartition var1, OffsetAndMetadata var2);
    }
}

