/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.LocationException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.KernelResolver;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import com.ibm.ws.kernel.boot.internal.PasswordGenerator;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BootstrapConfig {
    static final Pattern SYMBOL_DEF = Pattern.compile("\\$\\{([^\\$\\{\\}]*?)\\}");
    protected final File bootstrapLib;
    protected File installRoot = null;
    protected File userRoot = null;
    protected File processesRoot = null;
    protected File outputRoot = null;
    protected File configDir = null;
    protected File outputDir = null;
    protected File logDir = null;
    protected File consoleLogFile;
    protected File workarea = null;
    protected String processName;
    protected Map<String, String> initProps;
    protected List<String> cmdArgs;
    protected ClassLoader frameworkLaunchClassloader;
    protected Instrumentation instrumentation;
    protected KernelResolver kernelResolver;

    public BootstrapConfig() {
        File fbootstrapLib = null;
        try {
            fbootstrapLib = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return KernelUtils.getBootstrapLibDir();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bootstrapLib = fbootstrapLib;
    }

    protected void findLocations(String newServerName, String instanceDirStr, String outputDirStr, String logDirStr, String consoleLogFileStr) throws LocationException {
        this.findLocations(newServerName, instanceDirStr, outputDirStr, logDirStr, consoleLogFileStr, null);
    }

    protected void findLocations(String newServerName, String instanceDirStr, String outputDirStr, String logDirStr, String consoleLogFileStr, String workareaDirStr) throws LocationException {
        this.setProcessName(newServerName);
        this.installRoot = this.bootstrapLib.getParentFile();
        this.userRoot = instanceDirStr == null ? new File(this.installRoot, "usr") : this.assertDirectory(FileUtils.normalize(instanceDirStr), "WLP_USER_DIR");
        this.processesRoot = new File(this.userRoot, this.getProcessesSubdirectory());
        this.configDir = new File(this.processesRoot, this.processName);
        String canonicalServerName = this.processName;
        try {
            File parentDir = this.configDir.getParentFile();
            if (!BootstrapConfig.isSymbolicLink(this.configDir, parentDir)) {
                canonicalServerName = this.configDir.getCanonicalFile().getName();
                if (!this.processName.equals(canonicalServerName)) {
                    this.processName = canonicalServerName;
                    this.configDir = new File(this.processesRoot, this.processName);
                }
            } else {
                File candidate = null;
                File[] siblings = parentDir.listFiles();
                File canonicalConfigDir = this.configDir.getCanonicalFile();
                for (int i = 0; i < siblings.length; ++i) {
                    File sibling = siblings[i];
                    if (!sibling.isDirectory()) continue;
                    String sibname = sibling.getCanonicalFile().getName();
                    if (sibname.equals(this.processName)) {
                        candidate = sibling;
                        break;
                    }
                    if (!sibname.equalsIgnoreCase(this.processName) || !sibling.getCanonicalFile().equals(canonicalConfigDir)) continue;
                    candidate = sibling;
                }
                if (candidate != null) {
                    this.processName = candidate.getName();
                    this.configDir = new File(this.processesRoot, this.processName);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (outputDirStr == null) {
            this.outputRoot = this.processesRoot;
            this.outputDir = this.configDir;
        } else {
            this.outputRoot = this.assertDirectory(FileUtils.normalize(outputDirStr), this.getOutputDirectoryEnvName());
            this.outputDir = new File(this.outputRoot, this.processName);
        }
        this.logDir = logDirStr == null ? new File(this.outputDir, "logs") : this.assertDirectory(FileUtils.normalize(logDirStr), "LOG_DIR");
        this.consoleLogFile = new File(this.logDir, consoleLogFileStr != null ? consoleLogFileStr : "console.log");
        this.workarea = workareaDirStr == null ? new File(this.outputDir, "workarea") : new File(this.outputDir, "workarea/" + workareaDirStr);
    }

    static boolean isSymbolicLink(File file, File parentFile) throws IOException {
        File canonicalParentDir = parentFile.getCanonicalFile();
        File fileInCanonicalParentDir = new File(canonicalParentDir, file.getName());
        File canonicalFile = fileInCanonicalParentDir.getCanonicalFile();
        return !canonicalFile.equals(fileInCanonicalParentDir.getAbsoluteFile());
    }

    protected String getProcessesSubdirectory() {
        return "servers";
    }

    protected String getOutputDirectoryEnvName() {
        return "WLP_OUTPUT_DIR";
    }

    protected void configure(Map<String, String> initProps) throws LocationException {
        if (initProps == null) {
            throw new IllegalArgumentException("Initial properties can not be null");
        }
        this.initProps = initProps;
        initProps.put("wlp.process.type", this.getProcessType());
        initProps.put("wlp.server.name", this.processName);
        File f = this.getConfigFile("bootstrap.properties");
        if (f.exists()) {
            this.mergeProperties(initProps, null, f.toURI().toString());
        }
        boolean userRootIsDefault = this.userRoot.getParentFile().equals(this.installRoot);
        initProps.put("wlp.install.dir", this.getPathProperty(this.installRoot, new String[0]));
        initProps.put("wlp.user.dir", this.getPathProperty(this.userRoot, new String[0]));
        initProps.put("wlp.user.dir.isDefault", Boolean.toString(userRootIsDefault));
        initProps.put("server.config.dir", this.getPathProperty(this.configDir, new String[0]));
        initProps.put("server.output.dir", this.getPathProperty(this.outputDir, new String[0]));
        initProps.put("server.tmp.dir", this.getPathProperty(this.outputDir, "workarea", "tmp"));
        if ("client".equals(this.getProcessType())) {
            initProps.put("client.config.dir", this.getPathProperty(this.configDir, new String[0]));
            initProps.put("client.output.dir", this.getPathProperty(this.outputDir, new String[0]));
            initProps.put("client.tmp.dir", this.getPathProperty(this.outputDir, "workarea", "tmp"));
        }
        initProps.put("wlp.lib.dir", this.getPathProperty(this.bootstrapLib, new String[0]));
        initProps.put("shared.app.dir", this.getPathProperty(this.userRoot, "shared", "apps"));
        initProps.put("shared.config.dir", this.getPathProperty(this.userRoot, "shared", "config"));
        initProps.put("shared.resource.dir", this.getPathProperty(this.userRoot, "shared", "resources"));
        this.substituteSymbols(initProps);
    }

    protected String getPathProperty(File file, String ... dirs) {
        StringBuilder b = new StringBuilder().append(FileUtils.normalize(file.getAbsolutePath())).append('/');
        for (String dir : dirs) {
            b.append(dir).append('/');
        }
        return b.toString();
    }

    protected File assertDirectory(String dirName, String locName) {
        File d = new File(dirName);
        if (d.isFile()) {
            throw new LocationException("Path must reference a directory", MessageFormat.format(BootstrapConstants.messages.getString("error.specifiedLocation"), locName, d.getAbsolutePath()));
        }
        return d;
    }

    protected void setProcessName(String newProcessName) {
        if (newProcessName == null) {
            this.processName = this.getDefaultProcessName();
            return;
        }
        if (!newProcessName.matches("[\\p{L}\\p{N}\\+\\_][\\p{L}\\p{N}\\-\\+\\.\\_]*")) {
            throw new LocationException("Bad server name: " + newProcessName, MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorProcessNameCharacterMessageKey()), newProcessName));
        }
        this.processName = newProcessName;
    }

    public void setSystemProperties() {
        for (Map.Entry<String, String> entry : this.initProps.entrySet()) {
            if (entry.getKey().equals("websphere.java.security")) continue;
            final String key = entry.getKey();
            final String value = entry.getValue();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        System.setProperty(key, value);
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    public String get(final String key) {
        if (key == null || this.initProps == null) {
            return null;
        }
        String value = this.initProps.get(key);
        if (value == null) {
            try {
                value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getProperty(key);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public String put(String key, String value) {
        if (key == null || this.initProps == null) {
            return null;
        }
        return this.initProps.put(key, value);
    }

    public String putIfAbsent(String key, String value) {
        String current = this.get(key);
        return current == null ? this.put(key, value) : current;
    }

    public String remove(String key) {
        if (key == null) {
            return null;
        }
        return this.initProps.remove(key);
    }

    public String printLocations(boolean formatOutput) {
        if (!this.isConfigured()) {
            return super.toString() + " (not configured)";
        }
        StringBuilder sb = new StringBuilder();
        if (formatOutput) {
            String cmd;
            Formatter f = new Formatter();
            String value = null;
            if (value == null) {
                try {
                    value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return System.getenv("X_CMD");
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((cmd = value) != null) {
                f.format("%26s:  %s%n", "Command", cmd);
            }
            String java_home_value = null;
            try {
                java_home_value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getProperty("java.home");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.format("%26s:  %s%n", "Java home", java_home_value);
            f.format("%26s:  %s%n", "Install root", this.getPathProperty(this.installRoot, new String[0]));
            f.format("%26s:  %s%n", "System libraries", this.getPathProperty(this.bootstrapLib, new String[0]));
            f.format("%26s:  %s%n", "User root", this.getPathProperty(this.userRoot, new String[0]));
            f.format("%26s:  %s%n", "Config", this.getPathProperty(this.configDir, new String[0]));
            f.format("%26s:  %s%n", "Output", this.getPathProperty(this.outputDir, new String[0]));
            sb.append(f.toString());
            f.close();
        } else {
            sb.append("installRoot=").append(this.getPathProperty(this.installRoot, new String[0])).append(",");
            sb.append("bootstrapLib=").append(this.getPathProperty(this.bootstrapLib, new String[0])).append(",");
            sb.append("instanceRoot=").append(this.getPathProperty(this.userRoot, new String[0])).append(",");
            sb.append("configDir=").append(this.getPathProperty(this.configDir, new String[0])).append(",");
            sb.append("outputDir=").append(this.getPathProperty(this.outputDir, new String[0])).append(",");
        }
        return sb.toString();
    }

    public boolean isConfigured() {
        return this.userRoot != null;
    }

    public String getProcessName() {
        if (this.processName == null) {
            this.processName = this.getDefaultProcessName();
        }
        return this.processName;
    }

    public File getLogDirectory() {
        return this.logDir;
    }

    public File getConsoleLogFile() {
        return this.consoleLogFile;
    }

    public File getUserOutputFile(String relativePath) {
        if (relativePath == null) {
            return this.outputRoot;
        }
        return new File(this.outputRoot, relativePath);
    }

    public File getConfigFile(String relativeServerPath) {
        if (relativeServerPath == null) {
            return this.configDir;
        }
        return new File(this.configDir, relativeServerPath);
    }

    public File getOutputFile(String relativeServerPath) {
        if (relativeServerPath == null) {
            return this.outputDir;
        }
        return new File(this.outputDir, relativeServerPath);
    }

    public File getWorkareaFile(String relativeServerWorkareaPath) {
        if (relativeServerWorkareaPath == null) {
            return this.workarea;
        }
        return new File(this.workarea, relativeServerWorkareaPath);
    }

    protected void mergeProperties(Map<String, String> target, URL baseURL, String urlStr) {
        String includes = null;
        try {
            URL url = baseURL != null && urlStr == null ? baseURL : new URL(baseURL, urlStr);
            Properties props = KernelUtils.getProperties(url.openStream());
            includes = (String)props.remove("bootstrap.include");
            this.addMissingProperties(props, target);
            if (includes != null) {
                this.processIncludes(target, url, includes);
            }
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            throw new LocationException("Bad bootstrap.properties URI: " + urlStr, MessageFormat.format(BootstrapConstants.messages.getString("error.bootPropsURI"), urlStr, e), e);
        }
        catch (IOException e) {
            throw new LocationException("IOException reading bootstrap.properties: " + urlStr, MessageFormat.format(BootstrapConstants.messages.getString("error.bootPropsStream"), urlStr, e), e);
        }
    }

    protected void addMissingProperties(Properties source, Map<String, String> target) {
        if (source == null || source.isEmpty() || target == null) {
            return;
        }
        for (String key : source.stringPropertyNames()) {
            if (target.containsKey(key) || key.length() <= 0) continue;
            String value = System.getProperty(key);
            if (value == null) {
                value = source.getProperty(key);
            }
            target.put(key, value);
        }
    }

    protected void processIncludes(Map<String, String> mergeProps, URL rootURL, String includeProps) {
        String[] props;
        if (includeProps == null) {
            return;
        }
        for (String pname : props = includeProps.trim().split("\\s*,\\s*")) {
            this.mergeProperties(mergeProps, rootURL, pname);
        }
    }

    protected void substituteSymbols(Map<String, String> initProps) {
        for (Map.Entry<String, String> entry : initProps.entrySet()) {
            String value = entry.getValue();
            if (!(value instanceof String)) continue;
            String strValue = value;
            Matcher m = SYMBOL_DEF.matcher(strValue);
            int i = 0;
            while (m.find() && i++ < 4) {
                String symbol = m.group(1);
                String expansion = initProps.get(symbol);
                if (expansion == null || !(expansion instanceof String)) continue;
                strValue = strValue.replace(m.group(0), expansion);
                entry.setValue(strValue);
            }
        }
    }

    public String replaceSymbols(String str) {
        String symbol;
        String expansion;
        Matcher m = SYMBOL_DEF.matcher(str);
        if (m.find() && (expansion = this.get(symbol = m.group(1))) != null) {
            return str.replace(m.group(0), expansion);
        }
        return str;
    }

    void verifyProcess(BootstrapConstants.VerifyServer verifyServer, LaunchArguments createOptions) throws LaunchException {
        boolean generatePassword;
        if (verifyServer == null || verifyServer == BootstrapConstants.VerifyServer.SKIP) {
            return;
        }
        boolean bl = generatePassword = createOptions == null || createOptions.getOption("no-password") == null;
        if (!this.configDir.exists()) {
            if (verifyServer == BootstrapConstants.VerifyServer.CREATE || verifyServer == BootstrapConstants.VerifyServer.CREATE_DEFAULT && this.getDefaultProcessName().equals(this.processName)) {
                File template = this.findProcessTemplate(verifyServer == BootstrapConstants.VerifyServer.CREATE ? createOptions : null);
                if (this.configDir.mkdirs()) {
                    try {
                        this.createConfigDirectory(template);
                        this.generateServerEnv(generatePassword);
                    }
                    catch (IOException e) {
                        throw new LocationException("Error occurred while trying to create new process " + this.processName, MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorCreatingNewProcessMessageKey()), this.processName, this.configDir.getAbsolutePath(), e.getMessage()), e);
                    }
                }
                if (!this.configDir.exists()) {
                    throw new LocationException("Unable to create process config directory " + this.configDir.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorCreatingNewProcessMkDirFailMessageKey()), this.processName, this.configDir.getAbsolutePath()), null);
                }
                throw new LocationException("Something else has been detected creating the process config directory " + this.configDir.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorCreatingNewProcessExistsMessageKey()), this.processName, this.configDir.getAbsolutePath()), null);
            }
            LaunchException le = new LaunchException("Process config directory does not exist, and --create option not specified for " + this.processName, MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorNoExistingProcessMessageKey()), this.processName, this.configDir.getAbsolutePath()));
            le.setReturnCode(ReturnCode.SERVER_NOT_EXIST_STATUS);
            throw le;
        }
        if (verifyServer == BootstrapConstants.VerifyServer.CREATE) {
            LaunchException le = new LaunchException("Unable to create the process " + this.processName + " because the process config directory already exists", MessageFormat.format(BootstrapConstants.messages.getString(this.getErrorProcessDirExistsMessageKey()), this.processName, this.configDir));
            le.setReturnCode(ReturnCode.REDUNDANT_ACTION_STATUS);
            throw le;
        }
        File f = this.getConfigFile(this.getProcessXMLFilename());
        if (!f.exists() && verifyServer == BootstrapConstants.VerifyServer.CREATE_DEFAULT && this.getDefaultProcessName().equals(this.processName)) {
            try {
                this.createConfigDirectory(this.findProcessTemplate(null));
                this.generateServerEnv(generatePassword);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!f.exists() || !f.canRead()) {
            throw new LocationException("Not Found " + f.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.badConfigRoot"), f.getAbsolutePath(), "file not found"));
        }
    }

    protected void createConfigDirectory(File template) throws IOException {
        File serverConfig;
        File file = serverConfig = template == null ? null : new File(template, this.getProcessXMLFilename());
        if (template != null && template.exists() && template.isDirectory() && serverConfig.exists() && serverConfig.isFile()) {
            FileUtils.copyDir(template, this.configDir);
        } else {
            File defaultServerXML = this.getConfigFile(this.getProcessXMLFilename());
            FileUtils.createFile(defaultServerXML, BootstrapConfig.class.getResourceAsStream(this.getProcessXMLResourcePath()));
        }
        ServerLock.createServerLock(this);
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString(this.getInfoNewProcessCreatedMessageKey()), this.processName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File findProcessTemplate(LaunchArguments args) {
        File serverConfig;
        String templateExtension = null;
        if (args != null) {
            templateExtension = args.getOption("template");
        }
        File f = this.getInstallRoot();
        if (templateExtension == null) {
            return new File(f, this.getProcessesTemplateDir() + this.getDefaultProcessName());
        }
        if (templateExtension.contains(":")) {
            String[] templateArgs = templateExtension.split(":");
            String extensionName = templateArgs[0];
            String templateName = templateArgs[1];
            File extensionProp = new File(f, "etc/extensions/" + extensionName + ".properties");
            if (!extensionProp.exists()) throw new LaunchException("Not Found " + extensionProp.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.fileNotFound"), extensionProp.getAbsolutePath()));
            String directory = null;
            try {
                Properties prop = KernelUtils.getProperties(new FileInputStream(extensionProp.getAbsoluteFile()));
                directory = prop.getProperty("com.ibm.websphere.productInstall");
            }
            catch (Exception e) {
                throw new LaunchException("Unable to load property: com.ibm.websphere.productInstall", MessageFormat.format(BootstrapConstants.messages.getString("error.unable.load.property"), "com.ibm.websphere.productInstall", extensionProp.getAbsolutePath()));
            }
            if (directory != null) {
                File productInstallPath = new File(directory);
                if (!productInstallPath.isAbsolute()) {
                    productInstallPath = new File(f.getParent(), directory);
                }
                f = new File(productInstallPath, this.getProcessesTemplateDir() + templateName);
            }
        } else {
            f = new File(f, this.getProcessesTemplateDir() + templateExtension);
        }
        if ((serverConfig = new File(f, this.getProcessXMLFilename())).isFile()) return f;
        throw new LaunchException("Not Found " + serverConfig.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.fileNotFound"), serverConfig.getAbsolutePath()));
    }

    public Map<String, String> getFrameworkProperties() {
        return this.initProps;
    }

    public List<String> getCmdArgs() {
        return this.cmdArgs;
    }

    public void setCmdArgs(List<String> cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public ClassLoader getFrameworkClassloader() {
        return this.frameworkLaunchClassloader;
    }

    public void setFrameworkClassloader(ClassLoader frameworkLaunchClassloader) {
        this.frameworkLaunchClassloader = frameworkLaunchClassloader;
    }

    public KernelResolver getKernelResolver() {
        return this.kernelResolver;
    }

    public void setKernelResolver(KernelResolver resolver) {
        this.kernelResolver = resolver;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void setInstrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        if (instrumentation != null) {
            this.put("java.lang.instrument", "true");
        } else {
            this.remove("java.lang.instrument");
        }
    }

    public File getInstallRoot() {
        return this.installRoot;
    }

    public File getUserRoot() {
        return this.userRoot;
    }

    public File getCommonOutputRoot() {
        return this.outputRoot;
    }

    public boolean checkCleanStart() {
        String fwClean = this.get("org.osgi.framework.storage.clean");
        if (fwClean != null && fwClean.equals("onFirstInit")) {
            return true;
        }
        String osgiClean = this.get("osgi.clean");
        return Boolean.valueOf(osgiClean);
    }

    public void forceCleanStart() {
        this.put("org.osgi.framework.storage.clean", "onFirstInit");
    }

    protected String getDefaultProcessName() {
        return "defaultServer";
    }

    protected String getProcessXMLFilename() {
        return "server.xml";
    }

    protected String getProcessXMLResourcePath() {
        return "/OSGI-OPT/websphere/server/server.xml";
    }

    protected String getErrorCreatingNewProcessMessageKey() {
        return "error.creatingNewServer";
    }

    protected String getErrorCreatingNewProcessMkDirFailMessageKey() {
        return "error.creatingNewServerMkDirFail";
    }

    protected String getErrorCreatingNewProcessExistsMessageKey() {
        return "error.creatingNewServerExists";
    }

    protected String getErrorNoExistingProcessMessageKey() {
        return "error.noExistingServer";
    }

    protected String getErrorProcessDirExistsMessageKey() {
        return "error.serverDirExists";
    }

    protected String getErrorProcessNameCharacterMessageKey() {
        return "error.serverNameCharacter";
    }

    protected String getInfoNewProcessCreatedMessageKey() {
        return "info.newServerCreated";
    }

    protected String getProcessesTemplateDir() {
        return "templates/servers/";
    }

    public String getProcessType() {
        return "server";
    }

    public void addBootstrapJarURLs(List<URL> urlList) {
        urlList.add(KernelUtils.getBootstrapJarURL());
    }

    protected ReturnCode generateServerEnv(boolean generatePassword) {
        double jvmLevel;
        String s = null;
        try {
            s = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    String javaSpecVersion = System.getProperty("java.specification.version");
                    return javaSpecVersion;
                }
            });
            jvmLevel = Double.parseDouble(s);
        }
        catch (Exception ex) {
            throw new LaunchException("Invalid java.specification.version, " + s, MessageFormat.format(BootstrapConstants.messages.getString("error.create.unknownJavaLevel"), s), ex, ReturnCode.ERROR_BAD_JAVA_VERSION);
        }
        BufferedWriter bw = null;
        File serverEnv = this.getConfigFile("server.env");
        try {
            char[] keystorePass = PasswordGenerator.generateRandom();
            String serverEnvContents = FileUtils.readFile(serverEnv);
            String toWrite = "";
            if (generatePassword && (serverEnvContents == null || !serverEnvContents.contains("keystore_password="))) {
                if (serverEnvContents != null) {
                    toWrite = toWrite + System.getProperty("line.separator");
                }
                toWrite = toWrite + "keystore_password=" + new String(keystorePass);
            }
            if (jvmLevel >= 1.8 && (serverEnvContents == null || !serverEnvContents.contains("WLP_SKIP_MAXPERMSIZE="))) {
                if (serverEnvContents != null || !toWrite.isEmpty()) {
                    toWrite = toWrite + System.getProperty("line.separator");
                }
                toWrite = toWrite + "WLP_SKIP_MAXPERMSIZE=true";
            }
            if (serverEnvContents == null) {
                FileUtils.createFile(serverEnv, new ByteArrayInputStream(toWrite.getBytes("UTF-8")));
            } else {
                FileUtils.appendFile(serverEnv, new ByteArrayInputStream(toWrite.getBytes("UTF-8")));
            }
        }
        catch (IOException ex) {
            throw new LaunchException("Failed to create/update the server.env file for this server", MessageFormat.format(BootstrapConstants.messages.getString("error.create.java8serverenv"), serverEnv.getAbsolutePath()), ex, ReturnCode.LAUNCH_EXCEPTION);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ReturnCode.OK;
    }
}

