/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.ClientRunnerException;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.HelpActions;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.LocationException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelBootstrap;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.HelpCommand;
import com.ibm.ws.kernel.boot.internal.commands.ListServerHelper;
import com.ibm.ws.kernel.boot.internal.commands.PackageCommand;
import com.ibm.ws.kernel.boot.internal.commands.ProcessControlHelper;
import com.ibm.ws.kernel.boot.internal.commands.ServerHelpActions;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public class Launcher {
    static final long launchTime = System.nanoTime();

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        System.exit(launcher.createPlatform(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createPlatform(String[] args) {
        boolean delete;
        ReturnCode rc = ReturnCode.OK;
        HashMap<String, String> initProps = new HashMap<String, String>(20);
        initProps.put("kernel.launch.time", Long.toString(launchTime));
        initProps.put("org.apache.aries.blueprint.preemptiveShutdown", Boolean.toString(false));
        BootstrapConfig bootProps = this.createBootstrapConfig();
        try {
            LaunchArguments launchArgs = this.createLaunchArguments(args, initProps);
            rc = launchArgs.getRc();
            this.findLocations(bootProps, launchArgs.getProcessName());
            if (rc.logName != null) {
                if (rc == ReturnCode.CREATE_ACTION || !bootProps.getConfigFile(null).exists() && !rc.getVerifyServer().willCreate()) {
                    Debug.open(bootProps.getUserOutputFile(".logs"), rc.logName);
                } else {
                    Debug.open(bootProps.getLogDirectory(), rc.logName);
                }
            }
            bootProps.verifyProcess(rc.getVerifyServer(), launchArgs);
            if (rc.readInitialConfig()) {
                bootProps.configure(initProps);
                bootProps.setSystemProperties();
            }
            bootProps.setCmdArgs(launchArgs.getExtraArguments());
            if (launchArgs.getProcessName() == null && launchArgs.getRc().defaultServerNameMessage()) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString(this.getDefaultProcessNameMessageKey()), this.getDefaultProcessName()));
            }
            rc = this.handleActions(bootProps, launchArgs);
        }
        catch (LocationException e) {
            boolean delete2;
            System.out.println(BootstrapConstants.messages.getString("error.unableToLaunch"));
            System.out.println(e.getTranslatedMessage());
            if (Debug.isOpen()) {
                Debug.printStackTrace(e);
                Debug.println(bootProps.printLocations(true));
            }
            if (e.getCause() != null) {
                e.printStackTrace();
            }
            if (e.getCause() != null || bootProps.isConfigured()) {
                System.out.println(bootProps.printLocations(true));
            }
            rc = ReturnCode.LOCATION_EXCEPTION;
            System.out.flush();
            if (!Debug.isOpen()) {
                System.err.flush();
                return rc.val;
            }
            boolean bl = delete2 = rc == ReturnCode.OK;
            if (!delete2) {
                Debug.println();
                for (int i = 0; i < args.length; ++i) {
                    Debug.println("arg" + i + "=" + args[i]);
                }
                Debug.println("exit=" + rc.val);
                Debug.println();
                Debug.println(bootProps.printLocations(true));
            }
            Debug.close(delete2);
            return rc.val;
            catch (ClientRunnerException e2) {
                System.out.println(e2.getTranslatedMessage());
                if (Debug.isOpen()) {
                    Debug.printStackTrace(e2);
                }
                if (e2.getCause() != null) {
                    e2.printStackTrace();
                }
                rc = e2.getReturnCode();
                System.out.flush();
                if (!Debug.isOpen()) {
                    System.err.flush();
                    return rc.val;
                }
                boolean bl2 = delete3 = rc == ReturnCode.OK;
                if (!delete3) {
                    Debug.println();
                    for (int i = 0; i < args.length; ++i) {
                        Debug.println("arg" + i + "=" + args[i]);
                    }
                    Debug.println("exit=" + rc.val);
                    Debug.println();
                    Debug.println(bootProps.printLocations(true));
                }
                Debug.close(delete3);
                return rc.val;
                catch (LaunchException e3) {
                    System.out.println(BootstrapConstants.messages.getString("error.unableToLaunch"));
                    System.out.println(e3.getTranslatedMessage());
                    if (Debug.isOpen()) {
                        Debug.printStackTrace(e3);
                    }
                    if (e3.getCause() != null) {
                        e3.printStackTrace();
                    }
                    rc = e3.getReturnCode();
                    System.out.flush();
                    if (!Debug.isOpen()) {
                        System.err.flush();
                        return rc.val;
                    }
                    boolean bl3 = delete4 = rc == ReturnCode.OK;
                    if (!delete4) {
                        Debug.println();
                        for (int i = 0; i < args.length; ++i) {
                            Debug.println("arg" + i + "=" + args[i]);
                        }
                        Debug.println("exit=" + rc.val);
                        Debug.println();
                        Debug.println(bootProps.printLocations(true));
                    }
                    Debug.close(delete4);
                    return rc.val;
                    catch (RuntimeException e4) {
                        Throwable t = e4.getCause();
                        if (t == null) {
                            t = e4;
                        }
                        System.out.println(BootstrapConstants.messages.getString("error.unableToLaunch"));
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), t.toString()));
                        if (Debug.isOpen()) {
                            Debug.printStackTrace(e4);
                        }
                        e4.printStackTrace();
                        rc = ReturnCode.RUNTIME_EXCEPTION;
                        System.out.flush();
                        if (!Debug.isOpen()) {
                            System.err.flush();
                            return rc.val;
                        }
                        boolean bl4 = delete5 = rc == ReturnCode.OK;
                        if (!delete5) {
                            Debug.println();
                            for (int i = 0; i < args.length; ++i) {
                                Debug.println("arg" + i + "=" + args[i]);
                            }
                            Debug.println("exit=" + rc.val);
                            Debug.println();
                            Debug.println(bootProps.printLocations(true));
                        }
                        Debug.close(delete5);
                        return rc.val;
                        catch (Throwable e5) {
                            try {
                                System.out.println(BootstrapConstants.messages.getString("error.unableToLaunch"));
                                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), e5.toString()));
                                if (Debug.isOpen()) {
                                    Debug.printStackTrace(e5);
                                }
                                e5.printStackTrace();
                                rc = ReturnCode.UNKNOWN_EXCEPTION;
                                System.out.flush();
                            }
                            catch (Throwable throwable) {
                                boolean delete32;
                                System.out.flush();
                                if (!Debug.isOpen()) {
                                    System.err.flush();
                                    throw throwable;
                                }
                                boolean bl5 = delete32 = rc == ReturnCode.OK;
                                if (!delete32) {
                                    Debug.println();
                                    for (int i = 0; i < args.length; ++i) {
                                        Debug.println("arg" + i + "=" + args[i]);
                                    }
                                    Debug.println("exit=" + rc.val);
                                    Debug.println();
                                    Debug.println(bootProps.printLocations(true));
                                }
                                Debug.close(delete32);
                                throw throwable;
                            }
                            if (!Debug.isOpen()) {
                                System.err.flush();
                                return rc.val;
                            }
                            boolean bl6 = delete6 = rc == ReturnCode.OK;
                            if (!delete6) {
                                Debug.println();
                                for (int i = 0; i < args.length; ++i) {
                                    Debug.println("arg" + i + "=" + args[i]);
                                }
                                Debug.println("exit=" + rc.val);
                                Debug.println();
                                Debug.println(bootProps.printLocations(true));
                            }
                            Debug.close(delete6);
                            return rc.val;
                        }
                    }
                }
            }
        }
        System.out.flush();
        if (!Debug.isOpen()) {
            System.err.flush();
            return rc.val;
        }
        boolean bl = delete = rc == ReturnCode.OK;
        if (!delete) {
            Debug.println();
            for (int i = 0; i < args.length; ++i) {
                Debug.println("arg" + i + "=" + args[i]);
            }
            Debug.println("exit=" + rc.val);
            Debug.println();
            Debug.println(bootProps.printLocations(true));
        }
        Debug.close(delete);
        return rc.val;
    }

    protected BootstrapConfig createBootstrapConfig() {
        return new BootstrapConfig();
    }

    private LaunchArguments createLaunchArguments(String[] args, Map<String, String> initProps) {
        List<String> cmdArgs = this.processBatchFileArgs(new ArrayList<String>(Arrays.asList(args)));
        return new LaunchArguments(cmdArgs, initProps, this.isClient());
    }

    protected boolean isClient() {
        return false;
    }

    protected ReturnCode handleActions(BootstrapConfig bootProps, LaunchArguments launchArgs) {
        ReturnCode rc = launchArgs.getRc();
        switch (rc) {
            case OK: {
                rc = new KernelBootstrap(bootProps).go();
                break;
            }
            case CREATE_ACTION: {
                ServerLock.createServerLock(bootProps);
                boolean generatePass = launchArgs.getOption("no-password") == null;
                rc = bootProps.generateServerEnv(generatePass);
                break;
            }
            case MESSAGE_ACTION: {
                rc = this.showMessage(launchArgs);
                break;
            }
            case HELP_ACTION: {
                rc = this.showHelp(launchArgs);
                break;
            }
            case VERSION_ACTION: {
                KernelBootstrap.showVersion(bootProps);
                rc = ReturnCode.OK;
                break;
            }
            case STOP_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).stop();
                break;
            }
            case STATUS_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).status(false);
                break;
            }
            case STARTING_STATUS_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).status(true);
                break;
            }
            case START_STATUS_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).startStatus();
                break;
            }
            case PACKAGE_ACTION: {
                rc = new PackageCommand(bootProps, launchArgs).doPackage();
                break;
            }
            case PACKAGE_WLP_ACTION: {
                rc = new PackageCommand(bootProps, launchArgs).doPackageRuntimeOnly();
                break;
            }
            case DUMP_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).dump();
                break;
            }
            case JAVADUMP_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).dumpJava();
                break;
            }
            case PAUSE_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).pause();
                break;
            }
            case RESUME_ACTION: {
                rc = new ProcessControlHelper(bootProps, launchArgs).resume();
                break;
            }
            case LIST_ACTION: {
                rc = new ListServerHelper(bootProps, launchArgs).listServers();
                break;
            }
            default: {
                this.showHelp(launchArgs);
                rc = ReturnCode.BAD_ARGUMENT;
            }
        }
        return rc;
    }

    protected void findLocations(BootstrapConfig bootProps, String processName) {
        String consoleLogFileStr;
        String userDirStr = this.getEnv("WLP_USER_DIR");
        String serversDirStr = this.getEnv(bootProps.getOutputDirectoryEnvName());
        String logDirStr = this.getEnv("X_LOG_DIR");
        if (logDirStr == null) {
            logDirStr = this.getEnv("LOG_DIR");
        }
        if ((consoleLogFileStr = this.getEnv("X_LOG_FILE")) == null) {
            consoleLogFileStr = this.getEnv("LOG_FILE");
        }
        bootProps.findLocations(processName, userDirStr, serversDirStr, logDirStr, consoleLogFileStr, null);
    }

    protected ReturnCode showHelp(LaunchArguments launchArgs) {
        return new HelpCommand(this.getHelpActions()).showHelp(launchArgs);
    }

    protected HelpActions getHelpActions() {
        return new ServerHelpActions();
    }

    public ReturnCode showMessage(LaunchArguments launchArgs) {
        String message = launchArgs.getOption("message");
        try {
            String messageString = BootstrapConstants.messages.getString(message);
            List<String> messageArgs = launchArgs.getExtraArguments();
            if (messageArgs.isEmpty()) {
                System.out.println(messageString);
            } else {
                Object[] messageArgsArray = messageArgs.toArray(new Object[messageArgs.size()]);
                System.out.println(MessageFormat.format(messageString, messageArgsArray));
            }
        }
        catch (MissingResourceException e) {
            return ReturnCode.BAD_ARGUMENT;
        }
        return ReturnCode.OK;
    }

    protected String getEnv(final String key) {
        if (key == null) {
            return null;
        }
        String value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return System.getenv(key);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected String getDefaultProcessName() {
        return "defaultServer";
    }

    protected String getDefaultProcessNameMessageKey() {
        return "info.defaultServer";
    }

    protected List<String> processBatchFileArgs(List<String> args) {
        if (args.size() > 1) {
            String arg = args.get(0);
            if (arg.equals("--batch-file")) {
                args = this.processBatchFileArgs(args, null);
            } else if (arg.startsWith("--batch-file=")) {
                args = this.processBatchFileArgs(args, arg.substring("--batch-file=".length()));
            }
        }
        return args;
    }

    private List<String> processBatchFileArgs(List<String> args, String actionOption) {
        String processName;
        if (args.size() > 2) {
            processName = args.get(2);
            if (processName.isEmpty()) {
                processName = this.getDefaultProcessName();
            } else if (processName.startsWith("-")) {
                processName = this.getDefaultProcessName();
            } else {
                args.remove(2);
            }
        } else {
            processName = this.getDefaultProcessName();
        }
        if (args.size() > 1) {
            if (actionOption == null) {
                args.set(0, processName);
                args.remove(1);
            } else {
                args.set(0, actionOption);
                args.set(1, processName);
            }
        } else {
            args.set(0, processName);
        }
        return args;
    }
}

