/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.util.ArrayList;
import java.util.Map;

public class UDPChannelConfiguration {
    private static final TraceComponent tc = Tr.register(UDPChannelConfiguration.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static int DEFAULT_READ_BUFFER_SIZE = 1024000;
    private ChannelData channelData;
    private String hostname = null;
    private int port = 0;
    private int sendBufferSize = DEFAULT_READ_BUFFER_SIZE;
    private int receiveBufferSize = DEFAULT_READ_BUFFER_SIZE;
    private int channelReceiveBufferSize = 65535;
    private String[] addressExcludeList = null;
    private String[] addressIncludeList = null;

    private void setValues(Map<Object, Object> props) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValues", (Object[])new Object[0]);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (key.equals("id") || key.equals("type") || key.startsWith("service.") || key.startsWith("component.") || key.startsWith("config.") || key.startsWith("objectClass") || key.startsWith("parentPid")) continue;
                if (this.isInboundChannel()) {
                    if (key.equalsIgnoreCase("hostname")) {
                        this.setHostname((String)value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("port")) {
                        this.setPort(Integer.parseInt((String)value));
                        continue;
                    }
                    if (key.equalsIgnoreCase("endPointName")) continue;
                }
                if (key.equalsIgnoreCase("sendBufferSizeSocket")) {
                    this.setSendBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSizeSocket")) {
                    this.setReceiveBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSizeChannel")) {
                    this.setChannelReceiveBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("addressExcludeList")) {
                    if (value instanceof String) {
                        this.addressExcludeList = this.convertToArray((String)value);
                        continue;
                    }
                    this.addressExcludeList = (String[])value;
                    continue;
                }
                if (key.equalsIgnoreCase("addressIncludeList")) {
                    if (value instanceof String) {
                        this.addressIncludeList = this.convertToArray((String)value);
                        continue;
                    }
                    this.addressIncludeList = (String[])value;
                    continue;
                }
                if (key.equalsIgnoreCase("chainData")) continue;
                if (value instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CWUDP0003W", (Object[])new Object[]{this.getExternalName(), key, value});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CWUDP0003W", (Object[])new Object[]{this.getExternalName(), key, ""});
            }
            catch (NumberFormatException x) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Incorrect number in config; " + key + "=" + value), (Object[])new Object[0]);
                }
                throw new ChannelException(this.getExternalName() + ": Incorrect number in " + key + "=" + value, x);
            }
            catch (Throwable t) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected failure handling new config; " + t), (Object[])new Object[0]);
                }
                throw new ChannelException(this.getExternalName() + ": Unexpected error in new config", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValues");
        }
    }

    private String[] convertToArray(String allEntries) {
        int start = 0;
        int end = 0;
        String newAddress = null;
        if (allEntries == null) {
            return null;
        }
        int length = allEntries.length();
        ArrayList<String> entryList = new ArrayList<String>();
        while (start != length) {
            end = allEntries.indexOf(",", start);
            if (end > start) {
                newAddress = allEntries.substring(start, end);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            } else if (end != start) {
                newAddress = allEntries.substring(start);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            }
            if (end == -1) break;
            start = end + 1;
        }
        if (entryList.isEmpty()) {
            return null;
        }
        return entryList.toArray(new String[entryList.size()]);
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)("Config parameters for UDP Channel: " + this.getExternalName()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("Inbound: " + this.isInboundChannel()), (Object[])new Object[0]);
        if (this.isInboundChannel()) {
            Tr.debug((TraceComponent)tc, (String)("hostname: " + this.getHostname()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("port: " + this.getPort()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeSocket: " + this.getReceiveBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeChannel: " + this.getChannelReceiveBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("sendBufferSizeSocket: " + this.getSendBufferSize()), (Object[])new Object[0]);
    }

    protected void setHostname(String name) {
        if (null != name) {
            this.hostname = name.trim();
        }
    }

    public String getExternalName() {
        return this.channelData.getExternalName();
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isInboundChannel() {
        return this.channelData.isInbound();
    }

    public ChannelData getChannelData() {
        return this.channelData;
    }

    public void setChannelData(ChannelData data) throws ChannelException {
        this.channelData = data;
        this.setValues(data.getPropertyBag());
        if (tc.isDebugEnabled()) {
            this.outputConfigToTrace();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public int getChannelReceiveBufferSize() {
        return this.channelReceiveBufferSize;
    }

    public void setChannelReceiveBufferSize(int size) {
        this.channelReceiveBufferSize = size;
        if (size < 0 || size > 65535) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel Receive buffer size not within Limits: " + size + " setting to default: " + 65535), (Object[])new Object[0]);
            }
            this.channelReceiveBufferSize = 65535;
        }
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }
}

