/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.EndpointType;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.builder.AbstractJaxWsModuleInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilderExtension;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.web.VirtualHostOSGIService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebJaxWsModuleInfoBuilder
extends AbstractJaxWsModuleInfoBuilder {
    private static final TraceComponent tc = Tr.register(WebJaxWsModuleInfoBuilder.class, (String)"JaxWsWeb", (String)"com.ibm.ws.jaxws.web.internal.resources.JaxWsWebMessages");
    static final long serialVersionUID = 6260216729049427265L;

    public WebJaxWsModuleInfoBuilder() {
        super(JaxWsModuleType.WEB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedModuleInfo build(ModuleMetaData moduleMetaData, Container containerToAdapt, JaxWsModuleInfo jaxWsModuleInfo) throws UnableToAdaptException {
        if (JaxWsUtils.isEJBModule((Container)JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData).getModuleContainer())) {
            return null;
        }
        EndpointInfoBuilder endpointInfoBuilder = (EndpointInfoBuilder)this.endpointInfoBuilderSRRef.getService();
        if (endpointInfoBuilder == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot get the EndpointInfoBuilder, will ignore all the Webservices.", (Object[])new Object[0]);
            }
            return null;
        }
        WebAnnotations webAnnotations = (WebAnnotations)containerToAdapt.adapt(WebAnnotations.class);
        InfoStore infoStore = webAnnotations.getInfoStore();
        EndpointInfoBuilderContext endpointInfoBuilderContext = new EndpointInfoBuilderContext(infoStore, containerToAdapt);
        JaxWsModuleInfoBuilderContext jaxWsModuleInfoBuilderContext = new JaxWsModuleInfoBuilderContext(moduleMetaData, containerToAdapt, endpointInfoBuilderContext);
        Map<String, String> servletNameClassPairsInWebXML = this.getServletNameClassPairsInWebXML(containerToAdapt);
        jaxWsModuleInfoBuilderContext.addContextEnv("servletNameClassPairsForEJBsInWAR", servletNameClassPairsInWebXML);
        for (JaxWsModuleInfoBuilderExtension extension : this.extensions) {
            extension.preBuild(jaxWsModuleInfoBuilderContext, jaxWsModuleInfo);
        }
        try {
            webAnnotations.openInfoStore();
            Set presentedServices = jaxWsModuleInfo.getEndpointImplBeanClassNames();
            WebAppConfig webAppConfig = (WebAppConfig)containerToAdapt.adapt(WebAppConfig.class);
            this.setupContextRoot(moduleMetaData, webAppConfig);
            this.setupVirtualHostConfig(moduleMetaData, webAppConfig);
            if (webAppConfig.isMetadataComplete()) {
                this.processClassesInWebXML(endpointInfoBuilder, endpointInfoBuilderContext, webAppConfig, jaxWsModuleInfo, presentedServices);
            } else {
                Collection<String> implClassNamesInWebXML = servletNameClassPairsInWebXML.values();
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                HashSet serviceClassNames = new HashSet();
                serviceClassNames.addAll(annotationTargets.getAnnotatedClasses(WebService.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                serviceClassNames.addAll(annotationTargets.getAnnotatedClasses(WebServiceProvider.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                for (String serviceImplBeanClassName : serviceClassNames) {
                    if (implClassNamesInWebXML.contains(serviceImplBeanClassName) || presentedServices.contains(serviceImplBeanClassName) || !JaxWsUtils.isWebService((ClassInfo)infoStore.getDelayableClassInfo(serviceImplBeanClassName))) continue;
                    jaxWsModuleInfo.addEndpointInfo(serviceImplBeanClassName, endpointInfoBuilder.build(endpointInfoBuilderContext, serviceImplBeanClassName, EndpointType.SERVLET));
                }
                this.processClassesInWebXML(endpointInfoBuilder, endpointInfoBuilderContext, webAppConfig, jaxWsModuleInfo, presentedServices);
            }
        }
        finally {
            webAnnotations.closeInfoStore();
        }
        for (JaxWsModuleInfoBuilderExtension extension : this.extensions) {
            extension.postBuild(jaxWsModuleInfoBuilderContext, jaxWsModuleInfo);
        }
        return null;
    }

    private void setupContextRoot(ModuleMetaData moduleMetaData, WebAppConfig webAppConfig) {
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData);
        String contextRoot = webAppConfig.getContextRoot();
        jaxWsModuleMetaData.setContextRoot(contextRoot);
    }

    /*
     * WARNING - void declaration
     */
    private void setupVirtualHostConfig(ModuleMetaData moduleMetaData, WebAppConfig webAppConfig) {
        String webAppName = webAppConfig.getApplicationName();
        String contextRoot = webAppConfig.getContextRoot();
        String configedVirtualHostName = webAppConfig.getVirtualHostName();
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData);
        if (configedVirtualHostName == null) {
            return;
        }
        DynamicVirtualHostManager dvhm = VirtualHostOSGIService.getInstance().getDynamicVirtualHostManagerService();
        try {
            ConcurrentHashMap vhostMap;
            VirtualHost vHost;
            final Field transportMap = dvhm.getClass().getDeclaredField("transportMap");
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 6282830815282096042L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    transportMap.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.web.WebJaxWsModuleInfoBuilder$1", 1.class, (String)"JaxWsWeb", (String)"com.ibm.ws.jaxws.web.internal.resources.JaxWsWebMessages");
                }
            });
            Object transportObj = transportMap.get(dvhm);
            if (transportObj != null && (vHost = (VirtualHost)(vhostMap = (ConcurrentHashMap)transportObj).get(configedVirtualHostName)) != null) {
                String vHostURL = vHost.getUrlString(contextRoot, true);
                jaxWsModuleMetaData.getAppNameURLMap().put(webAppName, vHostURL);
            }
        }
        catch (Exception transportMap) {
            void e;
            FFDCFilter.processException((Throwable)transportMap, (String)"com.ibm.ws.jaxws.web.WebJaxWsModuleInfoBuilder", (String)"192", (Object)((Object)this), (Object[])new Object[]{moduleMetaData, webAppConfig});
            throw new SecurityException((Throwable)e);
        }
    }

    private Map<String, String> getServletNameClassPairsInWebXML(Container containerToAdapt) throws UnableToAdaptException {
        HashMap<String, String> nameClassPairs = new HashMap<String, String>();
        WebAppConfig webAppConfig = (WebAppConfig)containerToAdapt.adapt(WebAppConfig.class);
        Iterator cfgIter = webAppConfig.getServletInfos();
        while (cfgIter.hasNext()) {
            IServletConfig servletCfg = (IServletConfig)cfgIter.next();
            if (servletCfg.getClassName() == null) continue;
            nameClassPairs.put(servletCfg.getServletName(), servletCfg.getClassName());
        }
        return nameClassPairs;
    }

    private void processClassesInWebXML(EndpointInfoBuilder endpointInfoBuilder, EndpointInfoBuilderContext ctx, WebAppConfig webAppConfig, JaxWsModuleInfo jaxWsModuleInfo, Set<String> presentedServices) throws UnableToAdaptException {
        Iterator cfgIter = webAppConfig.getServletInfos();
        while (cfgIter.hasNext()) {
            IServletConfig servletCfg = (IServletConfig)cfgIter.next();
            String servletClassName = servletCfg.getClassName();
            if (servletClassName == null || presentedServices.contains(servletClassName) || !JaxWsUtils.isWebService((ClassInfo)ctx.getInfoStore().getDelayableClassInfo(servletClassName))) continue;
            String servletName = servletCfg.getServletName();
            ctx.addContextEnv("endpointServletNameInEnv", (Object)servletName);
            jaxWsModuleInfo.addEndpointInfo(servletName, endpointInfoBuilder.build(ctx, servletClassName, EndpointType.SERVLET));
        }
    }
}

