/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StaticFileProcessor {
    private static final TraceComponent tc = Tr.register(StaticFileProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    static final long serialVersionUID = 940896080690773088L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static String getOpenAPIFile(Container container) {
        String result = null;
        Entry openAPIFileEntry = container.getEntry("META-INF/openapi.yaml");
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("META-INF/openapi.yml");
        }
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("META-INF/openapi.json");
        }
        if (openAPIFileEntry == null) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"No static file was found", (Object[])new Object[0]);
            }
            return null;
        }
        InputStream is = StaticFileProcessor.entryToInputStream(openAPIFileEntry);
        if (is == null) {
            return result;
        }
        try {
            result = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException e) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Unable to read openapi file into a string", (Object[])new Object[0]);
            }
        }
        finally {
            block18: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block18;
                    Tr.event((TraceComponent)tc, (String)"Failed to close openapi file InputSteam", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static InputStream entryToInputStream(Entry entry) {
        if (entry == null) {
            return null;
        }
        try {
            InputStream is = (InputStream)entry.adapt(InputStream.class);
            return is;
        }
        catch (UnableToAdaptException e) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Unable to adapt {0} to InputStream", (Object[])new Object[]{entry.getName()});
            }
            return null;
        }
    }
}

