/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.api.JaxRsProviderFactoryService;
import com.ibm.ws.jaxrs20.endpoint.AbstractJaxRsWebEndpoint;
import com.ibm.ws.jaxrs20.endpoint.JaxRsPublisherContext;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.ProviderResourceInfo;
import com.ibm.ws.jaxrs20.server.LibertyJaxRsServerFactoryBean;
import com.ibm.ws.jaxrs20.server.internal.JaxRsServerConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.transport.http.AbstractHTTPDestination;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsWebEndpointImpl
extends AbstractJaxRsWebEndpoint {
    private Server server = null;
    private final Set<JaxRsFactoryBeanCustomizer> beanCustomizers;
    private static final TraceComponent tc = Tr.register(JaxRsWebEndpointImpl.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    private final List<Feature> features;
    static final long serialVersionUID = -378337445187376906L;

    public JaxRsWebEndpointImpl(EndpointInfo endpointInfo, JaxRsPublisherContext context, List<Feature> features) {
        super(endpointInfo, context.getModuleMetaData());
        this.beanCustomizers = (Set)context.getAttribute(JaxRsServerConstants.BEAN_CUSTOMIZER);
        this.features = features;
    }

    public void init(ServletConfig servletConfig, JaxRsProviderFactoryService providerFactoryService) throws ServletException {
        super.init(servletConfig, providerFactoryService);
        LibertyJaxRsServerFactoryBean jaxRsServerFactory = new LibertyJaxRsServerFactoryBean(this.endpointInfo, this.jaxRsModuleMetaData, this.beanCustomizers, servletConfig, providerFactoryService);
        if (this.features != null && !this.features.isEmpty()) {
            jaxRsServerFactory.setFeatures(this.features);
        }
        jaxRsServerFactory.doInit();
        ClassLoader origClassLoader = (ClassLoader)jaxRsServerFactory.getBus().getExtension(ClassLoader.class);
        jaxRsServerFactory.getBus().setExtension(null, ClassLoader.class);
        this.server = jaxRsServerFactory.create();
        jaxRsServerFactory.getBus().setExtension((Object)origClassLoader, ClassLoader.class);
        this.configureEndpointInfoProperties(this.endpointInfo, this.server.getEndpoint().getEndpointInfo());
        this.server.start();
        this.destination = (AbstractHTTPDestination)this.server.getDestination();
    }

    public void destroy() {
        Method preDestoryMethod;
        Set singletonProviderAndPathInfos = this.endpointInfo.getSingletonProviderAndPathInfos();
        for (Object o : singletonProviderAndPathInfos) {
            if (o.getRuntimeType() != ProviderResourceInfo.RuntimeType.POJO) continue;
            preDestoryMethod = ResourceUtils.findPreDestroyMethod((Class)o.getProviderResourceClass());
            InjectionUtils.invokeLifeCycleMethod((Object)o.getObject(), (Method)preDestoryMethod);
        }
        Set perRequestProviderAndPathInfos = this.endpointInfo.getPerRequestProviderAndPathInfos();
        for (ProviderResourceInfo o : perRequestProviderAndPathInfos) {
            if (o.getRuntimeType() != ProviderResourceInfo.RuntimeType.POJO || !o.isJaxRsProvider()) continue;
            Method preDestoryMethod2 = ResourceUtils.findPreDestroyMethod((Class)o.getProviderResourceClass());
            InjectionUtils.invokeLifeCycleMethod((Object)o.getObject(), (Method)preDestoryMethod2);
        }
        if (!this.endpointInfo.isCustomizedApp().booleanValue()) {
            Application app = this.endpointInfo.getApp();
            preDestoryMethod = ResourceUtils.findPreDestroyMethod(app.getClass());
            InjectionUtils.invokeLifeCycleMethod((Object)app, (Method)preDestoryMethod);
        } else {
            for (JaxRsFactoryBeanCustomizer beanCustomizer : this.beanCustomizers) {
                beanCustomizer.destroyApplicationScopeResources(this.jaxRsModuleMetaData);
            }
        }
        if (this.server != null) {
            this.server.destroy();
        }
        if (this.features != null) {
            this.features.clear();
        }
    }
}

