/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.serverconfig;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigFacade;
import com.ibm.ws.kernel.instrument.serialfilter.config.SimpleConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.kernel.instrument.serialfilter.serverconfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class FilterConfigFactory {
    private static final TraceComponent tc = Tr.register(FilterConfigFactory.class, null, (String)"com.ibm.ws.kernel.instrument.serialfilter.serverconfig.internal.resources.SerialFilterConfigMessages");
    public static final String CONFIG_MODE = "filterMode";
    public static final String CONFIG_POLICY = "policy";
    public static final String CONFIG_OPERATION = "operation";
    public static final String CONFIG_PERMISSION = "permission";
    public static final String CONFIG_CLASS = "class";
    public static final String CONFIG_METHOD = "method";
    public static final String VALUE_MODE_INACTIVE = "Inactive";
    public static final String VALUE_MODE_DISCOVER = "Discover";
    public static final String VALUE_MODE_ENFORCE = "Enforce";
    public static final String VALUE_MODE_REJECT = "Reject";
    public static final String VALUE_PERMISSION_ALLOW = "Allow";
    public static final String VALUE_PERMISSION_DENY = "Deny";
    private Map<String, Dictionary> serialFilterConfigMap = new HashMap<String, Dictionary>();
    static final long serialVersionUID = 982079261593529994L;

    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties});
        }
        if (this.isEnabled()) {
            this.loadMaps(properties);
        } else {
            Tr.error((TraceComponent)tc, (String)"SF_ERROR_NOT_ENABLED", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{properties});
        }
        if (this.isEnabled()) {
            this.loadMaps(properties);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("deactivate, reason : " + reason), (Object[])new Object[0]);
        }
    }

    private void loadMaps(Map<String, Object> properties) {
        HashMap<String, String> modeMap = new HashMap<String, String>();
        HashMap<String, String> policyMap = new HashMap<String, String>();
        this.loadModeMap(Nester.nest(CONFIG_MODE, properties), modeMap);
        this.loadPolicyMap(Nester.nest(CONFIG_POLICY, properties), policyMap);
        this.propagateConfigMap(modeMap, policyMap);
        Tr.info((TraceComponent)tc, (String)"SF_INFO_ENABLED", (Object[])new Object[0]);
    }

    private void loadModeMap(List<Map<String, Object>> items, Map<String, String> modeMap) {
        if (items != null && !items.isEmpty()) {
            for (Map<String, Object> item : items) {
                String clazz = (String)item.get(CONFIG_CLASS);
                String method = (String)item.get(CONFIG_METHOD);
                String operation = (String)item.get(CONFIG_OPERATION);
                String key = method != null ? clazz + "#" + method : clazz;
                if (!modeMap.containsKey(key)) {
                    modeMap.put(key, operation);
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"SF_WARNING_DUPLICATE_MODE", (Object[])new Object[]{operation, clazz, method});
            }
        }
    }

    private void loadPolicyMap(List<Map<String, Object>> items, Map<String, String> policyMap) {
        if (items != null && !items.isEmpty()) {
            for (Map<String, Object> item : items) {
                String clazz = (String)item.get(CONFIG_CLASS);
                String permission = (String)item.get(CONFIG_PERMISSION);
                if (!policyMap.containsKey(clazz)) {
                    policyMap.put(clazz, permission);
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"SF_WARNING_DUPLICATE_POLICY", (Object[])new Object[]{permission, clazz});
            }
        }
    }

    protected void propagateConfigMap(Map<String, String> modeMap, Map<String, String> policyMap) {
        SimpleConfig configObject = this.getSystemConfigProxy();
        Properties filterConfig = new Properties();
        this.convertData(modeMap, policyMap, filterConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"serialFilter configuration is being updated.", (Object[])new Object[]{filterConfig});
        }
        configObject.reset();
        if (!filterConfig.isEmpty()) {
            configObject.load(filterConfig);
        }
    }

    protected void convertData(Map<String, String> modeMap, Map<String, String> policyMap, Properties filterConfig) {
        HashSet<String> keys = new HashSet<String>(modeMap.keySet());
        keys.addAll(policyMap.keySet());
        for (String key : keys) {
            String operation = modeMap.get(key);
            String permission = policyMap.get(key);
            if (operation != null && permission != null) {
                filterConfig.setProperty(key, operation.toUpperCase() + "," + permission.toUpperCase());
                continue;
            }
            if (operation != null) {
                filterConfig.setProperty(key, operation.toUpperCase());
                continue;
            }
            filterConfig.setProperty(key, permission.toUpperCase());
        }
    }

    protected boolean isEnabled() {
        String activeSerialFilter = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 3542045532035911817L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("com.ibm.websphere.serialfilter.active");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.instrument.serialfilter.serverconfig.FilterConfigFactory$1", 1.class, null, (String)"com.ibm.ws.kernel.instrument.serialfilter.serverconfig.internal.resources.SerialFilterConfigMessages");
            }
        });
        return "true".equalsIgnoreCase(activeSerialFilter);
    }

    protected SimpleConfig getSystemConfigProxy() {
        return ConfigFacade.getSystemConfigProxy();
    }
}

